/*
 * Copyright (C) 2014 The Android Open Source Project
 * Copyright (c) 1995, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */


package java.util.zip;

import dalvik.system.ZipPathValidator;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.stream.Stream;

/**
 * This class is used to read entries from a zip file.
 *
 * <p> Unless otherwise noted, passing a {@code null} argument to a constructor
 * or method in this class will cause a {@link java.lang.NullPointerException NullPointerException} to be
 * thrown.
 *
 * @apiNote
 * To release resources used by this {@code ZipFile}, the {@link #close()} method
 * should be called explicitly or by try-with-resources. Subclasses are responsible
 * for the cleanup of resources acquired by the subclass. Subclasses that override
 * {@link #finalize()} in order to perform cleanup should be modified to use alternative
 * cleanup mechanisms such as {@link java.lang.ref.Cleaner} and remove the overriding
 * {@code finalize} method.
 *
 * @author      David Connelly
 * @since 1.1
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class ZipFile implements java.io.Closeable {

/**
 * Opens a zip file for reading.
 *
 * <p>First, if there is a security manager, its {@code checkRead}
 * method is called with the {@code name} argument as its argument
 * to ensure the read is allowed.
 *
 * <p>The UTF-8 {@link java.nio.charset.Charset charset} is used to
 * decode the entry names and comments.
 *
 * <p>If the app targets Android U or above, zip file entry names containing
 * ".." or starting with "/" passed here will throw a {@link java.util.zip.ZipException ZipException}.
 * For more details, see {@link dalvik.system.ZipPathValidator}.
 *
 * @param name the name of the zip file
 * @throws java.util.zip.ZipException if (1) a ZIP format error has occurred or
 *         (2) <code>targetSdkVersion >= BUILD.VERSION_CODES.UPSIDE_DOWN_CAKE</code>
 *         and (the <code>name</code> argument contains ".." or starts with "/").
 * @throws java.io.IOException if an I/O error has occurred
 * @throws java.lang.SecurityException if a security manager exists and its
 *         {@code checkRead} method doesn't allow read access to the file.
 *
 * @see java.lang.SecurityManager#checkRead(java.lang.String)
 */

public ZipFile(java.lang.String name) throws java.io.IOException { throw new RuntimeException("Stub!"); }

/**
 * Opens a new {@code ZipFile} to read from the specified
 * {@code File} object in the specified mode.  The mode argument
 * must be either {@code OPEN_READ} or {@code OPEN_READ | OPEN_DELETE}.
 *
 * <p>First, if there is a security manager, its {@code checkRead}
 * method is called with the {@code name} argument as its argument to
 * ensure the read is allowed.
 *
 * <p>The UTF-8 {@link java.nio.charset.Charset charset} is used to
 * decode the entry names and comments
 *
 * @param file the ZIP file to be opened for reading
 * @param mode the mode in which the file is to be opened
 * @throws java.util.zip.ZipException if a ZIP format error has occurred
 * @throws java.io.IOException if an I/O error has occurred
 * @throws java.lang.SecurityException if a security manager exists and
 *         its {@code checkRead} method
 *         doesn't allow read access to the file,
 *         or its {@code checkDelete} method doesn't allow deleting
 *         the file when the {@code OPEN_DELETE} flag is set.
 * @throws java.lang.IllegalArgumentException if the {@code mode} argument is invalid
 * @see java.lang.SecurityManager#checkRead(java.lang.String)
 * @since 1.3
 */

public ZipFile(java.io.File file, int mode) throws java.io.IOException { throw new RuntimeException("Stub!"); }

/**
 * Opens a ZIP file for reading given the specified File object.
 *
 * <p>The UTF-8 {@link java.nio.charset.Charset charset} is used to
 * decode the entry names and comments.
 *
 * @param file the ZIP file to be opened for reading
 * @throws java.util.zip.ZipException if a ZIP format error has occurred
 * @throws java.io.IOException if an I/O error has occurred
 */

public ZipFile(java.io.File file) throws java.io.IOException, java.util.zip.ZipException { throw new RuntimeException("Stub!"); }

/**
 * Opens a new {@code ZipFile} to read from the specified
 * {@code File} object in the specified mode.  The mode argument
 * must be either {@code OPEN_READ} or {@code OPEN_READ | OPEN_DELETE}.
 *
 * <p>First, if there is a security manager, its {@code checkRead}
 * method is called with the {@code name} argument as its argument to
 * ensure the read is allowed.
 *
 * @param file the ZIP file to be opened for reading
 * @param mode the mode in which the file is to be opened
 * @param charset
 *        the {@linkplain java.nio.charset.Charset charset} to
 *        be used to decode the ZIP entry name and comment that are not
 *        encoded by using UTF-8 encoding (indicated by entry's general
 *        purpose flag).
 *
 * @throws java.util.zip.ZipException if a ZIP format error has occurred
 * @throws java.io.IOException if an I/O error has occurred
 *
 * @throws java.lang.SecurityException
 *         if a security manager exists and its {@code checkRead}
 *         method doesn't allow read access to the file,or its
 *         {@code checkDelete} method doesn't allow deleting the
 *         file when the {@code OPEN_DELETE} flag is set
 *
 * @throws java.lang.IllegalArgumentException if the {@code mode} argument is invalid
 *
 * @see java.lang.SecurityManager#checkRead(java.lang.String)
 *
 * @since 1.7
 */

public ZipFile(java.io.File file, int mode, java.nio.charset.Charset charset) throws java.io.IOException { throw new RuntimeException("Stub!"); }

/**
 * Opens a zip file for reading.
 *
 * <p>First, if there is a security manager, its {@code checkRead}
 * method is called with the {@code name} argument as its argument
 * to ensure the read is allowed.
 *
 * @param name the name of the zip file
 * @param charset
 *        the {@linkplain java.nio.charset.Charset charset} to
 *        be used to decode the ZIP entry name and comment that are not
 *        encoded by using UTF-8 encoding (indicated by entry's general
 *        purpose flag).
 *
 * @throws java.util.zip.ZipException if a ZIP format error has occurred
 * @throws java.io.IOException if an I/O error has occurred
 * @throws java.lang.SecurityException
 *         if a security manager exists and its {@code checkRead}
 *         method doesn't allow read access to the file
 *
 * @see java.lang.SecurityManager#checkRead(java.lang.String)
 *
 * @since 1.7
 */

public ZipFile(java.lang.String name, java.nio.charset.Charset charset) throws java.io.IOException { throw new RuntimeException("Stub!"); }

/**
 * Opens a ZIP file for reading given the specified File object.
 *
 * @param file the ZIP file to be opened for reading
 * @param charset
 *        The {@linkplain java.nio.charset.Charset charset} to be
 *        used to decode the ZIP entry name and comment (ignored if
 *        the <a href="package-summary.html#lang_encoding"> language
 *        encoding bit</a> of the ZIP entry's general purpose bit
 *        flag is set).
 *
 * @throws java.util.zip.ZipException if a ZIP format error has occurred
 * @throws java.io.IOException if an I/O error has occurred
 *
 * @since 1.7
 */

public ZipFile(java.io.File file, java.nio.charset.Charset charset) throws java.io.IOException { throw new RuntimeException("Stub!"); }

/**
 * Returns the zip file comment, or null if none.
 *
 * @return the comment string for the zip file, or null if none
 *
 * @throws java.lang.IllegalStateException if the zip file has been closed
 *
 * @since 1.7
 */

public java.lang.String getComment() { throw new RuntimeException("Stub!"); }

/**
 * Returns the zip file entry for the specified name, or null
 * if not found.
 *
 * @param name the name of the entry
 * @return the zip file entry, or null if not found
 * @throws java.lang.IllegalStateException if the zip file has been closed
 */

public java.util.zip.ZipEntry getEntry(java.lang.String name) { throw new RuntimeException("Stub!"); }

/**
 * Returns an input stream for reading the contents of the specified
 * zip file entry.
 * <p>
 * Closing this ZIP file will, in turn, close all input streams that
 * have been returned by invocations of this method.
 *
 * @param entry the zip file entry
 * @return the input stream for reading the contents of the specified
 * zip file entry.
 * @throws java.util.zip.ZipException if a ZIP format error has occurred
 * @throws java.io.IOException if an I/O error has occurred
 * @throws java.lang.IllegalStateException if the zip file has been closed
 */

public java.io.InputStream getInputStream(java.util.zip.ZipEntry entry) throws java.io.IOException { throw new RuntimeException("Stub!"); }

/**
 * Returns the path name of the ZIP file.
 * @return the path name of the ZIP file
 */

public java.lang.String getName() { throw new RuntimeException("Stub!"); }

/**
 * Returns an enumeration of the ZIP file entries.
 * @return an enumeration of the ZIP file entries
 * @throws java.lang.IllegalStateException if the zip file has been closed
 */

public java.util.Enumeration<? extends java.util.zip.ZipEntry> entries() { throw new RuntimeException("Stub!"); }

/**
 * Returns an ordered {@code Stream} over the ZIP file entries.
 *
 * Entries appear in the {@code Stream} in the order they appear in
 * the central directory of the ZIP file.
 *
 * @return an ordered {@code Stream} of entries in this ZIP file
 * @throws java.lang.IllegalStateException if the zip file has been closed
 * @since 1.8
 */

public java.util.stream.Stream<? extends java.util.zip.ZipEntry> stream() { throw new RuntimeException("Stub!"); }

/**
 * Returns the number of entries in the ZIP file.
 *
 * @return the number of entries in the ZIP file
 * @throws java.lang.IllegalStateException if the zip file has been closed
 */

public int size() { throw new RuntimeException("Stub!"); }

/**
 * Closes the ZIP file.
 *
 * <p> Closing this ZIP file will close all of the input streams
 * previously returned by invocations of the {@link #getInputStream
 * getInputStream} method.
 *
 * @throws java.io.IOException if an I/O error has occurred
 */

public void close() throws java.io.IOException { throw new RuntimeException("Stub!"); }

/**
 * Central directory (CEN) header internal file attributes field offset.
 */

public static final int CENATT = 36; // 0x24

/**
 * Central directory (CEN) header external file attributes field offset.
 */

public static final int CENATX = 38; // 0x26

/**
 * Central directory (CEN) header comment length field offset.
 */

public static final int CENCOM = 32; // 0x20

/**
 * Central directory (CEN) header uncompressed file crc-32 value field offset.
 */

public static final int CENCRC = 16; // 0x10

/**
 * Central directory (CEN) header disk number start field offset.
 */

public static final int CENDSK = 34; // 0x22

/**
 * Central directory (CEN) header extra field length field offset.
 */

public static final int CENEXT = 30; // 0x1e

/**
 * Central directory (CEN) header encrypt, decrypt flags field offset.
 */

public static final int CENFLG = 8; // 0x8

/**
 * Central directory (CEN) header size in bytes (including signature).
 */

public static final int CENHDR = 46; // 0x2e

/**
 * Central directory (CEN) header compression method field offset.
 */

public static final int CENHOW = 10; // 0xa

/**
 * Central directory (CEN) header uncompressed size field offset.
 */

public static final int CENLEN = 24; // 0x18

/**
 * Central directory (CEN) header filename length field offset.
 */

public static final int CENNAM = 28; // 0x1c

/**
 * Central directory (CEN) header LOC header offset field offset.
 */

public static final int CENOFF = 42; // 0x2a

/**
 * Central directory (CEN) header signature.
 */

public static final long CENSIG = 33639248L; // 0x2014b50L

/**
 * Central directory (CEN) header compressed size field offset.
 */

public static final int CENSIZ = 20; // 0x14

/**
 * Central directory (CEN) header modification time field offset.
 */

public static final int CENTIM = 12; // 0xc

/**
 * Central directory (CEN) header version made by field offset.
 */

public static final int CENVEM = 4; // 0x4

/**
 * Central directory (CEN) header version needed to extract field offset.
 */

public static final int CENVER = 6; // 0x6

/**
 * End of central directory (END) header zip file comment length field offset.
 */

public static final int ENDCOM = 20; // 0x14

/**
 * End of central directory (END) header size in bytes (including signature).
 */

public static final int ENDHDR = 22; // 0x16

/**
 * End of central directory (END) header offset for the first CEN header field offset.
 */

public static final int ENDOFF = 16; // 0x10

/**
 * End of central directory (END) header signature.
 */

public static final long ENDSIG = 101010256L; // 0x6054b50L

/**
 * End of central directory (END) header central directory size in bytes field offset.
 */

public static final int ENDSIZ = 12; // 0xc

/**
 * End of central directory (END) header number of entries on this disk field offset.
 */

public static final int ENDSUB = 8; // 0x8

/**
 * End of central directory (END) header total number of entries field offset.
 */

public static final int ENDTOT = 10; // 0xa

/**
 * Extra local (EXT) header uncompressed file crc-32 value field offset.
 */

public static final int EXTCRC = 4; // 0x4

/**
 * Extra local (EXT) header size in bytes (including signature).
 */

public static final int EXTHDR = 16; // 0x10

/**
 * Extra local (EXT) header uncompressed size field offset.
 */

public static final int EXTLEN = 12; // 0xc

/**
 * Extra local (EXT) header signature.
 */

public static final long EXTSIG = 134695760L; // 0x8074b50L

/**
 * Extra local (EXT) header compressed size field offset.
 */

public static final int EXTSIZ = 8; // 0x8

/**
 * Local file (LOC) header uncompressed file crc-32 value field offset.
 */

public static final int LOCCRC = 14; // 0xe

/**
 * Local file (LOC) header extra field length field offset.
 */

public static final int LOCEXT = 28; // 0x1c

/**
 * Local file (LOC) header general purpose bit flag field offset.
 */

public static final int LOCFLG = 6; // 0x6

/**
 * Local file (LOC) header size in bytes (including signature).
 */

public static final int LOCHDR = 30; // 0x1e

/**
 * Local file (LOC) header compression method field offset.
 */

public static final int LOCHOW = 8; // 0x8

/**
 * Local file (LOC) header uncompressed size field offset.
 */

public static final int LOCLEN = 22; // 0x16

/**
 * Local file (LOC) header filename length field offset.
 */

public static final int LOCNAM = 26; // 0x1a

/**
 * Local file (LOC) header signature.
 */

public static final long LOCSIG = 67324752L; // 0x4034b50L

/**
 * Local file (LOC) header compressed size field offset.
 */

public static final int LOCSIZ = 18; // 0x12

/**
 * Local file (LOC) header modification time field offset.
 */

public static final int LOCTIM = 10; // 0xa

/**
 * Local file (LOC) header version needed to extract field offset.
 */

public static final int LOCVER = 4; // 0x4

/**
 * Mode flag to open a zip file and mark it for deletion.  The file will be
 * deleted some time between the moment that it is opened and the moment
 * that it is closed, but its contents will remain accessible via the
 * {@code ZipFile} object until either the close method is invoked or the
 * virtual machine exits.
 */

public static final int OPEN_DELETE = 4; // 0x4

/**
 * Mode flag to open a zip file for reading.
 */

public static final int OPEN_READ = 1; // 0x1
}

