/*
 * Copyright (C) 2014 The Android Open Source Project
 * Copyright (c) 1997, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */


package java.util;

import java.io.Serializable;
import java.util.concurrent.ForkJoinPool;
import java.util.function.BinaryOperator;
import java.util.function.DoubleBinaryOperator;
import java.util.function.IntBinaryOperator;
import java.util.function.LongBinaryOperator;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

/**
 * This class contains various methods for manipulating arrays (such as
 * sorting and searching). This class also contains a static factory
 * that allows arrays to be viewed as lists.
 *
 * <p>The methods in this class all throw a {@code NullPointerException},
 * if the specified array reference is null, except where noted.
 *
 * <p>The documentation for the methods contained in this class includes
 * brief descriptions of the <i>implementations</i>. Such descriptions should
 * be regarded as <i>implementation notes</i>, rather than parts of the
 * <i>specification</i>. Implementors should feel free to substitute other
 * algorithms, so long as the specification itself is adhered to. (For
 * example, the algorithm used by {@code sort(Object[])} does not have to be
 * a MergeSort, but it does have to be <i>stable</i>.)
 *
 * <p>This class is a member of the
 * <a href="{@docRoot}/reference/java/util/package-summary.html#CollectionsFramework">
 * Java Collections Framework</a>.
 *
 * @author Josh Bloch
 * @author Neal Gafter
 * @author John Rose
 * @since  1.2
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class Arrays {

Arrays() { throw new RuntimeException("Stub!"); }

/**
 * Sorts the specified array into ascending numerical order.
 *
 * @implNote The sorting algorithm is a Dual-Pivot Quicksort
 * by Vladimir Yaroslavskiy, Jon Bentley, and Joshua Bloch. This algorithm
 * offers O(n log(n)) performance on all data sets, and is typically
 * faster than traditional (one-pivot) Quicksort implementations.
 *
 * @param a the array to be sorted
 */

public static void sort(@androidx.annotation.RecentlyNonNull int[] a) { throw new RuntimeException("Stub!"); }

/**
 * Sorts the specified range of the array into ascending order. The range
 * to be sorted extends from the index {@code fromIndex}, inclusive, to
 * the index {@code toIndex}, exclusive. If {@code fromIndex == toIndex},
 * the range to be sorted is empty.
 *
 * @implNote The sorting algorithm is a Dual-Pivot Quicksort
 * by Vladimir Yaroslavskiy, Jon Bentley, and Joshua Bloch. This algorithm
 * offers O(n log(n)) performance on all data sets, and is typically
 * faster than traditional (one-pivot) Quicksort implementations.
 *
 * @param a the array to be sorted
 * @param fromIndex the index of the first element, inclusive, to be sorted
 * @param toIndex the index of the last element, exclusive, to be sorted
 *
 * @throws java.lang.IllegalArgumentException if {@code fromIndex > toIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *     if {@code fromIndex < 0} or {@code toIndex > a.length}
 */

public static void sort(@androidx.annotation.RecentlyNonNull int[] a, int fromIndex, int toIndex) { throw new RuntimeException("Stub!"); }

/**
 * Sorts the specified array into ascending numerical order.
 *
 * @implNote The sorting algorithm is a Dual-Pivot Quicksort
 * by Vladimir Yaroslavskiy, Jon Bentley, and Joshua Bloch. This algorithm
 * offers O(n log(n)) performance on all data sets, and is typically
 * faster than traditional (one-pivot) Quicksort implementations.
 *
 * @param a the array to be sorted
 */

public static void sort(@androidx.annotation.RecentlyNonNull long[] a) { throw new RuntimeException("Stub!"); }

/**
 * Sorts the specified range of the array into ascending order. The range
 * to be sorted extends from the index {@code fromIndex}, inclusive, to
 * the index {@code toIndex}, exclusive. If {@code fromIndex == toIndex},
 * the range to be sorted is empty.
 *
 * @implNote The sorting algorithm is a Dual-Pivot Quicksort
 * by Vladimir Yaroslavskiy, Jon Bentley, and Joshua Bloch. This algorithm
 * offers O(n log(n)) performance on all data sets, and is typically
 * faster than traditional (one-pivot) Quicksort implementations.
 *
 * @param a the array to be sorted
 * @param fromIndex the index of the first element, inclusive, to be sorted
 * @param toIndex the index of the last element, exclusive, to be sorted
 *
 * @throws java.lang.IllegalArgumentException if {@code fromIndex > toIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *     if {@code fromIndex < 0} or {@code toIndex > a.length}
 */

public static void sort(@androidx.annotation.RecentlyNonNull long[] a, int fromIndex, int toIndex) { throw new RuntimeException("Stub!"); }

/**
 * Sorts the specified array into ascending numerical order.
 *
 * @implNote The sorting algorithm is a Dual-Pivot Quicksort
 * by Vladimir Yaroslavskiy, Jon Bentley, and Joshua Bloch. This algorithm
 * offers O(n log(n)) performance on all data sets, and is typically
 * faster than traditional (one-pivot) Quicksort implementations.
 *
 * @param a the array to be sorted
 */

public static void sort(@androidx.annotation.RecentlyNonNull short[] a) { throw new RuntimeException("Stub!"); }

/**
 * Sorts the specified range of the array into ascending order. The range
 * to be sorted extends from the index {@code fromIndex}, inclusive, to
 * the index {@code toIndex}, exclusive. If {@code fromIndex == toIndex},
 * the range to be sorted is empty.
 *
 * @implNote The sorting algorithm is a Dual-Pivot Quicksort
 * by Vladimir Yaroslavskiy, Jon Bentley, and Joshua Bloch. This algorithm
 * offers O(n log(n)) performance on all data sets, and is typically
 * faster than traditional (one-pivot) Quicksort implementations.
 *
 * @param a the array to be sorted
 * @param fromIndex the index of the first element, inclusive, to be sorted
 * @param toIndex the index of the last element, exclusive, to be sorted
 *
 * @throws java.lang.IllegalArgumentException if {@code fromIndex > toIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *     if {@code fromIndex < 0} or {@code toIndex > a.length}
 */

public static void sort(@androidx.annotation.RecentlyNonNull short[] a, int fromIndex, int toIndex) { throw new RuntimeException("Stub!"); }

/**
 * Sorts the specified array into ascending numerical order.
 *
 * @implNote The sorting algorithm is a Dual-Pivot Quicksort
 * by Vladimir Yaroslavskiy, Jon Bentley, and Joshua Bloch. This algorithm
 * offers O(n log(n)) performance on all data sets, and is typically
 * faster than traditional (one-pivot) Quicksort implementations.
 *
 * @param a the array to be sorted
 */

public static void sort(@androidx.annotation.RecentlyNonNull char[] a) { throw new RuntimeException("Stub!"); }

/**
 * Sorts the specified range of the array into ascending order. The range
 * to be sorted extends from the index {@code fromIndex}, inclusive, to
 * the index {@code toIndex}, exclusive. If {@code fromIndex == toIndex},
 * the range to be sorted is empty.
 *
 * @implNote The sorting algorithm is a Dual-Pivot Quicksort
 * by Vladimir Yaroslavskiy, Jon Bentley, and Joshua Bloch. This algorithm
 * offers O(n log(n)) performance on all data sets, and is typically
 * faster than traditional (one-pivot) Quicksort implementations.
 *
 * @param a the array to be sorted
 * @param fromIndex the index of the first element, inclusive, to be sorted
 * @param toIndex the index of the last element, exclusive, to be sorted
 *
 * @throws java.lang.IllegalArgumentException if {@code fromIndex > toIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *     if {@code fromIndex < 0} or {@code toIndex > a.length}
 */

public static void sort(@androidx.annotation.RecentlyNonNull char[] a, int fromIndex, int toIndex) { throw new RuntimeException("Stub!"); }

/**
 * Sorts the specified array into ascending numerical order.
 *
 * @implNote The sorting algorithm is a Dual-Pivot Quicksort
 * by Vladimir Yaroslavskiy, Jon Bentley, and Joshua Bloch. This algorithm
 * offers O(n log(n)) performance on all data sets, and is typically
 * faster than traditional (one-pivot) Quicksort implementations.
 *
 * @param a the array to be sorted
 */

public static void sort(@androidx.annotation.RecentlyNonNull byte[] a) { throw new RuntimeException("Stub!"); }

/**
 * Sorts the specified range of the array into ascending order. The range
 * to be sorted extends from the index {@code fromIndex}, inclusive, to
 * the index {@code toIndex}, exclusive. If {@code fromIndex == toIndex},
 * the range to be sorted is empty.
 *
 * @implNote The sorting algorithm is a Dual-Pivot Quicksort
 * by Vladimir Yaroslavskiy, Jon Bentley, and Joshua Bloch. This algorithm
 * offers O(n log(n)) performance on all data sets, and is typically
 * faster than traditional (one-pivot) Quicksort implementations.
 *
 * @param a the array to be sorted
 * @param fromIndex the index of the first element, inclusive, to be sorted
 * @param toIndex the index of the last element, exclusive, to be sorted
 *
 * @throws java.lang.IllegalArgumentException if {@code fromIndex > toIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *     if {@code fromIndex < 0} or {@code toIndex > a.length}
 */

public static void sort(@androidx.annotation.RecentlyNonNull byte[] a, int fromIndex, int toIndex) { throw new RuntimeException("Stub!"); }

/**
 * Sorts the specified array into ascending numerical order.
 *
 * <p>The {@code <} relation does not provide a total order on all float
 * values: {@code -0.0f == 0.0f} is {@code true} and a {@code Float.NaN}
 * value compares neither less than, greater than, nor equal to any value,
 * even itself. This method uses the total order imposed by the method
 * {@link java.lang.Float#compareTo Float#compareTo}: {@code -0.0f} is treated as less than value
 * {@code 0.0f} and {@code Float.NaN} is considered greater than any
 * other value and all {@code Float.NaN} values are considered equal.
 *
 * @implNote The sorting algorithm is a Dual-Pivot Quicksort
 * by Vladimir Yaroslavskiy, Jon Bentley, and Joshua Bloch. This algorithm
 * offers O(n log(n)) performance on all data sets, and is typically
 * faster than traditional (one-pivot) Quicksort implementations.
 *
 * @param a the array to be sorted
 */

public static void sort(@androidx.annotation.RecentlyNonNull float[] a) { throw new RuntimeException("Stub!"); }

/**
 * Sorts the specified range of the array into ascending order. The range
 * to be sorted extends from the index {@code fromIndex}, inclusive, to
 * the index {@code toIndex}, exclusive. If {@code fromIndex == toIndex},
 * the range to be sorted is empty.
 *
 * <p>The {@code <} relation does not provide a total order on all float
 * values: {@code -0.0f == 0.0f} is {@code true} and a {@code Float.NaN}
 * value compares neither less than, greater than, nor equal to any value,
 * even itself. This method uses the total order imposed by the method
 * {@link java.lang.Float#compareTo Float#compareTo}: {@code -0.0f} is treated as less than value
 * {@code 0.0f} and {@code Float.NaN} is considered greater than any
 * other value and all {@code Float.NaN} values are considered equal.
 *
 * @implNote The sorting algorithm is a Dual-Pivot Quicksort
 * by Vladimir Yaroslavskiy, Jon Bentley, and Joshua Bloch. This algorithm
 * offers O(n log(n)) performance on all data sets, and is typically
 * faster than traditional (one-pivot) Quicksort implementations.
 *
 * @param a the array to be sorted
 * @param fromIndex the index of the first element, inclusive, to be sorted
 * @param toIndex the index of the last element, exclusive, to be sorted
 *
 * @throws java.lang.IllegalArgumentException if {@code fromIndex > toIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *     if {@code fromIndex < 0} or {@code toIndex > a.length}
 */

public static void sort(@androidx.annotation.RecentlyNonNull float[] a, int fromIndex, int toIndex) { throw new RuntimeException("Stub!"); }

/**
 * Sorts the specified array into ascending numerical order.
 *
 * <p>The {@code <} relation does not provide a total order on all double
 * values: {@code -0.0d == 0.0d} is {@code true} and a {@code Double.NaN}
 * value compares neither less than, greater than, nor equal to any value,
 * even itself. This method uses the total order imposed by the method
 * {@link java.lang.Double#compareTo Double#compareTo}: {@code -0.0d} is treated as less than value
 * {@code 0.0d} and {@code Double.NaN} is considered greater than any
 * other value and all {@code Double.NaN} values are considered equal.
 *
 * @implNote The sorting algorithm is a Dual-Pivot Quicksort
 * by Vladimir Yaroslavskiy, Jon Bentley, and Joshua Bloch. This algorithm
 * offers O(n log(n)) performance on all data sets, and is typically
 * faster than traditional (one-pivot) Quicksort implementations.
 *
 * @param a the array to be sorted
 */

public static void sort(@androidx.annotation.RecentlyNonNull double[] a) { throw new RuntimeException("Stub!"); }

/**
 * Sorts the specified range of the array into ascending order. The range
 * to be sorted extends from the index {@code fromIndex}, inclusive, to
 * the index {@code toIndex}, exclusive. If {@code fromIndex == toIndex},
 * the range to be sorted is empty.
 *
 * <p>The {@code <} relation does not provide a total order on all double
 * values: {@code -0.0d == 0.0d} is {@code true} and a {@code Double.NaN}
 * value compares neither less than, greater than, nor equal to any value,
 * even itself. This method uses the total order imposed by the method
 * {@link java.lang.Double#compareTo Double#compareTo}: {@code -0.0d} is treated as less than value
 * {@code 0.0d} and {@code Double.NaN} is considered greater than any
 * other value and all {@code Double.NaN} values are considered equal.
 *
 * @implNote The sorting algorithm is a Dual-Pivot Quicksort
 * by Vladimir Yaroslavskiy, Jon Bentley, and Joshua Bloch. This algorithm
 * offers O(n log(n)) performance on all data sets, and is typically
 * faster than traditional (one-pivot) Quicksort implementations.
 *
 * @param a the array to be sorted
 * @param fromIndex the index of the first element, inclusive, to be sorted
 * @param toIndex the index of the last element, exclusive, to be sorted
 *
 * @throws java.lang.IllegalArgumentException if {@code fromIndex > toIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *     if {@code fromIndex < 0} or {@code toIndex > a.length}
 */

public static void sort(@androidx.annotation.RecentlyNonNull double[] a, int fromIndex, int toIndex) { throw new RuntimeException("Stub!"); }

/**
 * Sorts the specified array into ascending numerical order.
 *
 * @implNote The sorting algorithm is a Dual-Pivot Quicksort by
 * Vladimir Yaroslavskiy, Jon Bentley and Josh Bloch. This algorithm
 * offers O(n log(n)) performance on all data sets, and is typically
 * faster than traditional (one-pivot) Quicksort implementations.
 *
 * @param a the array to be sorted
 *
 * @since 1.8
 */

public static void parallelSort(@androidx.annotation.RecentlyNonNull byte[] a) { throw new RuntimeException("Stub!"); }

/**
 * Sorts the specified range of the array into ascending numerical order.
 * The range to be sorted extends from the index {@code fromIndex},
 * inclusive, to the index {@code toIndex}, exclusive. If
 * {@code fromIndex == toIndex}, the range to be sorted is empty.
 *
 * @implNote The sorting algorithm is a Dual-Pivot Quicksort by
 * Vladimir Yaroslavskiy, Jon Bentley and Josh Bloch. This algorithm
 * offers O(n log(n)) performance on all data sets, and is typically
 * faster than traditional (one-pivot) Quicksort implementations.
 *
 * @param a the array to be sorted
 * @param fromIndex the index of the first element, inclusive, to be sorted
 * @param toIndex the index of the last element, exclusive, to be sorted
 *
 * @throws java.lang.IllegalArgumentException if {@code fromIndex > toIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *     if {@code fromIndex < 0} or {@code toIndex > a.length}
 *
 * @since 1.8
 */

public static void parallelSort(@androidx.annotation.RecentlyNonNull byte[] a, int fromIndex, int toIndex) { throw new RuntimeException("Stub!"); }

/**
 * Sorts the specified array into ascending numerical order.
 *
 * @implNote The sorting algorithm is a Dual-Pivot Quicksort by
 * Vladimir Yaroslavskiy, Jon Bentley and Josh Bloch. This algorithm
 * offers O(n log(n)) performance on all data sets, and is typically
 * faster than traditional (one-pivot) Quicksort implementations.
 *
 * @param a the array to be sorted
 *
 * @since 1.8
 */

public static void parallelSort(@androidx.annotation.RecentlyNonNull char[] a) { throw new RuntimeException("Stub!"); }

/**
 * Sorts the specified range of the array into ascending numerical order.
 * The range to be sorted extends from the index {@code fromIndex},
 * inclusive, to the index {@code toIndex}, exclusive. If
 * {@code fromIndex == toIndex}, the range to be sorted is empty.
 *
 * @implNote The sorting algorithm is a Dual-Pivot Quicksort by
 * Vladimir Yaroslavskiy, Jon Bentley and Josh Bloch. This algorithm
 * offers O(n log(n)) performance on all data sets, and is typically
 * faster than traditional (one-pivot) Quicksort implementations.
 *
 * @param a the array to be sorted
 * @param fromIndex the index of the first element, inclusive, to be sorted
 * @param toIndex the index of the last element, exclusive, to be sorted
 *
 * @throws java.lang.IllegalArgumentException if {@code fromIndex > toIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *     if {@code fromIndex < 0} or {@code toIndex > a.length}
 *
 * @since 1.8
 */

public static void parallelSort(@androidx.annotation.RecentlyNonNull char[] a, int fromIndex, int toIndex) { throw new RuntimeException("Stub!"); }

/**
 * Sorts the specified array into ascending numerical order.
 *
 * @implNote The sorting algorithm is a Dual-Pivot Quicksort by
 * Vladimir Yaroslavskiy, Jon Bentley and Josh Bloch. This algorithm
 * offers O(n log(n)) performance on all data sets, and is typically
 * faster than traditional (one-pivot) Quicksort implementations.
 *
 * @param a the array to be sorted
 *
 * @since 1.8
 */

public static void parallelSort(@androidx.annotation.RecentlyNonNull short[] a) { throw new RuntimeException("Stub!"); }

/**
 * Sorts the specified range of the array into ascending numerical order.
 * The range to be sorted extends from the index {@code fromIndex},
 * inclusive, to the index {@code toIndex}, exclusive. If
 * {@code fromIndex == toIndex}, the range to be sorted is empty.
 *
 * @implNote The sorting algorithm is a Dual-Pivot Quicksort by
 * Vladimir Yaroslavskiy, Jon Bentley and Josh Bloch. This algorithm
 * offers O(n log(n)) performance on all data sets, and is typically
 * faster than traditional (one-pivot) Quicksort implementations.
 *
 * @param a the array to be sorted
 * @param fromIndex the index of the first element, inclusive, to be sorted
 * @param toIndex the index of the last element, exclusive, to be sorted
 *
 * @throws java.lang.IllegalArgumentException if {@code fromIndex > toIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *     if {@code fromIndex < 0} or {@code toIndex > a.length}
 *
 * @since 1.8
 */

public static void parallelSort(@androidx.annotation.RecentlyNonNull short[] a, int fromIndex, int toIndex) { throw new RuntimeException("Stub!"); }

/**
 * Sorts the specified array into ascending numerical order.
 *
 * @implNote The sorting algorithm is a Dual-Pivot Quicksort by
 * Vladimir Yaroslavskiy, Jon Bentley and Josh Bloch. This algorithm
 * offers O(n log(n)) performance on all data sets, and is typically
 * faster than traditional (one-pivot) Quicksort implementations.
 *
 * @param a the array to be sorted
 *
 * @since 1.8
 */

public static void parallelSort(@androidx.annotation.RecentlyNonNull int[] a) { throw new RuntimeException("Stub!"); }

/**
 * Sorts the specified range of the array into ascending numerical order.
 * The range to be sorted extends from the index {@code fromIndex},
 * inclusive, to the index {@code toIndex}, exclusive. If
 * {@code fromIndex == toIndex}, the range to be sorted is empty.
 *
 * @implNote The sorting algorithm is a Dual-Pivot Quicksort by
 * Vladimir Yaroslavskiy, Jon Bentley and Josh Bloch. This algorithm
 * offers O(n log(n)) performance on all data sets, and is typically
 * faster than traditional (one-pivot) Quicksort implementations.
 *
 * @param a the array to be sorted
 * @param fromIndex the index of the first element, inclusive, to be sorted
 * @param toIndex the index of the last element, exclusive, to be sorted
 *
 * @throws java.lang.IllegalArgumentException if {@code fromIndex > toIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *     if {@code fromIndex < 0} or {@code toIndex > a.length}
 *
 * @since 1.8
 */

public static void parallelSort(@androidx.annotation.RecentlyNonNull int[] a, int fromIndex, int toIndex) { throw new RuntimeException("Stub!"); }

/**
 * Sorts the specified array into ascending numerical order.
 *
 * @implNote The sorting algorithm is a Dual-Pivot Quicksort by
 * Vladimir Yaroslavskiy, Jon Bentley and Josh Bloch. This algorithm
 * offers O(n log(n)) performance on all data sets, and is typically
 * faster than traditional (one-pivot) Quicksort implementations.
 *
 * @param a the array to be sorted
 *
 * @since 1.8
 */

public static void parallelSort(@androidx.annotation.RecentlyNonNull long[] a) { throw new RuntimeException("Stub!"); }

/**
 * Sorts the specified range of the array into ascending numerical order.
 * The range to be sorted extends from the index {@code fromIndex},
 * inclusive, to the index {@code toIndex}, exclusive. If
 * {@code fromIndex == toIndex}, the range to be sorted is empty.
 *
 * @implNote The sorting algorithm is a Dual-Pivot Quicksort by
 * Vladimir Yaroslavskiy, Jon Bentley and Josh Bloch. This algorithm
 * offers O(n log(n)) performance on all data sets, and is typically
 * faster than traditional (one-pivot) Quicksort implementations.
 *
 * @param a the array to be sorted
 * @param fromIndex the index of the first element, inclusive, to be sorted
 * @param toIndex the index of the last element, exclusive, to be sorted
 *
 * @throws java.lang.IllegalArgumentException if {@code fromIndex > toIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *     if {@code fromIndex < 0} or {@code toIndex > a.length}
 *
 * @since 1.8
 */

public static void parallelSort(@androidx.annotation.RecentlyNonNull long[] a, int fromIndex, int toIndex) { throw new RuntimeException("Stub!"); }

/**
 * Sorts the specified array into ascending numerical order.
 *
 * <p>The {@code <} relation does not provide a total order on all float
 * values: {@code -0.0f == 0.0f} is {@code true} and a {@code Float.NaN}
 * value compares neither less than, greater than, nor equal to any value,
 * even itself. This method uses the total order imposed by the method
 * {@link java.lang.Float#compareTo Float#compareTo}: {@code -0.0f} is treated as less than value
 * {@code 0.0f} and {@code Float.NaN} is considered greater than any
 * other value and all {@code Float.NaN} values are considered equal.
 *
 * @implNote The sorting algorithm is a Dual-Pivot Quicksort by
 * Vladimir Yaroslavskiy, Jon Bentley and Josh Bloch. This algorithm
 * offers O(n log(n)) performance on all data sets, and is typically
 * faster than traditional (one-pivot) Quicksort implementations.
 *
 * @param a the array to be sorted
 *
 * @since 1.8
 */

public static void parallelSort(@androidx.annotation.RecentlyNonNull float[] a) { throw new RuntimeException("Stub!"); }

/**
 * Sorts the specified range of the array into ascending numerical order.
 * The range to be sorted extends from the index {@code fromIndex},
 * inclusive, to the index {@code toIndex}, exclusive. If
 * {@code fromIndex == toIndex}, the range to be sorted is empty.
 *
 * <p>The {@code <} relation does not provide a total order on all float
 * values: {@code -0.0f == 0.0f} is {@code true} and a {@code Float.NaN}
 * value compares neither less than, greater than, nor equal to any value,
 * even itself. This method uses the total order imposed by the method
 * {@link java.lang.Float#compareTo Float#compareTo}: {@code -0.0f} is treated as less than value
 * {@code 0.0f} and {@code Float.NaN} is considered greater than any
 * other value and all {@code Float.NaN} values are considered equal.
 *
 * @implNote The sorting algorithm is a Dual-Pivot Quicksort by
 * Vladimir Yaroslavskiy, Jon Bentley and Josh Bloch. This algorithm
 * offers O(n log(n)) performance on all data sets, and is typically
 * faster than traditional (one-pivot) Quicksort implementations.
 *
 * @param a the array to be sorted
 * @param fromIndex the index of the first element, inclusive, to be sorted
 * @param toIndex the index of the last element, exclusive, to be sorted
 *
 * @throws java.lang.IllegalArgumentException if {@code fromIndex > toIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *     if {@code fromIndex < 0} or {@code toIndex > a.length}
 *
 * @since 1.8
 */

public static void parallelSort(@androidx.annotation.RecentlyNonNull float[] a, int fromIndex, int toIndex) { throw new RuntimeException("Stub!"); }

/**
 * Sorts the specified array into ascending numerical order.
 *
 * <p>The {@code <} relation does not provide a total order on all double
 * values: {@code -0.0d == 0.0d} is {@code true} and a {@code Double.NaN}
 * value compares neither less than, greater than, nor equal to any value,
 * even itself. This method uses the total order imposed by the method
 * {@link java.lang.Double#compareTo Double#compareTo}: {@code -0.0d} is treated as less than value
 * {@code 0.0d} and {@code Double.NaN} is considered greater than any
 * other value and all {@code Double.NaN} values are considered equal.
 *
 * @implNote The sorting algorithm is a Dual-Pivot Quicksort by
 * Vladimir Yaroslavskiy, Jon Bentley and Josh Bloch. This algorithm
 * offers O(n log(n)) performance on all data sets, and is typically
 * faster than traditional (one-pivot) Quicksort implementations.
 *
 * @param a the array to be sorted
 *
 * @since 1.8
 */

public static void parallelSort(@androidx.annotation.RecentlyNonNull double[] a) { throw new RuntimeException("Stub!"); }

/**
 * Sorts the specified range of the array into ascending numerical order.
 * The range to be sorted extends from the index {@code fromIndex},
 * inclusive, to the index {@code toIndex}, exclusive. If
 * {@code fromIndex == toIndex}, the range to be sorted is empty.
 *
 * <p>The {@code <} relation does not provide a total order on all double
 * values: {@code -0.0d == 0.0d} is {@code true} and a {@code Double.NaN}
 * value compares neither less than, greater than, nor equal to any value,
 * even itself. This method uses the total order imposed by the method
 * {@link java.lang.Double#compareTo Double#compareTo}: {@code -0.0d} is treated as less than value
 * {@code 0.0d} and {@code Double.NaN} is considered greater than any
 * other value and all {@code Double.NaN} values are considered equal.
 *
 * @implNote The sorting algorithm is a Dual-Pivot Quicksort by
 * Vladimir Yaroslavskiy, Jon Bentley and Josh Bloch. This algorithm
 * offers O(n log(n)) performance on all data sets, and is typically
 * faster than traditional (one-pivot) Quicksort implementations.
 *
 * @param a the array to be sorted
 * @param fromIndex the index of the first element, inclusive, to be sorted
 * @param toIndex the index of the last element, exclusive, to be sorted
 *
 * @throws java.lang.IllegalArgumentException if {@code fromIndex > toIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *     if {@code fromIndex < 0} or {@code toIndex > a.length}
 *
 * @since 1.8
 */

public static void parallelSort(@androidx.annotation.RecentlyNonNull double[] a, int fromIndex, int toIndex) { throw new RuntimeException("Stub!"); }

/**
 * Sorts the specified array of objects into ascending order, according
 * to the {@linkplain java.lang.Comparable natural ordering} of its elements.
 * All elements in the array must implement the {@link java.lang.Comparable Comparable}
 * interface.  Furthermore, all elements in the array must be
 * <i>mutually comparable</i> (that is, {@code e1.compareTo(e2)} must
 * not throw a {@code ClassCastException} for any elements {@code e1}
 * and {@code e2} in the array).
 *
 * <p>This sort is guaranteed to be <i>stable</i>:  equal elements will
 * not be reordered as a result of the sort.
 *
 * @implNote The sorting algorithm is a parallel sort-merge that breaks the
 * array into sub-arrays that are themselves sorted and then merged. When
 * the sub-array length reaches a minimum granularity, the sub-array is
 * sorted using the appropriate {@link java.util.Arrays#sort(java.lang.Object[]) Arrays.sort}
 * method. If the length of the specified array is less than the minimum
 * granularity, then it is sorted using the appropriate {@link java.util.Arrays#sort(java.lang.Object[]) Arrays.sort} method. The algorithm requires a
 * working space no greater than the size of the original array. The
 * {@link java.util.concurrent.ForkJoinPool#commonPool() ForkJoin common pool} is used to
 * execute any parallel tasks.
 *
 * @param <T> the class of the objects to be sorted
 * @param a the array to be sorted
 *
 * @throws java.lang.ClassCastException if the array contains elements that are not
 *         <i>mutually comparable</i> (for example, strings and integers)
 * @throws java.lang.IllegalArgumentException (optional) if the natural
 *         ordering of the array elements is found to violate the
 *         {@link java.lang.Comparable Comparable} contract
 *
 * @since 1.8
 */

public static <T extends java.lang.Comparable<? super T>> void parallelSort(@androidx.annotation.RecentlyNonNull T[] a) { throw new RuntimeException("Stub!"); }

/**
 * Sorts the specified range of the specified array of objects into
 * ascending order, according to the
 * {@linkplain java.lang.Comparable natural ordering} of its
 * elements.  The range to be sorted extends from index
 * {@code fromIndex}, inclusive, to index {@code toIndex}, exclusive.
 * (If {@code fromIndex==toIndex}, the range to be sorted is empty.)  All
 * elements in this range must implement the {@link java.lang.Comparable Comparable}
 * interface.  Furthermore, all elements in this range must be <i>mutually
 * comparable</i> (that is, {@code e1.compareTo(e2)} must not throw a
 * {@code ClassCastException} for any elements {@code e1} and
 * {@code e2} in the array).
 *
 * <p>This sort is guaranteed to be <i>stable</i>:  equal elements will
 * not be reordered as a result of the sort.
 *
 * @implNote The sorting algorithm is a parallel sort-merge that breaks the
 * array into sub-arrays that are themselves sorted and then merged. When
 * the sub-array length reaches a minimum granularity, the sub-array is
 * sorted using the appropriate {@link java.util.Arrays#sort(java.lang.Object[]) Arrays.sort}
 * method. If the length of the specified array is less than the minimum
 * granularity, then it is sorted using the appropriate {@link java.util.Arrays#sort(java.lang.Object[]) Arrays.sort} method. The algorithm requires a working
 * space no greater than the size of the specified range of the original
 * array. The {@link java.util.concurrent.ForkJoinPool#commonPool() ForkJoin common pool} is
 * used to execute any parallel tasks.
 *
 * @param <T> the class of the objects to be sorted
 * @param a the array to be sorted
 * @param fromIndex the index of the first element (inclusive) to be
 *        sorted
 * @param toIndex the index of the last element (exclusive) to be sorted
 * @throws java.lang.IllegalArgumentException if {@code fromIndex > toIndex} or
 *         (optional) if the natural ordering of the array elements is
 *         found to violate the {@link java.lang.Comparable Comparable} contract
 * @throws java.lang.ArrayIndexOutOfBoundsException if {@code fromIndex < 0} or
 *         {@code toIndex > a.length}
 * @throws java.lang.ClassCastException if the array contains elements that are
 *         not <i>mutually comparable</i> (for example, strings and
 *         integers).
 *
 * @since 1.8
 */

public static <T extends java.lang.Comparable<? super T>> void parallelSort(@androidx.annotation.RecentlyNonNull T[] a, int fromIndex, int toIndex) { throw new RuntimeException("Stub!"); }

/**
 * Sorts the specified array of objects according to the order induced by
 * the specified comparator.  All elements in the array must be
 * <i>mutually comparable</i> by the specified comparator (that is,
 * {@code c.compare(e1, e2)} must not throw a {@code ClassCastException}
 * for any elements {@code e1} and {@code e2} in the array).
 *
 * <p>This sort is guaranteed to be <i>stable</i>:  equal elements will
 * not be reordered as a result of the sort.
 *
 * @implNote The sorting algorithm is a parallel sort-merge that breaks the
 * array into sub-arrays that are themselves sorted and then merged. When
 * the sub-array length reaches a minimum granularity, the sub-array is
 * sorted using the appropriate {@link java.util.Arrays#sort(java.lang.Object[]) Arrays.sort}
 * method. If the length of the specified array is less than the minimum
 * granularity, then it is sorted using the appropriate {@link java.util.Arrays#sort(java.lang.Object[]) Arrays.sort} method. The algorithm requires a
 * working space no greater than the size of the original array. The
 * {@link java.util.concurrent.ForkJoinPool#commonPool() ForkJoin common pool} is used to
 * execute any parallel tasks.
 *
 * @param <T> the class of the objects to be sorted
 * @param a the array to be sorted
 * @param cmp the comparator to determine the order of the array.  A
 *        {@code null} value indicates that the elements'
 *        {@linkplain java.lang.Comparable natural ordering} should be used.
 * @throws java.lang.ClassCastException if the array contains elements that are
 *         not <i>mutually comparable</i> using the specified comparator
 * @throws java.lang.IllegalArgumentException (optional) if the comparator is
 *         found to violate the {@link java.util.Comparator} contract
 *
 * @since 1.8
 */

public static <T> void parallelSort(@androidx.annotation.RecentlyNonNull T[] a, @androidx.annotation.RecentlyNullable java.util.Comparator<? super T> cmp) { throw new RuntimeException("Stub!"); }

/**
 * Sorts the specified range of the specified array of objects according
 * to the order induced by the specified comparator.  The range to be
 * sorted extends from index {@code fromIndex}, inclusive, to index
 * {@code toIndex}, exclusive.  (If {@code fromIndex==toIndex}, the
 * range to be sorted is empty.)  All elements in the range must be
 * <i>mutually comparable</i> by the specified comparator (that is,
 * {@code c.compare(e1, e2)} must not throw a {@code ClassCastException}
 * for any elements {@code e1} and {@code e2} in the range).
 *
 * <p>This sort is guaranteed to be <i>stable</i>:  equal elements will
 * not be reordered as a result of the sort.
 *
 * @implNote The sorting algorithm is a parallel sort-merge that breaks the
 * array into sub-arrays that are themselves sorted and then merged. When
 * the sub-array length reaches a minimum granularity, the sub-array is
 * sorted using the appropriate {@link java.util.Arrays#sort(java.lang.Object[]) Arrays.sort}
 * method. If the length of the specified array is less than the minimum
 * granularity, then it is sorted using the appropriate {@link java.util.Arrays#sort(java.lang.Object[]) Arrays.sort} method. The algorithm requires a working
 * space no greater than the size of the specified range of the original
 * array. The {@link java.util.concurrent.ForkJoinPool#commonPool() ForkJoin common pool} is
 * used to execute any parallel tasks.
 *
 * @param <T> the class of the objects to be sorted
 * @param a the array to be sorted
 * @param fromIndex the index of the first element (inclusive) to be
 *        sorted
 * @param toIndex the index of the last element (exclusive) to be sorted
 * @param cmp the comparator to determine the order of the array.  A
 *        {@code null} value indicates that the elements'
 *        {@linkplain java.lang.Comparable natural ordering} should be used.
 * @throws java.lang.IllegalArgumentException if {@code fromIndex > toIndex} or
 *         (optional) if the natural ordering of the array elements is
 *         found to violate the {@link java.lang.Comparable Comparable} contract
 * @throws java.lang.ArrayIndexOutOfBoundsException if {@code fromIndex < 0} or
 *         {@code toIndex > a.length}
 * @throws java.lang.ClassCastException if the array contains elements that are
 *         not <i>mutually comparable</i> (for example, strings and
 *         integers).
 *
 * @since 1.8
 */

public static <T> void parallelSort(@androidx.annotation.RecentlyNonNull T[] a, int fromIndex, int toIndex, @androidx.annotation.RecentlyNullable java.util.Comparator<? super T> cmp) { throw new RuntimeException("Stub!"); }

/**
 * Sorts the specified array of objects into ascending order, according
 * to the {@linkplain java.lang.Comparable natural ordering} of its elements.
 * All elements in the array must implement the {@link java.lang.Comparable Comparable}
 * interface.  Furthermore, all elements in the array must be
 * <i>mutually comparable</i> (that is, {@code e1.compareTo(e2)} must
 * not throw a {@code ClassCastException} for any elements {@code e1}
 * and {@code e2} in the array).
 *
 * <p>This sort is guaranteed to be <i>stable</i>:  equal elements will
 * not be reordered as a result of the sort.
 *
 * <p>Implementation note: This implementation is a stable, adaptive,
 * iterative mergesort that requires far fewer than n lg(n) comparisons
 * when the input array is partially sorted, while offering the
 * performance of a traditional mergesort when the input array is
 * randomly ordered.  If the input array is nearly sorted, the
 * implementation requires approximately n comparisons.  Temporary
 * storage requirements vary from a small constant for nearly sorted
 * input arrays to n/2 object references for randomly ordered input
 * arrays.
 *
 * <p>The implementation takes equal advantage of ascending and
 * descending order in its input array, and can take advantage of
 * ascending and descending order in different parts of the same
 * input array.  It is well-suited to merging two or more sorted arrays:
 * simply concatenate the arrays and sort the resulting array.
 *
 * <p>The implementation was adapted from Tim Peters's list sort for Python
 * (<a href="http://svn.python.org/projects/python/trunk/Objects/listsort.txt">
 * TimSort</a>).  It uses techniques from Peter McIlroy's "Optimistic
 * Sorting and Information Theoretic Complexity", in Proceedings of the
 * Fourth Annual ACM-SIAM Symposium on Discrete Algorithms, pp 467-474,
 * January 1993.
 *
 * @param a the array to be sorted
 * @throws java.lang.ClassCastException if the array contains elements that are not
 *         <i>mutually comparable</i> (for example, strings and integers)
 * @throws java.lang.IllegalArgumentException (optional) if the natural
 *         ordering of the array elements is found to violate the
 *         {@link java.lang.Comparable Comparable} contract
 */

public static void sort(@androidx.annotation.RecentlyNonNull java.lang.Object[] a) { throw new RuntimeException("Stub!"); }

/**
 * Sorts the specified range of the specified array of objects into
 * ascending order, according to the
 * {@linkplain java.lang.Comparable natural ordering} of its
 * elements.  The range to be sorted extends from index
 * {@code fromIndex}, inclusive, to index {@code toIndex}, exclusive.
 * (If {@code fromIndex==toIndex}, the range to be sorted is empty.)  All
 * elements in this range must implement the {@link java.lang.Comparable Comparable}
 * interface.  Furthermore, all elements in this range must be <i>mutually
 * comparable</i> (that is, {@code e1.compareTo(e2)} must not throw a
 * {@code ClassCastException} for any elements {@code e1} and
 * {@code e2} in the array).
 *
 * <p>This sort is guaranteed to be <i>stable</i>:  equal elements will
 * not be reordered as a result of the sort.
 *
 * <p>Implementation note: This implementation is a stable, adaptive,
 * iterative mergesort that requires far fewer than n lg(n) comparisons
 * when the input array is partially sorted, while offering the
 * performance of a traditional mergesort when the input array is
 * randomly ordered.  If the input array is nearly sorted, the
 * implementation requires approximately n comparisons.  Temporary
 * storage requirements vary from a small constant for nearly sorted
 * input arrays to n/2 object references for randomly ordered input
 * arrays.
 *
 * <p>The implementation takes equal advantage of ascending and
 * descending order in its input array, and can take advantage of
 * ascending and descending order in different parts of the same
 * input array.  It is well-suited to merging two or more sorted arrays:
 * simply concatenate the arrays and sort the resulting array.
 *
 * <p>The implementation was adapted from Tim Peters's list sort for Python
 * (<a href="http://svn.python.org/projects/python/trunk/Objects/listsort.txt">
 * TimSort</a>).  It uses techniques from Peter McIlroy's "Optimistic
 * Sorting and Information Theoretic Complexity", in Proceedings of the
 * Fourth Annual ACM-SIAM Symposium on Discrete Algorithms, pp 467-474,
 * January 1993.
 *
 * @param a the array to be sorted
 * @param fromIndex the index of the first element (inclusive) to be
 *        sorted
 * @param toIndex the index of the last element (exclusive) to be sorted
 * @throws java.lang.IllegalArgumentException if {@code fromIndex > toIndex} or
 *         (optional) if the natural ordering of the array elements is
 *         found to violate the {@link java.lang.Comparable Comparable} contract
 * @throws java.lang.ArrayIndexOutOfBoundsException if {@code fromIndex < 0} or
 *         {@code toIndex > a.length}
 * @throws java.lang.ClassCastException if the array contains elements that are
 *         not <i>mutually comparable</i> (for example, strings and
 *         integers).
 */

public static void sort(@androidx.annotation.RecentlyNonNull java.lang.Object[] a, int fromIndex, int toIndex) { throw new RuntimeException("Stub!"); }

/**
 * Sorts the specified array of objects according to the order induced by
 * the specified comparator.  All elements in the array must be
 * <i>mutually comparable</i> by the specified comparator (that is,
 * {@code c.compare(e1, e2)} must not throw a {@code ClassCastException}
 * for any elements {@code e1} and {@code e2} in the array).
 *
 * <p>This sort is guaranteed to be <i>stable</i>:  equal elements will
 * not be reordered as a result of the sort.
 *
 * <p>Implementation note: This implementation is a stable, adaptive,
 * iterative mergesort that requires far fewer than n lg(n) comparisons
 * when the input array is partially sorted, while offering the
 * performance of a traditional mergesort when the input array is
 * randomly ordered.  If the input array is nearly sorted, the
 * implementation requires approximately n comparisons.  Temporary
 * storage requirements vary from a small constant for nearly sorted
 * input arrays to n/2 object references for randomly ordered input
 * arrays.
 *
 * <p>The implementation takes equal advantage of ascending and
 * descending order in its input array, and can take advantage of
 * ascending and descending order in different parts of the same
 * input array.  It is well-suited to merging two or more sorted arrays:
 * simply concatenate the arrays and sort the resulting array.
 *
 * <p>The implementation was adapted from Tim Peters's list sort for Python
 * (<a href="http://svn.python.org/projects/python/trunk/Objects/listsort.txt">
 * TimSort</a>).  It uses techniques from Peter McIlroy's "Optimistic
 * Sorting and Information Theoretic Complexity", in Proceedings of the
 * Fourth Annual ACM-SIAM Symposium on Discrete Algorithms, pp 467-474,
 * January 1993.
 *
 * @param <T> the class of the objects to be sorted
 * @param a the array to be sorted
 * @param c the comparator to determine the order of the array.  A
 *        {@code null} value indicates that the elements'
 *        {@linkplain java.lang.Comparable natural ordering} should be used.
 * @throws java.lang.ClassCastException if the array contains elements that are
 *         not <i>mutually comparable</i> using the specified comparator
 * @throws java.lang.IllegalArgumentException (optional) if the comparator is
 *         found to violate the {@link java.util.Comparator Comparator} contract
 */

public static <T> void sort(@androidx.annotation.RecentlyNonNull T[] a, @androidx.annotation.RecentlyNullable java.util.Comparator<? super T> c) { throw new RuntimeException("Stub!"); }

/**
 * Sorts the specified range of the specified array of objects according
 * to the order induced by the specified comparator.  The range to be
 * sorted extends from index {@code fromIndex}, inclusive, to index
 * {@code toIndex}, exclusive.  (If {@code fromIndex==toIndex}, the
 * range to be sorted is empty.)  All elements in the range must be
 * <i>mutually comparable</i> by the specified comparator (that is,
 * {@code c.compare(e1, e2)} must not throw a {@code ClassCastException}
 * for any elements {@code e1} and {@code e2} in the range).
 *
 * <p>This sort is guaranteed to be <i>stable</i>:  equal elements will
 * not be reordered as a result of the sort.
 *
 * <p>Implementation note: This implementation is a stable, adaptive,
 * iterative mergesort that requires far fewer than n lg(n) comparisons
 * when the input array is partially sorted, while offering the
 * performance of a traditional mergesort when the input array is
 * randomly ordered.  If the input array is nearly sorted, the
 * implementation requires approximately n comparisons.  Temporary
 * storage requirements vary from a small constant for nearly sorted
 * input arrays to n/2 object references for randomly ordered input
 * arrays.
 *
 * <p>The implementation takes equal advantage of ascending and
 * descending order in its input array, and can take advantage of
 * ascending and descending order in different parts of the same
 * input array.  It is well-suited to merging two or more sorted arrays:
 * simply concatenate the arrays and sort the resulting array.
 *
 * <p>The implementation was adapted from Tim Peters's list sort for Python
 * (<a href="http://svn.python.org/projects/python/trunk/Objects/listsort.txt">
 * TimSort</a>).  It uses techniques from Peter McIlroy's "Optimistic
 * Sorting and Information Theoretic Complexity", in Proceedings of the
 * Fourth Annual ACM-SIAM Symposium on Discrete Algorithms, pp 467-474,
 * January 1993.
 *
 * @param <T> the class of the objects to be sorted
 * @param a the array to be sorted
 * @param fromIndex the index of the first element (inclusive) to be
 *        sorted
 * @param toIndex the index of the last element (exclusive) to be sorted
 * @param c the comparator to determine the order of the array.  A
 *        {@code null} value indicates that the elements'
 *        {@linkplain java.lang.Comparable natural ordering} should be used.
 * @throws java.lang.ClassCastException if the array contains elements that are not
 *         <i>mutually comparable</i> using the specified comparator.
 * @throws java.lang.IllegalArgumentException if {@code fromIndex > toIndex} or
 *         (optional) if the comparator is found to violate the
 *         {@link java.util.Comparator Comparator} contract
 * @throws java.lang.ArrayIndexOutOfBoundsException if {@code fromIndex < 0} or
 *         {@code toIndex > a.length}
 */

public static <T> void sort(@androidx.annotation.RecentlyNonNull T[] a, int fromIndex, int toIndex, @androidx.annotation.RecentlyNullable java.util.Comparator<? super T> c) { throw new RuntimeException("Stub!"); }

/**
 * Cumulates, in parallel, each element of the given array in place,
 * using the supplied function. For example if the array initially
 * holds {@code [2, 1, 0, 3]} and the operation performs addition,
 * then upon return the array holds {@code [2, 3, 3, 6]}.
 * Parallel prefix computation is usually more efficient than
 * sequential loops for large arrays.
 *
 * @param <T> the class of the objects in the array
 * @param array the array, which is modified in-place by this method
 * @param op a side-effect-free, associative function to perform the
 * cumulation
 * @throws java.lang.NullPointerException if the specified array or function is null
 * @since 1.8
 */

public static <T> void parallelPrefix(@androidx.annotation.RecentlyNonNull T[] array, @androidx.annotation.RecentlyNonNull java.util.function.BinaryOperator<T> op) { throw new RuntimeException("Stub!"); }

/**
 * Performs {@link #parallelPrefix(java.lang.Object[],java.util.function.BinaryOperator)}
 * for the given subrange of the array.
 *
 * @param <T> the class of the objects in the array
 * @param array the array
 * @param fromIndex the index of the first element, inclusive
 * @param toIndex the index of the last element, exclusive
 * @param op a side-effect-free, associative function to perform the
 * cumulation
 * @throws java.lang.IllegalArgumentException if {@code fromIndex > toIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *     if {@code fromIndex < 0} or {@code toIndex > array.length}
 * @throws java.lang.NullPointerException if the specified array or function is null
 * @since 1.8
 */

public static <T> void parallelPrefix(@androidx.annotation.RecentlyNonNull T[] array, int fromIndex, int toIndex, @androidx.annotation.RecentlyNonNull java.util.function.BinaryOperator<T> op) { throw new RuntimeException("Stub!"); }

/**
 * Cumulates, in parallel, each element of the given array in place,
 * using the supplied function. For example if the array initially
 * holds {@code [2, 1, 0, 3]} and the operation performs addition,
 * then upon return the array holds {@code [2, 3, 3, 6]}.
 * Parallel prefix computation is usually more efficient than
 * sequential loops for large arrays.
 *
 * @param array the array, which is modified in-place by this method
 * @param op a side-effect-free, associative function to perform the
 * cumulation
 * @throws java.lang.NullPointerException if the specified array or function is null
 * @since 1.8
 */

public static void parallelPrefix(@androidx.annotation.RecentlyNonNull long[] array, @androidx.annotation.RecentlyNonNull java.util.function.LongBinaryOperator op) { throw new RuntimeException("Stub!"); }

/**
 * Performs {@link #parallelPrefix(long[],java.util.function.LongBinaryOperator)}
 * for the given subrange of the array.
 *
 * @param array the array
 * @param fromIndex the index of the first element, inclusive
 * @param toIndex the index of the last element, exclusive
 * @param op a side-effect-free, associative function to perform the
 * cumulation
 * @throws java.lang.IllegalArgumentException if {@code fromIndex > toIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *     if {@code fromIndex < 0} or {@code toIndex > array.length}
 * @throws java.lang.NullPointerException if the specified array or function is null
 * @since 1.8
 */

public static void parallelPrefix(@androidx.annotation.RecentlyNonNull long[] array, int fromIndex, int toIndex, @androidx.annotation.RecentlyNonNull java.util.function.LongBinaryOperator op) { throw new RuntimeException("Stub!"); }

/**
 * Cumulates, in parallel, each element of the given array in place,
 * using the supplied function. For example if the array initially
 * holds {@code [2.0, 1.0, 0.0, 3.0]} and the operation performs addition,
 * then upon return the array holds {@code [2.0, 3.0, 3.0, 6.0]}.
 * Parallel prefix computation is usually more efficient than
 * sequential loops for large arrays.
 *
 * <p> Because floating-point operations may not be strictly associative,
 * the returned result may not be identical to the value that would be
 * obtained if the operation was performed sequentially.
 *
 * @param array the array, which is modified in-place by this method
 * @param op a side-effect-free function to perform the cumulation
 * @throws java.lang.NullPointerException if the specified array or function is null
 * @since 1.8
 */

public static void parallelPrefix(@androidx.annotation.RecentlyNonNull double[] array, @androidx.annotation.RecentlyNonNull java.util.function.DoubleBinaryOperator op) { throw new RuntimeException("Stub!"); }

/**
 * Performs {@link #parallelPrefix(double[],java.util.function.DoubleBinaryOperator)}
 * for the given subrange of the array.
 *
 * @param array the array
 * @param fromIndex the index of the first element, inclusive
 * @param toIndex the index of the last element, exclusive
 * @param op a side-effect-free, associative function to perform the
 * cumulation
 * @throws java.lang.IllegalArgumentException if {@code fromIndex > toIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *     if {@code fromIndex < 0} or {@code toIndex > array.length}
 * @throws java.lang.NullPointerException if the specified array or function is null
 * @since 1.8
 */

public static void parallelPrefix(@androidx.annotation.RecentlyNonNull double[] array, int fromIndex, int toIndex, @androidx.annotation.RecentlyNonNull java.util.function.DoubleBinaryOperator op) { throw new RuntimeException("Stub!"); }

/**
 * Cumulates, in parallel, each element of the given array in place,
 * using the supplied function. For example if the array initially
 * holds {@code [2, 1, 0, 3]} and the operation performs addition,
 * then upon return the array holds {@code [2, 3, 3, 6]}.
 * Parallel prefix computation is usually more efficient than
 * sequential loops for large arrays.
 *
 * @param array the array, which is modified in-place by this method
 * @param op a side-effect-free, associative function to perform the
 * cumulation
 * @throws java.lang.NullPointerException if the specified array or function is null
 * @since 1.8
 */

public static void parallelPrefix(@androidx.annotation.RecentlyNonNull int[] array, @androidx.annotation.RecentlyNonNull java.util.function.IntBinaryOperator op) { throw new RuntimeException("Stub!"); }

/**
 * Performs {@link #parallelPrefix(int[],java.util.function.IntBinaryOperator)}
 * for the given subrange of the array.
 *
 * @param array the array
 * @param fromIndex the index of the first element, inclusive
 * @param toIndex the index of the last element, exclusive
 * @param op a side-effect-free, associative function to perform the
 * cumulation
 * @throws java.lang.IllegalArgumentException if {@code fromIndex > toIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *     if {@code fromIndex < 0} or {@code toIndex > array.length}
 * @throws java.lang.NullPointerException if the specified array or function is null
 * @since 1.8
 */

public static void parallelPrefix(@androidx.annotation.RecentlyNonNull int[] array, int fromIndex, int toIndex, @androidx.annotation.RecentlyNonNull java.util.function.IntBinaryOperator op) { throw new RuntimeException("Stub!"); }

/**
 * Searches the specified array of longs for the specified value using the
 * binary search algorithm.  The array must be sorted (as
 * by the {@link #sort(long[])} method) prior to making this call.  If it
 * is not sorted, the results are undefined.  If the array contains
 * multiple elements with the specified value, there is no guarantee which
 * one will be found.
 *
 * @param a the array to be searched
 * @param key the value to be searched for
 * @return index of the search key, if it is contained in the array;
 *         otherwise, <code>(-(<i>insertion point</i>) - 1)</code>.  The
 *         <i>insertion point</i> is defined as the point at which the
 *         key would be inserted into the array: the index of the first
 *         element greater than the key, or {@code a.length} if all
 *         elements in the array are less than the specified key.  Note
 *         that this guarantees that the return value will be &gt;= 0 if
 *         and only if the key is found.
 */

public static int binarySearch(@androidx.annotation.RecentlyNonNull long[] a, long key) { throw new RuntimeException("Stub!"); }

/**
 * Searches a range of
 * the specified array of longs for the specified value using the
 * binary search algorithm.
 * The range must be sorted (as
 * by the {@link #sort(long[],int,int)} method)
 * prior to making this call.  If it
 * is not sorted, the results are undefined.  If the range contains
 * multiple elements with the specified value, there is no guarantee which
 * one will be found.
 *
 * @param a the array to be searched
 * @param fromIndex the index of the first element (inclusive) to be
 *          searched
 * @param toIndex the index of the last element (exclusive) to be searched
 * @param key the value to be searched for
 * @return index of the search key, if it is contained in the array
 *         within the specified range;
 *         otherwise, <code>(-(<i>insertion point</i>) - 1)</code>.  The
 *         <i>insertion point</i> is defined as the point at which the
 *         key would be inserted into the array: the index of the first
 *         element in the range greater than the key,
 *         or {@code toIndex} if all
 *         elements in the range are less than the specified key.  Note
 *         that this guarantees that the return value will be &gt;= 0 if
 *         and only if the key is found.
 * @throws java.lang.IllegalArgumentException
 *         if {@code fromIndex > toIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *         if {@code fromIndex < 0 or toIndex > a.length}
 * @since 1.6
 */

public static int binarySearch(@androidx.annotation.RecentlyNonNull long[] a, int fromIndex, int toIndex, long key) { throw new RuntimeException("Stub!"); }

/**
 * Searches the specified array of ints for the specified value using the
 * binary search algorithm.  The array must be sorted (as
 * by the {@link #sort(int[])} method) prior to making this call.  If it
 * is not sorted, the results are undefined.  If the array contains
 * multiple elements with the specified value, there is no guarantee which
 * one will be found.
 *
 * @param a the array to be searched
 * @param key the value to be searched for
 * @return index of the search key, if it is contained in the array;
 *         otherwise, <code>(-(<i>insertion point</i>) - 1)</code>.  The
 *         <i>insertion point</i> is defined as the point at which the
 *         key would be inserted into the array: the index of the first
 *         element greater than the key, or {@code a.length} if all
 *         elements in the array are less than the specified key.  Note
 *         that this guarantees that the return value will be &gt;= 0 if
 *         and only if the key is found.
 */

public static int binarySearch(@androidx.annotation.RecentlyNonNull int[] a, int key) { throw new RuntimeException("Stub!"); }

/**
 * Searches a range of
 * the specified array of ints for the specified value using the
 * binary search algorithm.
 * The range must be sorted (as
 * by the {@link #sort(int[],int,int)} method)
 * prior to making this call.  If it
 * is not sorted, the results are undefined.  If the range contains
 * multiple elements with the specified value, there is no guarantee which
 * one will be found.
 *
 * @param a the array to be searched
 * @param fromIndex the index of the first element (inclusive) to be
 *          searched
 * @param toIndex the index of the last element (exclusive) to be searched
 * @param key the value to be searched for
 * @return index of the search key, if it is contained in the array
 *         within the specified range;
 *         otherwise, <code>(-(<i>insertion point</i>) - 1)</code>.  The
 *         <i>insertion point</i> is defined as the point at which the
 *         key would be inserted into the array: the index of the first
 *         element in the range greater than the key,
 *         or {@code toIndex} if all
 *         elements in the range are less than the specified key.  Note
 *         that this guarantees that the return value will be &gt;= 0 if
 *         and only if the key is found.
 * @throws java.lang.IllegalArgumentException
 *         if {@code fromIndex > toIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *         if {@code fromIndex < 0 or toIndex > a.length}
 * @since 1.6
 */

public static int binarySearch(@androidx.annotation.RecentlyNonNull int[] a, int fromIndex, int toIndex, int key) { throw new RuntimeException("Stub!"); }

/**
 * Searches the specified array of shorts for the specified value using
 * the binary search algorithm.  The array must be sorted
 * (as by the {@link #sort(short[])} method) prior to making this call.  If
 * it is not sorted, the results are undefined.  If the array contains
 * multiple elements with the specified value, there is no guarantee which
 * one will be found.
 *
 * @param a the array to be searched
 * @param key the value to be searched for
 * @return index of the search key, if it is contained in the array;
 *         otherwise, <code>(-(<i>insertion point</i>) - 1)</code>.  The
 *         <i>insertion point</i> is defined as the point at which the
 *         key would be inserted into the array: the index of the first
 *         element greater than the key, or {@code a.length} if all
 *         elements in the array are less than the specified key.  Note
 *         that this guarantees that the return value will be &gt;= 0 if
 *         and only if the key is found.
 */

public static int binarySearch(@androidx.annotation.RecentlyNonNull short[] a, short key) { throw new RuntimeException("Stub!"); }

/**
 * Searches a range of
 * the specified array of shorts for the specified value using
 * the binary search algorithm.
 * The range must be sorted
 * (as by the {@link #sort(short[],int,int)} method)
 * prior to making this call.  If
 * it is not sorted, the results are undefined.  If the range contains
 * multiple elements with the specified value, there is no guarantee which
 * one will be found.
 *
 * @param a the array to be searched
 * @param fromIndex the index of the first element (inclusive) to be
 *          searched
 * @param toIndex the index of the last element (exclusive) to be searched
 * @param key the value to be searched for
 * @return index of the search key, if it is contained in the array
 *         within the specified range;
 *         otherwise, <code>(-(<i>insertion point</i>) - 1)</code>.  The
 *         <i>insertion point</i> is defined as the point at which the
 *         key would be inserted into the array: the index of the first
 *         element in the range greater than the key,
 *         or {@code toIndex} if all
 *         elements in the range are less than the specified key.  Note
 *         that this guarantees that the return value will be &gt;= 0 if
 *         and only if the key is found.
 * @throws java.lang.IllegalArgumentException
 *         if {@code fromIndex > toIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *         if {@code fromIndex < 0 or toIndex > a.length}
 * @since 1.6
 */

public static int binarySearch(@androidx.annotation.RecentlyNonNull short[] a, int fromIndex, int toIndex, short key) { throw new RuntimeException("Stub!"); }

/**
 * Searches the specified array of chars for the specified value using the
 * binary search algorithm.  The array must be sorted (as
 * by the {@link #sort(char[])} method) prior to making this call.  If it
 * is not sorted, the results are undefined.  If the array contains
 * multiple elements with the specified value, there is no guarantee which
 * one will be found.
 *
 * @param a the array to be searched
 * @param key the value to be searched for
 * @return index of the search key, if it is contained in the array;
 *         otherwise, <code>(-(<i>insertion point</i>) - 1)</code>.  The
 *         <i>insertion point</i> is defined as the point at which the
 *         key would be inserted into the array: the index of the first
 *         element greater than the key, or {@code a.length} if all
 *         elements in the array are less than the specified key.  Note
 *         that this guarantees that the return value will be &gt;= 0 if
 *         and only if the key is found.
 */

public static int binarySearch(@androidx.annotation.RecentlyNonNull char[] a, char key) { throw new RuntimeException("Stub!"); }

/**
 * Searches a range of
 * the specified array of chars for the specified value using the
 * binary search algorithm.
 * The range must be sorted (as
 * by the {@link #sort(char[],int,int)} method)
 * prior to making this call.  If it
 * is not sorted, the results are undefined.  If the range contains
 * multiple elements with the specified value, there is no guarantee which
 * one will be found.
 *
 * @param a the array to be searched
 * @param fromIndex the index of the first element (inclusive) to be
 *          searched
 * @param toIndex the index of the last element (exclusive) to be searched
 * @param key the value to be searched for
 * @return index of the search key, if it is contained in the array
 *         within the specified range;
 *         otherwise, <code>(-(<i>insertion point</i>) - 1)</code>.  The
 *         <i>insertion point</i> is defined as the point at which the
 *         key would be inserted into the array: the index of the first
 *         element in the range greater than the key,
 *         or {@code toIndex} if all
 *         elements in the range are less than the specified key.  Note
 *         that this guarantees that the return value will be &gt;= 0 if
 *         and only if the key is found.
 * @throws java.lang.IllegalArgumentException
 *         if {@code fromIndex > toIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *         if {@code fromIndex < 0 or toIndex > a.length}
 * @since 1.6
 */

public static int binarySearch(@androidx.annotation.RecentlyNonNull char[] a, int fromIndex, int toIndex, char key) { throw new RuntimeException("Stub!"); }

/**
 * Searches the specified array of bytes for the specified value using the
 * binary search algorithm.  The array must be sorted (as
 * by the {@link #sort(byte[])} method) prior to making this call.  If it
 * is not sorted, the results are undefined.  If the array contains
 * multiple elements with the specified value, there is no guarantee which
 * one will be found.
 *
 * @param a the array to be searched
 * @param key the value to be searched for
 * @return index of the search key, if it is contained in the array;
 *         otherwise, <code>(-(<i>insertion point</i>) - 1)</code>.  The
 *         <i>insertion point</i> is defined as the point at which the
 *         key would be inserted into the array: the index of the first
 *         element greater than the key, or {@code a.length} if all
 *         elements in the array are less than the specified key.  Note
 *         that this guarantees that the return value will be &gt;= 0 if
 *         and only if the key is found.
 */

public static int binarySearch(@androidx.annotation.RecentlyNonNull byte[] a, byte key) { throw new RuntimeException("Stub!"); }

/**
 * Searches a range of
 * the specified array of bytes for the specified value using the
 * binary search algorithm.
 * The range must be sorted (as
 * by the {@link #sort(byte[],int,int)} method)
 * prior to making this call.  If it
 * is not sorted, the results are undefined.  If the range contains
 * multiple elements with the specified value, there is no guarantee which
 * one will be found.
 *
 * @param a the array to be searched
 * @param fromIndex the index of the first element (inclusive) to be
 *          searched
 * @param toIndex the index of the last element (exclusive) to be searched
 * @param key the value to be searched for
 * @return index of the search key, if it is contained in the array
 *         within the specified range;
 *         otherwise, <code>(-(<i>insertion point</i>) - 1)</code>.  The
 *         <i>insertion point</i> is defined as the point at which the
 *         key would be inserted into the array: the index of the first
 *         element in the range greater than the key,
 *         or {@code toIndex} if all
 *         elements in the range are less than the specified key.  Note
 *         that this guarantees that the return value will be &gt;= 0 if
 *         and only if the key is found.
 * @throws java.lang.IllegalArgumentException
 *         if {@code fromIndex > toIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *         if {@code fromIndex < 0 or toIndex > a.length}
 * @since 1.6
 */

public static int binarySearch(@androidx.annotation.RecentlyNonNull byte[] a, int fromIndex, int toIndex, byte key) { throw new RuntimeException("Stub!"); }

/**
 * Searches the specified array of doubles for the specified value using
 * the binary search algorithm.  The array must be sorted
 * (as by the {@link #sort(double[])} method) prior to making this call.
 * If it is not sorted, the results are undefined.  If the array contains
 * multiple elements with the specified value, there is no guarantee which
 * one will be found.  This method considers all NaN values to be
 * equivalent and equal.
 *
 * @param a the array to be searched
 * @param key the value to be searched for
 * @return index of the search key, if it is contained in the array;
 *         otherwise, <code>(-(<i>insertion point</i>) - 1)</code>.  The
 *         <i>insertion point</i> is defined as the point at which the
 *         key would be inserted into the array: the index of the first
 *         element greater than the key, or {@code a.length} if all
 *         elements in the array are less than the specified key.  Note
 *         that this guarantees that the return value will be &gt;= 0 if
 *         and only if the key is found.
 */

public static int binarySearch(@androidx.annotation.RecentlyNonNull double[] a, double key) { throw new RuntimeException("Stub!"); }

/**
 * Searches a range of
 * the specified array of doubles for the specified value using
 * the binary search algorithm.
 * The range must be sorted
 * (as by the {@link #sort(double[],int,int)} method)
 * prior to making this call.
 * If it is not sorted, the results are undefined.  If the range contains
 * multiple elements with the specified value, there is no guarantee which
 * one will be found.  This method considers all NaN values to be
 * equivalent and equal.
 *
 * @param a the array to be searched
 * @param fromIndex the index of the first element (inclusive) to be
 *          searched
 * @param toIndex the index of the last element (exclusive) to be searched
 * @param key the value to be searched for
 * @return index of the search key, if it is contained in the array
 *         within the specified range;
 *         otherwise, <code>(-(<i>insertion point</i>) - 1)</code>.  The
 *         <i>insertion point</i> is defined as the point at which the
 *         key would be inserted into the array: the index of the first
 *         element in the range greater than the key,
 *         or {@code toIndex} if all
 *         elements in the range are less than the specified key.  Note
 *         that this guarantees that the return value will be &gt;= 0 if
 *         and only if the key is found.
 * @throws java.lang.IllegalArgumentException
 *         if {@code fromIndex > toIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *         if {@code fromIndex < 0 or toIndex > a.length}
 * @since 1.6
 */

public static int binarySearch(@androidx.annotation.RecentlyNonNull double[] a, int fromIndex, int toIndex, double key) { throw new RuntimeException("Stub!"); }

/**
 * Searches the specified array of floats for the specified value using
 * the binary search algorithm. The array must be sorted
 * (as by the {@link #sort(float[])} method) prior to making this call. If
 * it is not sorted, the results are undefined. If the array contains
 * multiple elements with the specified value, there is no guarantee which
 * one will be found. This method considers all NaN values to be
 * equivalent and equal.
 *
 * @param a the array to be searched
 * @param key the value to be searched for
 * @return index of the search key, if it is contained in the array;
 *         otherwise, <code>(-(<i>insertion point</i>) - 1)</code>. The
 *         <i>insertion point</i> is defined as the point at which the
 *         key would be inserted into the array: the index of the first
 *         element greater than the key, or {@code a.length} if all
 *         elements in the array are less than the specified key. Note
 *         that this guarantees that the return value will be &gt;= 0 if
 *         and only if the key is found.
 */

public static int binarySearch(@androidx.annotation.RecentlyNonNull float[] a, float key) { throw new RuntimeException("Stub!"); }

/**
 * Searches a range of
 * the specified array of floats for the specified value using
 * the binary search algorithm.
 * The range must be sorted
 * (as by the {@link #sort(float[],int,int)} method)
 * prior to making this call. If
 * it is not sorted, the results are undefined. If the range contains
 * multiple elements with the specified value, there is no guarantee which
 * one will be found. This method considers all NaN values to be
 * equivalent and equal.
 *
 * @param a the array to be searched
 * @param fromIndex the index of the first element (inclusive) to be
 *          searched
 * @param toIndex the index of the last element (exclusive) to be searched
 * @param key the value to be searched for
 * @return index of the search key, if it is contained in the array
 *         within the specified range;
 *         otherwise, <code>(-(<i>insertion point</i>) - 1)</code>. The
 *         <i>insertion point</i> is defined as the point at which the
 *         key would be inserted into the array: the index of the first
 *         element in the range greater than the key,
 *         or {@code toIndex} if all
 *         elements in the range are less than the specified key. Note
 *         that this guarantees that the return value will be &gt;= 0 if
 *         and only if the key is found.
 * @throws java.lang.IllegalArgumentException
 *         if {@code fromIndex > toIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *         if {@code fromIndex < 0 or toIndex > a.length}
 * @since 1.6
 */

public static int binarySearch(@androidx.annotation.RecentlyNonNull float[] a, int fromIndex, int toIndex, float key) { throw new RuntimeException("Stub!"); }

/**
 * Searches the specified array for the specified object using the binary
 * search algorithm. The array must be sorted into ascending order
 * according to the
 * {@linkplain java.lang.Comparable natural ordering}
 * of its elements (as by the
 * {@link #sort(java.lang.Object[])} method) prior to making this call.
 * If it is not sorted, the results are undefined.
 * (If the array contains elements that are not mutually comparable (for
 * example, strings and integers), it <i>cannot</i> be sorted according
 * to the natural ordering of its elements, hence results are undefined.)
 * If the array contains multiple
 * elements equal to the specified object, there is no guarantee which
 * one will be found.
 *
 * @param a the array to be searched
 * @param key the value to be searched for
 * @return index of the search key, if it is contained in the array;
 *         otherwise, <code>(-(<i>insertion point</i>) - 1)</code>.  The
 *         <i>insertion point</i> is defined as the point at which the
 *         key would be inserted into the array: the index of the first
 *         element greater than the key, or {@code a.length} if all
 *         elements in the array are less than the specified key.  Note
 *         that this guarantees that the return value will be &gt;= 0 if
 *         and only if the key is found.
 * @throws java.lang.ClassCastException if the search key is not comparable to the
 *         elements of the array.
 */

public static int binarySearch(@androidx.annotation.RecentlyNonNull java.lang.Object[] a, @androidx.annotation.RecentlyNonNull java.lang.Object key) { throw new RuntimeException("Stub!"); }

/**
 * Searches a range of
 * the specified array for the specified object using the binary
 * search algorithm.
 * The range must be sorted into ascending order
 * according to the
 * {@linkplain java.lang.Comparable natural ordering}
 * of its elements (as by the
 * {@link #sort(java.lang.Object[],int,int)} method) prior to making this
 * call.  If it is not sorted, the results are undefined.
 * (If the range contains elements that are not mutually comparable (for
 * example, strings and integers), it <i>cannot</i> be sorted according
 * to the natural ordering of its elements, hence results are undefined.)
 * If the range contains multiple
 * elements equal to the specified object, there is no guarantee which
 * one will be found.
 *
 * @param a the array to be searched
 * @param fromIndex the index of the first element (inclusive) to be
 *          searched
 * @param toIndex the index of the last element (exclusive) to be searched
 * @param key the value to be searched for
 * @return index of the search key, if it is contained in the array
 *         within the specified range;
 *         otherwise, <code>(-(<i>insertion point</i>) - 1)</code>.  The
 *         <i>insertion point</i> is defined as the point at which the
 *         key would be inserted into the array: the index of the first
 *         element in the range greater than the key,
 *         or {@code toIndex} if all
 *         elements in the range are less than the specified key.  Note
 *         that this guarantees that the return value will be &gt;= 0 if
 *         and only if the key is found.
 * @throws java.lang.ClassCastException if the search key is not comparable to the
 *         elements of the array within the specified range.
 * @throws java.lang.IllegalArgumentException
 *         if {@code fromIndex > toIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *         if {@code fromIndex < 0 or toIndex > a.length}
 * @since 1.6
 */

public static int binarySearch(@androidx.annotation.RecentlyNonNull java.lang.Object[] a, int fromIndex, int toIndex, @androidx.annotation.RecentlyNonNull java.lang.Object key) { throw new RuntimeException("Stub!"); }

/**
 * Searches the specified array for the specified object using the binary
 * search algorithm.  The array must be sorted into ascending order
 * according to the specified comparator (as by the
 * {@link #sort(java.lang.Object[],java.util.Comparator) sort(T[], Comparator)}
 * method) prior to making this call.  If it is
 * not sorted, the results are undefined.
 * If the array contains multiple
 * elements equal to the specified object, there is no guarantee which one
 * will be found.
 *
 * @param <T> the class of the objects in the array
 * @param a the array to be searched
 * @param key the value to be searched for
 * @param c the comparator by which the array is ordered.  A
 *        {@code null} value indicates that the elements'
 *        {@linkplain java.lang.Comparable natural ordering} should be used.
 * @return index of the search key, if it is contained in the array;
 *         otherwise, <code>(-(<i>insertion point</i>) - 1)</code>.  The
 *         <i>insertion point</i> is defined as the point at which the
 *         key would be inserted into the array: the index of the first
 *         element greater than the key, or {@code a.length} if all
 *         elements in the array are less than the specified key.  Note
 *         that this guarantees that the return value will be &gt;= 0 if
 *         and only if the key is found.
 * @throws java.lang.ClassCastException if the array contains elements that are not
 *         <i>mutually comparable</i> using the specified comparator,
 *         or the search key is not comparable to the
 *         elements of the array using this comparator.
 */

public static <T> int binarySearch(@androidx.annotation.RecentlyNonNull T[] a, T key, @androidx.annotation.RecentlyNullable java.util.Comparator<? super T> c) { throw new RuntimeException("Stub!"); }

/**
 * Searches a range of
 * the specified array for the specified object using the binary
 * search algorithm.
 * The range must be sorted into ascending order
 * according to the specified comparator (as by the
 * {@link #sort(java.lang.Object[],int,int,java.util.Comparator)
 * sort(T[], int, int, Comparator)}
 * method) prior to making this call.
 * If it is not sorted, the results are undefined.
 * If the range contains multiple elements equal to the specified object,
 * there is no guarantee which one will be found.
 *
 * @param <T> the class of the objects in the array
 * @param a the array to be searched
 * @param fromIndex the index of the first element (inclusive) to be
 *          searched
 * @param toIndex the index of the last element (exclusive) to be searched
 * @param key the value to be searched for
 * @param c the comparator by which the array is ordered.  A
 *        {@code null} value indicates that the elements'
 *        {@linkplain java.lang.Comparable natural ordering} should be used.
 * @return index of the search key, if it is contained in the array
 *         within the specified range;
 *         otherwise, <code>(-(<i>insertion point</i>) - 1)</code>.  The
 *         <i>insertion point</i> is defined as the point at which the
 *         key would be inserted into the array: the index of the first
 *         element in the range greater than the key,
 *         or {@code toIndex} if all
 *         elements in the range are less than the specified key.  Note
 *         that this guarantees that the return value will be &gt;= 0 if
 *         and only if the key is found.
 * @throws java.lang.ClassCastException if the range contains elements that are not
 *         <i>mutually comparable</i> using the specified comparator,
 *         or the search key is not comparable to the
 *         elements in the range using this comparator.
 * @throws java.lang.IllegalArgumentException
 *         if {@code fromIndex > toIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *         if {@code fromIndex < 0 or toIndex > a.length}
 * @since 1.6
 */

public static <T> int binarySearch(@androidx.annotation.RecentlyNonNull T[] a, int fromIndex, int toIndex, T key, @androidx.annotation.RecentlyNullable java.util.Comparator<? super T> c) { throw new RuntimeException("Stub!"); }

/**
 * Returns {@code true} if the two specified arrays of longs are
 * <i>equal</i> to one another.  Two arrays are considered equal if both
 * arrays contain the same number of elements, and all corresponding pairs
 * of elements in the two arrays are equal.  In other words, two arrays
 * are equal if they contain the same elements in the same order.  Also,
 * two array references are considered equal if both are {@code null}.
 *
 * @param a one array to be tested for equality
 * @param a2 the other array to be tested for equality
 * @return {@code true} if the two arrays are equal
 */

public static boolean equals(@androidx.annotation.RecentlyNullable long[] a, @androidx.annotation.RecentlyNullable long[] a2) { throw new RuntimeException("Stub!"); }

/**
 * Returns true if the two specified arrays of longs, over the specified
 * ranges, are <i>equal</i> to one another.
 *
 * <p>Two arrays are considered equal if the number of elements covered by
 * each range is the same, and all corresponding pairs of elements over the
 * specified ranges in the two arrays are equal.  In other words, two arrays
 * are equal if they contain, over the specified ranges, the same elements
 * in the same order.
 *
 * @param a the first array to be tested for equality
 * @param aFromIndex the index (inclusive) of the first element in the
 *                   first array to be tested
 * @param aToIndex the index (exclusive) of the last element in the
 *                 first array to be tested
 * @param b the second array to be tested for equality
 * @param bFromIndex the index (inclusive) of the first element in the
 *                   second array to be tested
 * @param bToIndex the index (exclusive) of the last element in the
 *                 second array to be tested
 * @return {@code true} if the two arrays, over the specified ranges, are
 *         equal
 * @throws java.lang.IllegalArgumentException
 *         if {@code aFromIndex > aToIndex} or
 *         if {@code bFromIndex > bToIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *         if {@code aFromIndex < 0 or aToIndex > a.length} or
 *         if {@code bFromIndex < 0 or bToIndex > b.length}
 * @throws java.lang.NullPointerException
 *         if either array is {@code null}
 * @since 9
 */

public static boolean equals(@androidx.annotation.RecentlyNonNull long[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull long[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

/**
 * Returns {@code true} if the two specified arrays of ints are
 * <i>equal</i> to one another.  Two arrays are considered equal if both
 * arrays contain the same number of elements, and all corresponding pairs
 * of elements in the two arrays are equal.  In other words, two arrays
 * are equal if they contain the same elements in the same order.  Also,
 * two array references are considered equal if both are {@code null}.
 *
 * @param a one array to be tested for equality
 * @param a2 the other array to be tested for equality
 * @return {@code true} if the two arrays are equal
 */

public static boolean equals(@androidx.annotation.RecentlyNullable int[] a, @androidx.annotation.RecentlyNullable int[] a2) { throw new RuntimeException("Stub!"); }

/**
 * Returns true if the two specified arrays of ints, over the specified
 * ranges, are <i>equal</i> to one another.
 *
 * <p>Two arrays are considered equal if the number of elements covered by
 * each range is the same, and all corresponding pairs of elements over the
 * specified ranges in the two arrays are equal.  In other words, two arrays
 * are equal if they contain, over the specified ranges, the same elements
 * in the same order.
 *
 * @param a the first array to be tested for equality
 * @param aFromIndex the index (inclusive) of the first element in the
 *                   first array to be tested
 * @param aToIndex the index (exclusive) of the last element in the
 *                 first array to be tested
 * @param b the second array to be tested for equality
 * @param bFromIndex the index (inclusive) of the first element in the
 *                   second array to be tested
 * @param bToIndex the index (exclusive) of the last element in the
 *                 second array to be tested
 * @return {@code true} if the two arrays, over the specified ranges, are
 *         equal
 * @throws java.lang.IllegalArgumentException
 *         if {@code aFromIndex > aToIndex} or
 *         if {@code bFromIndex > bToIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *         if {@code aFromIndex < 0 or aToIndex > a.length} or
 *         if {@code bFromIndex < 0 or bToIndex > b.length}
 * @throws java.lang.NullPointerException
 *         if either array is {@code null}
 * @since 9
 */

public static boolean equals(@androidx.annotation.RecentlyNonNull int[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull int[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

/**
 * Returns {@code true} if the two specified arrays of shorts are
 * <i>equal</i> to one another.  Two arrays are considered equal if both
 * arrays contain the same number of elements, and all corresponding pairs
 * of elements in the two arrays are equal.  In other words, two arrays
 * are equal if they contain the same elements in the same order.  Also,
 * two array references are considered equal if both are {@code null}.
 *
 * @param a one array to be tested for equality
 * @param a2 the other array to be tested for equality
 * @return {@code true} if the two arrays are equal
 */

public static boolean equals(@androidx.annotation.RecentlyNullable short[] a, @androidx.annotation.RecentlyNullable short[] a2) { throw new RuntimeException("Stub!"); }

/**
 * Returns true if the two specified arrays of shorts, over the specified
 * ranges, are <i>equal</i> to one another.
 *
 * <p>Two arrays are considered equal if the number of elements covered by
 * each range is the same, and all corresponding pairs of elements over the
 * specified ranges in the two arrays are equal.  In other words, two arrays
 * are equal if they contain, over the specified ranges, the same elements
 * in the same order.
 *
 * @param a the first array to be tested for equality
 * @param aFromIndex the index (inclusive) of the first element in the
 *                   first array to be tested
 * @param aToIndex the index (exclusive) of the last element in the
 *                 first array to be tested
 * @param b the second array to be tested for equality
 * @param bFromIndex the index (inclusive) of the first element in the
 *                   second array to be tested
 * @param bToIndex the index (exclusive) of the last element in the
 *                 second array to be tested
 * @return {@code true} if the two arrays, over the specified ranges, are
 *         equal
 * @throws java.lang.IllegalArgumentException
 *         if {@code aFromIndex > aToIndex} or
 *         if {@code bFromIndex > bToIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *         if {@code aFromIndex < 0 or aToIndex > a.length} or
 *         if {@code bFromIndex < 0 or bToIndex > b.length}
 * @throws java.lang.NullPointerException
 *         if either array is {@code null}
 * @since 9
 */

public static boolean equals(@androidx.annotation.RecentlyNonNull short[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull short[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

/**
 * Returns {@code true} if the two specified arrays of chars are
 * <i>equal</i> to one another.  Two arrays are considered equal if both
 * arrays contain the same number of elements, and all corresponding pairs
 * of elements in the two arrays are equal.  In other words, two arrays
 * are equal if they contain the same elements in the same order.  Also,
 * two array references are considered equal if both are {@code null}.
 *
 * @param a one array to be tested for equality
 * @param a2 the other array to be tested for equality
 * @return {@code true} if the two arrays are equal
 */

public static boolean equals(@androidx.annotation.RecentlyNullable char[] a, @androidx.annotation.RecentlyNullable char[] a2) { throw new RuntimeException("Stub!"); }

/**
 * Returns true if the two specified arrays of chars, over the specified
 * ranges, are <i>equal</i> to one another.
 *
 * <p>Two arrays are considered equal if the number of elements covered by
 * each range is the same, and all corresponding pairs of elements over the
 * specified ranges in the two arrays are equal.  In other words, two arrays
 * are equal if they contain, over the specified ranges, the same elements
 * in the same order.
 *
 * @param a the first array to be tested for equality
 * @param aFromIndex the index (inclusive) of the first element in the
 *                   first array to be tested
 * @param aToIndex the index (exclusive) of the last element in the
 *                 first array to be tested
 * @param b the second array to be tested for equality
 * @param bFromIndex the index (inclusive) of the first element in the
 *                   second array to be tested
 * @param bToIndex the index (exclusive) of the last element in the
 *                 second array to be tested
 * @return {@code true} if the two arrays, over the specified ranges, are
 *         equal
 * @throws java.lang.IllegalArgumentException
 *         if {@code aFromIndex > aToIndex} or
 *         if {@code bFromIndex > bToIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *         if {@code aFromIndex < 0 or aToIndex > a.length} or
 *         if {@code bFromIndex < 0 or bToIndex > b.length}
 * @throws java.lang.NullPointerException
 *         if either array is {@code null}
 * @since 9
 */

public static boolean equals(@androidx.annotation.RecentlyNonNull char[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull char[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

/**
 * Returns {@code true} if the two specified arrays of bytes are
 * <i>equal</i> to one another.  Two arrays are considered equal if both
 * arrays contain the same number of elements, and all corresponding pairs
 * of elements in the two arrays are equal.  In other words, two arrays
 * are equal if they contain the same elements in the same order.  Also,
 * two array references are considered equal if both are {@code null}.
 *
 * @param a one array to be tested for equality
 * @param a2 the other array to be tested for equality
 * @return {@code true} if the two arrays are equal
 */

public static boolean equals(@androidx.annotation.RecentlyNullable byte[] a, @androidx.annotation.RecentlyNullable byte[] a2) { throw new RuntimeException("Stub!"); }

/**
 * Returns true if the two specified arrays of bytes, over the specified
 * ranges, are <i>equal</i> to one another.
 *
 * <p>Two arrays are considered equal if the number of elements covered by
 * each range is the same, and all corresponding pairs of elements over the
 * specified ranges in the two arrays are equal.  In other words, two arrays
 * are equal if they contain, over the specified ranges, the same elements
 * in the same order.
 *
 * @param a the first array to be tested for equality
 * @param aFromIndex the index (inclusive) of the first element in the
 *                   first array to be tested
 * @param aToIndex the index (exclusive) of the last element in the
 *                 first array to be tested
 * @param b the second array to be tested for equality
 * @param bFromIndex the index (inclusive) of the first element in the
 *                   second array to be tested
 * @param bToIndex the index (exclusive) of the last element in the
 *                 second array to be tested
 * @return {@code true} if the two arrays, over the specified ranges, are
 *         equal
 * @throws java.lang.IllegalArgumentException
 *         if {@code aFromIndex > aToIndex} or
 *         if {@code bFromIndex > bToIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *         if {@code aFromIndex < 0 or aToIndex > a.length} or
 *         if {@code bFromIndex < 0 or bToIndex > b.length}
 * @throws java.lang.NullPointerException
 *         if either array is {@code null}
 * @since 9
 */

public static boolean equals(@androidx.annotation.RecentlyNonNull byte[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull byte[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

/**
 * Returns {@code true} if the two specified arrays of booleans are
 * <i>equal</i> to one another.  Two arrays are considered equal if both
 * arrays contain the same number of elements, and all corresponding pairs
 * of elements in the two arrays are equal.  In other words, two arrays
 * are equal if they contain the same elements in the same order.  Also,
 * two array references are considered equal if both are {@code null}.
 *
 * @param a one array to be tested for equality
 * @param a2 the other array to be tested for equality
 * @return {@code true} if the two arrays are equal
 */

public static boolean equals(@androidx.annotation.RecentlyNullable boolean[] a, @androidx.annotation.RecentlyNullable boolean[] a2) { throw new RuntimeException("Stub!"); }

/**
 * Returns true if the two specified arrays of booleans, over the specified
 * ranges, are <i>equal</i> to one another.
 *
 * <p>Two arrays are considered equal if the number of elements covered by
 * each range is the same, and all corresponding pairs of elements over the
 * specified ranges in the two arrays are equal.  In other words, two arrays
 * are equal if they contain, over the specified ranges, the same elements
 * in the same order.
 *
 * @param a the first array to be tested for equality
 * @param aFromIndex the index (inclusive) of the first element in the
 *                   first array to be tested
 * @param aToIndex the index (exclusive) of the last element in the
 *                 first array to be tested
 * @param b the second array to be tested for equality
 * @param bFromIndex the index (inclusive) of the first element in the
 *                   second array to be tested
 * @param bToIndex the index (exclusive) of the last element in the
 *                 second array to be tested
 * @return {@code true} if the two arrays, over the specified ranges, are
 *         equal
 * @throws java.lang.IllegalArgumentException
 *         if {@code aFromIndex > aToIndex} or
 *         if {@code bFromIndex > bToIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *         if {@code aFromIndex < 0 or aToIndex > a.length} or
 *         if {@code bFromIndex < 0 or bToIndex > b.length}
 * @throws java.lang.NullPointerException
 *         if either array is {@code null}
 * @since 9
 */

public static boolean equals(@androidx.annotation.RecentlyNonNull boolean[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull boolean[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

/**
 * Returns {@code true} if the two specified arrays of doubles are
 * <i>equal</i> to one another.  Two arrays are considered equal if both
 * arrays contain the same number of elements, and all corresponding pairs
 * of elements in the two arrays are equal.  In other words, two arrays
 * are equal if they contain the same elements in the same order.  Also,
 * two array references are considered equal if both are {@code null}.
 *
 * Two doubles {@code d1} and {@code d2} are considered equal if:
 * <pre>    {@code new Double(d1).equals(new Double(d2))}</pre>
 * (Unlike the {@code ==} operator, this method considers
 * {@code NaN} equal to itself, and 0.0d unequal to -0.0d.)
 *
 * @param a one array to be tested for equality
 * @param a2 the other array to be tested for equality
 * @return {@code true} if the two arrays are equal
 * @see java.lang.Double#equals(Object)
 */

public static boolean equals(@androidx.annotation.RecentlyNullable double[] a, @androidx.annotation.RecentlyNullable double[] a2) { throw new RuntimeException("Stub!"); }

/**
 * Returns true if the two specified arrays of doubles, over the specified
 * ranges, are <i>equal</i> to one another.
 *
 * <p>Two arrays are considered equal if the number of elements covered by
 * each range is the same, and all corresponding pairs of elements over the
 * specified ranges in the two arrays are equal.  In other words, two arrays
 * are equal if they contain, over the specified ranges, the same elements
 * in the same order.
 *
 * <p>Two doubles {@code d1} and {@code d2} are considered equal if:
 * <pre>    {@code new Double(d1).equals(new Double(d2))}</pre>
 * (Unlike the {@code ==} operator, this method considers
 * {@code NaN} equal to itself, and 0.0d unequal to -0.0d.)
 *
 * @param a the first array to be tested for equality
 * @param aFromIndex the index (inclusive) of the first element in the
 *                   first array to be tested
 * @param aToIndex the index (exclusive) of the last element in the
 *                 first array to be tested
 * @param b the second array to be tested for equality
 * @param bFromIndex the index (inclusive) of the first element in the
 *                   second array to be tested
 * @param bToIndex the index (exclusive) of the last element in the
 *                 second array to be tested
 * @return {@code true} if the two arrays, over the specified ranges, are
 *         equal
 * @throws java.lang.IllegalArgumentException
 *         if {@code aFromIndex > aToIndex} or
 *         if {@code bFromIndex > bToIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *         if {@code aFromIndex < 0 or aToIndex > a.length} or
 *         if {@code bFromIndex < 0 or bToIndex > b.length}
 * @throws java.lang.NullPointerException
 *         if either array is {@code null}
 * @see java.lang.Double#equals(Object)
 * @since 9
 */

public static boolean equals(@androidx.annotation.RecentlyNonNull double[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull double[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

/**
 * Returns {@code true} if the two specified arrays of floats are
 * <i>equal</i> to one another.  Two arrays are considered equal if both
 * arrays contain the same number of elements, and all corresponding pairs
 * of elements in the two arrays are equal.  In other words, two arrays
 * are equal if they contain the same elements in the same order.  Also,
 * two array references are considered equal if both are {@code null}.
 *
 * Two floats {@code f1} and {@code f2} are considered equal if:
 * <pre>    {@code new Float(f1).equals(new Float(f2))}</pre>
 * (Unlike the {@code ==} operator, this method considers
 * {@code NaN} equal to itself, and 0.0f unequal to -0.0f.)
 *
 * @param a one array to be tested for equality
 * @param a2 the other array to be tested for equality
 * @return {@code true} if the two arrays are equal
 * @see java.lang.Float#equals(Object)
 */

public static boolean equals(@androidx.annotation.RecentlyNullable float[] a, @androidx.annotation.RecentlyNullable float[] a2) { throw new RuntimeException("Stub!"); }

/**
 * Returns true if the two specified arrays of floats, over the specified
 * ranges, are <i>equal</i> to one another.
 *
 * <p>Two arrays are considered equal if the number of elements covered by
 * each range is the same, and all corresponding pairs of elements over the
 * specified ranges in the two arrays are equal.  In other words, two arrays
 * are equal if they contain, over the specified ranges, the same elements
 * in the same order.
 *
 * <p>Two floats {@code f1} and {@code f2} are considered equal if:
 * <pre>    {@code new Float(f1).equals(new Float(f2))}</pre>
 * (Unlike the {@code ==} operator, this method considers
 * {@code NaN} equal to itself, and 0.0f unequal to -0.0f.)
 *
 * @param a the first array to be tested for equality
 * @param aFromIndex the index (inclusive) of the first element in the
 *                   first array to be tested
 * @param aToIndex the index (exclusive) of the last element in the
 *                 first array to be tested
 * @param b the second array to be tested for equality
 * @param bFromIndex the index (inclusive) of the first element in the
 *                   second array to be tested
 * @param bToIndex the index (exclusive) of the last element in the
 *                 second array to be tested
 * @return {@code true} if the two arrays, over the specified ranges, are
 *         equal
 * @throws java.lang.IllegalArgumentException
 *         if {@code aFromIndex > aToIndex} or
 *         if {@code bFromIndex > bToIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *         if {@code aFromIndex < 0 or aToIndex > a.length} or
 *         if {@code bFromIndex < 0 or bToIndex > b.length}
 * @throws java.lang.NullPointerException
 *         if either array is {@code null}
 * @see java.lang.Float#equals(Object)
 * @since 9
 */

public static boolean equals(@androidx.annotation.RecentlyNonNull float[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull float[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

/**
 * Returns {@code true} if the two specified arrays of Objects are
 * <i>equal</i> to one another.  The two arrays are considered equal if
 * both arrays contain the same number of elements, and all corresponding
 * pairs of elements in the two arrays are equal.  Two objects {@code e1}
 * and {@code e2} are considered <i>equal</i> if
 * {@code Objects.equals(e1, e2)}.
 * In other words, the two arrays are equal if
 * they contain the same elements in the same order.  Also, two array
 * references are considered equal if both are {@code null}.
 *
 * @param a one array to be tested for equality
 * @param a2 the other array to be tested for equality
 * @return {@code true} if the two arrays are equal
 */

public static boolean equals(@androidx.annotation.RecentlyNullable java.lang.Object[] a, @androidx.annotation.RecentlyNullable java.lang.Object[] a2) { throw new RuntimeException("Stub!"); }

/**
 * Returns true if the two specified arrays of Objects, over the specified
 * ranges, are <i>equal</i> to one another.
 *
 * <p>Two arrays are considered equal if the number of elements covered by
 * each range is the same, and all corresponding pairs of elements over the
 * specified ranges in the two arrays are equal.  In other words, two arrays
 * are equal if they contain, over the specified ranges, the same elements
 * in the same order.
 *
 * <p>Two objects {@code e1} and {@code e2} are considered <i>equal</i> if
 * {@code Objects.equals(e1, e2)}.
 *
 * @param a the first array to be tested for equality
 * @param aFromIndex the index (inclusive) of the first element in the
 *                   first array to be tested
 * @param aToIndex the index (exclusive) of the last element in the
 *                 first array to be tested
 * @param b the second array to be tested for equality
 * @param bFromIndex the index (inclusive) of the first element in the
 *                   second array to be tested
 * @param bToIndex the index (exclusive) of the last element in the
 *                 second array to be tested
 * @return {@code true} if the two arrays, over the specified ranges, are
 *         equal
 * @throws java.lang.IllegalArgumentException
 *         if {@code aFromIndex > aToIndex} or
 *         if {@code bFromIndex > bToIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *         if {@code aFromIndex < 0 or aToIndex > a.length} or
 *         if {@code bFromIndex < 0 or bToIndex > b.length}
 * @throws java.lang.NullPointerException
 *         if either array is {@code null}
 * @since 9
 */

public static boolean equals(@androidx.annotation.RecentlyNonNull java.lang.Object[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull java.lang.Object[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

/**
 * Returns {@code true} if the two specified arrays of Objects are
 * <i>equal</i> to one another.
 *
 * <p>Two arrays are considered equal if both arrays contain the same number
 * of elements, and all corresponding pairs of elements in the two arrays
 * are equal.  In other words, the two arrays are equal if they contain the
 * same elements in the same order.  Also, two array references are
 * considered equal if both are {@code null}.
 *
 * <p>Two objects {@code e1} and {@code e2} are considered <i>equal</i> if,
 * given the specified comparator, {@code cmp.compare(e1, e2) == 0}.
 *
 * @param a one array to be tested for equality
 * @param a2 the other array to be tested for equality
 * @param cmp the comparator to compare array elements
 * @param <T> the type of array elements
 * @return {@code true} if the two arrays are equal
 * @throws java.lang.NullPointerException if the comparator is {@code null}
 * @since 9
 */

public static <T> boolean equals(@androidx.annotation.RecentlyNullable T[] a, @androidx.annotation.RecentlyNullable T[] a2, @androidx.annotation.RecentlyNonNull java.util.Comparator<? super T> cmp) { throw new RuntimeException("Stub!"); }

/**
 * Returns true if the two specified arrays of Objects, over the specified
 * ranges, are <i>equal</i> to one another.
 *
 * <p>Two arrays are considered equal if the number of elements covered by
 * each range is the same, and all corresponding pairs of elements over the
 * specified ranges in the two arrays are equal.  In other words, two arrays
 * are equal if they contain, over the specified ranges, the same elements
 * in the same order.
 *
 * <p>Two objects {@code e1} and {@code e2} are considered <i>equal</i> if,
 * given the specified comparator, {@code cmp.compare(e1, e2) == 0}.
 *
 * @param a the first array to be tested for equality
 * @param aFromIndex the index (inclusive) of the first element in the
 *                   first array to be tested
 * @param aToIndex the index (exclusive) of the last element in the
 *                 first array to be tested
 * @param b the second array to be tested for equality
 * @param bFromIndex the index (inclusive) of the first element in the
 *                   second array to be tested
 * @param bToIndex the index (exclusive) of the last element in the
 *                 second array to be tested
 * @param cmp the comparator to compare array elements
 * @param <T> the type of array elements
 * @return {@code true} if the two arrays, over the specified ranges, are
 *         equal
 * @throws java.lang.IllegalArgumentException
 *         if {@code aFromIndex > aToIndex} or
 *         if {@code bFromIndex > bToIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *         if {@code aFromIndex < 0 or aToIndex > a.length} or
 *         if {@code bFromIndex < 0 or bToIndex > b.length}
 * @throws java.lang.NullPointerException
 *         if either array or the comparator is {@code null}
 * @since 9
 */

public static <T> boolean equals(@androidx.annotation.RecentlyNonNull T[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull T[] b, int bFromIndex, int bToIndex, @androidx.annotation.RecentlyNonNull java.util.Comparator<? super T> cmp) { throw new RuntimeException("Stub!"); }

/**
 * Assigns the specified long value to each element of the specified array
 * of longs.
 *
 * @param a the array to be filled
 * @param val the value to be stored in all elements of the array
 */

public static void fill(@androidx.annotation.RecentlyNonNull long[] a, long val) { throw new RuntimeException("Stub!"); }

/**
 * Assigns the specified long value to each element of the specified
 * range of the specified array of longs.  The range to be filled
 * extends from index {@code fromIndex}, inclusive, to index
 * {@code toIndex}, exclusive.  (If {@code fromIndex==toIndex}, the
 * range to be filled is empty.)
 *
 * @param a the array to be filled
 * @param fromIndex the index of the first element (inclusive) to be
 *        filled with the specified value
 * @param toIndex the index of the last element (exclusive) to be
 *        filled with the specified value
 * @param val the value to be stored in all elements of the array
 * @throws java.lang.IllegalArgumentException if {@code fromIndex > toIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException if {@code fromIndex < 0} or
 *         {@code toIndex > a.length}
 */

public static void fill(@androidx.annotation.RecentlyNonNull long[] a, int fromIndex, int toIndex, long val) { throw new RuntimeException("Stub!"); }

/**
 * Assigns the specified int value to each element of the specified array
 * of ints.
 *
 * @param a the array to be filled
 * @param val the value to be stored in all elements of the array
 */

public static void fill(@androidx.annotation.RecentlyNonNull int[] a, int val) { throw new RuntimeException("Stub!"); }

/**
 * Assigns the specified int value to each element of the specified
 * range of the specified array of ints.  The range to be filled
 * extends from index {@code fromIndex}, inclusive, to index
 * {@code toIndex}, exclusive.  (If {@code fromIndex==toIndex}, the
 * range to be filled is empty.)
 *
 * @param a the array to be filled
 * @param fromIndex the index of the first element (inclusive) to be
 *        filled with the specified value
 * @param toIndex the index of the last element (exclusive) to be
 *        filled with the specified value
 * @param val the value to be stored in all elements of the array
 * @throws java.lang.IllegalArgumentException if {@code fromIndex > toIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException if {@code fromIndex < 0} or
 *         {@code toIndex > a.length}
 */

public static void fill(@androidx.annotation.RecentlyNonNull int[] a, int fromIndex, int toIndex, int val) { throw new RuntimeException("Stub!"); }

/**
 * Assigns the specified short value to each element of the specified array
 * of shorts.
 *
 * @param a the array to be filled
 * @param val the value to be stored in all elements of the array
 */

public static void fill(@androidx.annotation.RecentlyNonNull short[] a, short val) { throw new RuntimeException("Stub!"); }

/**
 * Assigns the specified short value to each element of the specified
 * range of the specified array of shorts.  The range to be filled
 * extends from index {@code fromIndex}, inclusive, to index
 * {@code toIndex}, exclusive.  (If {@code fromIndex==toIndex}, the
 * range to be filled is empty.)
 *
 * @param a the array to be filled
 * @param fromIndex the index of the first element (inclusive) to be
 *        filled with the specified value
 * @param toIndex the index of the last element (exclusive) to be
 *        filled with the specified value
 * @param val the value to be stored in all elements of the array
 * @throws java.lang.IllegalArgumentException if {@code fromIndex > toIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException if {@code fromIndex < 0} or
 *         {@code toIndex > a.length}
 */

public static void fill(@androidx.annotation.RecentlyNonNull short[] a, int fromIndex, int toIndex, short val) { throw new RuntimeException("Stub!"); }

/**
 * Assigns the specified char value to each element of the specified array
 * of chars.
 *
 * @param a the array to be filled
 * @param val the value to be stored in all elements of the array
 */

public static void fill(@androidx.annotation.RecentlyNonNull char[] a, char val) { throw new RuntimeException("Stub!"); }

/**
 * Assigns the specified char value to each element of the specified
 * range of the specified array of chars.  The range to be filled
 * extends from index {@code fromIndex}, inclusive, to index
 * {@code toIndex}, exclusive.  (If {@code fromIndex==toIndex}, the
 * range to be filled is empty.)
 *
 * @param a the array to be filled
 * @param fromIndex the index of the first element (inclusive) to be
 *        filled with the specified value
 * @param toIndex the index of the last element (exclusive) to be
 *        filled with the specified value
 * @param val the value to be stored in all elements of the array
 * @throws java.lang.IllegalArgumentException if {@code fromIndex > toIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException if {@code fromIndex < 0} or
 *         {@code toIndex > a.length}
 */

public static void fill(@androidx.annotation.RecentlyNonNull char[] a, int fromIndex, int toIndex, char val) { throw new RuntimeException("Stub!"); }

/**
 * Assigns the specified byte value to each element of the specified array
 * of bytes.
 *
 * @param a the array to be filled
 * @param val the value to be stored in all elements of the array
 */

public static void fill(@androidx.annotation.RecentlyNonNull byte[] a, byte val) { throw new RuntimeException("Stub!"); }

/**
 * Assigns the specified byte value to each element of the specified
 * range of the specified array of bytes.  The range to be filled
 * extends from index {@code fromIndex}, inclusive, to index
 * {@code toIndex}, exclusive.  (If {@code fromIndex==toIndex}, the
 * range to be filled is empty.)
 *
 * @param a the array to be filled
 * @param fromIndex the index of the first element (inclusive) to be
 *        filled with the specified value
 * @param toIndex the index of the last element (exclusive) to be
 *        filled with the specified value
 * @param val the value to be stored in all elements of the array
 * @throws java.lang.IllegalArgumentException if {@code fromIndex > toIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException if {@code fromIndex < 0} or
 *         {@code toIndex > a.length}
 */

public static void fill(@androidx.annotation.RecentlyNonNull byte[] a, int fromIndex, int toIndex, byte val) { throw new RuntimeException("Stub!"); }

/**
 * Assigns the specified boolean value to each element of the specified
 * array of booleans.
 *
 * @param a the array to be filled
 * @param val the value to be stored in all elements of the array
 */

public static void fill(@androidx.annotation.RecentlyNonNull boolean[] a, boolean val) { throw new RuntimeException("Stub!"); }

/**
 * Assigns the specified boolean value to each element of the specified
 * range of the specified array of booleans.  The range to be filled
 * extends from index {@code fromIndex}, inclusive, to index
 * {@code toIndex}, exclusive.  (If {@code fromIndex==toIndex}, the
 * range to be filled is empty.)
 *
 * @param a the array to be filled
 * @param fromIndex the index of the first element (inclusive) to be
 *        filled with the specified value
 * @param toIndex the index of the last element (exclusive) to be
 *        filled with the specified value
 * @param val the value to be stored in all elements of the array
 * @throws java.lang.IllegalArgumentException if {@code fromIndex > toIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException if {@code fromIndex < 0} or
 *         {@code toIndex > a.length}
 */

public static void fill(@androidx.annotation.RecentlyNonNull boolean[] a, int fromIndex, int toIndex, boolean val) { throw new RuntimeException("Stub!"); }

/**
 * Assigns the specified double value to each element of the specified
 * array of doubles.
 *
 * @param a the array to be filled
 * @param val the value to be stored in all elements of the array
 */

public static void fill(@androidx.annotation.RecentlyNonNull double[] a, double val) { throw new RuntimeException("Stub!"); }

/**
 * Assigns the specified double value to each element of the specified
 * range of the specified array of doubles.  The range to be filled
 * extends from index {@code fromIndex}, inclusive, to index
 * {@code toIndex}, exclusive.  (If {@code fromIndex==toIndex}, the
 * range to be filled is empty.)
 *
 * @param a the array to be filled
 * @param fromIndex the index of the first element (inclusive) to be
 *        filled with the specified value
 * @param toIndex the index of the last element (exclusive) to be
 *        filled with the specified value
 * @param val the value to be stored in all elements of the array
 * @throws java.lang.IllegalArgumentException if {@code fromIndex > toIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException if {@code fromIndex < 0} or
 *         {@code toIndex > a.length}
 */

public static void fill(@androidx.annotation.RecentlyNonNull double[] a, int fromIndex, int toIndex, double val) { throw new RuntimeException("Stub!"); }

/**
 * Assigns the specified float value to each element of the specified array
 * of floats.
 *
 * @param a the array to be filled
 * @param val the value to be stored in all elements of the array
 */

public static void fill(@androidx.annotation.RecentlyNonNull float[] a, float val) { throw new RuntimeException("Stub!"); }

/**
 * Assigns the specified float value to each element of the specified
 * range of the specified array of floats.  The range to be filled
 * extends from index {@code fromIndex}, inclusive, to index
 * {@code toIndex}, exclusive.  (If {@code fromIndex==toIndex}, the
 * range to be filled is empty.)
 *
 * @param a the array to be filled
 * @param fromIndex the index of the first element (inclusive) to be
 *        filled with the specified value
 * @param toIndex the index of the last element (exclusive) to be
 *        filled with the specified value
 * @param val the value to be stored in all elements of the array
 * @throws java.lang.IllegalArgumentException if {@code fromIndex > toIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException if {@code fromIndex < 0} or
 *         {@code toIndex > a.length}
 */

public static void fill(@androidx.annotation.RecentlyNonNull float[] a, int fromIndex, int toIndex, float val) { throw new RuntimeException("Stub!"); }

/**
 * Assigns the specified Object reference to each element of the specified
 * array of Objects.
 *
 * @param a the array to be filled
 * @param val the value to be stored in all elements of the array
 * @throws java.lang.ArrayStoreException if the specified value is not of a
 *         runtime type that can be stored in the specified array
 */

public static void fill(@androidx.annotation.RecentlyNonNull java.lang.Object[] a, @androidx.annotation.RecentlyNullable java.lang.Object val) { throw new RuntimeException("Stub!"); }

/**
 * Assigns the specified Object reference to each element of the specified
 * range of the specified array of Objects.  The range to be filled
 * extends from index {@code fromIndex}, inclusive, to index
 * {@code toIndex}, exclusive.  (If {@code fromIndex==toIndex}, the
 * range to be filled is empty.)
 *
 * @param a the array to be filled
 * @param fromIndex the index of the first element (inclusive) to be
 *        filled with the specified value
 * @param toIndex the index of the last element (exclusive) to be
 *        filled with the specified value
 * @param val the value to be stored in all elements of the array
 * @throws java.lang.IllegalArgumentException if {@code fromIndex > toIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException if {@code fromIndex < 0} or
 *         {@code toIndex > a.length}
 * @throws java.lang.ArrayStoreException if the specified value is not of a
 *         runtime type that can be stored in the specified array
 */

public static void fill(@androidx.annotation.RecentlyNonNull java.lang.Object[] a, int fromIndex, int toIndex, @androidx.annotation.RecentlyNullable java.lang.Object val) { throw new RuntimeException("Stub!"); }

/**
 * Copies the specified array, truncating or padding with nulls (if necessary)
 * so the copy has the specified length.  For all indices that are
 * valid in both the original array and the copy, the two arrays will
 * contain identical values.  For any indices that are valid in the
 * copy but not the original, the copy will contain {@code null}.
 * Such indices will exist if and only if the specified length
 * is greater than that of the original array.
 * The resulting array is of exactly the same class as the original array.
 *
 * @param <T> the class of the objects in the array
 * @param original the array to be copied
 * @param newLength the length of the copy to be returned
 * @return a copy of the original array, truncated or padded with nulls
 *     to obtain the specified length
 * @throws java.lang.NegativeArraySizeException if {@code newLength} is negative
 * @throws java.lang.NullPointerException if {@code original} is null
 * @since 1.6
 */

@androidx.annotation.RecentlyNonNull
public static <T> T[] copyOf(@androidx.annotation.RecentlyNonNull T[] original, int newLength) { throw new RuntimeException("Stub!"); }

/**
 * Copies the specified array, truncating or padding with nulls (if necessary)
 * so the copy has the specified length.  For all indices that are
 * valid in both the original array and the copy, the two arrays will
 * contain identical values.  For any indices that are valid in the
 * copy but not the original, the copy will contain {@code null}.
 * Such indices will exist if and only if the specified length
 * is greater than that of the original array.
 * The resulting array is of the class {@code newType}.
 *
 * @param <U> the class of the objects in the original array
 * @param <T> the class of the objects in the returned array
 * @param original the array to be copied
 * @param newLength the length of the copy to be returned
 * @param newType the class of the copy to be returned
 * @return a copy of the original array, truncated or padded with nulls
 *     to obtain the specified length
 * @throws java.lang.NegativeArraySizeException if {@code newLength} is negative
 * @throws java.lang.NullPointerException if {@code original} is null
 * @throws java.lang.ArrayStoreException if an element copied from
 *     {@code original} is not of a runtime type that can be stored in
 *     an array of class {@code newType}
 * @since 1.6
 */

@androidx.annotation.RecentlyNonNull
public static <T, U> T[] copyOf(@androidx.annotation.RecentlyNonNull U[] original, int newLength, @androidx.annotation.RecentlyNonNull java.lang.Class<? extends T[]> newType) { throw new RuntimeException("Stub!"); }

/**
 * Copies the specified array, truncating or padding with zeros (if necessary)
 * so the copy has the specified length.  For all indices that are
 * valid in both the original array and the copy, the two arrays will
 * contain identical values.  For any indices that are valid in the
 * copy but not the original, the copy will contain {@code (byte)0}.
 * Such indices will exist if and only if the specified length
 * is greater than that of the original array.
 *
 * @param original the array to be copied
 * @param newLength the length of the copy to be returned
 * @return a copy of the original array, truncated or padded with zeros
 *     to obtain the specified length
 * @throws java.lang.NegativeArraySizeException if {@code newLength} is negative
 * @throws java.lang.NullPointerException if {@code original} is null
 * @since 1.6
 */

@androidx.annotation.RecentlyNonNull
public static byte[] copyOf(@androidx.annotation.RecentlyNonNull byte[] original, int newLength) { throw new RuntimeException("Stub!"); }

/**
 * Copies the specified array, truncating or padding with zeros (if necessary)
 * so the copy has the specified length.  For all indices that are
 * valid in both the original array and the copy, the two arrays will
 * contain identical values.  For any indices that are valid in the
 * copy but not the original, the copy will contain {@code (short)0}.
 * Such indices will exist if and only if the specified length
 * is greater than that of the original array.
 *
 * @param original the array to be copied
 * @param newLength the length of the copy to be returned
 * @return a copy of the original array, truncated or padded with zeros
 *     to obtain the specified length
 * @throws java.lang.NegativeArraySizeException if {@code newLength} is negative
 * @throws java.lang.NullPointerException if {@code original} is null
 * @since 1.6
 */

@androidx.annotation.RecentlyNonNull
public static short[] copyOf(@androidx.annotation.RecentlyNonNull short[] original, int newLength) { throw new RuntimeException("Stub!"); }

/**
 * Copies the specified array, truncating or padding with zeros (if necessary)
 * so the copy has the specified length.  For all indices that are
 * valid in both the original array and the copy, the two arrays will
 * contain identical values.  For any indices that are valid in the
 * copy but not the original, the copy will contain {@code 0}.
 * Such indices will exist if and only if the specified length
 * is greater than that of the original array.
 *
 * @param original the array to be copied
 * @param newLength the length of the copy to be returned
 * @return a copy of the original array, truncated or padded with zeros
 *     to obtain the specified length
 * @throws java.lang.NegativeArraySizeException if {@code newLength} is negative
 * @throws java.lang.NullPointerException if {@code original} is null
 * @since 1.6
 */

@androidx.annotation.RecentlyNonNull
public static int[] copyOf(@androidx.annotation.RecentlyNonNull int[] original, int newLength) { throw new RuntimeException("Stub!"); }

/**
 * Copies the specified array, truncating or padding with zeros (if necessary)
 * so the copy has the specified length.  For all indices that are
 * valid in both the original array and the copy, the two arrays will
 * contain identical values.  For any indices that are valid in the
 * copy but not the original, the copy will contain {@code 0L}.
 * Such indices will exist if and only if the specified length
 * is greater than that of the original array.
 *
 * @param original the array to be copied
 * @param newLength the length of the copy to be returned
 * @return a copy of the original array, truncated or padded with zeros
 *     to obtain the specified length
 * @throws java.lang.NegativeArraySizeException if {@code newLength} is negative
 * @throws java.lang.NullPointerException if {@code original} is null
 * @since 1.6
 */

@androidx.annotation.RecentlyNonNull
public static long[] copyOf(@androidx.annotation.RecentlyNonNull long[] original, int newLength) { throw new RuntimeException("Stub!"); }

/**
 * Copies the specified array, truncating or padding with null characters (if necessary)
 * so the copy has the specified length.  For all indices that are valid
 * in both the original array and the copy, the two arrays will contain
 * identical values.  For any indices that are valid in the copy but not
 * the original, the copy will contain {@code '\u005cu0000'}.  Such indices
 * will exist if and only if the specified length is greater than that of
 * the original array.
 *
 * @param original the array to be copied
 * @param newLength the length of the copy to be returned
 * @return a copy of the original array, truncated or padded with null characters
 *     to obtain the specified length
 * @throws java.lang.NegativeArraySizeException if {@code newLength} is negative
 * @throws java.lang.NullPointerException if {@code original} is null
 * @since 1.6
 */

@androidx.annotation.RecentlyNonNull
public static char[] copyOf(@androidx.annotation.RecentlyNonNull char[] original, int newLength) { throw new RuntimeException("Stub!"); }

/**
 * Copies the specified array, truncating or padding with zeros (if necessary)
 * so the copy has the specified length.  For all indices that are
 * valid in both the original array and the copy, the two arrays will
 * contain identical values.  For any indices that are valid in the
 * copy but not the original, the copy will contain {@code 0f}.
 * Such indices will exist if and only if the specified length
 * is greater than that of the original array.
 *
 * @param original the array to be copied
 * @param newLength the length of the copy to be returned
 * @return a copy of the original array, truncated or padded with zeros
 *     to obtain the specified length
 * @throws java.lang.NegativeArraySizeException if {@code newLength} is negative
 * @throws java.lang.NullPointerException if {@code original} is null
 * @since 1.6
 */

@androidx.annotation.RecentlyNonNull
public static float[] copyOf(@androidx.annotation.RecentlyNonNull float[] original, int newLength) { throw new RuntimeException("Stub!"); }

/**
 * Copies the specified array, truncating or padding with zeros (if necessary)
 * so the copy has the specified length.  For all indices that are
 * valid in both the original array and the copy, the two arrays will
 * contain identical values.  For any indices that are valid in the
 * copy but not the original, the copy will contain {@code 0d}.
 * Such indices will exist if and only if the specified length
 * is greater than that of the original array.
 *
 * @param original the array to be copied
 * @param newLength the length of the copy to be returned
 * @return a copy of the original array, truncated or padded with zeros
 *     to obtain the specified length
 * @throws java.lang.NegativeArraySizeException if {@code newLength} is negative
 * @throws java.lang.NullPointerException if {@code original} is null
 * @since 1.6
 */

@androidx.annotation.RecentlyNonNull
public static double[] copyOf(@androidx.annotation.RecentlyNonNull double[] original, int newLength) { throw new RuntimeException("Stub!"); }

/**
 * Copies the specified array, truncating or padding with {@code false} (if necessary)
 * so the copy has the specified length.  For all indices that are
 * valid in both the original array and the copy, the two arrays will
 * contain identical values.  For any indices that are valid in the
 * copy but not the original, the copy will contain {@code false}.
 * Such indices will exist if and only if the specified length
 * is greater than that of the original array.
 *
 * @param original the array to be copied
 * @param newLength the length of the copy to be returned
 * @return a copy of the original array, truncated or padded with false elements
 *     to obtain the specified length
 * @throws java.lang.NegativeArraySizeException if {@code newLength} is negative
 * @throws java.lang.NullPointerException if {@code original} is null
 * @since 1.6
 */

@androidx.annotation.RecentlyNonNull
public static boolean[] copyOf(@androidx.annotation.RecentlyNonNull boolean[] original, int newLength) { throw new RuntimeException("Stub!"); }

/**
 * Copies the specified range of the specified array into a new array.
 * The initial index of the range ({@code from}) must lie between zero
 * and {@code original.length}, inclusive.  The value at
 * {@code original[from]} is placed into the initial element of the copy
 * (unless {@code from == original.length} or {@code from == to}).
 * Values from subsequent elements in the original array are placed into
 * subsequent elements in the copy.  The final index of the range
 * ({@code to}), which must be greater than or equal to {@code from},
 * may be greater than {@code original.length}, in which case
 * {@code null} is placed in all elements of the copy whose index is
 * greater than or equal to {@code original.length - from}.  The length
 * of the returned array will be {@code to - from}.
 * <p>
 * The resulting array is of exactly the same class as the original array.
 *
 * @param <T> the class of the objects in the array
 * @param original the array from which a range is to be copied
 * @param from the initial index of the range to be copied, inclusive
 * @param to the final index of the range to be copied, exclusive.
 *     (This index may lie outside the array.)
 * @return a new array containing the specified range from the original array,
 *     truncated or padded with nulls to obtain the required length
 * @throws java.lang.ArrayIndexOutOfBoundsException if {@code from < 0}
 *     or {@code from > original.length}
 * @throws java.lang.IllegalArgumentException if {@code from > to}
 * @throws java.lang.NullPointerException if {@code original} is null
 * @since 1.6
 */

@androidx.annotation.RecentlyNonNull
public static <T> T[] copyOfRange(@androidx.annotation.RecentlyNonNull T[] original, int from, int to) { throw new RuntimeException("Stub!"); }

/**
 * Copies the specified range of the specified array into a new array.
 * The initial index of the range ({@code from}) must lie between zero
 * and {@code original.length}, inclusive.  The value at
 * {@code original[from]} is placed into the initial element of the copy
 * (unless {@code from == original.length} or {@code from == to}).
 * Values from subsequent elements in the original array are placed into
 * subsequent elements in the copy.  The final index of the range
 * ({@code to}), which must be greater than or equal to {@code from},
 * may be greater than {@code original.length}, in which case
 * {@code null} is placed in all elements of the copy whose index is
 * greater than or equal to {@code original.length - from}.  The length
 * of the returned array will be {@code to - from}.
 * The resulting array is of the class {@code newType}.
 *
 * @param <U> the class of the objects in the original array
 * @param <T> the class of the objects in the returned array
 * @param original the array from which a range is to be copied
 * @param from the initial index of the range to be copied, inclusive
 * @param to the final index of the range to be copied, exclusive.
 *     (This index may lie outside the array.)
 * @param newType the class of the copy to be returned
 * @return a new array containing the specified range from the original array,
 *     truncated or padded with nulls to obtain the required length
 * @throws java.lang.ArrayIndexOutOfBoundsException if {@code from < 0}
 *     or {@code from > original.length}
 * @throws java.lang.IllegalArgumentException if {@code from > to}
 * @throws java.lang.NullPointerException if {@code original} is null
 * @throws java.lang.ArrayStoreException if an element copied from
 *     {@code original} is not of a runtime type that can be stored in
 *     an array of class {@code newType}.
 * @since 1.6
 */

@androidx.annotation.RecentlyNonNull
public static <T, U> T[] copyOfRange(@androidx.annotation.RecentlyNonNull U[] original, int from, int to, @androidx.annotation.RecentlyNonNull java.lang.Class<? extends T[]> newType) { throw new RuntimeException("Stub!"); }

/**
 * Copies the specified range of the specified array into a new array.
 * The initial index of the range ({@code from}) must lie between zero
 * and {@code original.length}, inclusive.  The value at
 * {@code original[from]} is placed into the initial element of the copy
 * (unless {@code from == original.length} or {@code from == to}).
 * Values from subsequent elements in the original array are placed into
 * subsequent elements in the copy.  The final index of the range
 * ({@code to}), which must be greater than or equal to {@code from},
 * may be greater than {@code original.length}, in which case
 * {@code (byte)0} is placed in all elements of the copy whose index is
 * greater than or equal to {@code original.length - from}.  The length
 * of the returned array will be {@code to - from}.
 *
 * @param original the array from which a range is to be copied
 * @param from the initial index of the range to be copied, inclusive
 * @param to the final index of the range to be copied, exclusive.
 *     (This index may lie outside the array.)
 * @return a new array containing the specified range from the original array,
 *     truncated or padded with zeros to obtain the required length
 * @throws java.lang.ArrayIndexOutOfBoundsException if {@code from < 0}
 *     or {@code from > original.length}
 * @throws java.lang.IllegalArgumentException if {@code from > to}
 * @throws java.lang.NullPointerException if {@code original} is null
 * @since 1.6
 */

@androidx.annotation.RecentlyNonNull
public static byte[] copyOfRange(@androidx.annotation.RecentlyNonNull byte[] original, int from, int to) { throw new RuntimeException("Stub!"); }

/**
 * Copies the specified range of the specified array into a new array.
 * The initial index of the range ({@code from}) must lie between zero
 * and {@code original.length}, inclusive.  The value at
 * {@code original[from]} is placed into the initial element of the copy
 * (unless {@code from == original.length} or {@code from == to}).
 * Values from subsequent elements in the original array are placed into
 * subsequent elements in the copy.  The final index of the range
 * ({@code to}), which must be greater than or equal to {@code from},
 * may be greater than {@code original.length}, in which case
 * {@code (short)0} is placed in all elements of the copy whose index is
 * greater than or equal to {@code original.length - from}.  The length
 * of the returned array will be {@code to - from}.
 *
 * @param original the array from which a range is to be copied
 * @param from the initial index of the range to be copied, inclusive
 * @param to the final index of the range to be copied, exclusive.
 *     (This index may lie outside the array.)
 * @return a new array containing the specified range from the original array,
 *     truncated or padded with zeros to obtain the required length
 * @throws java.lang.ArrayIndexOutOfBoundsException if {@code from < 0}
 *     or {@code from > original.length}
 * @throws java.lang.IllegalArgumentException if {@code from > to}
 * @throws java.lang.NullPointerException if {@code original} is null
 * @since 1.6
 */

@androidx.annotation.RecentlyNonNull
public static short[] copyOfRange(@androidx.annotation.RecentlyNonNull short[] original, int from, int to) { throw new RuntimeException("Stub!"); }

/**
 * Copies the specified range of the specified array into a new array.
 * The initial index of the range ({@code from}) must lie between zero
 * and {@code original.length}, inclusive.  The value at
 * {@code original[from]} is placed into the initial element of the copy
 * (unless {@code from == original.length} or {@code from == to}).
 * Values from subsequent elements in the original array are placed into
 * subsequent elements in the copy.  The final index of the range
 * ({@code to}), which must be greater than or equal to {@code from},
 * may be greater than {@code original.length}, in which case
 * {@code 0} is placed in all elements of the copy whose index is
 * greater than or equal to {@code original.length - from}.  The length
 * of the returned array will be {@code to - from}.
 *
 * @param original the array from which a range is to be copied
 * @param from the initial index of the range to be copied, inclusive
 * @param to the final index of the range to be copied, exclusive.
 *     (This index may lie outside the array.)
 * @return a new array containing the specified range from the original array,
 *     truncated or padded with zeros to obtain the required length
 * @throws java.lang.ArrayIndexOutOfBoundsException if {@code from < 0}
 *     or {@code from > original.length}
 * @throws java.lang.IllegalArgumentException if {@code from > to}
 * @throws java.lang.NullPointerException if {@code original} is null
 * @since 1.6
 */

@androidx.annotation.RecentlyNonNull
public static int[] copyOfRange(@androidx.annotation.RecentlyNonNull int[] original, int from, int to) { throw new RuntimeException("Stub!"); }

/**
 * Copies the specified range of the specified array into a new array.
 * The initial index of the range ({@code from}) must lie between zero
 * and {@code original.length}, inclusive.  The value at
 * {@code original[from]} is placed into the initial element of the copy
 * (unless {@code from == original.length} or {@code from == to}).
 * Values from subsequent elements in the original array are placed into
 * subsequent elements in the copy.  The final index of the range
 * ({@code to}), which must be greater than or equal to {@code from},
 * may be greater than {@code original.length}, in which case
 * {@code 0L} is placed in all elements of the copy whose index is
 * greater than or equal to {@code original.length - from}.  The length
 * of the returned array will be {@code to - from}.
 *
 * @param original the array from which a range is to be copied
 * @param from the initial index of the range to be copied, inclusive
 * @param to the final index of the range to be copied, exclusive.
 *     (This index may lie outside the array.)
 * @return a new array containing the specified range from the original array,
 *     truncated or padded with zeros to obtain the required length
 * @throws java.lang.ArrayIndexOutOfBoundsException if {@code from < 0}
 *     or {@code from > original.length}
 * @throws java.lang.IllegalArgumentException if {@code from > to}
 * @throws java.lang.NullPointerException if {@code original} is null
 * @since 1.6
 */

@androidx.annotation.RecentlyNonNull
public static long[] copyOfRange(@androidx.annotation.RecentlyNonNull long[] original, int from, int to) { throw new RuntimeException("Stub!"); }

/**
 * Copies the specified range of the specified array into a new array.
 * The initial index of the range ({@code from}) must lie between zero
 * and {@code original.length}, inclusive.  The value at
 * {@code original[from]} is placed into the initial element of the copy
 * (unless {@code from == original.length} or {@code from == to}).
 * Values from subsequent elements in the original array are placed into
 * subsequent elements in the copy.  The final index of the range
 * ({@code to}), which must be greater than or equal to {@code from},
 * may be greater than {@code original.length}, in which case
 * {@code '\u005cu0000'} is placed in all elements of the copy whose index is
 * greater than or equal to {@code original.length - from}.  The length
 * of the returned array will be {@code to - from}.
 *
 * @param original the array from which a range is to be copied
 * @param from the initial index of the range to be copied, inclusive
 * @param to the final index of the range to be copied, exclusive.
 *     (This index may lie outside the array.)
 * @return a new array containing the specified range from the original array,
 *     truncated or padded with null characters to obtain the required length
 * @throws java.lang.ArrayIndexOutOfBoundsException if {@code from < 0}
 *     or {@code from > original.length}
 * @throws java.lang.IllegalArgumentException if {@code from > to}
 * @throws java.lang.NullPointerException if {@code original} is null
 * @since 1.6
 */

@androidx.annotation.RecentlyNonNull
public static char[] copyOfRange(@androidx.annotation.RecentlyNonNull char[] original, int from, int to) { throw new RuntimeException("Stub!"); }

/**
 * Copies the specified range of the specified array into a new array.
 * The initial index of the range ({@code from}) must lie between zero
 * and {@code original.length}, inclusive.  The value at
 * {@code original[from]} is placed into the initial element of the copy
 * (unless {@code from == original.length} or {@code from == to}).
 * Values from subsequent elements in the original array are placed into
 * subsequent elements in the copy.  The final index of the range
 * ({@code to}), which must be greater than or equal to {@code from},
 * may be greater than {@code original.length}, in which case
 * {@code 0f} is placed in all elements of the copy whose index is
 * greater than or equal to {@code original.length - from}.  The length
 * of the returned array will be {@code to - from}.
 *
 * @param original the array from which a range is to be copied
 * @param from the initial index of the range to be copied, inclusive
 * @param to the final index of the range to be copied, exclusive.
 *     (This index may lie outside the array.)
 * @return a new array containing the specified range from the original array,
 *     truncated or padded with zeros to obtain the required length
 * @throws java.lang.ArrayIndexOutOfBoundsException if {@code from < 0}
 *     or {@code from > original.length}
 * @throws java.lang.IllegalArgumentException if {@code from > to}
 * @throws java.lang.NullPointerException if {@code original} is null
 * @since 1.6
 */

@androidx.annotation.RecentlyNonNull
public static float[] copyOfRange(@androidx.annotation.RecentlyNonNull float[] original, int from, int to) { throw new RuntimeException("Stub!"); }

/**
 * Copies the specified range of the specified array into a new array.
 * The initial index of the range ({@code from}) must lie between zero
 * and {@code original.length}, inclusive.  The value at
 * {@code original[from]} is placed into the initial element of the copy
 * (unless {@code from == original.length} or {@code from == to}).
 * Values from subsequent elements in the original array are placed into
 * subsequent elements in the copy.  The final index of the range
 * ({@code to}), which must be greater than or equal to {@code from},
 * may be greater than {@code original.length}, in which case
 * {@code 0d} is placed in all elements of the copy whose index is
 * greater than or equal to {@code original.length - from}.  The length
 * of the returned array will be {@code to - from}.
 *
 * @param original the array from which a range is to be copied
 * @param from the initial index of the range to be copied, inclusive
 * @param to the final index of the range to be copied, exclusive.
 *     (This index may lie outside the array.)
 * @return a new array containing the specified range from the original array,
 *     truncated or padded with zeros to obtain the required length
 * @throws java.lang.ArrayIndexOutOfBoundsException if {@code from < 0}
 *     or {@code from > original.length}
 * @throws java.lang.IllegalArgumentException if {@code from > to}
 * @throws java.lang.NullPointerException if {@code original} is null
 * @since 1.6
 */

@androidx.annotation.RecentlyNonNull
public static double[] copyOfRange(@androidx.annotation.RecentlyNonNull double[] original, int from, int to) { throw new RuntimeException("Stub!"); }

/**
 * Copies the specified range of the specified array into a new array.
 * The initial index of the range ({@code from}) must lie between zero
 * and {@code original.length}, inclusive.  The value at
 * {@code original[from]} is placed into the initial element of the copy
 * (unless {@code from == original.length} or {@code from == to}).
 * Values from subsequent elements in the original array are placed into
 * subsequent elements in the copy.  The final index of the range
 * ({@code to}), which must be greater than or equal to {@code from},
 * may be greater than {@code original.length}, in which case
 * {@code false} is placed in all elements of the copy whose index is
 * greater than or equal to {@code original.length - from}.  The length
 * of the returned array will be {@code to - from}.
 *
 * @param original the array from which a range is to be copied
 * @param from the initial index of the range to be copied, inclusive
 * @param to the final index of the range to be copied, exclusive.
 *     (This index may lie outside the array.)
 * @return a new array containing the specified range from the original array,
 *     truncated or padded with false elements to obtain the required length
 * @throws java.lang.ArrayIndexOutOfBoundsException if {@code from < 0}
 *     or {@code from > original.length}
 * @throws java.lang.IllegalArgumentException if {@code from > to}
 * @throws java.lang.NullPointerException if {@code original} is null
 * @since 1.6
 */

@androidx.annotation.RecentlyNonNull
public static boolean[] copyOfRange(@androidx.annotation.RecentlyNonNull boolean[] original, int from, int to) { throw new RuntimeException("Stub!"); }

/**
 * Returns a fixed-size list backed by the specified array. Changes made to
 * the array will be visible in the returned list, and changes made to the
 * list will be visible in the array. The returned list is
 * {@link java.io.Serializable Serializable} and implements {@link java.util.RandomAccess RandomAccess}.
 *
 * <p>The returned list implements the optional {@code Collection} methods, except
 * those that would change the size of the returned list. Those methods leave
 * the list unchanged and throw {@link java.lang.UnsupportedOperationException UnsupportedOperationException}.
 *
 * @apiNote
 * This method acts as bridge between array-based and collection-based
 * APIs, in combination with {@link java.util.Collection#toArray Collection#toArray}.
 *
 * <p>This method provides a way to wrap an existing array:
 * <pre>{@code
 *     Integer[] numbers = ...
 *     ...
 *     List<Integer> values = Arrays.asList(numbers);
 * }</pre>
 *
 * <p>This method also provides a convenient way to create a fixed-size
 * list initialized to contain several elements:
 * <pre>{@code
 *     List<String> stooges = Arrays.asList("Larry", "Moe", "Curly");
 * }</pre>
 *
 * <p><em>The list returned by this method is modifiable.</em>
 * To create an unmodifiable list, use
 * {@link java.util.Collections#unmodifiableList Collections.unmodifiableList}
 * or <a href="List.html#unmodifiable">Unmodifiable Lists</a>.
 *
 * @param <T> the class of the objects in the array
 * @param a the array by which the list will be backed
 * @return a list view of the specified array
 * @throws java.lang.NullPointerException if the specified array is {@code null}
 */

@androidx.annotation.RecentlyNonNull
@java.lang.SafeVarargs
public static <T> java.util.List<T> asList(@androidx.annotation.RecentlyNonNull T... a) { throw new RuntimeException("Stub!"); }

/**
 * Returns a hash code based on the contents of the specified array.
 * For any two {@code long} arrays {@code a} and {@code b}
 * such that {@code Arrays.equals(a, b)}, it is also the case that
 * {@code Arrays.hashCode(a) == Arrays.hashCode(b)}.
 *
 * <p>The value returned by this method is the same value that would be
 * obtained by invoking the {@link java.util.List#hashCode() hashCode}
 * method on a {@link java.util.List List} containing a sequence of {@link java.lang.Long Long}
 * instances representing the elements of {@code a} in the same order.
 * If {@code a} is {@code null}, this method returns 0.
 *
 * @param a the array whose hash value to compute
 * @return a content-based hash code for {@code a}
 * @since 1.5
 */

public static int hashCode(@androidx.annotation.RecentlyNullable long[] a) { throw new RuntimeException("Stub!"); }

/**
 * Returns a hash code based on the contents of the specified array.
 * For any two non-null {@code int} arrays {@code a} and {@code b}
 * such that {@code Arrays.equals(a, b)}, it is also the case that
 * {@code Arrays.hashCode(a) == Arrays.hashCode(b)}.
 *
 * <p>The value returned by this method is the same value that would be
 * obtained by invoking the {@link java.util.List#hashCode() hashCode}
 * method on a {@link java.util.List List} containing a sequence of {@link java.lang.Integer Integer}
 * instances representing the elements of {@code a} in the same order.
 * If {@code a} is {@code null}, this method returns 0.
 *
 * @param a the array whose hash value to compute
 * @return a content-based hash code for {@code a}
 * @since 1.5
 */

public static int hashCode(@androidx.annotation.RecentlyNullable int[] a) { throw new RuntimeException("Stub!"); }

/**
 * Returns a hash code based on the contents of the specified array.
 * For any two {@code short} arrays {@code a} and {@code b}
 * such that {@code Arrays.equals(a, b)}, it is also the case that
 * {@code Arrays.hashCode(a) == Arrays.hashCode(b)}.
 *
 * <p>The value returned by this method is the same value that would be
 * obtained by invoking the {@link java.util.List#hashCode() hashCode}
 * method on a {@link java.util.List List} containing a sequence of {@link java.lang.Short Short}
 * instances representing the elements of {@code a} in the same order.
 * If {@code a} is {@code null}, this method returns 0.
 *
 * @param a the array whose hash value to compute
 * @return a content-based hash code for {@code a}
 * @since 1.5
 */

public static int hashCode(@androidx.annotation.RecentlyNullable short[] a) { throw new RuntimeException("Stub!"); }

/**
 * Returns a hash code based on the contents of the specified array.
 * For any two {@code char} arrays {@code a} and {@code b}
 * such that {@code Arrays.equals(a, b)}, it is also the case that
 * {@code Arrays.hashCode(a) == Arrays.hashCode(b)}.
 *
 * <p>The value returned by this method is the same value that would be
 * obtained by invoking the {@link java.util.List#hashCode() hashCode}
 * method on a {@link java.util.List List} containing a sequence of {@link java.lang.Character Character}
 * instances representing the elements of {@code a} in the same order.
 * If {@code a} is {@code null}, this method returns 0.
 *
 * @param a the array whose hash value to compute
 * @return a content-based hash code for {@code a}
 * @since 1.5
 */

public static int hashCode(@androidx.annotation.RecentlyNullable char[] a) { throw new RuntimeException("Stub!"); }

/**
 * Returns a hash code based on the contents of the specified array.
 * For any two {@code byte} arrays {@code a} and {@code b}
 * such that {@code Arrays.equals(a, b)}, it is also the case that
 * {@code Arrays.hashCode(a) == Arrays.hashCode(b)}.
 *
 * <p>The value returned by this method is the same value that would be
 * obtained by invoking the {@link java.util.List#hashCode() hashCode}
 * method on a {@link java.util.List List} containing a sequence of {@link java.lang.Byte Byte}
 * instances representing the elements of {@code a} in the same order.
 * If {@code a} is {@code null}, this method returns 0.
 *
 * @param a the array whose hash value to compute
 * @return a content-based hash code for {@code a}
 * @since 1.5
 */

public static int hashCode(@androidx.annotation.RecentlyNullable byte[] a) { throw new RuntimeException("Stub!"); }

/**
 * Returns a hash code based on the contents of the specified array.
 * For any two {@code boolean} arrays {@code a} and {@code b}
 * such that {@code Arrays.equals(a, b)}, it is also the case that
 * {@code Arrays.hashCode(a) == Arrays.hashCode(b)}.
 *
 * <p>The value returned by this method is the same value that would be
 * obtained by invoking the {@link java.util.List#hashCode() hashCode}
 * method on a {@link java.util.List List} containing a sequence of {@link java.lang.Boolean Boolean}
 * instances representing the elements of {@code a} in the same order.
 * If {@code a} is {@code null}, this method returns 0.
 *
 * @param a the array whose hash value to compute
 * @return a content-based hash code for {@code a}
 * @since 1.5
 */

public static int hashCode(@androidx.annotation.RecentlyNullable boolean[] a) { throw new RuntimeException("Stub!"); }

/**
 * Returns a hash code based on the contents of the specified array.
 * For any two {@code float} arrays {@code a} and {@code b}
 * such that {@code Arrays.equals(a, b)}, it is also the case that
 * {@code Arrays.hashCode(a) == Arrays.hashCode(b)}.
 *
 * <p>The value returned by this method is the same value that would be
 * obtained by invoking the {@link java.util.List#hashCode() hashCode}
 * method on a {@link java.util.List List} containing a sequence of {@link java.lang.Float Float}
 * instances representing the elements of {@code a} in the same order.
 * If {@code a} is {@code null}, this method returns 0.
 *
 * @param a the array whose hash value to compute
 * @return a content-based hash code for {@code a}
 * @since 1.5
 */

public static int hashCode(@androidx.annotation.RecentlyNullable float[] a) { throw new RuntimeException("Stub!"); }

/**
 * Returns a hash code based on the contents of the specified array.
 * For any two {@code double} arrays {@code a} and {@code b}
 * such that {@code Arrays.equals(a, b)}, it is also the case that
 * {@code Arrays.hashCode(a) == Arrays.hashCode(b)}.
 *
 * <p>The value returned by this method is the same value that would be
 * obtained by invoking the {@link java.util.List#hashCode() hashCode}
 * method on a {@link java.util.List List} containing a sequence of {@link java.lang.Double Double}
 * instances representing the elements of {@code a} in the same order.
 * If {@code a} is {@code null}, this method returns 0.
 *
 * @param a the array whose hash value to compute
 * @return a content-based hash code for {@code a}
 * @since 1.5
 */

public static int hashCode(@androidx.annotation.RecentlyNullable double[] a) { throw new RuntimeException("Stub!"); }

/**
 * Returns a hash code based on the contents of the specified array.  If
 * the array contains other arrays as elements, the hash code is based on
 * their identities rather than their contents.  It is therefore
 * acceptable to invoke this method on an array that contains itself as an
 * element,  either directly or indirectly through one or more levels of
 * arrays.
 *
 * <p>For any two arrays {@code a} and {@code b} such that
 * {@code Arrays.equals(a, b)}, it is also the case that
 * {@code Arrays.hashCode(a) == Arrays.hashCode(b)}.
 *
 * <p>The value returned by this method is equal to the value that would
 * be returned by {@code Arrays.asList(a).hashCode()}, unless {@code a}
 * is {@code null}, in which case {@code 0} is returned.
 *
 * @param a the array whose content-based hash code to compute
 * @return a content-based hash code for {@code a}
 * @see #deepHashCode(Object[])
 * @since 1.5
 */

public static int hashCode(@androidx.annotation.RecentlyNullable java.lang.Object[] a) { throw new RuntimeException("Stub!"); }

/**
 * Returns a hash code based on the "deep contents" of the specified
 * array.  If the array contains other arrays as elements, the
 * hash code is based on their contents and so on, ad infinitum.
 * It is therefore unacceptable to invoke this method on an array that
 * contains itself as an element, either directly or indirectly through
 * one or more levels of arrays.  The behavior of such an invocation is
 * undefined.
 *
 * <p>For any two arrays {@code a} and {@code b} such that
 * {@code Arrays.deepEquals(a, b)}, it is also the case that
 * {@code Arrays.deepHashCode(a) == Arrays.deepHashCode(b)}.
 *
 * <p>The computation of the value returned by this method is similar to
 * that of the value returned by {@link java.util.List#hashCode() List#hashCode()} on a list
 * containing the same elements as {@code a} in the same order, with one
 * difference: If an element {@code e} of {@code a} is itself an array,
 * its hash code is computed not by calling {@code e.hashCode()}, but as
 * by calling the appropriate overloading of {@code Arrays.hashCode(e)}
 * if {@code e} is an array of a primitive type, or as by calling
 * {@code Arrays.deepHashCode(e)} recursively if {@code e} is an array
 * of a reference type.  If {@code a} is {@code null}, this method
 * returns 0.
 *
 * @param a the array whose deep-content-based hash code to compute
 * @return a deep-content-based hash code for {@code a}
 * @see #hashCode(Object[])
 * @since 1.5
 */

public static int deepHashCode(@androidx.annotation.RecentlyNullable java.lang.Object[] a) { throw new RuntimeException("Stub!"); }

/**
 * Returns {@code true} if the two specified arrays are <i>deeply
 * equal</i> to one another.  Unlike the {@link #equals(java.lang.Object[],java.lang.Object[])}
 * method, this method is appropriate for use with nested arrays of
 * arbitrary depth.
 *
 * <p>Two array references are considered deeply equal if both
 * are {@code null}, or if they refer to arrays that contain the same
 * number of elements and all corresponding pairs of elements in the two
 * arrays are deeply equal.
 *
 * <p>Two possibly {@code null} elements {@code e1} and {@code e2} are
 * deeply equal if any of the following conditions hold:
 * <ul>
 *    <li> {@code e1} and {@code e2} are both arrays of object reference
 *         types, and {@code Arrays.deepEquals(e1, e2) would return true}
 *    <li> {@code e1} and {@code e2} are arrays of the same primitive
 *         type, and the appropriate overloading of
 *         {@code Arrays.equals(e1, e2)} would return true.
 *    <li> {@code e1 == e2}
 *    <li> {@code e1.equals(e2)} would return true.
 * </ul>
 * Note that this definition permits {@code null} elements at any depth.
 *
 * <p>If either of the specified arrays contain themselves as elements
 * either directly or indirectly through one or more levels of arrays,
 * the behavior of this method is undefined.
 *
 * @param a1 one array to be tested for equality
 * @param a2 the other array to be tested for equality
 * @return {@code true} if the two arrays are equal
 * @see #equals(Object[],Object[])
 * @see java.util.Objects#deepEquals(Object, Object)
 * @since 1.5
 */

public static boolean deepEquals(@androidx.annotation.RecentlyNullable java.lang.Object[] a1, @androidx.annotation.RecentlyNullable java.lang.Object[] a2) { throw new RuntimeException("Stub!"); }

/**
 * Returns a string representation of the contents of the specified array.
 * The string representation consists of a list of the array's elements,
 * enclosed in square brackets ({@code "[]"}).  Adjacent elements are
 * separated by the characters {@code ", "} (a comma followed by a
 * space).  Elements are converted to strings as by
 * {@code String.valueOf(long)}.  Returns {@code "null"} if {@code a}
 * is {@code null}.
 *
 * @param a the array whose string representation to return
 * @return a string representation of {@code a}
 * @since 1.5
 */

@androidx.annotation.RecentlyNonNull
public static java.lang.String toString(@androidx.annotation.RecentlyNullable long[] a) { throw new RuntimeException("Stub!"); }

/**
 * Returns a string representation of the contents of the specified array.
 * The string representation consists of a list of the array's elements,
 * enclosed in square brackets ({@code "[]"}).  Adjacent elements are
 * separated by the characters {@code ", "} (a comma followed by a
 * space).  Elements are converted to strings as by
 * {@code String.valueOf(int)}.  Returns {@code "null"} if {@code a} is
 * {@code null}.
 *
 * @param a the array whose string representation to return
 * @return a string representation of {@code a}
 * @since 1.5
 */

@androidx.annotation.RecentlyNonNull
public static java.lang.String toString(@androidx.annotation.RecentlyNullable int[] a) { throw new RuntimeException("Stub!"); }

/**
 * Returns a string representation of the contents of the specified array.
 * The string representation consists of a list of the array's elements,
 * enclosed in square brackets ({@code "[]"}).  Adjacent elements are
 * separated by the characters {@code ", "} (a comma followed by a
 * space).  Elements are converted to strings as by
 * {@code String.valueOf(short)}.  Returns {@code "null"} if {@code a}
 * is {@code null}.
 *
 * @param a the array whose string representation to return
 * @return a string representation of {@code a}
 * @since 1.5
 */

@androidx.annotation.RecentlyNonNull
public static java.lang.String toString(@androidx.annotation.RecentlyNullable short[] a) { throw new RuntimeException("Stub!"); }

/**
 * Returns a string representation of the contents of the specified array.
 * The string representation consists of a list of the array's elements,
 * enclosed in square brackets ({@code "[]"}).  Adjacent elements are
 * separated by the characters {@code ", "} (a comma followed by a
 * space).  Elements are converted to strings as by
 * {@code String.valueOf(char)}.  Returns {@code "null"} if {@code a}
 * is {@code null}.
 *
 * @param a the array whose string representation to return
 * @return a string representation of {@code a}
 * @since 1.5
 */

@androidx.annotation.RecentlyNonNull
public static java.lang.String toString(@androidx.annotation.RecentlyNullable char[] a) { throw new RuntimeException("Stub!"); }

/**
 * Returns a string representation of the contents of the specified array.
 * The string representation consists of a list of the array's elements,
 * enclosed in square brackets ({@code "[]"}).  Adjacent elements
 * are separated by the characters {@code ", "} (a comma followed
 * by a space).  Elements are converted to strings as by
 * {@code String.valueOf(byte)}.  Returns {@code "null"} if
 * {@code a} is {@code null}.
 *
 * @param a the array whose string representation to return
 * @return a string representation of {@code a}
 * @since 1.5
 */

@androidx.annotation.RecentlyNonNull
public static java.lang.String toString(@androidx.annotation.RecentlyNullable byte[] a) { throw new RuntimeException("Stub!"); }

/**
 * Returns a string representation of the contents of the specified array.
 * The string representation consists of a list of the array's elements,
 * enclosed in square brackets ({@code "[]"}).  Adjacent elements are
 * separated by the characters {@code ", "} (a comma followed by a
 * space).  Elements are converted to strings as by
 * {@code String.valueOf(boolean)}.  Returns {@code "null"} if
 * {@code a} is {@code null}.
 *
 * @param a the array whose string representation to return
 * @return a string representation of {@code a}
 * @since 1.5
 */

@androidx.annotation.RecentlyNonNull
public static java.lang.String toString(@androidx.annotation.RecentlyNullable boolean[] a) { throw new RuntimeException("Stub!"); }

/**
 * Returns a string representation of the contents of the specified array.
 * The string representation consists of a list of the array's elements,
 * enclosed in square brackets ({@code "[]"}).  Adjacent elements are
 * separated by the characters {@code ", "} (a comma followed by a
 * space).  Elements are converted to strings as by
 * {@code String.valueOf(float)}.  Returns {@code "null"} if {@code a}
 * is {@code null}.
 *
 * @param a the array whose string representation to return
 * @return a string representation of {@code a}
 * @since 1.5
 */

@androidx.annotation.RecentlyNonNull
public static java.lang.String toString(@androidx.annotation.RecentlyNullable float[] a) { throw new RuntimeException("Stub!"); }

/**
 * Returns a string representation of the contents of the specified array.
 * The string representation consists of a list of the array's elements,
 * enclosed in square brackets ({@code "[]"}).  Adjacent elements are
 * separated by the characters {@code ", "} (a comma followed by a
 * space).  Elements are converted to strings as by
 * {@code String.valueOf(double)}.  Returns {@code "null"} if {@code a}
 * is {@code null}.
 *
 * @param a the array whose string representation to return
 * @return a string representation of {@code a}
 * @since 1.5
 */

@androidx.annotation.RecentlyNonNull
public static java.lang.String toString(@androidx.annotation.RecentlyNullable double[] a) { throw new RuntimeException("Stub!"); }

/**
 * Returns a string representation of the contents of the specified array.
 * If the array contains other arrays as elements, they are converted to
 * strings by the {@link java.lang.Object#toString Object#toString} method inherited from
 * {@code Object}, which describes their <i>identities</i> rather than
 * their contents.
 *
 * <p>The value returned by this method is equal to the value that would
 * be returned by {@code Arrays.asList(a).toString()}, unless {@code a}
 * is {@code null}, in which case {@code "null"} is returned.
 *
 * @param a the array whose string representation to return
 * @return a string representation of {@code a}
 * @see #deepToString(Object[])
 * @since 1.5
 */

@androidx.annotation.RecentlyNonNull
public static java.lang.String toString(@androidx.annotation.RecentlyNullable java.lang.Object[] a) { throw new RuntimeException("Stub!"); }

/**
 * Returns a string representation of the "deep contents" of the specified
 * array.  If the array contains other arrays as elements, the string
 * representation contains their contents and so on.  This method is
 * designed for converting multidimensional arrays to strings.
 *
 * <p>The string representation consists of a list of the array's
 * elements, enclosed in square brackets ({@code "[]"}).  Adjacent
 * elements are separated by the characters {@code ", "} (a comma
 * followed by a space).  Elements are converted to strings as by
 * {@code String.valueOf(Object)}, unless they are themselves
 * arrays.
 *
 * <p>If an element {@code e} is an array of a primitive type, it is
 * converted to a string as by invoking the appropriate overloading of
 * {@code Arrays.toString(e)}.  If an element {@code e} is an array of a
 * reference type, it is converted to a string as by invoking
 * this method recursively.
 *
 * <p>To avoid infinite recursion, if the specified array contains itself
 * as an element, or contains an indirect reference to itself through one
 * or more levels of arrays, the self-reference is converted to the string
 * {@code "[...]"}.  For example, an array containing only a reference
 * to itself would be rendered as {@code "[[...]]"}.
 *
 * <p>This method returns {@code "null"} if the specified array
 * is {@code null}.
 *
 * @param a the array whose string representation to return
 * @return a string representation of {@code a}
 * @see #toString(Object[])
 * @since 1.5
 */

@androidx.annotation.RecentlyNonNull
public static java.lang.String deepToString(@androidx.annotation.RecentlyNullable java.lang.Object[] a) { throw new RuntimeException("Stub!"); }

/**
 * Set all elements of the specified array, using the provided
 * generator function to compute each element.
 *
 * <p>If the generator function throws an exception, it is relayed to
 * the caller and the array is left in an indeterminate state.
 *
 * @apiNote
 * Setting a subrange of an array, using a generator function to compute
 * each element, can be written as follows:
 * <pre>{@code
 * IntStream.range(startInclusive, endExclusive)
 *          .forEach(i -> array[i] = generator.apply(i));
 * }</pre>
 *
 * @param <T> type of elements of the array
 * @param array array to be initialized
 * @param generator a function accepting an index and producing the desired
 *        value for that position
 * @throws java.lang.NullPointerException if the generator is null
 * @since 1.8
 */

public static <T> void setAll(@androidx.annotation.RecentlyNonNull T[] array, @androidx.annotation.RecentlyNonNull java.util.function.IntFunction<? extends T> generator) { throw new RuntimeException("Stub!"); }

/**
 * Set all elements of the specified array, in parallel, using the
 * provided generator function to compute each element.
 *
 * <p>If the generator function throws an exception, an unchecked exception
 * is thrown from {@code parallelSetAll} and the array is left in an
 * indeterminate state.
 *
 * @apiNote
 * Setting a subrange of an array, in parallel, using a generator function
 * to compute each element, can be written as follows:
 * <pre>{@code
 * IntStream.range(startInclusive, endExclusive)
 *          .parallel()
 *          .forEach(i -> array[i] = generator.apply(i));
 * }</pre>
 *
 * @param <T> type of elements of the array
 * @param array array to be initialized
 * @param generator a function accepting an index and producing the desired
 *        value for that position
 * @throws java.lang.NullPointerException if the generator is null
 * @since 1.8
 */

public static <T> void parallelSetAll(@androidx.annotation.RecentlyNonNull T[] array, @androidx.annotation.RecentlyNonNull java.util.function.IntFunction<? extends T> generator) { throw new RuntimeException("Stub!"); }

/**
 * Set all elements of the specified array, using the provided
 * generator function to compute each element.
 *
 * <p>If the generator function throws an exception, it is relayed to
 * the caller and the array is left in an indeterminate state.
 *
 * @apiNote
 * Setting a subrange of an array, using a generator function to compute
 * each element, can be written as follows:
 * <pre>{@code
 * IntStream.range(startInclusive, endExclusive)
 *          .forEach(i -> array[i] = generator.applyAsInt(i));
 * }</pre>
 *
 * @param array array to be initialized
 * @param generator a function accepting an index and producing the desired
 *        value for that position
 * @throws java.lang.NullPointerException if the generator is null
 * @since 1.8
 */

public static void setAll(@androidx.annotation.RecentlyNonNull int[] array, @androidx.annotation.RecentlyNonNull java.util.function.IntUnaryOperator generator) { throw new RuntimeException("Stub!"); }

/**
 * Set all elements of the specified array, in parallel, using the
 * provided generator function to compute each element.
 *
 * <p>If the generator function throws an exception, an unchecked exception
 * is thrown from {@code parallelSetAll} and the array is left in an
 * indeterminate state.
 *
 * @apiNote
 * Setting a subrange of an array, in parallel, using a generator function
 * to compute each element, can be written as follows:
 * <pre>{@code
 * IntStream.range(startInclusive, endExclusive)
 *          .parallel()
 *          .forEach(i -> array[i] = generator.applyAsInt(i));
 * }</pre>
 *
 * @param array array to be initialized
 * @param generator a function accepting an index and producing the desired
 * value for that position
 * @throws java.lang.NullPointerException if the generator is null
 * @since 1.8
 */

public static void parallelSetAll(@androidx.annotation.RecentlyNonNull int[] array, @androidx.annotation.RecentlyNonNull java.util.function.IntUnaryOperator generator) { throw new RuntimeException("Stub!"); }

/**
 * Set all elements of the specified array, using the provided
 * generator function to compute each element.
 *
 * <p>If the generator function throws an exception, it is relayed to
 * the caller and the array is left in an indeterminate state.
 *
 * @apiNote
 * Setting a subrange of an array, using a generator function to compute
 * each element, can be written as follows:
 * <pre>{@code
 * IntStream.range(startInclusive, endExclusive)
 *          .forEach(i -> array[i] = generator.applyAsLong(i));
 * }</pre>
 *
 * @param array array to be initialized
 * @param generator a function accepting an index and producing the desired
 *        value for that position
 * @throws java.lang.NullPointerException if the generator is null
 * @since 1.8
 */

public static void setAll(@androidx.annotation.RecentlyNonNull long[] array, @androidx.annotation.RecentlyNonNull java.util.function.IntToLongFunction generator) { throw new RuntimeException("Stub!"); }

/**
 * Set all elements of the specified array, in parallel, using the
 * provided generator function to compute each element.
 *
 * <p>If the generator function throws an exception, an unchecked exception
 * is thrown from {@code parallelSetAll} and the array is left in an
 * indeterminate state.
 *
 * @apiNote
 * Setting a subrange of an array, in parallel, using a generator function
 * to compute each element, can be written as follows:
 * <pre>{@code
 * IntStream.range(startInclusive, endExclusive)
 *          .parallel()
 *          .forEach(i -> array[i] = generator.applyAsLong(i));
 * }</pre>
 *
 * @param array array to be initialized
 * @param generator a function accepting an index and producing the desired
 *        value for that position
 * @throws java.lang.NullPointerException if the generator is null
 * @since 1.8
 */

public static void parallelSetAll(@androidx.annotation.RecentlyNonNull long[] array, @androidx.annotation.RecentlyNonNull java.util.function.IntToLongFunction generator) { throw new RuntimeException("Stub!"); }

/**
 * Set all elements of the specified array, using the provided
 * generator function to compute each element.
 *
 * <p>If the generator function throws an exception, it is relayed to
 * the caller and the array is left in an indeterminate state.
 *
 * @apiNote
 * Setting a subrange of an array, using a generator function to compute
 * each element, can be written as follows:
 * <pre>{@code
 * IntStream.range(startInclusive, endExclusive)
 *          .forEach(i -> array[i] = generator.applyAsDouble(i));
 * }</pre>
 *
 * @param array array to be initialized
 * @param generator a function accepting an index and producing the desired
 *        value for that position
 * @throws java.lang.NullPointerException if the generator is null
 * @since 1.8
 */

public static void setAll(@androidx.annotation.RecentlyNonNull double[] array, @androidx.annotation.RecentlyNonNull java.util.function.IntToDoubleFunction generator) { throw new RuntimeException("Stub!"); }

/**
 * Set all elements of the specified array, in parallel, using the
 * provided generator function to compute each element.
 *
 * <p>If the generator function throws an exception, an unchecked exception
 * is thrown from {@code parallelSetAll} and the array is left in an
 * indeterminate state.
 *
 * @apiNote
 * Setting a subrange of an array, in parallel, using a generator function
 * to compute each element, can be written as follows:
 * <pre>{@code
 * IntStream.range(startInclusive, endExclusive)
 *          .parallel()
 *          .forEach(i -> array[i] = generator.applyAsDouble(i));
 * }</pre>
 *
 * @param array array to be initialized
 * @param generator a function accepting an index and producing the desired
 *        value for that position
 * @throws java.lang.NullPointerException if the generator is null
 * @since 1.8
 */

public static void parallelSetAll(@androidx.annotation.RecentlyNonNull double[] array, @androidx.annotation.RecentlyNonNull java.util.function.IntToDoubleFunction generator) { throw new RuntimeException("Stub!"); }

/**
 * Returns a {@link java.util.Spliterator Spliterator} covering all of the specified array.
 *
 * <p>The spliterator reports {@link java.util.Spliterator#SIZED Spliterator#SIZED},
 * {@link java.util.Spliterator#SUBSIZED Spliterator#SUBSIZED}, {@link java.util.Spliterator#ORDERED Spliterator#ORDERED}, and
 * {@link java.util.Spliterator#IMMUTABLE Spliterator#IMMUTABLE}.
 *
 * @param <T> type of elements
 * @param array the array, assumed to be unmodified during use
 * @return a spliterator for the array elements
 * @since 1.8
 */

@androidx.annotation.RecentlyNonNull
public static <T> java.util.Spliterator<T> spliterator(@androidx.annotation.RecentlyNonNull T[] array) { throw new RuntimeException("Stub!"); }

/**
 * Returns a {@link java.util.Spliterator Spliterator} covering the specified range of the
 * specified array.
 *
 * <p>The spliterator reports {@link java.util.Spliterator#SIZED Spliterator#SIZED},
 * {@link java.util.Spliterator#SUBSIZED Spliterator#SUBSIZED}, {@link java.util.Spliterator#ORDERED Spliterator#ORDERED}, and
 * {@link java.util.Spliterator#IMMUTABLE Spliterator#IMMUTABLE}.
 *
 * @param <T> type of elements
 * @param array the array, assumed to be unmodified during use
 * @param startInclusive the first index to cover, inclusive
 * @param endExclusive index immediately past the last index to cover
 * @return a spliterator for the array elements
 * @throws java.lang.ArrayIndexOutOfBoundsException if {@code startInclusive} is
 *         negative, {@code endExclusive} is less than
 *         {@code startInclusive}, or {@code endExclusive} is greater than
 *         the array size
 * @since 1.8
 */

@androidx.annotation.RecentlyNonNull
public static <T> java.util.Spliterator<T> spliterator(@androidx.annotation.RecentlyNonNull T[] array, int startInclusive, int endExclusive) { throw new RuntimeException("Stub!"); }

/**
 * Returns a {@link java.util.Spliterator.OfInt Spliterator.OfInt} covering all of the specified array.
 *
 * <p>The spliterator reports {@link java.util.Spliterator#SIZED Spliterator#SIZED},
 * {@link java.util.Spliterator#SUBSIZED Spliterator#SUBSIZED}, {@link java.util.Spliterator#ORDERED Spliterator#ORDERED}, and
 * {@link java.util.Spliterator#IMMUTABLE Spliterator#IMMUTABLE}.
 *
 * @param array the array, assumed to be unmodified during use
 * @return a spliterator for the array elements
 * @since 1.8
 */

@androidx.annotation.RecentlyNonNull
public static java.util.Spliterator.OfInt spliterator(@androidx.annotation.RecentlyNonNull int[] array) { throw new RuntimeException("Stub!"); }

/**
 * Returns a {@link java.util.Spliterator.OfInt Spliterator.OfInt} covering the specified range of the
 * specified array.
 *
 * <p>The spliterator reports {@link java.util.Spliterator#SIZED Spliterator#SIZED},
 * {@link java.util.Spliterator#SUBSIZED Spliterator#SUBSIZED}, {@link java.util.Spliterator#ORDERED Spliterator#ORDERED}, and
 * {@link java.util.Spliterator#IMMUTABLE Spliterator#IMMUTABLE}.
 *
 * @param array the array, assumed to be unmodified during use
 * @param startInclusive the first index to cover, inclusive
 * @param endExclusive index immediately past the last index to cover
 * @return a spliterator for the array elements
 * @throws java.lang.ArrayIndexOutOfBoundsException if {@code startInclusive} is
 *         negative, {@code endExclusive} is less than
 *         {@code startInclusive}, or {@code endExclusive} is greater than
 *         the array size
 * @since 1.8
 */

@androidx.annotation.RecentlyNonNull
public static java.util.Spliterator.OfInt spliterator(@androidx.annotation.RecentlyNonNull int[] array, int startInclusive, int endExclusive) { throw new RuntimeException("Stub!"); }

/**
 * Returns a {@link java.util.Spliterator.OfLong Spliterator.OfLong} covering all of the specified array.
 *
 * <p>The spliterator reports {@link java.util.Spliterator#SIZED Spliterator#SIZED},
 * {@link java.util.Spliterator#SUBSIZED Spliterator#SUBSIZED}, {@link java.util.Spliterator#ORDERED Spliterator#ORDERED}, and
 * {@link java.util.Spliterator#IMMUTABLE Spliterator#IMMUTABLE}.
 *
 * @param array the array, assumed to be unmodified during use
 * @return the spliterator for the array elements
 * @since 1.8
 */

@androidx.annotation.RecentlyNonNull
public static java.util.Spliterator.OfLong spliterator(@androidx.annotation.RecentlyNonNull long[] array) { throw new RuntimeException("Stub!"); }

/**
 * Returns a {@link java.util.Spliterator.OfLong Spliterator.OfLong} covering the specified range of the
 * specified array.
 *
 * <p>The spliterator reports {@link java.util.Spliterator#SIZED Spliterator#SIZED},
 * {@link java.util.Spliterator#SUBSIZED Spliterator#SUBSIZED}, {@link java.util.Spliterator#ORDERED Spliterator#ORDERED}, and
 * {@link java.util.Spliterator#IMMUTABLE Spliterator#IMMUTABLE}.
 *
 * @param array the array, assumed to be unmodified during use
 * @param startInclusive the first index to cover, inclusive
 * @param endExclusive index immediately past the last index to cover
 * @return a spliterator for the array elements
 * @throws java.lang.ArrayIndexOutOfBoundsException if {@code startInclusive} is
 *         negative, {@code endExclusive} is less than
 *         {@code startInclusive}, or {@code endExclusive} is greater than
 *         the array size
 * @since 1.8
 */

@androidx.annotation.RecentlyNonNull
public static java.util.Spliterator.OfLong spliterator(@androidx.annotation.RecentlyNonNull long[] array, int startInclusive, int endExclusive) { throw new RuntimeException("Stub!"); }

/**
 * Returns a {@link java.util.Spliterator.OfDouble Spliterator.OfDouble} covering all of the specified
 * array.
 *
 * <p>The spliterator reports {@link java.util.Spliterator#SIZED Spliterator#SIZED},
 * {@link java.util.Spliterator#SUBSIZED Spliterator#SUBSIZED}, {@link java.util.Spliterator#ORDERED Spliterator#ORDERED}, and
 * {@link java.util.Spliterator#IMMUTABLE Spliterator#IMMUTABLE}.
 *
 * @param array the array, assumed to be unmodified during use
 * @return a spliterator for the array elements
 * @since 1.8
 */

@androidx.annotation.RecentlyNonNull
public static java.util.Spliterator.OfDouble spliterator(@androidx.annotation.RecentlyNonNull double[] array) { throw new RuntimeException("Stub!"); }

/**
 * Returns a {@link java.util.Spliterator.OfDouble Spliterator.OfDouble} covering the specified range of
 * the specified array.
 *
 * <p>The spliterator reports {@link java.util.Spliterator#SIZED Spliterator#SIZED},
 * {@link java.util.Spliterator#SUBSIZED Spliterator#SUBSIZED}, {@link java.util.Spliterator#ORDERED Spliterator#ORDERED}, and
 * {@link java.util.Spliterator#IMMUTABLE Spliterator#IMMUTABLE}.
 *
 * @param array the array, assumed to be unmodified during use
 * @param startInclusive the first index to cover, inclusive
 * @param endExclusive index immediately past the last index to cover
 * @return a spliterator for the array elements
 * @throws java.lang.ArrayIndexOutOfBoundsException if {@code startInclusive} is
 *         negative, {@code endExclusive} is less than
 *         {@code startInclusive}, or {@code endExclusive} is greater than
 *         the array size
 * @since 1.8
 */

@androidx.annotation.RecentlyNonNull
public static java.util.Spliterator.OfDouble spliterator(@androidx.annotation.RecentlyNonNull double[] array, int startInclusive, int endExclusive) { throw new RuntimeException("Stub!"); }

/**
 * Returns a sequential {@link java.util.stream.Stream Stream} with the specified array as its
 * source.
 *
 * @param <T> The type of the array elements
 * @param array The array, assumed to be unmodified during use
 * @return a {@code Stream} for the array
 * @since 1.8
 */

@androidx.annotation.RecentlyNonNull
public static <T> java.util.stream.Stream<T> stream(@androidx.annotation.RecentlyNonNull T[] array) { throw new RuntimeException("Stub!"); }

/**
 * Returns a sequential {@link java.util.stream.Stream Stream} with the specified range of the
 * specified array as its source.
 *
 * @param <T> the type of the array elements
 * @param array the array, assumed to be unmodified during use
 * @param startInclusive the first index to cover, inclusive
 * @param endExclusive index immediately past the last index to cover
 * @return a {@code Stream} for the array range
 * @throws java.lang.ArrayIndexOutOfBoundsException if {@code startInclusive} is
 *         negative, {@code endExclusive} is less than
 *         {@code startInclusive}, or {@code endExclusive} is greater than
 *         the array size
 * @since 1.8
 */

@androidx.annotation.RecentlyNonNull
public static <T> java.util.stream.Stream<T> stream(@androidx.annotation.RecentlyNonNull T[] array, int startInclusive, int endExclusive) { throw new RuntimeException("Stub!"); }

/**
 * Returns a sequential {@link java.util.stream.IntStream IntStream} with the specified array as its
 * source.
 *
 * @param array the array, assumed to be unmodified during use
 * @return an {@code IntStream} for the array
 * @since 1.8
 */

@androidx.annotation.RecentlyNonNull
public static java.util.stream.IntStream stream(@androidx.annotation.RecentlyNonNull int[] array) { throw new RuntimeException("Stub!"); }

/**
 * Returns a sequential {@link java.util.stream.IntStream IntStream} with the specified range of the
 * specified array as its source.
 *
 * @param array the array, assumed to be unmodified during use
 * @param startInclusive the first index to cover, inclusive
 * @param endExclusive index immediately past the last index to cover
 * @return an {@code IntStream} for the array range
 * @throws java.lang.ArrayIndexOutOfBoundsException if {@code startInclusive} is
 *         negative, {@code endExclusive} is less than
 *         {@code startInclusive}, or {@code endExclusive} is greater than
 *         the array size
 * @since 1.8
 */

@androidx.annotation.RecentlyNonNull
public static java.util.stream.IntStream stream(@androidx.annotation.RecentlyNonNull int[] array, int startInclusive, int endExclusive) { throw new RuntimeException("Stub!"); }

/**
 * Returns a sequential {@link java.util.stream.LongStream LongStream} with the specified array as its
 * source.
 *
 * @param array the array, assumed to be unmodified during use
 * @return a {@code LongStream} for the array
 * @since 1.8
 */

@androidx.annotation.RecentlyNonNull
public static java.util.stream.LongStream stream(@androidx.annotation.RecentlyNonNull long[] array) { throw new RuntimeException("Stub!"); }

/**
 * Returns a sequential {@link java.util.stream.LongStream LongStream} with the specified range of the
 * specified array as its source.
 *
 * @param array the array, assumed to be unmodified during use
 * @param startInclusive the first index to cover, inclusive
 * @param endExclusive index immediately past the last index to cover
 * @return a {@code LongStream} for the array range
 * @throws java.lang.ArrayIndexOutOfBoundsException if {@code startInclusive} is
 *         negative, {@code endExclusive} is less than
 *         {@code startInclusive}, or {@code endExclusive} is greater than
 *         the array size
 * @since 1.8
 */

@androidx.annotation.RecentlyNonNull
public static java.util.stream.LongStream stream(@androidx.annotation.RecentlyNonNull long[] array, int startInclusive, int endExclusive) { throw new RuntimeException("Stub!"); }

/**
 * Returns a sequential {@link java.util.stream.DoubleStream DoubleStream} with the specified array as its
 * source.
 *
 * @param array the array, assumed to be unmodified during use
 * @return a {@code DoubleStream} for the array
 * @since 1.8
 */

@androidx.annotation.RecentlyNonNull
public static java.util.stream.DoubleStream stream(@androidx.annotation.RecentlyNonNull double[] array) { throw new RuntimeException("Stub!"); }

/**
 * Returns a sequential {@link java.util.stream.DoubleStream DoubleStream} with the specified range of the
 * specified array as its source.
 *
 * @param array the array, assumed to be unmodified during use
 * @param startInclusive the first index to cover, inclusive
 * @param endExclusive index immediately past the last index to cover
 * @return a {@code DoubleStream} for the array range
 * @throws java.lang.ArrayIndexOutOfBoundsException if {@code startInclusive} is
 *         negative, {@code endExclusive} is less than
 *         {@code startInclusive}, or {@code endExclusive} is greater than
 *         the array size
 * @since 1.8
 */

@androidx.annotation.RecentlyNonNull
public static java.util.stream.DoubleStream stream(@androidx.annotation.RecentlyNonNull double[] array, int startInclusive, int endExclusive) { throw new RuntimeException("Stub!"); }

/**
 * Compares two {@code boolean} arrays lexicographically.
 *
 * <p>If the two arrays share a common prefix then the lexicographic
 * comparison is the result of comparing two elements, as if by
 * {@link java.lang.Boolean#compare(boolean,boolean) Boolean#compare(boolean, boolean)}, at an index within the
 * respective arrays that is the prefix length.
 * Otherwise, one array is a proper prefix of the other and, lexicographic
 * comparison is the result of comparing the two array lengths.
 * (See {@link #mismatch(boolean[],boolean[])} for the definition of a
 * common and proper prefix.)
 *
 * <p>A {@code null} array reference is considered lexicographically less
 * than a non-{@code null} array reference.  Two {@code null} array
 * references are considered equal.
 *
 * <p>The comparison is consistent with {@link #equals(boolean[],boolean[]) equals},
 * more specifically the following holds for arrays {@code a} and {@code b}:
 * <pre>{@code
 *     Arrays.equals(a, b) == (Arrays.compare(a, b) == 0)
 * }</pre>
 *
 * @apiNote
 * <p>This method behaves as if (for non-{@code null} array references):
 * <pre>{@code
 *     int i = Arrays.mismatch(a, b);
 *     if (i >= 0 && i < Math.min(a.length, b.length))
 *         return Boolean.compare(a[i], b[i]);
 *     return a.length - b.length;
 * }</pre>
 *
 * @param a the first array to compare
 * @param b the second array to compare
 * @return the value {@code 0} if the first and second array are equal and
 *         contain the same elements in the same order;
 *         a value less than {@code 0} if the first array is
 *         lexicographically less than the second array; and
 *         a value greater than {@code 0} if the first array is
 *         lexicographically greater than the second array
 * @since 9
 */

public static int compare(@androidx.annotation.RecentlyNullable boolean[] a, @androidx.annotation.RecentlyNullable boolean[] b) { throw new RuntimeException("Stub!"); }

/**
 * Compares two {@code boolean} arrays lexicographically over the specified
 * ranges.
 *
 * <p>If the two arrays, over the specified ranges, share a common prefix
 * then the lexicographic comparison is the result of comparing two
 * elements, as if by {@link java.lang.Boolean#compare(boolean,boolean) Boolean#compare(boolean, boolean)}, at a
 * relative index within the respective arrays that is the length of the
 * prefix.
 * Otherwise, one array is a proper prefix of the other and, lexicographic
 * comparison is the result of comparing the two range lengths.
 * (See {@link #mismatch(boolean[],int,int,boolean[],int,int)} for the
 * definition of a common and proper prefix.)
 *
 * <p>The comparison is consistent with
 * {@link #equals(boolean[],int,int,boolean[],int,int) equals}, more
 * specifically the following holds for arrays {@code a} and {@code b} with
 * specified ranges [{@code aFromIndex}, {@code atoIndex}) and
 * [{@code bFromIndex}, {@code btoIndex}) respectively:
 * <pre>{@code
 *     Arrays.equals(a, aFromIndex, aToIndex, b, bFromIndex, bToIndex) ==
 *         (Arrays.compare(a, aFromIndex, aToIndex, b, bFromIndex, bToIndex) == 0)
 * }</pre>
 *
 * @apiNote
 * <p>This method behaves as if:
 * <pre>{@code
 *     int i = Arrays.mismatch(a, aFromIndex, aToIndex,
 *                             b, bFromIndex, bToIndex);
 *     if (i >= 0 && i < Math.min(aToIndex - aFromIndex, bToIndex - bFromIndex))
 *         return Boolean.compare(a[aFromIndex + i], b[bFromIndex + i]);
 *     return (aToIndex - aFromIndex) - (bToIndex - bFromIndex);
 * }</pre>
 *
 * @param a the first array to compare
 * @param aFromIndex the index (inclusive) of the first element in the
 *                   first array to be compared
 * @param aToIndex the index (exclusive) of the last element in the
 *                 first array to be compared
 * @param b the second array to compare
 * @param bFromIndex the index (inclusive) of the first element in the
 *                   second array to be compared
 * @param bToIndex the index (exclusive) of the last element in the
 *                 second array to be compared
 * @return the value {@code 0} if, over the specified ranges, the first and
 *         second array are equal and contain the same elements in the same
 *         order;
 *         a value less than {@code 0} if, over the specified ranges, the
 *         first array is lexicographically less than the second array; and
 *         a value greater than {@code 0} if, over the specified ranges, the
 *         first array is lexicographically greater than the second array
 * @throws java.lang.IllegalArgumentException
 *         if {@code aFromIndex > aToIndex} or
 *         if {@code bFromIndex > bToIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *         if {@code aFromIndex < 0 or aToIndex > a.length} or
 *         if {@code bFromIndex < 0 or bToIndex > b.length}
 * @throws java.lang.NullPointerException
 *         if either array is {@code null}
 * @since 9
 */

public static int compare(@androidx.annotation.RecentlyNonNull boolean[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull boolean[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

/**
 * Compares two {@code byte} arrays lexicographically.
 *
 * <p>If the two arrays share a common prefix then the lexicographic
 * comparison is the result of comparing two elements, as if by
 * {@link java.lang.Byte#compare(byte,byte) Byte#compare(byte, byte)}, at an index within the respective
 * arrays that is the prefix length.
 * Otherwise, one array is a proper prefix of the other and, lexicographic
 * comparison is the result of comparing the two array lengths.
 * (See {@link #mismatch(byte[],byte[])} for the definition of a common and
 * proper prefix.)
 *
 * <p>A {@code null} array reference is considered lexicographically less
 * than a non-{@code null} array reference.  Two {@code null} array
 * references are considered equal.
 *
 * <p>The comparison is consistent with {@link #equals(byte[],byte[]) equals},
 * more specifically the following holds for arrays {@code a} and {@code b}:
 * <pre>{@code
 *     Arrays.equals(a, b) == (Arrays.compare(a, b) == 0)
 * }</pre>
 *
 * @apiNote
 * <p>This method behaves as if (for non-{@code null} array references):
 * <pre>{@code
 *     int i = Arrays.mismatch(a, b);
 *     if (i >= 0 && i < Math.min(a.length, b.length))
 *         return Byte.compare(a[i], b[i]);
 *     return a.length - b.length;
 * }</pre>
 *
 * @param a the first array to compare
 * @param b the second array to compare
 * @return the value {@code 0} if the first and second array are equal and
 *         contain the same elements in the same order;
 *         a value less than {@code 0} if the first array is
 *         lexicographically less than the second array; and
 *         a value greater than {@code 0} if the first array is
 *         lexicographically greater than the second array
 * @since 9
 */

public static int compare(@androidx.annotation.RecentlyNullable byte[] a, @androidx.annotation.RecentlyNullable byte[] b) { throw new RuntimeException("Stub!"); }

/**
 * Compares two {@code byte} arrays lexicographically over the specified
 * ranges.
 *
 * <p>If the two arrays, over the specified ranges, share a common prefix
 * then the lexicographic comparison is the result of comparing two
 * elements, as if by {@link java.lang.Byte#compare(byte,byte) Byte#compare(byte, byte)}, at a relative index
 * within the respective arrays that is the length of the prefix.
 * Otherwise, one array is a proper prefix of the other and, lexicographic
 * comparison is the result of comparing the two range lengths.
 * (See {@link #mismatch(byte[],int,int,byte[],int,int)} for the
 * definition of a common and proper prefix.)
 *
 * <p>The comparison is consistent with
 * {@link #equals(byte[],int,int,byte[],int,int) equals}, more
 * specifically the following holds for arrays {@code a} and {@code b} with
 * specified ranges [{@code aFromIndex}, {@code atoIndex}) and
 * [{@code bFromIndex}, {@code btoIndex}) respectively:
 * <pre>{@code
 *     Arrays.equals(a, aFromIndex, aToIndex, b, bFromIndex, bToIndex) ==
 *         (Arrays.compare(a, aFromIndex, aToIndex, b, bFromIndex, bToIndex) == 0)
 * }</pre>
 *
 * @apiNote
 * <p>This method behaves as if:
 * <pre>{@code
 *     int i = Arrays.mismatch(a, aFromIndex, aToIndex,
 *                             b, bFromIndex, bToIndex);
 *     if (i >= 0 && i < Math.min(aToIndex - aFromIndex, bToIndex - bFromIndex))
 *         return Byte.compare(a[aFromIndex + i], b[bFromIndex + i]);
 *     return (aToIndex - aFromIndex) - (bToIndex - bFromIndex);
 * }</pre>
 *
 * @param a the first array to compare
 * @param aFromIndex the index (inclusive) of the first element in the
 *                   first array to be compared
 * @param aToIndex the index (exclusive) of the last element in the
 *                 first array to be compared
 * @param b the second array to compare
 * @param bFromIndex the index (inclusive) of the first element in the
 *                   second array to be compared
 * @param bToIndex the index (exclusive) of the last element in the
 *                 second array to be compared
 * @return the value {@code 0} if, over the specified ranges, the first and
 *         second array are equal and contain the same elements in the same
 *         order;
 *         a value less than {@code 0} if, over the specified ranges, the
 *         first array is lexicographically less than the second array; and
 *         a value greater than {@code 0} if, over the specified ranges, the
 *         first array is lexicographically greater than the second array
 * @throws java.lang.IllegalArgumentException
 *         if {@code aFromIndex > aToIndex} or
 *         if {@code bFromIndex > bToIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *         if {@code aFromIndex < 0 or aToIndex > a.length} or
 *         if {@code bFromIndex < 0 or bToIndex > b.length}
 * @throws java.lang.NullPointerException
 *         if either array is {@code null}
 * @since 9
 */

public static int compare(@androidx.annotation.RecentlyNonNull byte[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull byte[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

/**
 * Compares two {@code byte} arrays lexicographically, numerically treating
 * elements as unsigned.
 *
 * <p>If the two arrays share a common prefix then the lexicographic
 * comparison is the result of comparing two elements, as if by
 * {@link java.lang.Byte#compareUnsigned(byte,byte) Byte#compareUnsigned(byte, byte)}, at an index within the
 * respective arrays that is the prefix length.
 * Otherwise, one array is a proper prefix of the other and, lexicographic
 * comparison is the result of comparing the two array lengths.
 * (See {@link #mismatch(byte[],byte[])} for the definition of a common
 * and proper prefix.)
 *
 * <p>A {@code null} array reference is considered lexicographically less
 * than a non-{@code null} array reference.  Two {@code null} array
 * references are considered equal.
 *
 * @apiNote
 * <p>This method behaves as if (for non-{@code null} array references):
 * <pre>{@code
 *     int i = Arrays.mismatch(a, b);
 *     if (i >= 0 && i < Math.min(a.length, b.length))
 *         return Byte.compareUnsigned(a[i], b[i]);
 *     return a.length - b.length;
 * }</pre>
 *
 * @param a the first array to compare
 * @param b the second array to compare
 * @return the value {@code 0} if the first and second array are
 *         equal and contain the same elements in the same order;
 *         a value less than {@code 0} if the first array is
 *         lexicographically less than the second array; and
 *         a value greater than {@code 0} if the first array is
 *         lexicographically greater than the second array
 * @since 9
 */

public static int compareUnsigned(@androidx.annotation.RecentlyNullable byte[] a, @androidx.annotation.RecentlyNullable byte[] b) { throw new RuntimeException("Stub!"); }

/**
 * Compares two {@code byte} arrays lexicographically over the specified
 * ranges, numerically treating elements as unsigned.
 *
 * <p>If the two arrays, over the specified ranges, share a common prefix
 * then the lexicographic comparison is the result of comparing two
 * elements, as if by {@link java.lang.Byte#compareUnsigned(byte,byte) Byte#compareUnsigned(byte, byte)}, at a
 * relative index within the respective arrays that is the length of the
 * prefix.
 * Otherwise, one array is a proper prefix of the other and, lexicographic
 * comparison is the result of comparing the two range lengths.
 * (See {@link #mismatch(byte[],int,int,byte[],int,int)} for the
 * definition of a common and proper prefix.)
 *
 * @apiNote
 * <p>This method behaves as if:
 * <pre>{@code
 *     int i = Arrays.mismatch(a, aFromIndex, aToIndex,
 *                             b, bFromIndex, bToIndex);
 *     if (i >= 0 && i < Math.min(aToIndex - aFromIndex, bToIndex - bFromIndex))
 *         return Byte.compareUnsigned(a[aFromIndex + i], b[bFromIndex + i]);
 *     return (aToIndex - aFromIndex) - (bToIndex - bFromIndex);
 * }</pre>
 *
 * @param a the first array to compare
 * @param aFromIndex the index (inclusive) of the first element in the
 *                   first array to be compared
 * @param aToIndex the index (exclusive) of the last element in the
 *                 first array to be compared
 * @param b the second array to compare
 * @param bFromIndex the index (inclusive) of the first element in the
 *                   second array to be compared
 * @param bToIndex the index (exclusive) of the last element in the
 *                 second array to be compared
 * @return the value {@code 0} if, over the specified ranges, the first and
 *         second array are equal and contain the same elements in the same
 *         order;
 *         a value less than {@code 0} if, over the specified ranges, the
 *         first array is lexicographically less than the second array; and
 *         a value greater than {@code 0} if, over the specified ranges, the
 *         first array is lexicographically greater than the second array
 * @throws java.lang.IllegalArgumentException
 *         if {@code aFromIndex > aToIndex} or
 *         if {@code bFromIndex > bToIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *         if {@code aFromIndex < 0 or aToIndex > a.length} or
 *         if {@code bFromIndex < 0 or bToIndex > b.length}
 * @throws java.lang.NullPointerException
 *         if either array is null
 * @since 9
 */

public static int compareUnsigned(@androidx.annotation.RecentlyNonNull byte[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull byte[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

/**
 * Compares two {@code short} arrays lexicographically.
 *
 * <p>If the two arrays share a common prefix then the lexicographic
 * comparison is the result of comparing two elements, as if by
 * {@link java.lang.Short#compare(short,short) Short#compare(short, short)}, at an index within the respective
 * arrays that is the prefix length.
 * Otherwise, one array is a proper prefix of the other and, lexicographic
 * comparison is the result of comparing the two array lengths.
 * (See {@link #mismatch(short[],short[])} for the definition of a common
 * and proper prefix.)
 *
 * <p>A {@code null} array reference is considered lexicographically less
 * than a non-{@code null} array reference.  Two {@code null} array
 * references are considered equal.
 *
 * <p>The comparison is consistent with {@link #equals(short[],short[]) equals},
 * more specifically the following holds for arrays {@code a} and {@code b}:
 * <pre>{@code
 *     Arrays.equals(a, b) == (Arrays.compare(a, b) == 0)
 * }</pre>
 *
 * @apiNote
 * <p>This method behaves as if (for non-{@code null} array references):
 * <pre>{@code
 *     int i = Arrays.mismatch(a, b);
 *     if (i >= 0 && i < Math.min(a.length, b.length))
 *         return Short.compare(a[i], b[i]);
 *     return a.length - b.length;
 * }</pre>
 *
 * @param a the first array to compare
 * @param b the second array to compare
 * @return the value {@code 0} if the first and second array are equal and
 *         contain the same elements in the same order;
 *         a value less than {@code 0} if the first array is
 *         lexicographically less than the second array; and
 *         a value greater than {@code 0} if the first array is
 *         lexicographically greater than the second array
 * @since 9
 */

public static int compare(@androidx.annotation.RecentlyNullable short[] a, @androidx.annotation.RecentlyNullable short[] b) { throw new RuntimeException("Stub!"); }

/**
 * Compares two {@code short} arrays lexicographically over the specified
 * ranges.
 *
 * <p>If the two arrays, over the specified ranges, share a common prefix
 * then the lexicographic comparison is the result of comparing two
 * elements, as if by {@link java.lang.Short#compare(short,short) Short#compare(short, short)}, at a relative
 * index within the respective arrays that is the length of the prefix.
 * Otherwise, one array is a proper prefix of the other and, lexicographic
 * comparison is the result of comparing the two range lengths.
 * (See {@link #mismatch(short[],int,int,short[],int,int)} for the
 * definition of a common and proper prefix.)
 *
 * <p>The comparison is consistent with
 * {@link #equals(short[],int,int,short[],int,int) equals}, more
 * specifically the following holds for arrays {@code a} and {@code b} with
 * specified ranges [{@code aFromIndex}, {@code atoIndex}) and
 * [{@code bFromIndex}, {@code btoIndex}) respectively:
 * <pre>{@code
 *     Arrays.equals(a, aFromIndex, aToIndex, b, bFromIndex, bToIndex) ==
 *         (Arrays.compare(a, aFromIndex, aToIndex, b, bFromIndex, bToIndex) == 0)
 * }</pre>
 *
 * @apiNote
 * <p>This method behaves as if:
 * <pre>{@code
 *     int i = Arrays.mismatch(a, aFromIndex, aToIndex,
 *                             b, bFromIndex, bToIndex);
 *     if (i >= 0 && i < Math.min(aToIndex - aFromIndex, bToIndex - bFromIndex))
 *         return Short.compare(a[aFromIndex + i], b[bFromIndex + i]);
 *     return (aToIndex - aFromIndex) - (bToIndex - bFromIndex);
 * }</pre>
 *
 * @param a the first array to compare
 * @param aFromIndex the index (inclusive) of the first element in the
 *                   first array to be compared
 * @param aToIndex the index (exclusive) of the last element in the
 *                 first array to be compared
 * @param b the second array to compare
 * @param bFromIndex the index (inclusive) of the first element in the
 *                   second array to be compared
 * @param bToIndex the index (exclusive) of the last element in the
 *                 second array to be compared
 * @return the value {@code 0} if, over the specified ranges, the first and
 *         second array are equal and contain the same elements in the same
 *         order;
 *         a value less than {@code 0} if, over the specified ranges, the
 *         first array is lexicographically less than the second array; and
 *         a value greater than {@code 0} if, over the specified ranges, the
 *         first array is lexicographically greater than the second array
 * @throws java.lang.IllegalArgumentException
 *         if {@code aFromIndex > aToIndex} or
 *         if {@code bFromIndex > bToIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *         if {@code aFromIndex < 0 or aToIndex > a.length} or
 *         if {@code bFromIndex < 0 or bToIndex > b.length}
 * @throws java.lang.NullPointerException
 *         if either array is {@code null}
 * @since 9
 */

public static int compare(@androidx.annotation.RecentlyNonNull short[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull short[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

/**
 * Compares two {@code short} arrays lexicographically, numerically treating
 * elements as unsigned.
 *
 * <p>If the two arrays share a common prefix then the lexicographic
 * comparison is the result of comparing two elements, as if by
 * {@link java.lang.Short#compareUnsigned(short,short) Short#compareUnsigned(short, short)}, at an index within the
 * respective arrays that is the prefix length.
 * Otherwise, one array is a proper prefix of the other and, lexicographic
 * comparison is the result of comparing the two array lengths.
 * (See {@link #mismatch(short[],short[])} for the definition of a common
 * and proper prefix.)
 *
 * <p>A {@code null} array reference is considered lexicographically less
 * than a non-{@code null} array reference.  Two {@code null} array
 * references are considered equal.
 *
 * @apiNote
 * <p>This method behaves as if (for non-{@code null} array references):
 * <pre>{@code
 *     int i = Arrays.mismatch(a, b);
 *     if (i >= 0 && i < Math.min(a.length, b.length))
 *         return Short.compareUnsigned(a[i], b[i]);
 *     return a.length - b.length;
 * }</pre>
 *
 * @param a the first array to compare
 * @param b the second array to compare
 * @return the value {@code 0} if the first and second array are
 *         equal and contain the same elements in the same order;
 *         a value less than {@code 0} if the first array is
 *         lexicographically less than the second array; and
 *         a value greater than {@code 0} if the first array is
 *         lexicographically greater than the second array
 * @since 9
 */

public static int compareUnsigned(@androidx.annotation.RecentlyNullable short[] a, @androidx.annotation.RecentlyNullable short[] b) { throw new RuntimeException("Stub!"); }

/**
 * Compares two {@code short} arrays lexicographically over the specified
 * ranges, numerically treating elements as unsigned.
 *
 * <p>If the two arrays, over the specified ranges, share a common prefix
 * then the lexicographic comparison is the result of comparing two
 * elements, as if by {@link java.lang.Short#compareUnsigned(short,short) Short#compareUnsigned(short, short)}, at a
 * relative index within the respective arrays that is the length of the
 * prefix.
 * Otherwise, one array is a proper prefix of the other and, lexicographic
 * comparison is the result of comparing the two range lengths.
 * (See {@link #mismatch(short[],int,int,short[],int,int)} for the
 * definition of a common and proper prefix.)
 *
 * @apiNote
 * <p>This method behaves as if:
 * <pre>{@code
 *     int i = Arrays.mismatch(a, aFromIndex, aToIndex,
 *                             b, bFromIndex, bToIndex);
 *     if (i >= 0 && i < Math.min(aToIndex - aFromIndex, bToIndex - bFromIndex))
 *         return Short.compareUnsigned(a[aFromIndex + i], b[bFromIndex + i]);
 *     return (aToIndex - aFromIndex) - (bToIndex - bFromIndex);
 * }</pre>
 *
 * @param a the first array to compare
 * @param aFromIndex the index (inclusive) of the first element in the
 *                   first array to be compared
 * @param aToIndex the index (exclusive) of the last element in the
 *                 first array to be compared
 * @param b the second array to compare
 * @param bFromIndex the index (inclusive) of the first element in the
 *                   second array to be compared
 * @param bToIndex the index (exclusive) of the last element in the
 *                 second array to be compared
 * @return the value {@code 0} if, over the specified ranges, the first and
 *         second array are equal and contain the same elements in the same
 *         order;
 *         a value less than {@code 0} if, over the specified ranges, the
 *         first array is lexicographically less than the second array; and
 *         a value greater than {@code 0} if, over the specified ranges, the
 *         first array is lexicographically greater than the second array
 * @throws java.lang.IllegalArgumentException
 *         if {@code aFromIndex > aToIndex} or
 *         if {@code bFromIndex > bToIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *         if {@code aFromIndex < 0 or aToIndex > a.length} or
 *         if {@code bFromIndex < 0 or bToIndex > b.length}
 * @throws java.lang.NullPointerException
 *         if either array is null
 * @since 9
 */

public static int compareUnsigned(@androidx.annotation.RecentlyNonNull short[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull short[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

/**
 * Compares two {@code char} arrays lexicographically.
 *
 * <p>If the two arrays share a common prefix then the lexicographic
 * comparison is the result of comparing two elements, as if by
 * {@link java.lang.Character#compare(char,char) Character#compare(char, char)}, at an index within the respective
 * arrays that is the prefix length.
 * Otherwise, one array is a proper prefix of the other and, lexicographic
 * comparison is the result of comparing the two array lengths.
 * (See {@link #mismatch(char[],char[])} for the definition of a common and
 * proper prefix.)
 *
 * <p>A {@code null} array reference is considered lexicographically less
 * than a non-{@code null} array reference.  Two {@code null} array
 * references are considered equal.
 *
 * <p>The comparison is consistent with {@link #equals(char[],char[]) equals},
 * more specifically the following holds for arrays {@code a} and {@code b}:
 * <pre>{@code
 *     Arrays.equals(a, b) == (Arrays.compare(a, b) == 0)
 * }</pre>
 *
 * @apiNote
 * <p>This method behaves as if (for non-{@code null} array references):
 * <pre>{@code
 *     int i = Arrays.mismatch(a, b);
 *     if (i >= 0 && i < Math.min(a.length, b.length))
 *         return Character.compare(a[i], b[i]);
 *     return a.length - b.length;
 * }</pre>
 *
 * @param a the first array to compare
 * @param b the second array to compare
 * @return the value {@code 0} if the first and second array are equal and
 *         contain the same elements in the same order;
 *         a value less than {@code 0} if the first array is
 *         lexicographically less than the second array; and
 *         a value greater than {@code 0} if the first array is
 *         lexicographically greater than the second array
 * @since 9
 */

public static int compare(@androidx.annotation.RecentlyNullable char[] a, @androidx.annotation.RecentlyNullable char[] b) { throw new RuntimeException("Stub!"); }

/**
 * Compares two {@code char} arrays lexicographically over the specified
 * ranges.
 *
 * <p>If the two arrays, over the specified ranges, share a common prefix
 * then the lexicographic comparison is the result of comparing two
 * elements, as if by {@link java.lang.Character#compare(char,char) Character#compare(char, char)}, at a relative
 * index within the respective arrays that is the length of the prefix.
 * Otherwise, one array is a proper prefix of the other and, lexicographic
 * comparison is the result of comparing the two range lengths.
 * (See {@link #mismatch(char[],int,int,char[],int,int)} for the
 * definition of a common and proper prefix.)
 *
 * <p>The comparison is consistent with
 * {@link #equals(char[],int,int,char[],int,int) equals}, more
 * specifically the following holds for arrays {@code a} and {@code b} with
 * specified ranges [{@code aFromIndex}, {@code atoIndex}) and
 * [{@code bFromIndex}, {@code btoIndex}) respectively:
 * <pre>{@code
 *     Arrays.equals(a, aFromIndex, aToIndex, b, bFromIndex, bToIndex) ==
 *         (Arrays.compare(a, aFromIndex, aToIndex, b, bFromIndex, bToIndex) == 0)
 * }</pre>
 *
 * @apiNote
 * <p>This method behaves as if:
 * <pre>{@code
 *     int i = Arrays.mismatch(a, aFromIndex, aToIndex,
 *                             b, bFromIndex, bToIndex);
 *     if (i >= 0 && i < Math.min(aToIndex - aFromIndex, bToIndex - bFromIndex))
 *         return Character.compare(a[aFromIndex + i], b[bFromIndex + i]);
 *     return (aToIndex - aFromIndex) - (bToIndex - bFromIndex);
 * }</pre>
 *
 * @param a the first array to compare
 * @param aFromIndex the index (inclusive) of the first element in the
 *                   first array to be compared
 * @param aToIndex the index (exclusive) of the last element in the
 *                 first array to be compared
 * @param b the second array to compare
 * @param bFromIndex the index (inclusive) of the first element in the
 *                   second array to be compared
 * @param bToIndex the index (exclusive) of the last element in the
 *                 second array to be compared
 * @return the value {@code 0} if, over the specified ranges, the first and
 *         second array are equal and contain the same elements in the same
 *         order;
 *         a value less than {@code 0} if, over the specified ranges, the
 *         first array is lexicographically less than the second array; and
 *         a value greater than {@code 0} if, over the specified ranges, the
 *         first array is lexicographically greater than the second array
 * @throws java.lang.IllegalArgumentException
 *         if {@code aFromIndex > aToIndex} or
 *         if {@code bFromIndex > bToIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *         if {@code aFromIndex < 0 or aToIndex > a.length} or
 *         if {@code bFromIndex < 0 or bToIndex > b.length}
 * @throws java.lang.NullPointerException
 *         if either array is {@code null}
 * @since 9
 */

public static int compare(@androidx.annotation.RecentlyNonNull char[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull char[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

/**
 * Compares two {@code int} arrays lexicographically.
 *
 * <p>If the two arrays share a common prefix then the lexicographic
 * comparison is the result of comparing two elements, as if by
 * {@link java.lang.Integer#compare(int,int) Integer#compare(int, int)}, at an index within the respective
 * arrays that is the prefix length.
 * Otherwise, one array is a proper prefix of the other and, lexicographic
 * comparison is the result of comparing the two array lengths.
 * (See {@link #mismatch(int[],int[])} for the definition of a common and
 * proper prefix.)
 *
 * <p>A {@code null} array reference is considered lexicographically less
 * than a non-{@code null} array reference.  Two {@code null} array
 * references are considered equal.
 *
 * <p>The comparison is consistent with {@link #equals(int[],int[]) equals},
 * more specifically the following holds for arrays {@code a} and {@code b}:
 * <pre>{@code
 *     Arrays.equals(a, b) == (Arrays.compare(a, b) == 0)
 * }</pre>
 *
 * @apiNote
 * <p>This method behaves as if (for non-{@code null} array references):
 * <pre>{@code
 *     int i = Arrays.mismatch(a, b);
 *     if (i >= 0 && i < Math.min(a.length, b.length))
 *         return Integer.compare(a[i], b[i]);
 *     return a.length - b.length;
 * }</pre>
 *
 * @param a the first array to compare
 * @param b the second array to compare
 * @return the value {@code 0} if the first and second array are equal and
 *         contain the same elements in the same order;
 *         a value less than {@code 0} if the first array is
 *         lexicographically less than the second array; and
 *         a value greater than {@code 0} if the first array is
 *         lexicographically greater than the second array
 * @since 9
 */

public static int compare(@androidx.annotation.RecentlyNullable int[] a, @androidx.annotation.RecentlyNullable int[] b) { throw new RuntimeException("Stub!"); }

/**
 * Compares two {@code int} arrays lexicographically over the specified
 * ranges.
 *
 * <p>If the two arrays, over the specified ranges, share a common prefix
 * then the lexicographic comparison is the result of comparing two
 * elements, as if by {@link java.lang.Integer#compare(int,int) Integer#compare(int, int)}, at a relative index
 * within the respective arrays that is the length of the prefix.
 * Otherwise, one array is a proper prefix of the other and, lexicographic
 * comparison is the result of comparing the two range lengths.
 * (See {@link #mismatch(int[],int,int,int[],int,int)} for the
 * definition of a common and proper prefix.)
 *
 * <p>The comparison is consistent with
 * {@link #equals(int[],int,int,int[],int,int) equals}, more
 * specifically the following holds for arrays {@code a} and {@code b} with
 * specified ranges [{@code aFromIndex}, {@code atoIndex}) and
 * [{@code bFromIndex}, {@code btoIndex}) respectively:
 * <pre>{@code
 *     Arrays.equals(a, aFromIndex, aToIndex, b, bFromIndex, bToIndex) ==
 *         (Arrays.compare(a, aFromIndex, aToIndex, b, bFromIndex, bToIndex) == 0)
 * }</pre>
 *
 * @apiNote
 * <p>This method behaves as if:
 * <pre>{@code
 *     int i = Arrays.mismatch(a, aFromIndex, aToIndex,
 *                             b, bFromIndex, bToIndex);
 *     if (i >= 0 && i < Math.min(aToIndex - aFromIndex, bToIndex - bFromIndex))
 *         return Integer.compare(a[aFromIndex + i], b[bFromIndex + i]);
 *     return (aToIndex - aFromIndex) - (bToIndex - bFromIndex);
 * }</pre>
 *
 * @param a the first array to compare
 * @param aFromIndex the index (inclusive) of the first element in the
 *                   first array to be compared
 * @param aToIndex the index (exclusive) of the last element in the
 *                 first array to be compared
 * @param b the second array to compare
 * @param bFromIndex the index (inclusive) of the first element in the
 *                   second array to be compared
 * @param bToIndex the index (exclusive) of the last element in the
 *                 second array to be compared
 * @return the value {@code 0} if, over the specified ranges, the first and
 *         second array are equal and contain the same elements in the same
 *         order;
 *         a value less than {@code 0} if, over the specified ranges, the
 *         first array is lexicographically less than the second array; and
 *         a value greater than {@code 0} if, over the specified ranges, the
 *         first array is lexicographically greater than the second array
 * @throws java.lang.IllegalArgumentException
 *         if {@code aFromIndex > aToIndex} or
 *         if {@code bFromIndex > bToIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *         if {@code aFromIndex < 0 or aToIndex > a.length} or
 *         if {@code bFromIndex < 0 or bToIndex > b.length}
 * @throws java.lang.NullPointerException
 *         if either array is {@code null}
 * @since 9
 */

public static int compare(@androidx.annotation.RecentlyNonNull int[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull int[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

/**
 * Compares two {@code int} arrays lexicographically, numerically treating
 * elements as unsigned.
 *
 * <p>If the two arrays share a common prefix then the lexicographic
 * comparison is the result of comparing two elements, as if by
 * {@link java.lang.Integer#compareUnsigned(int,int) Integer#compareUnsigned(int, int)}, at an index within the
 * respective arrays that is the prefix length.
 * Otherwise, one array is a proper prefix of the other and, lexicographic
 * comparison is the result of comparing the two array lengths.
 * (See {@link #mismatch(int[],int[])} for the definition of a common
 * and proper prefix.)
 *
 * <p>A {@code null} array reference is considered lexicographically less
 * than a non-{@code null} array reference.  Two {@code null} array
 * references are considered equal.
 *
 * @apiNote
 * <p>This method behaves as if (for non-{@code null} array references):
 * <pre>{@code
 *     int i = Arrays.mismatch(a, b);
 *     if (i >= 0 && i < Math.min(a.length, b.length))
 *         return Integer.compareUnsigned(a[i], b[i]);
 *     return a.length - b.length;
 * }</pre>
 *
 * @param a the first array to compare
 * @param b the second array to compare
 * @return the value {@code 0} if the first and second array are
 *         equal and contain the same elements in the same order;
 *         a value less than {@code 0} if the first array is
 *         lexicographically less than the second array; and
 *         a value greater than {@code 0} if the first array is
 *         lexicographically greater than the second array
 * @since 9
 */

public static int compareUnsigned(@androidx.annotation.RecentlyNullable int[] a, @androidx.annotation.RecentlyNullable int[] b) { throw new RuntimeException("Stub!"); }

/**
 * Compares two {@code int} arrays lexicographically over the specified
 * ranges, numerically treating elements as unsigned.
 *
 * <p>If the two arrays, over the specified ranges, share a common prefix
 * then the lexicographic comparison is the result of comparing two
 * elements, as if by {@link java.lang.Integer#compareUnsigned(int,int) Integer#compareUnsigned(int, int)}, at a
 * relative index within the respective arrays that is the length of the
 * prefix.
 * Otherwise, one array is a proper prefix of the other and, lexicographic
 * comparison is the result of comparing the two range lengths.
 * (See {@link #mismatch(int[],int,int,int[],int,int)} for the
 * definition of a common and proper prefix.)
 *
 * @apiNote
 * <p>This method behaves as if:
 * <pre>{@code
 *     int i = Arrays.mismatch(a, aFromIndex, aToIndex,
 *                             b, bFromIndex, bToIndex);
 *     if (i >= 0 && i < Math.min(aToIndex - aFromIndex, bToIndex - bFromIndex))
 *         return Integer.compareUnsigned(a[aFromIndex + i], b[bFromIndex + i]);
 *     return (aToIndex - aFromIndex) - (bToIndex - bFromIndex);
 * }</pre>
 *
 * @param a the first array to compare
 * @param aFromIndex the index (inclusive) of the first element in the
 *                   first array to be compared
 * @param aToIndex the index (exclusive) of the last element in the
 *                 first array to be compared
 * @param b the second array to compare
 * @param bFromIndex the index (inclusive) of the first element in the
 *                   second array to be compared
 * @param bToIndex the index (exclusive) of the last element in the
 *                 second array to be compared
 * @return the value {@code 0} if, over the specified ranges, the first and
 *         second array are equal and contain the same elements in the same
 *         order;
 *         a value less than {@code 0} if, over the specified ranges, the
 *         first array is lexicographically less than the second array; and
 *         a value greater than {@code 0} if, over the specified ranges, the
 *         first array is lexicographically greater than the second array
 * @throws java.lang.IllegalArgumentException
 *         if {@code aFromIndex > aToIndex} or
 *         if {@code bFromIndex > bToIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *         if {@code aFromIndex < 0 or aToIndex > a.length} or
 *         if {@code bFromIndex < 0 or bToIndex > b.length}
 * @throws java.lang.NullPointerException
 *         if either array is null
 * @since 9
 */

public static int compareUnsigned(@androidx.annotation.RecentlyNonNull int[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull int[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

/**
 * Compares two {@code long} arrays lexicographically.
 *
 * <p>If the two arrays share a common prefix then the lexicographic
 * comparison is the result of comparing two elements, as if by
 * {@link java.lang.Long#compare(long,long) Long#compare(long, long)}, at an index within the respective
 * arrays that is the prefix length.
 * Otherwise, one array is a proper prefix of the other and, lexicographic
 * comparison is the result of comparing the two array lengths.
 * (See {@link #mismatch(long[],long[])} for the definition of a common and
 * proper prefix.)
 *
 * <p>A {@code null} array reference is considered lexicographically less
 * than a non-{@code null} array reference.  Two {@code null} array
 * references are considered equal.
 *
 * <p>The comparison is consistent with {@link #equals(long[],long[]) equals},
 * more specifically the following holds for arrays {@code a} and {@code b}:
 * <pre>{@code
 *     Arrays.equals(a, b) == (Arrays.compare(a, b) == 0)
 * }</pre>
 *
 * @apiNote
 * <p>This method behaves as if (for non-{@code null} array references):
 * <pre>{@code
 *     int i = Arrays.mismatch(a, b);
 *     if (i >= 0 && i < Math.min(a.length, b.length))
 *         return Long.compare(a[i], b[i]);
 *     return a.length - b.length;
 * }</pre>
 *
 * @param a the first array to compare
 * @param b the second array to compare
 * @return the value {@code 0} if the first and second array are equal and
 *         contain the same elements in the same order;
 *         a value less than {@code 0} if the first array is
 *         lexicographically less than the second array; and
 *         a value greater than {@code 0} if the first array is
 *         lexicographically greater than the second array
 * @since 9
 */

public static int compare(@androidx.annotation.RecentlyNullable long[] a, @androidx.annotation.RecentlyNullable long[] b) { throw new RuntimeException("Stub!"); }

/**
 * Compares two {@code long} arrays lexicographically over the specified
 * ranges.
 *
 * <p>If the two arrays, over the specified ranges, share a common prefix
 * then the lexicographic comparison is the result of comparing two
 * elements, as if by {@link java.lang.Long#compare(long,long) Long#compare(long, long)}, at a relative index
 * within the respective arrays that is the length of the prefix.
 * Otherwise, one array is a proper prefix of the other and, lexicographic
 * comparison is the result of comparing the two range lengths.
 * (See {@link #mismatch(long[],int,int,long[],int,int)} for the
 * definition of a common and proper prefix.)
 *
 * <p>The comparison is consistent with
 * {@link #equals(long[],int,int,long[],int,int) equals}, more
 * specifically the following holds for arrays {@code a} and {@code b} with
 * specified ranges [{@code aFromIndex}, {@code atoIndex}) and
 * [{@code bFromIndex}, {@code btoIndex}) respectively:
 * <pre>{@code
 *     Arrays.equals(a, aFromIndex, aToIndex, b, bFromIndex, bToIndex) ==
 *         (Arrays.compare(a, aFromIndex, aToIndex, b, bFromIndex, bToIndex) == 0)
 * }</pre>
 *
 * @apiNote
 * <p>This method behaves as if:
 * <pre>{@code
 *     int i = Arrays.mismatch(a, aFromIndex, aToIndex,
 *                             b, bFromIndex, bToIndex);
 *     if (i >= 0 && i < Math.min(aToIndex - aFromIndex, bToIndex - bFromIndex))
 *         return Long.compare(a[aFromIndex + i], b[bFromIndex + i]);
 *     return (aToIndex - aFromIndex) - (bToIndex - bFromIndex);
 * }</pre>
 *
 * @param a the first array to compare
 * @param aFromIndex the index (inclusive) of the first element in the
 *                   first array to be compared
 * @param aToIndex the index (exclusive) of the last element in the
 *                 first array to be compared
 * @param b the second array to compare
 * @param bFromIndex the index (inclusive) of the first element in the
 *                   second array to be compared
 * @param bToIndex the index (exclusive) of the last element in the
 *                 second array to be compared
 * @return the value {@code 0} if, over the specified ranges, the first and
 *         second array are equal and contain the same elements in the same
 *         order;
 *         a value less than {@code 0} if, over the specified ranges, the
 *         first array is lexicographically less than the second array; and
 *         a value greater than {@code 0} if, over the specified ranges, the
 *         first array is lexicographically greater than the second array
 * @throws java.lang.IllegalArgumentException
 *         if {@code aFromIndex > aToIndex} or
 *         if {@code bFromIndex > bToIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *         if {@code aFromIndex < 0 or aToIndex > a.length} or
 *         if {@code bFromIndex < 0 or bToIndex > b.length}
 * @throws java.lang.NullPointerException
 *         if either array is {@code null}
 * @since 9
 */

public static int compare(@androidx.annotation.RecentlyNonNull long[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull long[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

/**
 * Compares two {@code long} arrays lexicographically, numerically treating
 * elements as unsigned.
 *
 * <p>If the two arrays share a common prefix then the lexicographic
 * comparison is the result of comparing two elements, as if by
 * {@link java.lang.Long#compareUnsigned(long,long) Long#compareUnsigned(long, long)}, at an index within the
 * respective arrays that is the prefix length.
 * Otherwise, one array is a proper prefix of the other and, lexicographic
 * comparison is the result of comparing the two array lengths.
 * (See {@link #mismatch(long[],long[])} for the definition of a common
 * and proper prefix.)
 *
 * <p>A {@code null} array reference is considered lexicographically less
 * than a non-{@code null} array reference.  Two {@code null} array
 * references are considered equal.
 *
 * @apiNote
 * <p>This method behaves as if (for non-{@code null} array references):
 * <pre>{@code
 *     int i = Arrays.mismatch(a, b);
 *     if (i >= 0 && i < Math.min(a.length, b.length))
 *         return Long.compareUnsigned(a[i], b[i]);
 *     return a.length - b.length;
 * }</pre>
 *
 * @param a the first array to compare
 * @param b the second array to compare
 * @return the value {@code 0} if the first and second array are
 *         equal and contain the same elements in the same order;
 *         a value less than {@code 0} if the first array is
 *         lexicographically less than the second array; and
 *         a value greater than {@code 0} if the first array is
 *         lexicographically greater than the second array
 * @since 9
 */

public static int compareUnsigned(@androidx.annotation.RecentlyNullable long[] a, @androidx.annotation.RecentlyNullable long[] b) { throw new RuntimeException("Stub!"); }

/**
 * Compares two {@code long} arrays lexicographically over the specified
 * ranges, numerically treating elements as unsigned.
 *
 * <p>If the two arrays, over the specified ranges, share a common prefix
 * then the lexicographic comparison is the result of comparing two
 * elements, as if by {@link java.lang.Long#compareUnsigned(long,long) Long#compareUnsigned(long, long)}, at a
 * relative index within the respective arrays that is the length of the
 * prefix.
 * Otherwise, one array is a proper prefix of the other and, lexicographic
 * comparison is the result of comparing the two range lengths.
 * (See {@link #mismatch(long[],int,int,long[],int,int)} for the
 * definition of a common and proper prefix.)
 *
 * @apiNote
 * <p>This method behaves as if:
 * <pre>{@code
 *     int i = Arrays.mismatch(a, aFromIndex, aToIndex,
 *                             b, bFromIndex, bToIndex);
 *     if (i >= 0 && i < Math.min(aToIndex - aFromIndex, bToIndex - bFromIndex))
 *         return Long.compareUnsigned(a[aFromIndex + i], b[bFromIndex + i]);
 *     return (aToIndex - aFromIndex) - (bToIndex - bFromIndex);
 * }</pre>
 *
 * @param a the first array to compare
 * @param aFromIndex the index (inclusive) of the first element in the
 *                   first array to be compared
 * @param aToIndex the index (exclusive) of the last element in the
 *                 first array to be compared
 * @param b the second array to compare
 * @param bFromIndex the index (inclusive) of the first element in the
 *                   second array to be compared
 * @param bToIndex the index (exclusive) of the last element in the
 *                 second array to be compared
 * @return the value {@code 0} if, over the specified ranges, the first and
 *         second array are equal and contain the same elements in the same
 *         order;
 *         a value less than {@code 0} if, over the specified ranges, the
 *         first array is lexicographically less than the second array; and
 *         a value greater than {@code 0} if, over the specified ranges, the
 *         first array is lexicographically greater than the second array
 * @throws java.lang.IllegalArgumentException
 *         if {@code aFromIndex > aToIndex} or
 *         if {@code bFromIndex > bToIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *         if {@code aFromIndex < 0 or aToIndex > a.length} or
 *         if {@code bFromIndex < 0 or bToIndex > b.length}
 * @throws java.lang.NullPointerException
 *         if either array is null
 * @since 9
 */

public static int compareUnsigned(@androidx.annotation.RecentlyNonNull long[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull long[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

/**
 * Compares two {@code float} arrays lexicographically.
 *
 * <p>If the two arrays share a common prefix then the lexicographic
 * comparison is the result of comparing two elements, as if by
 * {@link java.lang.Float#compare(float,float) Float#compare(float, float)}, at an index within the respective
 * arrays that is the prefix length.
 * Otherwise, one array is a proper prefix of the other and, lexicographic
 * comparison is the result of comparing the two array lengths.
 * (See {@link #mismatch(float[],float[])} for the definition of a common
 * and proper prefix.)
 *
 * <p>A {@code null} array reference is considered lexicographically less
 * than a non-{@code null} array reference.  Two {@code null} array
 * references are considered equal.
 *
 * <p>The comparison is consistent with {@link #equals(float[],float[]) equals},
 * more specifically the following holds for arrays {@code a} and {@code b}:
 * <pre>{@code
 *     Arrays.equals(a, b) == (Arrays.compare(a, b) == 0)
 * }</pre>
 *
 * @apiNote
 * <p>This method behaves as if (for non-{@code null} array references):
 * <pre>{@code
 *     int i = Arrays.mismatch(a, b);
 *     if (i >= 0 && i < Math.min(a.length, b.length))
 *         return Float.compare(a[i], b[i]);
 *     return a.length - b.length;
 * }</pre>
 *
 * @param a the first array to compare
 * @param b the second array to compare
 * @return the value {@code 0} if the first and second array are equal and
 *         contain the same elements in the same order;
 *         a value less than {@code 0} if the first array is
 *         lexicographically less than the second array; and
 *         a value greater than {@code 0} if the first array is
 *         lexicographically greater than the second array
 * @since 9
 */

public static int compare(@androidx.annotation.RecentlyNullable float[] a, @androidx.annotation.RecentlyNullable float[] b) { throw new RuntimeException("Stub!"); }

/**
 * Compares two {@code float} arrays lexicographically over the specified
 * ranges.
 *
 * <p>If the two arrays, over the specified ranges, share a common prefix
 * then the lexicographic comparison is the result of comparing two
 * elements, as if by {@link java.lang.Float#compare(float,float) Float#compare(float, float)}, at a relative
 * index within the respective arrays that is the length of the prefix.
 * Otherwise, one array is a proper prefix of the other and, lexicographic
 * comparison is the result of comparing the two range lengths.
 * (See {@link #mismatch(float[],int,int,float[],int,int)} for the
 * definition of a common and proper prefix.)
 *
 * <p>The comparison is consistent with
 * {@link #equals(float[],int,int,float[],int,int) equals}, more
 * specifically the following holds for arrays {@code a} and {@code b} with
 * specified ranges [{@code aFromIndex}, {@code atoIndex}) and
 * [{@code bFromIndex}, {@code btoIndex}) respectively:
 * <pre>{@code
 *     Arrays.equals(a, aFromIndex, aToIndex, b, bFromIndex, bToIndex) ==
 *         (Arrays.compare(a, aFromIndex, aToIndex, b, bFromIndex, bToIndex) == 0)
 * }</pre>
 *
 * @apiNote
 * <p>This method behaves as if:
 * <pre>{@code
 *     int i = Arrays.mismatch(a, aFromIndex, aToIndex,
 *                             b, bFromIndex, bToIndex);
 *     if (i >= 0 && i < Math.min(aToIndex - aFromIndex, bToIndex - bFromIndex))
 *         return Float.compare(a[aFromIndex + i], b[bFromIndex + i]);
 *     return (aToIndex - aFromIndex) - (bToIndex - bFromIndex);
 * }</pre>
 *
 * @param a the first array to compare
 * @param aFromIndex the index (inclusive) of the first element in the
 *                   first array to be compared
 * @param aToIndex the index (exclusive) of the last element in the
 *                 first array to be compared
 * @param b the second array to compare
 * @param bFromIndex the index (inclusive) of the first element in the
 *                   second array to be compared
 * @param bToIndex the index (exclusive) of the last element in the
 *                 second array to be compared
 * @return the value {@code 0} if, over the specified ranges, the first and
 *         second array are equal and contain the same elements in the same
 *         order;
 *         a value less than {@code 0} if, over the specified ranges, the
 *         first array is lexicographically less than the second array; and
 *         a value greater than {@code 0} if, over the specified ranges, the
 *         first array is lexicographically greater than the second array
 * @throws java.lang.IllegalArgumentException
 *         if {@code aFromIndex > aToIndex} or
 *         if {@code bFromIndex > bToIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *         if {@code aFromIndex < 0 or aToIndex > a.length} or
 *         if {@code bFromIndex < 0 or bToIndex > b.length}
 * @throws java.lang.NullPointerException
 *         if either array is {@code null}
 * @since 9
 */

public static int compare(@androidx.annotation.RecentlyNonNull float[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull float[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

/**
 * Compares two {@code double} arrays lexicographically.
 *
 * <p>If the two arrays share a common prefix then the lexicographic
 * comparison is the result of comparing two elements, as if by
 * {@link java.lang.Double#compare(double,double) Double#compare(double, double)}, at an index within the respective
 * arrays that is the prefix length.
 * Otherwise, one array is a proper prefix of the other and, lexicographic
 * comparison is the result of comparing the two array lengths.
 * (See {@link #mismatch(double[],double[])} for the definition of a common
 * and proper prefix.)
 *
 * <p>A {@code null} array reference is considered lexicographically less
 * than a non-{@code null} array reference.  Two {@code null} array
 * references are considered equal.
 *
 * <p>The comparison is consistent with {@link #equals(double[],double[]) equals},
 * more specifically the following holds for arrays {@code a} and {@code b}:
 * <pre>{@code
 *     Arrays.equals(a, b) == (Arrays.compare(a, b) == 0)
 * }</pre>
 *
 * @apiNote
 * <p>This method behaves as if (for non-{@code null} array references):
 * <pre>{@code
 *     int i = Arrays.mismatch(a, b);
 *     if (i >= 0 && i < Math.min(a.length, b.length))
 *         return Double.compare(a[i], b[i]);
 *     return a.length - b.length;
 * }</pre>
 *
 * @param a the first array to compare
 * @param b the second array to compare
 * @return the value {@code 0} if the first and second array are equal and
 *         contain the same elements in the same order;
 *         a value less than {@code 0} if the first array is
 *         lexicographically less than the second array; and
 *         a value greater than {@code 0} if the first array is
 *         lexicographically greater than the second array
 * @since 9
 */

public static int compare(@androidx.annotation.RecentlyNullable double[] a, @androidx.annotation.RecentlyNullable double[] b) { throw new RuntimeException("Stub!"); }

/**
 * Compares two {@code double} arrays lexicographically over the specified
 * ranges.
 *
 * <p>If the two arrays, over the specified ranges, share a common prefix
 * then the lexicographic comparison is the result of comparing two
 * elements, as if by {@link java.lang.Double#compare(double,double) Double#compare(double, double)}, at a relative
 * index within the respective arrays that is the length of the prefix.
 * Otherwise, one array is a proper prefix of the other and, lexicographic
 * comparison is the result of comparing the two range lengths.
 * (See {@link #mismatch(double[],int,int,double[],int,int)} for the
 * definition of a common and proper prefix.)
 *
 * <p>The comparison is consistent with
 * {@link #equals(double[],int,int,double[],int,int) equals}, more
 * specifically the following holds for arrays {@code a} and {@code b} with
 * specified ranges [{@code aFromIndex}, {@code atoIndex}) and
 * [{@code bFromIndex}, {@code btoIndex}) respectively:
 * <pre>{@code
 *     Arrays.equals(a, aFromIndex, aToIndex, b, bFromIndex, bToIndex) ==
 *         (Arrays.compare(a, aFromIndex, aToIndex, b, bFromIndex, bToIndex) == 0)
 * }</pre>
 *
 * @apiNote
 * <p>This method behaves as if:
 * <pre>{@code
 *     int i = Arrays.mismatch(a, aFromIndex, aToIndex,
 *                             b, bFromIndex, bToIndex);
 *     if (i >= 0 && i < Math.min(aToIndex - aFromIndex, bToIndex - bFromIndex))
 *         return Double.compare(a[aFromIndex + i], b[bFromIndex + i]);
 *     return (aToIndex - aFromIndex) - (bToIndex - bFromIndex);
 * }</pre>
 *
 * @param a the first array to compare
 * @param aFromIndex the index (inclusive) of the first element in the
 *                   first array to be compared
 * @param aToIndex the index (exclusive) of the last element in the
 *                 first array to be compared
 * @param b the second array to compare
 * @param bFromIndex the index (inclusive) of the first element in the
 *                   second array to be compared
 * @param bToIndex the index (exclusive) of the last element in the
 *                 second array to be compared
 * @return the value {@code 0} if, over the specified ranges, the first and
 *         second array are equal and contain the same elements in the same
 *         order;
 *         a value less than {@code 0} if, over the specified ranges, the
 *         first array is lexicographically less than the second array; and
 *         a value greater than {@code 0} if, over the specified ranges, the
 *         first array is lexicographically greater than the second array
 * @throws java.lang.IllegalArgumentException
 *         if {@code aFromIndex > aToIndex} or
 *         if {@code bFromIndex > bToIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *         if {@code aFromIndex < 0 or aToIndex > a.length} or
 *         if {@code bFromIndex < 0 or bToIndex > b.length}
 * @throws java.lang.NullPointerException
 *         if either array is {@code null}
 * @since 9
 */

public static int compare(@androidx.annotation.RecentlyNonNull double[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull double[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

/**
 * Compares two {@code Object} arrays, within comparable elements,
 * lexicographically.
 *
 * <p>If the two arrays share a common prefix then the lexicographic
 * comparison is the result of comparing two elements of type {@code T} at
 * an index {@code i} within the respective arrays that is the prefix
 * length, as if by:
 * <pre>{@code
 *     Comparator.nullsFirst(Comparator.<T>naturalOrder()).
 *         compare(a[i], b[i])
 * }</pre>
 * Otherwise, one array is a proper prefix of the other and, lexicographic
 * comparison is the result of comparing the two array lengths.
 * (See {@link #mismatch(java.lang.Object[],java.lang.Object[])} for the definition of a common
 * and proper prefix.)
 *
 * <p>A {@code null} array reference is considered lexicographically less
 * than a non-{@code null} array reference. Two {@code null} array
 * references are considered equal.
 * A {@code null} array element is considered lexicographically less than a
 * non-{@code null} array element. Two {@code null} array elements are
 * considered equal.
 *
 * <p>The comparison is consistent with {@link #equals(java.lang.Object[],java.lang.Object[]) equals},
 * more specifically the following holds for arrays {@code a} and {@code b}:
 * <pre>{@code
 *     Arrays.equals(a, b) == (Arrays.compare(a, b) == 0)
 * }</pre>
 *
 * @apiNote
 * <p>This method behaves as if (for non-{@code null} array references
 * and elements):
 * <pre>{@code
 *     int i = Arrays.mismatch(a, b);
 *     if (i >= 0 && i < Math.min(a.length, b.length))
 *         return a[i].compareTo(b[i]);
 *     return a.length - b.length;
 * }</pre>
 *
 * @param a the first array to compare
 * @param b the second array to compare
 * @param <T> the type of comparable array elements
 * @return the value {@code 0} if the first and second array are equal and
 *         contain the same elements in the same order;
 *         a value less than {@code 0} if the first array is
 *         lexicographically less than the second array; and
 *         a value greater than {@code 0} if the first array is
 *         lexicographically greater than the second array
 * @since 9
 */

public static <T extends java.lang.Comparable<? super T>> int compare(@androidx.annotation.RecentlyNullable T[] a, @androidx.annotation.RecentlyNullable T[] b) { throw new RuntimeException("Stub!"); }

/**
 * Compares two {@code Object} arrays lexicographically over the specified
 * ranges.
 *
 * <p>If the two arrays, over the specified ranges, share a common prefix
 * then the lexicographic comparison is the result of comparing two
 * elements of type {@code T} at a relative index {@code i} within the
 * respective arrays that is the prefix length, as if by:
 * <pre>{@code
 *     Comparator.nullsFirst(Comparator.<T>naturalOrder()).
 *         compare(a[aFromIndex + i, b[bFromIndex + i])
 * }</pre>
 * Otherwise, one array is a proper prefix of the other and, lexicographic
 * comparison is the result of comparing the two range lengths.
 * (See {@link #mismatch(java.lang.Object[],int,int,java.lang.Object[],int,int)} for the
 * definition of a common and proper prefix.)
 *
 * <p>The comparison is consistent with
 * {@link #equals(java.lang.Object[],int,int,java.lang.Object[],int,int) equals}, more
 * specifically the following holds for arrays {@code a} and {@code b} with
 * specified ranges [{@code aFromIndex}, {@code atoIndex}) and
 * [{@code bFromIndex}, {@code btoIndex}) respectively:
 * <pre>{@code
 *     Arrays.equals(a, aFromIndex, aToIndex, b, bFromIndex, bToIndex) ==
 *         (Arrays.compare(a, aFromIndex, aToIndex, b, bFromIndex, bToIndex) == 0)
 * }</pre>
 *
 * @apiNote
 * <p>This method behaves as if (for non-{@code null} array elements):
 * <pre>{@code
 *     int i = Arrays.mismatch(a, aFromIndex, aToIndex,
 *                             b, bFromIndex, bToIndex);
 *     if (i >= 0 && i < Math.min(aToIndex - aFromIndex, bToIndex - bFromIndex))
 *         return a[aFromIndex + i].compareTo(b[bFromIndex + i]);
 *     return (aToIndex - aFromIndex) - (bToIndex - bFromIndex);
 * }</pre>
 *
 * @param a the first array to compare
 * @param aFromIndex the index (inclusive) of the first element in the
 *                   first array to be compared
 * @param aToIndex the index (exclusive) of the last element in the
 *                 first array to be compared
 * @param b the second array to compare
 * @param bFromIndex the index (inclusive) of the first element in the
 *                   second array to be compared
 * @param bToIndex the index (exclusive) of the last element in the
 *                 second array to be compared
 * @param <T> the type of comparable array elements
 * @return the value {@code 0} if, over the specified ranges, the first and
 *         second array are equal and contain the same elements in the same
 *         order;
 *         a value less than {@code 0} if, over the specified ranges, the
 *         first array is lexicographically less than the second array; and
 *         a value greater than {@code 0} if, over the specified ranges, the
 *         first array is lexicographically greater than the second array
 * @throws java.lang.IllegalArgumentException
 *         if {@code aFromIndex > aToIndex} or
 *         if {@code bFromIndex > bToIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *         if {@code aFromIndex < 0 or aToIndex > a.length} or
 *         if {@code bFromIndex < 0 or bToIndex > b.length}
 * @throws java.lang.NullPointerException
 *         if either array is {@code null}
 * @since 9
 */

public static <T extends java.lang.Comparable<? super T>> int compare(@androidx.annotation.RecentlyNonNull T[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull T[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

/**
 * Compares two {@code Object} arrays lexicographically using a specified
 * comparator.
 *
 * <p>If the two arrays share a common prefix then the lexicographic
 * comparison is the result of comparing with the specified comparator two
 * elements at an index within the respective arrays that is the prefix
 * length.
 * Otherwise, one array is a proper prefix of the other and, lexicographic
 * comparison is the result of comparing the two array lengths.
 * (See {@link #mismatch(java.lang.Object[],java.lang.Object[])} for the definition of a common
 * and proper prefix.)
 *
 * <p>A {@code null} array reference is considered lexicographically less
 * than a non-{@code null} array reference.  Two {@code null} array
 * references are considered equal.
 *
 * @apiNote
 * <p>This method behaves as if (for non-{@code null} array references):
 * <pre>{@code
 *     int i = Arrays.mismatch(a, b, cmp);
 *     if (i >= 0 && i < Math.min(a.length, b.length))
 *         return cmp.compare(a[i], b[i]);
 *     return a.length - b.length;
 * }</pre>
 *
 * @param a the first array to compare
 * @param b the second array to compare
 * @param cmp the comparator to compare array elements
 * @param <T> the type of array elements
 * @return the value {@code 0} if the first and second array are equal and
 *         contain the same elements in the same order;
 *         a value less than {@code 0} if the first array is
 *         lexicographically less than the second array; and
 *         a value greater than {@code 0} if the first array is
 *         lexicographically greater than the second array
 * @throws java.lang.NullPointerException if the comparator is {@code null}
 * @since 9
 */

public static <T> int compare(@androidx.annotation.RecentlyNullable T[] a, @androidx.annotation.RecentlyNullable T[] b, @androidx.annotation.RecentlyNonNull java.util.Comparator<? super T> cmp) { throw new RuntimeException("Stub!"); }

/**
 * Compares two {@code Object} arrays lexicographically over the specified
 * ranges.
 *
 * <p>If the two arrays, over the specified ranges, share a common prefix
 * then the lexicographic comparison is the result of comparing with the
 * specified comparator two elements at a relative index within the
 * respective arrays that is the prefix length.
 * Otherwise, one array is a proper prefix of the other and, lexicographic
 * comparison is the result of comparing the two range lengths.
 * (See {@link #mismatch(java.lang.Object[],int,int,java.lang.Object[],int,int)} for the
 * definition of a common and proper prefix.)
 *
 * @apiNote
 * <p>This method behaves as if (for non-{@code null} array elements):
 * <pre>{@code
 *     int i = Arrays.mismatch(a, aFromIndex, aToIndex,
 *                             b, bFromIndex, bToIndex, cmp);
 *     if (i >= 0 && i < Math.min(aToIndex - aFromIndex, bToIndex - bFromIndex))
 *         return cmp.compare(a[aFromIndex + i], b[bFromIndex + i]);
 *     return (aToIndex - aFromIndex) - (bToIndex - bFromIndex);
 * }</pre>
 *
 * @param a the first array to compare
 * @param aFromIndex the index (inclusive) of the first element in the
 *                   first array to be compared
 * @param aToIndex the index (exclusive) of the last element in the
 *                 first array to be compared
 * @param b the second array to compare
 * @param bFromIndex the index (inclusive) of the first element in the
 *                   second array to be compared
 * @param bToIndex the index (exclusive) of the last element in the
 *                 second array to be compared
 * @param cmp the comparator to compare array elements
 * @param <T> the type of array elements
 * @return the value {@code 0} if, over the specified ranges, the first and
 *         second array are equal and contain the same elements in the same
 *         order;
 *         a value less than {@code 0} if, over the specified ranges, the
 *         first array is lexicographically less than the second array; and
 *         a value greater than {@code 0} if, over the specified ranges, the
 *         first array is lexicographically greater than the second array
 * @throws java.lang.IllegalArgumentException
 *         if {@code aFromIndex > aToIndex} or
 *         if {@code bFromIndex > bToIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *         if {@code aFromIndex < 0 or aToIndex > a.length} or
 *         if {@code bFromIndex < 0 or bToIndex > b.length}
 * @throws java.lang.NullPointerException
 *         if either array or the comparator is {@code null}
 * @since 9
 */

public static <T> int compare(@androidx.annotation.RecentlyNonNull T[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull T[] b, int bFromIndex, int bToIndex, @androidx.annotation.RecentlyNonNull java.util.Comparator<? super T> cmp) { throw new RuntimeException("Stub!"); }

/**
 * Finds and returns the index of the first mismatch between two
 * {@code boolean} arrays, otherwise return -1 if no mismatch is found.  The
 * index will be in the range of 0 (inclusive) up to the length (inclusive)
 * of the smaller array.
 *
 * <p>If the two arrays share a common prefix then the returned index is the
 * length of the common prefix and it follows that there is a mismatch
 * between the two elements at that index within the respective arrays.
 * If one array is a proper prefix of the other then the returned index is
 * the length of the smaller array and it follows that the index is only
 * valid for the larger array.
 * Otherwise, there is no mismatch.
 *
 * <p>Two non-{@code null} arrays, {@code a} and {@code b}, share a common
 * prefix of length {@code pl} if the following expression is true:
 * <pre>{@code
 *     pl >= 0 &&
 *     pl < Math.min(a.length, b.length) &&
 *     Arrays.equals(a, 0, pl, b, 0, pl) &&
 *     a[pl] != b[pl]
 * }</pre>
 * Note that a common prefix length of {@code 0} indicates that the first
 * elements from each array mismatch.
 *
 * <p>Two non-{@code null} arrays, {@code a} and {@code b}, share a proper
 * prefix if the following expression is true:
 * <pre>{@code
 *     a.length != b.length &&
 *     Arrays.equals(a, 0, Math.min(a.length, b.length),
 *                   b, 0, Math.min(a.length, b.length))
 * }</pre>
 *
 * @param a the first array to be tested for a mismatch
 * @param b the second array to be tested for a mismatch
 * @return the index of the first mismatch between the two arrays,
 *         otherwise {@code -1}.
 * @throws java.lang.NullPointerException
 *         if either array is {@code null}
 * @since 9
 */

public static int mismatch(@androidx.annotation.RecentlyNonNull boolean[] a, @androidx.annotation.RecentlyNonNull boolean[] b) { throw new RuntimeException("Stub!"); }

/**
 * Finds and returns the relative index of the first mismatch between two
 * {@code boolean} arrays over the specified ranges, otherwise return -1 if
 * no mismatch is found.  The index will be in the range of 0 (inclusive) up
 * to the length (inclusive) of the smaller range.
 *
 * <p>If the two arrays, over the specified ranges, share a common prefix
 * then the returned relative index is the length of the common prefix and
 * it follows that there is a mismatch between the two elements at that
 * relative index within the respective arrays.
 * If one array is a proper prefix of the other, over the specified ranges,
 * then the returned relative index is the length of the smaller range and
 * it follows that the relative index is only valid for the array with the
 * larger range.
 * Otherwise, there is no mismatch.
 *
 * <p>Two non-{@code null} arrays, {@code a} and {@code b} with specified
 * ranges [{@code aFromIndex}, {@code atoIndex}) and
 * [{@code bFromIndex}, {@code btoIndex}) respectively, share a common
 * prefix of length {@code pl} if the following expression is true:
 * <pre>{@code
 *     pl >= 0 &&
 *     pl < Math.min(aToIndex - aFromIndex, bToIndex - bFromIndex) &&
 *     Arrays.equals(a, aFromIndex, aFromIndex + pl, b, bFromIndex, bFromIndex + pl) &&
 *     a[aFromIndex + pl] != b[bFromIndex + pl]
 * }</pre>
 * Note that a common prefix length of {@code 0} indicates that the first
 * elements from each array mismatch.
 *
 * <p>Two non-{@code null} arrays, {@code a} and {@code b} with specified
 * ranges [{@code aFromIndex}, {@code atoIndex}) and
 * [{@code bFromIndex}, {@code btoIndex}) respectively, share a proper
 * prefix if the following expression is true:
 * <pre>{@code
 *     (aToIndex - aFromIndex) != (bToIndex - bFromIndex) &&
 *     Arrays.equals(a, 0, Math.min(aToIndex - aFromIndex, bToIndex - bFromIndex),
 *                   b, 0, Math.min(aToIndex - aFromIndex, bToIndex - bFromIndex))
 * }</pre>
 *
 * @param a the first array to be tested for a mismatch
 * @param aFromIndex the index (inclusive) of the first element in the
 *                   first array to be tested
 * @param aToIndex the index (exclusive) of the last element in the
 *                 first array to be tested
 * @param b the second array to be tested for a mismatch
 * @param bFromIndex the index (inclusive) of the first element in the
 *                   second array to be tested
 * @param bToIndex the index (exclusive) of the last element in the
 *                 second array to be tested
 * @return the relative index of the first mismatch between the two arrays
 *         over the specified ranges, otherwise {@code -1}.
 * @throws java.lang.IllegalArgumentException
 *         if {@code aFromIndex > aToIndex} or
 *         if {@code bFromIndex > bToIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *         if {@code aFromIndex < 0 or aToIndex > a.length} or
 *         if {@code bFromIndex < 0 or bToIndex > b.length}
 * @throws java.lang.NullPointerException
 *         if either array is {@code null}
 * @since 9
 */

public static int mismatch(@androidx.annotation.RecentlyNonNull boolean[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull boolean[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

/**
 * Finds and returns the index of the first mismatch between two {@code byte}
 * arrays, otherwise return -1 if no mismatch is found.  The index will be
 * in the range of 0 (inclusive) up to the length (inclusive) of the smaller
 * array.
 *
 * <p>If the two arrays share a common prefix then the returned index is the
 * length of the common prefix and it follows that there is a mismatch
 * between the two elements at that index within the respective arrays.
 * If one array is a proper prefix of the other then the returned index is
 * the length of the smaller array and it follows that the index is only
 * valid for the larger array.
 * Otherwise, there is no mismatch.
 *
 * <p>Two non-{@code null} arrays, {@code a} and {@code b}, share a common
 * prefix of length {@code pl} if the following expression is true:
 * <pre>{@code
 *     pl >= 0 &&
 *     pl < Math.min(a.length, b.length) &&
 *     Arrays.equals(a, 0, pl, b, 0, pl) &&
 *     a[pl] != b[pl]
 * }</pre>
 * Note that a common prefix length of {@code 0} indicates that the first
 * elements from each array mismatch.
 *
 * <p>Two non-{@code null} arrays, {@code a} and {@code b}, share a proper
 * prefix if the following expression is true:
 * <pre>{@code
 *     a.length != b.length &&
 *     Arrays.equals(a, 0, Math.min(a.length, b.length),
 *                   b, 0, Math.min(a.length, b.length))
 * }</pre>
 *
 * @param a the first array to be tested for a mismatch
 * @param b the second array to be tested for a mismatch
 * @return the index of the first mismatch between the two arrays,
 *         otherwise {@code -1}.
 * @throws java.lang.NullPointerException
 *         if either array is {@code null}
 * @since 9
 */

public static int mismatch(@androidx.annotation.RecentlyNonNull byte[] a, @androidx.annotation.RecentlyNonNull byte[] b) { throw new RuntimeException("Stub!"); }

/**
 * Finds and returns the relative index of the first mismatch between two
 * {@code byte} arrays over the specified ranges, otherwise return -1 if no
 * mismatch is found.  The index will be in the range of 0 (inclusive) up to
 * the length (inclusive) of the smaller range.
 *
 * <p>If the two arrays, over the specified ranges, share a common prefix
 * then the returned relative index is the length of the common prefix and
 * it follows that there is a mismatch between the two elements at that
 * relative index within the respective arrays.
 * If one array is a proper prefix of the other, over the specified ranges,
 * then the returned relative index is the length of the smaller range and
 * it follows that the relative index is only valid for the array with the
 * larger range.
 * Otherwise, there is no mismatch.
 *
 * <p>Two non-{@code null} arrays, {@code a} and {@code b} with specified
 * ranges [{@code aFromIndex}, {@code atoIndex}) and
 * [{@code bFromIndex}, {@code btoIndex}) respectively, share a common
 * prefix of length {@code pl} if the following expression is true:
 * <pre>{@code
 *     pl >= 0 &&
 *     pl < Math.min(aToIndex - aFromIndex, bToIndex - bFromIndex) &&
 *     Arrays.equals(a, aFromIndex, aFromIndex + pl, b, bFromIndex, bFromIndex + pl) &&
 *     a[aFromIndex + pl] != b[bFromIndex + pl]
 * }</pre>
 * Note that a common prefix length of {@code 0} indicates that the first
 * elements from each array mismatch.
 *
 * <p>Two non-{@code null} arrays, {@code a} and {@code b} with specified
 * ranges [{@code aFromIndex}, {@code atoIndex}) and
 * [{@code bFromIndex}, {@code btoIndex}) respectively, share a proper
 * prefix if the following expression is true:
 * <pre>{@code
 *     (aToIndex - aFromIndex) != (bToIndex - bFromIndex) &&
 *     Arrays.equals(a, 0, Math.min(aToIndex - aFromIndex, bToIndex - bFromIndex),
 *                   b, 0, Math.min(aToIndex - aFromIndex, bToIndex - bFromIndex))
 * }</pre>
 *
 * @param a the first array to be tested for a mismatch
 * @param aFromIndex the index (inclusive) of the first element in the
 *                   first array to be tested
 * @param aToIndex the index (exclusive) of the last element in the
 *                 first array to be tested
 * @param b the second array to be tested for a mismatch
 * @param bFromIndex the index (inclusive) of the first element in the
 *                   second array to be tested
 * @param bToIndex the index (exclusive) of the last element in the
 *                 second array to be tested
 * @return the relative index of the first mismatch between the two arrays
 *         over the specified ranges, otherwise {@code -1}.
 * @throws java.lang.IllegalArgumentException
 *         if {@code aFromIndex > aToIndex} or
 *         if {@code bFromIndex > bToIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *         if {@code aFromIndex < 0 or aToIndex > a.length} or
 *         if {@code bFromIndex < 0 or bToIndex > b.length}
 * @throws java.lang.NullPointerException
 *         if either array is {@code null}
 * @since 9
 */

public static int mismatch(byte[] a, int aFromIndex, int aToIndex, byte[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

/**
 * Finds and returns the index of the first mismatch between two {@code char}
 * arrays, otherwise return -1 if no mismatch is found.  The index will be
 * in the range of 0 (inclusive) up to the length (inclusive) of the smaller
 * array.
 *
 * <p>If the two arrays share a common prefix then the returned index is the
 * length of the common prefix and it follows that there is a mismatch
 * between the two elements at that index within the respective arrays.
 * If one array is a proper prefix of the other then the returned index is
 * the length of the smaller array and it follows that the index is only
 * valid for the larger array.
 * Otherwise, there is no mismatch.
 *
 * <p>Two non-{@code null} arrays, {@code a} and {@code b}, share a common
 * prefix of length {@code pl} if the following expression is true:
 * <pre>{@code
 *     pl >= 0 &&
 *     pl < Math.min(a.length, b.length) &&
 *     Arrays.equals(a, 0, pl, b, 0, pl) &&
 *     a[pl] != b[pl]
 * }</pre>
 * Note that a common prefix length of {@code 0} indicates that the first
 * elements from each array mismatch.
 *
 * <p>Two non-{@code null} arrays, {@code a} and {@code b}, share a proper
 * prefix if the following expression is true:
 * <pre>{@code
 *     a.length != b.length &&
 *     Arrays.equals(a, 0, Math.min(a.length, b.length),
 *                   b, 0, Math.min(a.length, b.length))
 * }</pre>
 *
 * @param a the first array to be tested for a mismatch
 * @param b the second array to be tested for a mismatch
 * @return the index of the first mismatch between the two arrays,
 *         otherwise {@code -1}.
 * @throws java.lang.NullPointerException
 *         if either array is {@code null}
 * @since 9
 */

public static int mismatch(@androidx.annotation.RecentlyNonNull char[] a, @androidx.annotation.RecentlyNonNull char[] b) { throw new RuntimeException("Stub!"); }

/**
 * Finds and returns the relative index of the first mismatch between two
 * {@code char} arrays over the specified ranges, otherwise return -1 if no
 * mismatch is found.  The index will be in the range of 0 (inclusive) up to
 * the length (inclusive) of the smaller range.
 *
 * <p>If the two arrays, over the specified ranges, share a common prefix
 * then the returned relative index is the length of the common prefix and
 * it follows that there is a mismatch between the two elements at that
 * relative index within the respective arrays.
 * If one array is a proper prefix of the other, over the specified ranges,
 * then the returned relative index is the length of the smaller range and
 * it follows that the relative index is only valid for the array with the
 * larger range.
 * Otherwise, there is no mismatch.
 *
 * <p>Two non-{@code null} arrays, {@code a} and {@code b} with specified
 * ranges [{@code aFromIndex}, {@code atoIndex}) and
 * [{@code bFromIndex}, {@code btoIndex}) respectively, share a common
 * prefix of length {@code pl} if the following expression is true:
 * <pre>{@code
 *     pl >= 0 &&
 *     pl < Math.min(aToIndex - aFromIndex, bToIndex - bFromIndex) &&
 *     Arrays.equals(a, aFromIndex, aFromIndex + pl, b, bFromIndex, bFromIndex + pl) &&
 *     a[aFromIndex + pl] != b[bFromIndex + pl]
 * }</pre>
 * Note that a common prefix length of {@code 0} indicates that the first
 * elements from each array mismatch.
 *
 * <p>Two non-{@code null} arrays, {@code a} and {@code b} with specified
 * ranges [{@code aFromIndex}, {@code atoIndex}) and
 * [{@code bFromIndex}, {@code btoIndex}) respectively, share a proper
 * prefix if the following expression is true:
 * <pre>{@code
 *     (aToIndex - aFromIndex) != (bToIndex - bFromIndex) &&
 *     Arrays.equals(a, 0, Math.min(aToIndex - aFromIndex, bToIndex - bFromIndex),
 *                   b, 0, Math.min(aToIndex - aFromIndex, bToIndex - bFromIndex))
 * }</pre>
 *
 * @param a the first array to be tested for a mismatch
 * @param aFromIndex the index (inclusive) of the first element in the
 *                   first array to be tested
 * @param aToIndex the index (exclusive) of the last element in the
 *                 first array to be tested
 * @param b the second array to be tested for a mismatch
 * @param bFromIndex the index (inclusive) of the first element in the
 *                   second array to be tested
 * @param bToIndex the index (exclusive) of the last element in the
 *                 second array to be tested
 * @return the relative index of the first mismatch between the two arrays
 *         over the specified ranges, otherwise {@code -1}.
 * @throws java.lang.IllegalArgumentException
 *         if {@code aFromIndex > aToIndex} or
 *         if {@code bFromIndex > bToIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *         if {@code aFromIndex < 0 or aToIndex > a.length} or
 *         if {@code bFromIndex < 0 or bToIndex > b.length}
 * @throws java.lang.NullPointerException
 *         if either array is {@code null}
 * @since 9
 */

public static int mismatch(@androidx.annotation.RecentlyNonNull char[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull char[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

/**
 * Finds and returns the index of the first mismatch between two {@code short}
 * arrays, otherwise return -1 if no mismatch is found.  The index will be
 * in the range of 0 (inclusive) up to the length (inclusive) of the smaller
 * array.
 *
 * <p>If the two arrays share a common prefix then the returned index is the
 * length of the common prefix and it follows that there is a mismatch
 * between the two elements at that index within the respective arrays.
 * If one array is a proper prefix of the other then the returned index is
 * the length of the smaller array and it follows that the index is only
 * valid for the larger array.
 * Otherwise, there is no mismatch.
 *
 * <p>Two non-{@code null} arrays, {@code a} and {@code b}, share a common
 * prefix of length {@code pl} if the following expression is true:
 * <pre>{@code
 *     pl >= 0 &&
 *     pl < Math.min(a.length, b.length) &&
 *     Arrays.equals(a, 0, pl, b, 0, pl) &&
 *     a[pl] != b[pl]
 * }</pre>
 * Note that a common prefix length of {@code 0} indicates that the first
 * elements from each array mismatch.
 *
 * <p>Two non-{@code null} arrays, {@code a} and {@code b}, share a proper
 * prefix if the following expression is true:
 * <pre>{@code
 *     a.length != b.length &&
 *     Arrays.equals(a, 0, Math.min(a.length, b.length),
 *                   b, 0, Math.min(a.length, b.length))
 * }</pre>
 *
 * @param a the first array to be tested for a mismatch
 * @param b the second array to be tested for a mismatch
 * @return the index of the first mismatch between the two arrays,
 *         otherwise {@code -1}.
 * @throws java.lang.NullPointerException
 *         if either array is {@code null}
 * @since 9
 */

public static int mismatch(@androidx.annotation.RecentlyNonNull short[] a, @androidx.annotation.RecentlyNonNull short[] b) { throw new RuntimeException("Stub!"); }

/**
 * Finds and returns the relative index of the first mismatch between two
 * {@code short} arrays over the specified ranges, otherwise return -1 if no
 * mismatch is found.  The index will be in the range of 0 (inclusive) up to
 * the length (inclusive) of the smaller range.
 *
 * <p>If the two arrays, over the specified ranges, share a common prefix
 * then the returned relative index is the length of the common prefix and
 * it follows that there is a mismatch between the two elements at that
 * relative index within the respective arrays.
 * If one array is a proper prefix of the other, over the specified ranges,
 * then the returned relative index is the length of the smaller range and
 * it follows that the relative index is only valid for the array with the
 * larger range.
 * Otherwise, there is no mismatch.
 *
 * <p>Two non-{@code null} arrays, {@code a} and {@code b} with specified
 * ranges [{@code aFromIndex}, {@code atoIndex}) and
 * [{@code bFromIndex}, {@code btoIndex}) respectively, share a common
 * prefix of length {@code pl} if the following expression is true:
 * <pre>{@code
 *     pl >= 0 &&
 *     pl < Math.min(aToIndex - aFromIndex, bToIndex - bFromIndex) &&
 *     Arrays.equals(a, aFromIndex, aFromIndex + pl, b, bFromIndex, bFromIndex + pl) &&
 *     a[aFromIndex + pl] != b[bFromIndex + pl]
 * }</pre>
 * Note that a common prefix length of {@code 0} indicates that the first
 * elements from each array mismatch.
 *
 * <p>Two non-{@code null} arrays, {@code a} and {@code b} with specified
 * ranges [{@code aFromIndex}, {@code atoIndex}) and
 * [{@code bFromIndex}, {@code btoIndex}) respectively, share a proper
 * prefix if the following expression is true:
 * <pre>{@code
 *     (aToIndex - aFromIndex) != (bToIndex - bFromIndex) &&
 *     Arrays.equals(a, 0, Math.min(aToIndex - aFromIndex, bToIndex - bFromIndex),
 *                   b, 0, Math.min(aToIndex - aFromIndex, bToIndex - bFromIndex))
 * }</pre>
 *
 * @param a the first array to be tested for a mismatch
 * @param aFromIndex the index (inclusive) of the first element in the
 *                   first array to be tested
 * @param aToIndex the index (exclusive) of the last element in the
 *                 first array to be tested
 * @param b the second array to be tested for a mismatch
 * @param bFromIndex the index (inclusive) of the first element in the
 *                   second array to be tested
 * @param bToIndex the index (exclusive) of the last element in the
 *                 second array to be tested
 * @return the relative index of the first mismatch between the two arrays
 *         over the specified ranges, otherwise {@code -1}.
 * @throws java.lang.IllegalArgumentException
 *         if {@code aFromIndex > aToIndex} or
 *         if {@code bFromIndex > bToIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *         if {@code aFromIndex < 0 or aToIndex > a.length} or
 *         if {@code bFromIndex < 0 or bToIndex > b.length}
 * @throws java.lang.NullPointerException
 *         if either array is {@code null}
 * @since 9
 */

public static int mismatch(@androidx.annotation.RecentlyNonNull short[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull short[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

/**
 * Finds and returns the index of the first mismatch between two {@code int}
 * arrays, otherwise return -1 if no mismatch is found.  The index will be
 * in the range of 0 (inclusive) up to the length (inclusive) of the smaller
 * array.
 *
 * <p>If the two arrays share a common prefix then the returned index is the
 * length of the common prefix and it follows that there is a mismatch
 * between the two elements at that index within the respective arrays.
 * If one array is a proper prefix of the other then the returned index is
 * the length of the smaller array and it follows that the index is only
 * valid for the larger array.
 * Otherwise, there is no mismatch.
 *
 * <p>Two non-{@code null} arrays, {@code a} and {@code b}, share a common
 * prefix of length {@code pl} if the following expression is true:
 * <pre>{@code
 *     pl >= 0 &&
 *     pl < Math.min(a.length, b.length) &&
 *     Arrays.equals(a, 0, pl, b, 0, pl) &&
 *     a[pl] != b[pl]
 * }</pre>
 * Note that a common prefix length of {@code 0} indicates that the first
 * elements from each array mismatch.
 *
 * <p>Two non-{@code null} arrays, {@code a} and {@code b}, share a proper
 * prefix if the following expression is true:
 * <pre>{@code
 *     a.length != b.length &&
 *     Arrays.equals(a, 0, Math.min(a.length, b.length),
 *                   b, 0, Math.min(a.length, b.length))
 * }</pre>
 *
 * @param a the first array to be tested for a mismatch
 * @param b the second array to be tested for a mismatch
 * @return the index of the first mismatch between the two arrays,
 *         otherwise {@code -1}.
 * @throws java.lang.NullPointerException
 *         if either array is {@code null}
 * @since 9
 */

public static int mismatch(@androidx.annotation.RecentlyNonNull int[] a, @androidx.annotation.RecentlyNonNull int[] b) { throw new RuntimeException("Stub!"); }

/**
 * Finds and returns the relative index of the first mismatch between two
 * {@code int} arrays over the specified ranges, otherwise return -1 if no
 * mismatch is found.  The index will be in the range of 0 (inclusive) up to
 * the length (inclusive) of the smaller range.
 *
 * <p>If the two arrays, over the specified ranges, share a common prefix
 * then the returned relative index is the length of the common prefix and
 * it follows that there is a mismatch between the two elements at that
 * relative index within the respective arrays.
 * If one array is a proper prefix of the other, over the specified ranges,
 * then the returned relative index is the length of the smaller range and
 * it follows that the relative index is only valid for the array with the
 * larger range.
 * Otherwise, there is no mismatch.
 *
 * <p>Two non-{@code null} arrays, {@code a} and {@code b} with specified
 * ranges [{@code aFromIndex}, {@code atoIndex}) and
 * [{@code bFromIndex}, {@code btoIndex}) respectively, share a common
 * prefix of length {@code pl} if the following expression is true:
 * <pre>{@code
 *     pl >= 0 &&
 *     pl < Math.min(aToIndex - aFromIndex, bToIndex - bFromIndex) &&
 *     Arrays.equals(a, aFromIndex, aFromIndex + pl, b, bFromIndex, bFromIndex + pl) &&
 *     a[aFromIndex + pl] != b[bFromIndex + pl]
 * }</pre>
 * Note that a common prefix length of {@code 0} indicates that the first
 * elements from each array mismatch.
 *
 * <p>Two non-{@code null} arrays, {@code a} and {@code b} with specified
 * ranges [{@code aFromIndex}, {@code atoIndex}) and
 * [{@code bFromIndex}, {@code btoIndex}) respectively, share a proper
 * prefix if the following expression is true:
 * <pre>{@code
 *     (aToIndex - aFromIndex) != (bToIndex - bFromIndex) &&
 *     Arrays.equals(a, 0, Math.min(aToIndex - aFromIndex, bToIndex - bFromIndex),
 *                   b, 0, Math.min(aToIndex - aFromIndex, bToIndex - bFromIndex))
 * }</pre>
 *
 * @param a the first array to be tested for a mismatch
 * @param aFromIndex the index (inclusive) of the first element in the
 *                   first array to be tested
 * @param aToIndex the index (exclusive) of the last element in the
 *                 first array to be tested
 * @param b the second array to be tested for a mismatch
 * @param bFromIndex the index (inclusive) of the first element in the
 *                   second array to be tested
 * @param bToIndex the index (exclusive) of the last element in the
 *                 second array to be tested
 * @return the relative index of the first mismatch between the two arrays
 *         over the specified ranges, otherwise {@code -1}.
 * @throws java.lang.IllegalArgumentException
 *         if {@code aFromIndex > aToIndex} or
 *         if {@code bFromIndex > bToIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *         if {@code aFromIndex < 0 or aToIndex > a.length} or
 *         if {@code bFromIndex < 0 or bToIndex > b.length}
 * @throws java.lang.NullPointerException
 *         if either array is {@code null}
 * @since 9
 */

public static int mismatch(@androidx.annotation.RecentlyNonNull int[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull int[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

/**
 * Finds and returns the index of the first mismatch between two {@code long}
 * arrays, otherwise return -1 if no mismatch is found.  The index will be
 * in the range of 0 (inclusive) up to the length (inclusive) of the smaller
 * array.
 *
 * <p>If the two arrays share a common prefix then the returned index is the
 * length of the common prefix and it follows that there is a mismatch
 * between the two elements at that index within the respective arrays.
 * If one array is a proper prefix of the other then the returned index is
 * the length of the smaller array and it follows that the index is only
 * valid for the larger array.
 * Otherwise, there is no mismatch.
 *
 * <p>Two non-{@code null} arrays, {@code a} and {@code b}, share a common
 * prefix of length {@code pl} if the following expression is true:
 * <pre>{@code
 *     pl >= 0 &&
 *     pl < Math.min(a.length, b.length) &&
 *     Arrays.equals(a, 0, pl, b, 0, pl) &&
 *     a[pl] != b[pl]
 * }</pre>
 * Note that a common prefix length of {@code 0} indicates that the first
 * elements from each array mismatch.
 *
 * <p>Two non-{@code null} arrays, {@code a} and {@code b}, share a proper
 * prefix if the following expression is true:
 * <pre>{@code
 *     a.length != b.length &&
 *     Arrays.equals(a, 0, Math.min(a.length, b.length),
 *                   b, 0, Math.min(a.length, b.length))
 * }</pre>
 *
 * @param a the first array to be tested for a mismatch
 * @param b the second array to be tested for a mismatch
 * @return the index of the first mismatch between the two arrays,
 *         otherwise {@code -1}.
 * @throws java.lang.NullPointerException
 *         if either array is {@code null}
 * @since 9
 */

public static int mismatch(@androidx.annotation.RecentlyNonNull long[] a, @androidx.annotation.RecentlyNonNull long[] b) { throw new RuntimeException("Stub!"); }

/**
 * Finds and returns the relative index of the first mismatch between two
 * {@code long} arrays over the specified ranges, otherwise return -1 if no
 * mismatch is found.  The index will be in the range of 0 (inclusive) up to
 * the length (inclusive) of the smaller range.
 *
 * <p>If the two arrays, over the specified ranges, share a common prefix
 * then the returned relative index is the length of the common prefix and
 * it follows that there is a mismatch between the two elements at that
 * relative index within the respective arrays.
 * If one array is a proper prefix of the other, over the specified ranges,
 * then the returned relative index is the length of the smaller range and
 * it follows that the relative index is only valid for the array with the
 * larger range.
 * Otherwise, there is no mismatch.
 *
 * <p>Two non-{@code null} arrays, {@code a} and {@code b} with specified
 * ranges [{@code aFromIndex}, {@code atoIndex}) and
 * [{@code bFromIndex}, {@code btoIndex}) respectively, share a common
 * prefix of length {@code pl} if the following expression is true:
 * <pre>{@code
 *     pl >= 0 &&
 *     pl < Math.min(aToIndex - aFromIndex, bToIndex - bFromIndex) &&
 *     Arrays.equals(a, aFromIndex, aFromIndex + pl, b, bFromIndex, bFromIndex + pl) &&
 *     a[aFromIndex + pl] != b[bFromIndex + pl]
 * }</pre>
 * Note that a common prefix length of {@code 0} indicates that the first
 * elements from each array mismatch.
 *
 * <p>Two non-{@code null} arrays, {@code a} and {@code b} with specified
 * ranges [{@code aFromIndex}, {@code atoIndex}) and
 * [{@code bFromIndex}, {@code btoIndex}) respectively, share a proper
 * prefix if the following expression is true:
 * <pre>{@code
 *     (aToIndex - aFromIndex) != (bToIndex - bFromIndex) &&
 *     Arrays.equals(a, 0, Math.min(aToIndex - aFromIndex, bToIndex - bFromIndex),
 *                   b, 0, Math.min(aToIndex - aFromIndex, bToIndex - bFromIndex))
 * }</pre>
 *
 * @param a the first array to be tested for a mismatch
 * @param aFromIndex the index (inclusive) of the first element in the
 *                   first array to be tested
 * @param aToIndex the index (exclusive) of the last element in the
 *                 first array to be tested
 * @param b the second array to be tested for a mismatch
 * @param bFromIndex the index (inclusive) of the first element in the
 *                   second array to be tested
 * @param bToIndex the index (exclusive) of the last element in the
 *                 second array to be tested
 * @return the relative index of the first mismatch between the two arrays
 *         over the specified ranges, otherwise {@code -1}.
 * @throws java.lang.IllegalArgumentException
 *         if {@code aFromIndex > aToIndex} or
 *         if {@code bFromIndex > bToIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *         if {@code aFromIndex < 0 or aToIndex > a.length} or
 *         if {@code bFromIndex < 0 or bToIndex > b.length}
 * @throws java.lang.NullPointerException
 *         if either array is {@code null}
 * @since 9
 */

public static int mismatch(@androidx.annotation.RecentlyNonNull long[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull long[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

/**
 * Finds and returns the index of the first mismatch between two {@code float}
 * arrays, otherwise return -1 if no mismatch is found.  The index will be
 * in the range of 0 (inclusive) up to the length (inclusive) of the smaller
 * array.
 *
 * <p>If the two arrays share a common prefix then the returned index is the
 * length of the common prefix and it follows that there is a mismatch
 * between the two elements at that index within the respective arrays.
 * If one array is a proper prefix of the other then the returned index is
 * the length of the smaller array and it follows that the index is only
 * valid for the larger array.
 * Otherwise, there is no mismatch.
 *
 * <p>Two non-{@code null} arrays, {@code a} and {@code b}, share a common
 * prefix of length {@code pl} if the following expression is true:
 * <pre>{@code
 *     pl >= 0 &&
 *     pl < Math.min(a.length, b.length) &&
 *     Arrays.equals(a, 0, pl, b, 0, pl) &&
 *     Float.compare(a[pl], b[pl]) != 0
 * }</pre>
 * Note that a common prefix length of {@code 0} indicates that the first
 * elements from each array mismatch.
 *
 * <p>Two non-{@code null} arrays, {@code a} and {@code b}, share a proper
 * prefix if the following expression is true:
 * <pre>{@code
 *     a.length != b.length &&
 *     Arrays.equals(a, 0, Math.min(a.length, b.length),
 *                   b, 0, Math.min(a.length, b.length))
 * }</pre>
 *
 * @param a the first array to be tested for a mismatch
 * @param b the second array to be tested for a mismatch
 * @return the index of the first mismatch between the two arrays,
 *         otherwise {@code -1}.
 * @throws java.lang.NullPointerException
 *         if either array is {@code null}
 * @since 9
 */

public static int mismatch(@androidx.annotation.RecentlyNonNull float[] a, @androidx.annotation.RecentlyNonNull float[] b) { throw new RuntimeException("Stub!"); }

/**
 * Finds and returns the relative index of the first mismatch between two
 * {@code float} arrays over the specified ranges, otherwise return -1 if no
 * mismatch is found.  The index will be in the range of 0 (inclusive) up to
 * the length (inclusive) of the smaller range.
 *
 * <p>If the two arrays, over the specified ranges, share a common prefix
 * then the returned relative index is the length of the common prefix and
 * it follows that there is a mismatch between the two elements at that
 * relative index within the respective arrays.
 * If one array is a proper prefix of the other, over the specified ranges,
 * then the returned relative index is the length of the smaller range and
 * it follows that the relative index is only valid for the array with the
 * larger range.
 * Otherwise, there is no mismatch.
 *
 * <p>Two non-{@code null} arrays, {@code a} and {@code b} with specified
 * ranges [{@code aFromIndex}, {@code atoIndex}) and
 * [{@code bFromIndex}, {@code btoIndex}) respectively, share a common
 * prefix of length {@code pl} if the following expression is true:
 * <pre>{@code
 *     pl >= 0 &&
 *     pl < Math.min(aToIndex - aFromIndex, bToIndex - bFromIndex) &&
 *     Arrays.equals(a, aFromIndex, aFromIndex + pl, b, bFromIndex, bFromIndex + pl) &&
 *     Float.compare(a[aFromIndex + pl], b[bFromIndex + pl]) != 0
 * }</pre>
 * Note that a common prefix length of {@code 0} indicates that the first
 * elements from each array mismatch.
 *
 * <p>Two non-{@code null} arrays, {@code a} and {@code b} with specified
 * ranges [{@code aFromIndex}, {@code atoIndex}) and
 * [{@code bFromIndex}, {@code btoIndex}) respectively, share a proper
 * prefix if the following expression is true:
 * <pre>{@code
 *     (aToIndex - aFromIndex) != (bToIndex - bFromIndex) &&
 *     Arrays.equals(a, 0, Math.min(aToIndex - aFromIndex, bToIndex - bFromIndex),
 *                   b, 0, Math.min(aToIndex - aFromIndex, bToIndex - bFromIndex))
 * }</pre>
 *
 * @param a the first array to be tested for a mismatch
 * @param aFromIndex the index (inclusive) of the first element in the
 *                   first array to be tested
 * @param aToIndex the index (exclusive) of the last element in the
 *                 first array to be tested
 * @param b the second array to be tested for a mismatch
 * @param bFromIndex the index (inclusive) of the first element in the
 *                   second array to be tested
 * @param bToIndex the index (exclusive) of the last element in the
 *                 second array to be tested
 * @return the relative index of the first mismatch between the two arrays
 *         over the specified ranges, otherwise {@code -1}.
 * @throws java.lang.IllegalArgumentException
 *         if {@code aFromIndex > aToIndex} or
 *         if {@code bFromIndex > bToIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *         if {@code aFromIndex < 0 or aToIndex > a.length} or
 *         if {@code bFromIndex < 0 or bToIndex > b.length}
 * @throws java.lang.NullPointerException
 *         if either array is {@code null}
 * @since 9
 */

public static int mismatch(@androidx.annotation.RecentlyNonNull float[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull float[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

/**
 * Finds and returns the index of the first mismatch between two
 * {@code double} arrays, otherwise return -1 if no mismatch is found.  The
 * index will be in the range of 0 (inclusive) up to the length (inclusive)
 * of the smaller array.
 *
 * <p>If the two arrays share a common prefix then the returned index is the
 * length of the common prefix and it follows that there is a mismatch
 * between the two elements at that index within the respective arrays.
 * If one array is a proper prefix of the other then the returned index is
 * the length of the smaller array and it follows that the index is only
 * valid for the larger array.
 * Otherwise, there is no mismatch.
 *
 * <p>Two non-{@code null} arrays, {@code a} and {@code b}, share a common
 * prefix of length {@code pl} if the following expression is true:
 * <pre>{@code
 *     pl >= 0 &&
 *     pl < Math.min(a.length, b.length) &&
 *     Arrays.equals(a, 0, pl, b, 0, pl) &&
 *     Double.compare(a[pl], b[pl]) != 0
 * }</pre>
 * Note that a common prefix length of {@code 0} indicates that the first
 * elements from each array mismatch.
 *
 * <p>Two non-{@code null} arrays, {@code a} and {@code b}, share a proper
 * prefix if the following expression is true:
 * <pre>{@code
 *     a.length != b.length &&
 *     Arrays.equals(a, 0, Math.min(a.length, b.length),
 *                   b, 0, Math.min(a.length, b.length))
 * }</pre>
 *
 * @param a the first array to be tested for a mismatch
 * @param b the second array to be tested for a mismatch
 * @return the index of the first mismatch between the two arrays,
 *         otherwise {@code -1}.
 * @throws java.lang.NullPointerException
 *         if either array is {@code null}
 * @since 9
 */

public static int mismatch(@androidx.annotation.RecentlyNonNull double[] a, @androidx.annotation.RecentlyNonNull double[] b) { throw new RuntimeException("Stub!"); }

/**
 * Finds and returns the relative index of the first mismatch between two
 * {@code double} arrays over the specified ranges, otherwise return -1 if
 * no mismatch is found.  The index will be in the range of 0 (inclusive) up
 * to the length (inclusive) of the smaller range.
 *
 * <p>If the two arrays, over the specified ranges, share a common prefix
 * then the returned relative index is the length of the common prefix and
 * it follows that there is a mismatch between the two elements at that
 * relative index within the respective arrays.
 * If one array is a proper prefix of the other, over the specified ranges,
 * then the returned relative index is the length of the smaller range and
 * it follows that the relative index is only valid for the array with the
 * larger range.
 * Otherwise, there is no mismatch.
 *
 * <p>Two non-{@code null} arrays, {@code a} and {@code b} with specified
 * ranges [{@code aFromIndex}, {@code atoIndex}) and
 * [{@code bFromIndex}, {@code btoIndex}) respectively, share a common
 * prefix of length {@code pl} if the following expression is true:
 * <pre>{@code
 *     pl >= 0 &&
 *     pl < Math.min(aToIndex - aFromIndex, bToIndex - bFromIndex) &&
 *     Arrays.equals(a, aFromIndex, aFromIndex + pl, b, bFromIndex, bFromIndex + pl) &&
 *     Double.compare(a[aFromIndex + pl], b[bFromIndex + pl]) != 0
 * }</pre>
 * Note that a common prefix length of {@code 0} indicates that the first
 * elements from each array mismatch.
 *
 * <p>Two non-{@code null} arrays, {@code a} and {@code b} with specified
 * ranges [{@code aFromIndex}, {@code atoIndex}) and
 * [{@code bFromIndex}, {@code btoIndex}) respectively, share a proper
 * prefix if the following expression is true:
 * <pre>{@code
 *     (aToIndex - aFromIndex) != (bToIndex - bFromIndex) &&
 *     Arrays.equals(a, 0, Math.min(aToIndex - aFromIndex, bToIndex - bFromIndex),
 *                   b, 0, Math.min(aToIndex - aFromIndex, bToIndex - bFromIndex))
 * }</pre>
 *
 * @param a the first array to be tested for a mismatch
 * @param aFromIndex the index (inclusive) of the first element in the
 *                   first array to be tested
 * @param aToIndex the index (exclusive) of the last element in the
 *                 first array to be tested
 * @param b the second array to be tested for a mismatch
 * @param bFromIndex the index (inclusive) of the first element in the
 *                   second array to be tested
 * @param bToIndex the index (exclusive) of the last element in the
 *                 second array to be tested
 * @return the relative index of the first mismatch between the two arrays
 *         over the specified ranges, otherwise {@code -1}.
 * @throws java.lang.IllegalArgumentException
 *         if {@code aFromIndex > aToIndex} or
 *         if {@code bFromIndex > bToIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *         if {@code aFromIndex < 0 or aToIndex > a.length} or
 *         if {@code bFromIndex < 0 or bToIndex > b.length}
 * @throws java.lang.NullPointerException
 *         if either array is {@code null}
 * @since 9
 */

public static int mismatch(@androidx.annotation.RecentlyNonNull double[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull double[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

/**
 * Finds and returns the index of the first mismatch between two
 * {@code Object} arrays, otherwise return -1 if no mismatch is found.  The
 * index will be in the range of 0 (inclusive) up to the length (inclusive)
 * of the smaller array.
 *
 * <p>If the two arrays share a common prefix then the returned index is the
 * length of the common prefix and it follows that there is a mismatch
 * between the two elements at that index within the respective arrays.
 * If one array is a proper prefix of the other then the returned index is
 * the length of the smaller array and it follows that the index is only
 * valid for the larger array.
 * Otherwise, there is no mismatch.
 *
 * <p>Two non-{@code null} arrays, {@code a} and {@code b}, share a common
 * prefix of length {@code pl} if the following expression is true:
 * <pre>{@code
 *     pl >= 0 &&
 *     pl < Math.min(a.length, b.length) &&
 *     Arrays.equals(a, 0, pl, b, 0, pl) &&
 *     !Objects.equals(a[pl], b[pl])
 * }</pre>
 * Note that a common prefix length of {@code 0} indicates that the first
 * elements from each array mismatch.
 *
 * <p>Two non-{@code null} arrays, {@code a} and {@code b}, share a proper
 * prefix if the following expression is true:
 * <pre>{@code
 *     a.length != b.length &&
 *     Arrays.equals(a, 0, Math.min(a.length, b.length),
 *                   b, 0, Math.min(a.length, b.length))
 * }</pre>
 *
 * @param a the first array to be tested for a mismatch
 * @param b the second array to be tested for a mismatch
 * @return the index of the first mismatch between the two arrays,
 *         otherwise {@code -1}.
 * @throws java.lang.NullPointerException
 *         if either array is {@code null}
 * @since 9
 */

public static int mismatch(@androidx.annotation.RecentlyNonNull java.lang.Object[] a, @androidx.annotation.RecentlyNonNull java.lang.Object[] b) { throw new RuntimeException("Stub!"); }

/**
 * Finds and returns the relative index of the first mismatch between two
 * {@code Object} arrays over the specified ranges, otherwise return -1 if
 * no mismatch is found.  The index will be in the range of 0 (inclusive) up
 * to the length (inclusive) of the smaller range.
 *
 * <p>If the two arrays, over the specified ranges, share a common prefix
 * then the returned relative index is the length of the common prefix and
 * it follows that there is a mismatch between the two elements at that
 * relative index within the respective arrays.
 * If one array is a proper prefix of the other, over the specified ranges,
 * then the returned relative index is the length of the smaller range and
 * it follows that the relative index is only valid for the array with the
 * larger range.
 * Otherwise, there is no mismatch.
 *
 * <p>Two non-{@code null} arrays, {@code a} and {@code b} with specified
 * ranges [{@code aFromIndex}, {@code atoIndex}) and
 * [{@code bFromIndex}, {@code btoIndex}) respectively, share a common
 * prefix of length {@code pl} if the following expression is true:
 * <pre>{@code
 *     pl >= 0 &&
 *     pl < Math.min(aToIndex - aFromIndex, bToIndex - bFromIndex) &&
 *     Arrays.equals(a, aFromIndex, aFromIndex + pl, b, bFromIndex, bFromIndex + pl) &&
 *     !Objects.equals(a[aFromIndex + pl], b[bFromIndex + pl])
 * }</pre>
 * Note that a common prefix length of {@code 0} indicates that the first
 * elements from each array mismatch.
 *
 * <p>Two non-{@code null} arrays, {@code a} and {@code b} with specified
 * ranges [{@code aFromIndex}, {@code atoIndex}) and
 * [{@code bFromIndex}, {@code btoIndex}) respectively, share a proper
 * prefix if the following expression is true:
 * <pre>{@code
 *     (aToIndex - aFromIndex) != (bToIndex - bFromIndex) &&
 *     Arrays.equals(a, 0, Math.min(aToIndex - aFromIndex, bToIndex - bFromIndex),
 *                   b, 0, Math.min(aToIndex - aFromIndex, bToIndex - bFromIndex))
 * }</pre>
 *
 * @param a the first array to be tested for a mismatch
 * @param aFromIndex the index (inclusive) of the first element in the
 *                   first array to be tested
 * @param aToIndex the index (exclusive) of the last element in the
 *                 first array to be tested
 * @param b the second array to be tested for a mismatch
 * @param bFromIndex the index (inclusive) of the first element in the
 *                   second array to be tested
 * @param bToIndex the index (exclusive) of the last element in the
 *                 second array to be tested
 * @return the relative index of the first mismatch between the two arrays
 *         over the specified ranges, otherwise {@code -1}.
 * @throws java.lang.IllegalArgumentException
 *         if {@code aFromIndex > aToIndex} or
 *         if {@code bFromIndex > bToIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *         if {@code aFromIndex < 0 or aToIndex > a.length} or
 *         if {@code bFromIndex < 0 or bToIndex > b.length}
 * @throws java.lang.NullPointerException
 *         if either array is {@code null}
 * @since 9
 */

public static int mismatch(@androidx.annotation.RecentlyNonNull java.lang.Object[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull java.lang.Object[] b, int bFromIndex, int bToIndex) { throw new RuntimeException("Stub!"); }

/**
 * Finds and returns the index of the first mismatch between two
 * {@code Object} arrays, otherwise return -1 if no mismatch is found.
 * The index will be in the range of 0 (inclusive) up to the length
 * (inclusive) of the smaller array.
 *
 * <p>The specified comparator is used to determine if two array elements
 * from the each array are not equal.
 *
 * <p>If the two arrays share a common prefix then the returned index is the
 * length of the common prefix and it follows that there is a mismatch
 * between the two elements at that index within the respective arrays.
 * If one array is a proper prefix of the other then the returned index is
 * the length of the smaller array and it follows that the index is only
 * valid for the larger array.
 * Otherwise, there is no mismatch.
 *
 * <p>Two non-{@code null} arrays, {@code a} and {@code b}, share a common
 * prefix of length {@code pl} if the following expression is true:
 * <pre>{@code
 *     pl >= 0 &&
 *     pl < Math.min(a.length, b.length) &&
 *     Arrays.equals(a, 0, pl, b, 0, pl, cmp)
 *     cmp.compare(a[pl], b[pl]) != 0
 * }</pre>
 * Note that a common prefix length of {@code 0} indicates that the first
 * elements from each array mismatch.
 *
 * <p>Two non-{@code null} arrays, {@code a} and {@code b}, share a proper
 * prefix if the following expression is true:
 * <pre>{@code
 *     a.length != b.length &&
 *     Arrays.equals(a, 0, Math.min(a.length, b.length),
 *                   b, 0, Math.min(a.length, b.length),
 *                   cmp)
 * }</pre>
 *
 * @param a the first array to be tested for a mismatch
 * @param b the second array to be tested for a mismatch
 * @param cmp the comparator to compare array elements
 * @param <T> the type of array elements
 * @return the index of the first mismatch between the two arrays,
 *         otherwise {@code -1}.
 * @throws java.lang.NullPointerException
 *         if either array or the comparator is {@code null}
 * @since 9
 */

public static <T> int mismatch(@androidx.annotation.RecentlyNonNull T[] a, @androidx.annotation.RecentlyNonNull T[] b, @androidx.annotation.RecentlyNonNull java.util.Comparator<? super T> cmp) { throw new RuntimeException("Stub!"); }

/**
 * Finds and returns the relative index of the first mismatch between two
 * {@code Object} arrays over the specified ranges, otherwise return -1 if
 * no mismatch is found.  The index will be in the range of 0 (inclusive) up
 * to the length (inclusive) of the smaller range.
 *
 * <p>If the two arrays, over the specified ranges, share a common prefix
 * then the returned relative index is the length of the common prefix and
 * it follows that there is a mismatch between the two elements at that
 * relative index within the respective arrays.
 * If one array is a proper prefix of the other, over the specified ranges,
 * then the returned relative index is the length of the smaller range and
 * it follows that the relative index is only valid for the array with the
 * larger range.
 * Otherwise, there is no mismatch.
 *
 * <p>Two non-{@code null} arrays, {@code a} and {@code b} with specified
 * ranges [{@code aFromIndex}, {@code atoIndex}) and
 * [{@code bFromIndex}, {@code btoIndex}) respectively, share a common
 * prefix of length {@code pl} if the following expression is true:
 * <pre>{@code
 *     pl >= 0 &&
 *     pl < Math.min(aToIndex - aFromIndex, bToIndex - bFromIndex) &&
 *     Arrays.equals(a, aFromIndex, aFromIndex + pl, b, bFromIndex, bFromIndex + pl, cmp) &&
 *     cmp.compare(a[aFromIndex + pl], b[bFromIndex + pl]) != 0
 * }</pre>
 * Note that a common prefix length of {@code 0} indicates that the first
 * elements from each array mismatch.
 *
 * <p>Two non-{@code null} arrays, {@code a} and {@code b} with specified
 * ranges [{@code aFromIndex}, {@code atoIndex}) and
 * [{@code bFromIndex}, {@code btoIndex}) respectively, share a proper
 * prefix if the following expression is true:
 * <pre>{@code
 *     (aToIndex - aFromIndex) != (bToIndex - bFromIndex) &&
 *     Arrays.equals(a, 0, Math.min(aToIndex - aFromIndex, bToIndex - bFromIndex),
 *                   b, 0, Math.min(aToIndex - aFromIndex, bToIndex - bFromIndex),
 *                   cmp)
 * }</pre>
 *
 * @param a the first array to be tested for a mismatch
 * @param aFromIndex the index (inclusive) of the first element in the
 *                   first array to be tested
 * @param aToIndex the index (exclusive) of the last element in the
 *                 first array to be tested
 * @param b the second array to be tested for a mismatch
 * @param bFromIndex the index (inclusive) of the first element in the
 *                   second array to be tested
 * @param bToIndex the index (exclusive) of the last element in the
 *                 second array to be tested
 * @param cmp the comparator to compare array elements
 * @param <T> the type of array elements
 * @return the relative index of the first mismatch between the two arrays
 *         over the specified ranges, otherwise {@code -1}.
 * @throws java.lang.IllegalArgumentException
 *         if {@code aFromIndex > aToIndex} or
 *         if {@code bFromIndex > bToIndex}
 * @throws java.lang.ArrayIndexOutOfBoundsException
 *         if {@code aFromIndex < 0 or aToIndex > a.length} or
 *         if {@code bFromIndex < 0 or bToIndex > b.length}
 * @throws java.lang.NullPointerException
 *         if either array or the comparator is {@code null}
 * @since 9
 */

public static <T> int mismatch(@androidx.annotation.RecentlyNonNull T[] a, int aFromIndex, int aToIndex, @androidx.annotation.RecentlyNonNull T[] b, int bFromIndex, int bToIndex, @androidx.annotation.RecentlyNonNull java.util.Comparator<? super T> cmp) { throw new RuntimeException("Stub!"); }
}

