/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.os;


/**
 * API for apps to request and listen for app specific profiling.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class ProfilingManager {

ProfilingManager() { throw new RuntimeException("Stub!"); }

/**
 * Request system profiling.
 *
 * <p class="note"> Note: use of this API directly is not recommended for most use cases.
 * Please use the higher level wrappers provided by androidx that will construct the request
 * correctly based on available options and simplified user provided request parameters.</p>
 *
 * <p class="note"> Note: requests are not guaranteed to be filled.</p>
 *
 * <p class="note"> Note: Both a listener and executor must be set for the request to be
 * considered for fulfillment.
 * Listeners can be set in this method, with {@link #registerForAllProfilingResults}, or both.
 * If no listener and executor is set the request will be discarded.</p>
 *
 * @param profilingType Type of profiling to collect.
 * Value is {@link android.os.ProfilingManager#PROFILING_TYPE_JAVA_HEAP_DUMP}, {@link android.os.ProfilingManager#PROFILING_TYPE_HEAP_PROFILE}, {@link android.os.ProfilingManager#PROFILING_TYPE_STACK_SAMPLING}, or {@link android.os.ProfilingManager#PROFILING_TYPE_SYSTEM_TRACE}
 * @param parameters Bundle of request related parameters. If the bundle contains any
 *                  unrecognized parameters, the request will be fail with
 *                  {@link #ProfilingResult#ERROR_FAILED_INVALID_REQUEST}. If the values for
 *                  the parameters are out of supported range, the closest possible in range
 *                  value will be chosen.
 *                  Use of androidx wrappers is recommended over generating this directly.
 * This value may be {@code null}.
 * @param tag Caller defined data to help identify the output.
 *                  The first 20 alphanumeric characters, plus dashes, will be lowercased
 *                  and included in the output filename.
 * This value may be {@code null}.
 * @param cancellationSignal for caller requested cancellation.
 *                  Results will be returned if available.
 *                  If this is null, the requesting app will not be able to stop the collection.
 *                  The collection will stop after timing out with either the provided
 *                  configurations or with system defaults
 * @param executor  The executor to call back with.
 *                  Will only be used for the listener provided in this method.
 *                  If this is null, and no global executor and listener combinations are
 *                  registered at the time of the request, the request will be dropped.
 * @param listener  Listener to be triggered with result. Any global listeners registered via
 *                  {@link #registerForAllProfilingResults} will also be triggered. If this is
 *                  null, and no global listener and executor combinations are registered at
 *                  the time of the request, the request will be dropped.
 */

public void requestProfiling(int profilingType, @android.annotation.Nullable android.os.Bundle parameters, @android.annotation.Nullable java.lang.String tag, @android.annotation.Nullable android.os.CancellationSignal cancellationSignal, @android.annotation.Nullable java.util.concurrent.Executor executor, @android.annotation.Nullable java.util.function.Consumer<android.os.ProfilingResult> listener) { throw new RuntimeException("Stub!"); }

/**
 * Register a listener to be called for all profiling results for this uid. Listeners set here
 * will be called in addition to any provided with the request.
 *
 * @param executor The executor to call back with.
 * This value cannot be {@code null}.
 * @param listener Listener to be triggered with result.

 * This value cannot be {@code null}.
 */

public void registerForAllProfilingResults(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull java.util.function.Consumer<android.os.ProfilingResult> listener) { throw new RuntimeException("Stub!"); }

/**
 * Unregister a listener that was to be called for all profiling results. If no listener is
 * provided, all listeners for this process that were not submitted with a profiling request
 * will be removed.
 *
 * @param listener Listener to unregister and no longer be triggered with the results.
 *                 Null to remove all global listeners for this uid.

 * This value may be {@code null}.
 */

public void unregisterForAllProfilingResults(@android.annotation.Nullable java.util.function.Consumer<android.os.ProfilingResult> listener) { throw new RuntimeException("Stub!"); }

/** Profiling type for {@link #requestProfiling} to request a heap profile. */

public static final int PROFILING_TYPE_HEAP_PROFILE = 2; // 0x2

/** Profiling type for {@link #requestProfiling} to request a java heap dump. */

public static final int PROFILING_TYPE_JAVA_HEAP_DUMP = 1; // 0x1

/** Profiling type for {@link #requestProfiling} to request a stack sample. */

public static final int PROFILING_TYPE_STACK_SAMPLING = 3; // 0x3

/** Profiling type for {@link #requestProfiling} to request a system trace. */

public static final int PROFILING_TYPE_SYSTEM_TRACE = 4; // 0x4
}

