/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.media.session;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class PlaybackState implements android.os.Parcelable {

PlaybackState() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public int getState() { throw new RuntimeException("Stub!"); }

public long getPosition() { throw new RuntimeException("Stub!"); }

public long getBufferedPosition() { throw new RuntimeException("Stub!"); }

public float getPlaybackSpeed() { throw new RuntimeException("Stub!"); }

public long getActions() { throw new RuntimeException("Stub!"); }

public java.util.List<android.media.session.PlaybackState.CustomAction> getCustomActions() { throw new RuntimeException("Stub!"); }

public java.lang.CharSequence getErrorMessage() { throw new RuntimeException("Stub!"); }

public long getLastPositionUpdateTime() { throw new RuntimeException("Stub!"); }

public long getActiveQueueItemId() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.os.Bundle getExtras() { throw new RuntimeException("Stub!"); }

public boolean isActive() { throw new RuntimeException("Stub!"); }

public static final long ACTION_FAST_FORWARD = 64L; // 0x40L

public static final long ACTION_PAUSE = 2L; // 0x2L

public static final long ACTION_PLAY = 4L; // 0x4L

public static final long ACTION_PLAY_FROM_MEDIA_ID = 1024L; // 0x400L

public static final long ACTION_PLAY_FROM_SEARCH = 2048L; // 0x800L

public static final long ACTION_PLAY_FROM_URI = 8192L; // 0x2000L

public static final long ACTION_PLAY_PAUSE = 512L; // 0x200L

public static final long ACTION_PREPARE = 16384L; // 0x4000L

public static final long ACTION_PREPARE_FROM_MEDIA_ID = 32768L; // 0x8000L

public static final long ACTION_PREPARE_FROM_SEARCH = 65536L; // 0x10000L

public static final long ACTION_PREPARE_FROM_URI = 131072L; // 0x20000L

public static final long ACTION_REWIND = 8L; // 0x8L

public static final long ACTION_SEEK_TO = 256L; // 0x100L

public static final long ACTION_SET_PLAYBACK_SPEED = 4194304L; // 0x400000L

public static final long ACTION_SET_RATING = 128L; // 0x80L

public static final long ACTION_SKIP_TO_NEXT = 32L; // 0x20L

public static final long ACTION_SKIP_TO_PREVIOUS = 16L; // 0x10L

public static final long ACTION_SKIP_TO_QUEUE_ITEM = 4096L; // 0x1000L

public static final long ACTION_STOP = 1L; // 0x1L

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.media.session.PlaybackState> CREATOR;
static { CREATOR = null; }

public static final long PLAYBACK_POSITION_UNKNOWN = -1L; // 0xffffffffffffffffL

public static final int STATE_BUFFERING = 6; // 0x6

public static final int STATE_CONNECTING = 8; // 0x8

public static final int STATE_ERROR = 7; // 0x7

public static final int STATE_FAST_FORWARDING = 4; // 0x4

public static final int STATE_NONE = 0; // 0x0

public static final int STATE_PAUSED = 2; // 0x2

public static final int STATE_PLAYING = 3; // 0x3

public static final int STATE_REWINDING = 5; // 0x5

public static final int STATE_SKIPPING_TO_NEXT = 10; // 0xa

public static final int STATE_SKIPPING_TO_PREVIOUS = 9; // 0x9

public static final int STATE_SKIPPING_TO_QUEUE_ITEM = 11; // 0xb

public static final int STATE_STOPPED = 1; // 0x1
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

public Builder(android.media.session.PlaybackState from) { throw new RuntimeException("Stub!"); }

public android.media.session.PlaybackState.Builder setState(int state, long position, float playbackSpeed, long updateTime) { throw new RuntimeException("Stub!"); }

public android.media.session.PlaybackState.Builder setState(int state, long position, float playbackSpeed) { throw new RuntimeException("Stub!"); }

public android.media.session.PlaybackState.Builder setActions(long actions) { throw new RuntimeException("Stub!"); }

public android.media.session.PlaybackState.Builder addCustomAction(java.lang.String action, java.lang.String name, int icon) { throw new RuntimeException("Stub!"); }

public android.media.session.PlaybackState.Builder addCustomAction(android.media.session.PlaybackState.CustomAction customAction) { throw new RuntimeException("Stub!"); }

public android.media.session.PlaybackState.Builder setBufferedPosition(long bufferedPosition) { throw new RuntimeException("Stub!"); }

public android.media.session.PlaybackState.Builder setActiveQueueItemId(long id) { throw new RuntimeException("Stub!"); }

public android.media.session.PlaybackState.Builder setErrorMessage(java.lang.CharSequence error) { throw new RuntimeException("Stub!"); }

public android.media.session.PlaybackState.Builder setExtras(android.os.Bundle extras) { throw new RuntimeException("Stub!"); }

public android.media.session.PlaybackState build() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class CustomAction implements android.os.Parcelable {

CustomAction() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public java.lang.String getAction() { throw new RuntimeException("Stub!"); }

public java.lang.CharSequence getName() { throw new RuntimeException("Stub!"); }

public int getIcon() { throw new RuntimeException("Stub!"); }

public android.os.Bundle getExtras() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.media.session.PlaybackState.CustomAction> CREATOR;
static { CREATOR = null; }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder(java.lang.String action, java.lang.CharSequence name, int icon) { throw new RuntimeException("Stub!"); }

public android.media.session.PlaybackState.CustomAction.Builder setExtras(android.os.Bundle extras) { throw new RuntimeException("Stub!"); }

public android.media.session.PlaybackState.CustomAction build() { throw new RuntimeException("Stub!"); }
}

}

}

