/*
 * Copyright (C) 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.location;


/**
 * This class contains extra parameters to pass in a GNSS measurement request.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class GnssMeasurementRequest implements android.os.Parcelable {

GnssMeasurementRequest() { throw new RuntimeException("Stub!"); }

/**
 * Represents whether to enable full GNSS tracking.
 *
 * <p>If true, GNSS chipset switches off duty cycling. In such a mode, no clock
 * discontinuities are expected, and when supported, carrier phase should be continuous in
 * good signal conditions. All non-blocklisted, healthy constellations, satellites and
 * frequency bands that are meaningful to positioning accuracy must be tracked and reported in
 * this mode. The GNSS chipset will consume more power in full tracking mode than in duty
 * cycling mode. If false, GNSS chipset optimizes power via duty cycling, constellations and
 * frequency limits, etc.
 *
 * <p>Full GNSS tracking mode affects GnssMeasurement and other GNSS functionalities
 * including GNSS location.
 */

public boolean isFullTracking() { throw new RuntimeException("Stub!"); }

/**
 * Returns the requested time interval between the reported measurements in milliseconds, or
 * {@link #PASSIVE_INTERVAL} if this is a passive, no power request. A passive request will not
 * actively generate GNSS measurement updates, but may receive GNSS measurement updates
 * generated as a result of other GNSS measurement requests.
 *
 * <p>If the time interval is not set, the default value is 0, which means the fastest rate the
 * GNSS chipset can report.
 *
 * <p>The GNSS chipset may report measurements with a rate faster than requested.
 *
 * <p class="note">Note that on Android T, a request interval of {@link #PASSIVE_INTERVAL}
 * will first trigger one GNSS measurement. Another GNSS measurement will be triggered after
 * {@link #PASSIVE_INTERVAL} milliseconds ans so on.

 * @return Value is 0 or greater
 */

public int getIntervalMillis() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param parcel This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel parcel, int flags) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object obj) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.location.GnssMeasurementRequest> CREATOR;
static { CREATOR = null; }

/**
 * Represents a passive only request. Such a request will not trigger any active GNSS
 * measurements or power usage itself, but may receive GNSS measurements generated in response
 * to other requests.
 *
 * <p class="note">Note that on Android T, such a request will trigger one GNSS measurement.
 * Another GNSS measurement will be triggered after {@link #PASSIVE_INTERVAL} and so on.
 *
 * @see android.location.GnssMeasurementRequest#getIntervalMillis()
 */

public static final int PASSIVE_INTERVAL = 2147483647; // 0x7fffffff
/** Builder for {@link android.location.GnssMeasurementRequest GnssMeasurementRequest} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Constructs a {@link android.location.GnssMeasurementRequest.Builder Builder} instance.
 */

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Constructs a {@link android.location.GnssMeasurementRequest.Builder Builder} instance by copying a {@link android.location.GnssMeasurementRequest GnssMeasurementRequest}.

 * @param request This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.location.GnssMeasurementRequest request) { throw new RuntimeException("Stub!"); }

/**
 * Set the value of whether to enable full GNSS tracking, which is false by default.
 *
 * <p>If true, GNSS chipset switches off duty cycling. In such a mode, no clock
 * discontinuities are expected, and when supported, carrier phase should be continuous in
 * good signal conditions. All non-blocklisted, healthy constellations, satellites and
 * frequency bands that the chipset supports must be reported in this mode. The GNSS chipset
 * will consume more power in full tracking mode than in duty cycling mode. If false,
 * GNSS chipset optimizes power via duty cycling, constellations and frequency limits, etc.
 *
 * <p>Full GNSS tracking mode affects GnssMeasurement and other GNSS functionalities
 * including GNSS location.
 *
 * <p>Full tracking requests always override non-full tracking requests. If any full
 * tracking request occurs, all listeners on the device will receive full tracking GNSS
 * measurements.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssMeasurementRequest.Builder setFullTracking(boolean value) { throw new RuntimeException("Stub!"); }

/**
 * Set the time interval between the reported measurements in milliseconds, which is 0 by
 * default. The request interval may be set to {@link #PASSIVE_INTERVAL} which indicates
 * this request will not actively generate GNSS measurement updates, but may receive
 * GNSS measurement updates generated as a result of other GNSS measurement requests.
 *
 * <p>An interval of 0 milliseconds means the fastest rate the chipset can report.
 *
 * <p>The GNSS chipset may report measurements with a rate faster than requested.
 *
 * <p class="note">Note that on Android T, a request interval of {@link #PASSIVE_INTERVAL}
 * will first trigger one GNSS measurement. Another GNSS measurement will be triggered after
 * {@link #PASSIVE_INTERVAL} milliseconds and so on.
 
 * @param value Value is 0 or greater
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssMeasurementRequest.Builder setIntervalMillis(int value) { throw new RuntimeException("Stub!"); }

/**
 * Builds a {@link android.location.GnssMeasurementRequest GnssMeasurementRequest} instance as specified by this builder.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.location.GnssMeasurementRequest build() { throw new RuntimeException("Stub!"); }
}

}

