/* GENERATED SOURCE. DO NOT MODIFY. */
// © 2022 and later: Unicode, Inc. and others.
// License & terms of use: http://www.unicode.org/copyright.html


package android.icu.text;

import java.util.List;

/**
 * Represents all the display options that are supported by CLDR such as grammatical case, noun
 * class, ... etc. It currently supports enums, but may be extended in the future to have other
 * types of data. It replaces a DisplayContext[] as a method parameter.
 * <p>
 * NOTE: This class is Immutable, and uses a Builder interface.
 * <p>For example:
 * {@code DisplayOptions x =
 *                DisplayOptions.builder()
 *                             .setNounClass(NounClass.DATIVE)
 *                             .setPluralCategory(PluralCategory.FEW)
 *                             .build();
 *                             }
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class DisplayOptions {

DisplayOptions() { throw new RuntimeException("Stub!"); }

/**
 * Creates a builder with the {@code UNDEFINED} value for all the parameters.
 *
 * @return Builder
 */

public static android.icu.text.DisplayOptions.Builder builder() { throw new RuntimeException("Stub!"); }

/**
 * Creates a builder with the same parameters from this object.
 *
 * @return Builder
 */

public android.icu.text.DisplayOptions.Builder copyToBuilder() { throw new RuntimeException("Stub!"); }

/**
 * Gets the grammatical case.
 *
 * @return GrammaticalCase
 */

public android.icu.text.DisplayOptions.GrammaticalCase getGrammaticalCase() { throw new RuntimeException("Stub!"); }

/**
 * Gets the noun class.
 *
 * @return NounClass
 */

public android.icu.text.DisplayOptions.NounClass getNounClass() { throw new RuntimeException("Stub!"); }

/**
 * Gets the plural category.
 *
 * @return PluralCategory
 */

public android.icu.text.DisplayOptions.PluralCategory getPluralCategory() { throw new RuntimeException("Stub!"); }

/**
 * Gets the capitalization.
 *
 * @return Capitalization
 */

public android.icu.text.DisplayOptions.Capitalization getCapitalization() { throw new RuntimeException("Stub!"); }

/**
 * Gets the name style.
 *
 * @return NameStyle
 */

public android.icu.text.DisplayOptions.NameStyle getNameStyle() { throw new RuntimeException("Stub!"); }

/**
 * Gets the display length.
 *
 * @return DisplayLength
 */

public android.icu.text.DisplayOptions.DisplayLength getDisplayLength() { throw new RuntimeException("Stub!"); }

/**
 * Gets the substitute handling.
 *
 * @return SubstituteHandling
 */

public android.icu.text.DisplayOptions.SubstituteHandling getSubstituteHandling() { throw new RuntimeException("Stub!"); }
/**
 * Responsible for building {@code DisplayOptions}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class Builder {

Builder() { throw new RuntimeException("Stub!"); }

/**
 * Sets the grammatical case.
 *
 * @param grammaticalCase The grammatical case.
 * @return Builder
 */

public android.icu.text.DisplayOptions.Builder setGrammaticalCase(android.icu.text.DisplayOptions.GrammaticalCase grammaticalCase) { throw new RuntimeException("Stub!"); }

/**
 * Sets the noun class.
 *
 * @param nounClass The noun class.
 * @return Builder
 */

public android.icu.text.DisplayOptions.Builder setNounClass(android.icu.text.DisplayOptions.NounClass nounClass) { throw new RuntimeException("Stub!"); }

/**
 * Sets the plural category.
 *
 * @param pluralCategory The plural category.
 * @return Builder
 */

public android.icu.text.DisplayOptions.Builder setPluralCategory(android.icu.text.DisplayOptions.PluralCategory pluralCategory) { throw new RuntimeException("Stub!"); }

/**
 * Sets the capitalization.
 *
 * @param capitalization The capitalization.
 * @return Builder
 */

public android.icu.text.DisplayOptions.Builder setCapitalization(android.icu.text.DisplayOptions.Capitalization capitalization) { throw new RuntimeException("Stub!"); }

/**
 * Sets the name style.
 *
 * @param nameStyle The name style.
 * @return Builder
 */

public android.icu.text.DisplayOptions.Builder setNameStyle(android.icu.text.DisplayOptions.NameStyle nameStyle) { throw new RuntimeException("Stub!"); }

/**
 * Sets the display length.
 *
 * @param displayLength The display length.
 * @return Builder
 */

public android.icu.text.DisplayOptions.Builder setDisplayLength(android.icu.text.DisplayOptions.DisplayLength displayLength) { throw new RuntimeException("Stub!"); }

/**
 * Sets the substitute handling.
 *
 * @param substituteHandling The substitute handling.
 * @return Builder
 */

public android.icu.text.DisplayOptions.Builder setSubstituteHandling(android.icu.text.DisplayOptions.SubstituteHandling substituteHandling) { throw new RuntimeException("Stub!"); }

/**
 * Builds the display options.
 *
 * @return DisplayOptions
 */

public android.icu.text.DisplayOptions build() { throw new RuntimeException("Stub!"); }
}

/**
 * Represents all the capitalization options.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public enum Capitalization {
/**
 * A possible setting for Capitalization. The capitalization context to be used is unknown (this
 * is the default value).
 */

UNDEFINED,
/**
 * The capitalization context if a date, date symbol or display name is to be formatted with
 * capitalization appropriate for the beginning of a sentence.
 */

BEGINNING_OF_SENTENCE,
/**
 * The capitalization context if a date, date symbol or display name is to be formatted with
 * capitalization appropriate for the middle of a sentence.
 */

MIDDLE_OF_SENTENCE,
/**
 * The capitalization context if a date, date symbol or display name is to be formatted with
 * capitalization appropriate for stand-alone usage such as an isolated name on a calendar
 * page.
 */

STANDALONE,
/**
 * The capitalization context if a date, date symbol or display name is to be formatted with
 * capitalization appropriate for a user-interface list or menu item.
 */

UI_LIST_OR_MENU;

/**
 * Unmodifiable List of all the capitalizations constants. List version of {@link #values()}.
 */

public static final java.util.List<android.icu.text.DisplayOptions.Capitalization> VALUES = null;
}

/**
 * Represents all the display lengths.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public enum DisplayLength {
/**
 * A possible setting for DisplayLength. The DisplayLength context to be used is unknown (this
 * is the default value).
 */

UNDEFINED,
/**
 * Uses full names when generating a locale name, e.g. "United States" for US.
 */

LENGTH_FULL,
/**
 * Use short names when generating a locale name, e.g. "U.S." for US.
 */

LENGTH_SHORT;

/**
 * Unmodifiable List of all display lengths constants. List version of {@link #values()}.
 */

public static final java.util.List<android.icu.text.DisplayOptions.DisplayLength> VALUES = null;
}

/**
 * Represents all the grammatical cases that are supported by CLDR.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public enum GrammaticalCase {
/**
 * A possible setting for GrammaticalCase. The grammatical case context to be used is unknown
 * (this is the default value).
 */

UNDEFINED,
/**
 */

ABLATIVE,
/**
 */

ACCUSATIVE,
/**
 */

COMITATIVE,
/**
 */

DATIVE,
/**
 */

ERGATIVE,
/**
 */

GENITIVE,
/**
 */

INSTRUMENTAL,
/**
 */

LOCATIVE,
/**
 */

LOCATIVE_COPULATIVE,
/**
 */

NOMINATIVE,
/**
 */

OBLIQUE,
/**
 */

PREPOSITIONAL,
/**
 */

SOCIATIVE,
/**
 */

VOCATIVE;

/**
 * @return the lowercase CLDR keyword string for the grammatical case.
 */

public java.lang.String getIdentifier() { throw new RuntimeException("Stub!"); }

/**
 * @param identifier in lower case such as "dative" or "nominative"
 * @return the plural category corresponding to the identifier, or {@code UNDEFINED}
 */

public static android.icu.text.DisplayOptions.GrammaticalCase fromIdentifier(java.lang.String identifier) { throw new RuntimeException("Stub!"); }

/**
 * Unmodifiable List of all grammatical cases constants. List version of {@link #values()}.
 */

public static final java.util.List<android.icu.text.DisplayOptions.GrammaticalCase> VALUES = null;
}

/**
 * Represents all the name styles.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public enum NameStyle {
/**
 * A possible setting for NameStyle. The NameStyle context to be used is unknown (this is the
 * default value).
 */

UNDEFINED,
/**
 * Use standard names when generating a locale name, e.g. en_GB displays as 'English (United
 * Kingdom)'.
 */

STANDARD_NAMES,
/**
 * Use dialect names, when generating a locale name, e.g. en_GB displays as 'British English'.
 */

DIALECT_NAMES;

/**
 * Unmodifiable List of all name styles constants. List version of {@link #values()}.
 */

public static final java.util.List<android.icu.text.DisplayOptions.NameStyle> VALUES = null;
}

/**
 * Represents all the grammatical noun classes that are supported by CLDR.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public enum NounClass {
/**
 * A possible setting for NounClass. The noun class context to be used is unknown (this is the
 * default value).
 */

UNDEFINED,
/**
 */

OTHER,
/**
 */

NEUTER,
/**
 */

FEMININE,
/**
 */

MASCULINE,
/**
 */

ANIMATE,
/**
 */

INANIMATE,
/**
 */

PERSONAL,
/**
 */

COMMON;

/**
 * @return the lowercase CLDR keyword string for the noun class.
 */

public java.lang.String getIdentifier() { throw new RuntimeException("Stub!"); }

/**
 * @param identifier in lower case such as "feminine" or "masculine"
 * @return the plural category corresponding to the identifier, or {@code UNDEFINED}
 */

public static android.icu.text.DisplayOptions.NounClass fromIdentifier(java.lang.String identifier) { throw new RuntimeException("Stub!"); }

/**
 * Unmodifiable List of all noun classes constants. List version of {@link #values()}.
 */

public static final java.util.List<android.icu.text.DisplayOptions.NounClass> VALUES = null;
}

/**
 * Standard CLDR plural category constants. See http://www.unicode.org/reports/tr35/tr35-numbers.html#Language_Plural_Rules
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public enum PluralCategory {
/**
 * A possible setting for PluralCategory. The plural category context to be used is unknown
 * (this is the default value).
 */

UNDEFINED,
/**
 */

ZERO,
/**
 */

ONE,
/**
 */

TWO,
/**
 */

FEW,
/**
 */

MANY,
/**
 */

OTHER;

/**
 * @return the lowercase CLDR keyword string for the plural category
 */

public java.lang.String getIdentifier() { throw new RuntimeException("Stub!"); }

/**
 * @param identifier in lower case such as "few" or "other"
 * @return the plural category corresponding to the identifier, or {@code UNDEFINED}
 */

public static android.icu.text.DisplayOptions.PluralCategory fromIdentifier(java.lang.String identifier) { throw new RuntimeException("Stub!"); }

/**
 * Unmodifiable List of all plural categories constants. List version of {@link #values()}.
 */

public static final java.util.List<android.icu.text.DisplayOptions.PluralCategory> VALUES = null;
}

/**
 * Represents all the substitute handlings.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public enum SubstituteHandling {
/**
 * A possible setting for SubstituteHandling. The SubstituteHandling context to be used is
 * unknown (this is the default value).
 */

UNDEFINED,
/**
 * Returns a fallback value (e.g., the input code) when no data is available. This is the
 * default behaviour.
 */

SUBSTITUTE,
/**
 * Returns a null value when no data is available.
 */

NO_SUBSTITUTE;

/**
 * Unmodifiable List of all substitute handlings constants. List version of {@link #values()}.
 */

public static final java.util.List<android.icu.text.DisplayOptions.SubstituteHandling> VALUES = null;
}

}

