/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.health.connect.datatypes;

import android.health.connect.HealthConnectManager;
import android.health.connect.datatypes.units.Temperature;
import android.health.connect.datatypes.units.TemperatureDelta;

/**
 * Captures the skin temperature of a user. Each record can represent a series of measurements of
 * temperature differences.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class SkinTemperatureRecord extends android.health.connect.datatypes.IntervalRecord {

SkinTemperatureRecord() { throw new RuntimeException("Stub!"); }

/**
 * @return baseline skin temperature in {@link android.health.connect.datatypes.units.Temperature Temperature} unit.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.health.connect.datatypes.units.Temperature getBaseline() { throw new RuntimeException("Stub!"); }

/**
 * @return an unmodified list of skin temperature deltas in {@link android.health.connect.datatypes.units.TemperatureDelta TemperatureDelta} unit.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.health.connect.datatypes.SkinTemperatureRecord.Delta> getDeltas() { throw new RuntimeException("Stub!"); }

/**
 * @return measurementLocation

 * Value is {@link android.health.connect.datatypes.SkinTemperatureRecord#MEASUREMENT_LOCATION_UNKNOWN}, {@link android.health.connect.datatypes.SkinTemperatureRecord#MEASUREMENT_LOCATION_FINGER}, {@link android.health.connect.datatypes.SkinTemperatureRecord#MEASUREMENT_LOCATION_TOE}, or {@link android.health.connect.datatypes.SkinTemperatureRecord#MEASUREMENT_LOCATION_WRIST}
 */

public int getMeasurementLocation() { throw new RuntimeException("Stub!"); }

/**
 * Indicates whether some other object is "equal to" this one.
 *
 * @param object the reference object with which to compare.
 * This value may be {@code null}.
 * @return {@code true} if this object is the same as the object.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object object) { throw new RuntimeException("Stub!"); }

/**
 * @return a hash code value for the object.
 */

public int hashCode() { throw new RuntimeException("Stub!"); }

/** Skin temperature measurement location finger. */

public static final int MEASUREMENT_LOCATION_FINGER = 1; // 0x1

/** Skin temperature measurement location toe. */

public static final int MEASUREMENT_LOCATION_TOE = 2; // 0x2

/** Skin temperature measurement location unknown. */

public static final int MEASUREMENT_LOCATION_UNKNOWN = 0; // 0x0

/** Skin temperature measurement location wrist. */

public static final int MEASUREMENT_LOCATION_WRIST = 3; // 0x3

/**
 * Metric identifier to retrieve average skin temperature delta using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}.
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.TemperatureDelta> SKIN_TEMPERATURE_DELTA_AVG;
static { SKIN_TEMPERATURE_DELTA_AVG = null; }

/**
 * Metric identifier to retrieve maximum skin temperature delta using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}.
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.TemperatureDelta> SKIN_TEMPERATURE_DELTA_MAX;
static { SKIN_TEMPERATURE_DELTA_MAX = null; }

/**
 * Metric identifier to retrieve minimum skin temperature delta using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}.
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.TemperatureDelta> SKIN_TEMPERATURE_DELTA_MIN;
static { SKIN_TEMPERATURE_DELTA_MIN = null; }
/** Builder class for {@link android.health.connect.datatypes.SkinTemperatureRecord SkinTemperatureRecord} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * @param metadata Metadata Metadata to be associated with the record. See {@link android.health.connect.datatypes.Metadata Metadata}.
 * This value cannot be {@code null}.
 * @param startTime Start time of this activity.
 * This value cannot be {@code null}.
 * @param endTime End time of this activity.

 * This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.health.connect.datatypes.Metadata metadata, @android.annotation.NonNull java.time.Instant startTime, @android.annotation.NonNull java.time.Instant endTime) { throw new RuntimeException("Stub!"); }

/**
 * Sets the zone offset of the user when the activity started.
 * @param startZoneOffset This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.SkinTemperatureRecord.Builder setStartZoneOffset(@android.annotation.NonNull java.time.ZoneOffset startZoneOffset) { throw new RuntimeException("Stub!"); }

/**
 * Sets the zone offset of the user when the activity ended.
 * @param endZoneOffset This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.SkinTemperatureRecord.Builder setEndZoneOffset(@android.annotation.NonNull java.time.ZoneOffset endZoneOffset) { throw new RuntimeException("Stub!"); }

/**
 * Clears the zone offset of the user when the activity started.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.SkinTemperatureRecord.Builder clearStartZoneOffset() { throw new RuntimeException("Stub!"); }

/**
 * Clears the zone offset of the user when the activity ended.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.SkinTemperatureRecord.Builder clearEndZoneOffset() { throw new RuntimeException("Stub!"); }

/**
 * Sets the baseline skin temperature for the user.
 * @param baseline This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.SkinTemperatureRecord.Builder setBaseline(@android.annotation.Nullable android.health.connect.datatypes.units.Temperature baseline) { throw new RuntimeException("Stub!"); }

/**
 * Sets a list of skin temperature deltas.
 * @param deltas This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.SkinTemperatureRecord.Builder setDeltas(@android.annotation.NonNull java.util.List<android.health.connect.datatypes.SkinTemperatureRecord.Delta> deltas) { throw new RuntimeException("Stub!"); }

/**
 * Sets the measurement location of the skin temperature.
 * @param measurementLocation Value is {@link android.health.connect.datatypes.SkinTemperatureRecord#MEASUREMENT_LOCATION_UNKNOWN}, {@link android.health.connect.datatypes.SkinTemperatureRecord#MEASUREMENT_LOCATION_FINGER}, {@link android.health.connect.datatypes.SkinTemperatureRecord#MEASUREMENT_LOCATION_TOE}, or {@link android.health.connect.datatypes.SkinTemperatureRecord#MEASUREMENT_LOCATION_WRIST}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.SkinTemperatureRecord.Builder setMeasurementLocation(int measurementLocation) { throw new RuntimeException("Stub!"); }

/**
 * @return Object of {@link android.health.connect.datatypes.SkinTemperatureRecord SkinTemperatureRecord}.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.SkinTemperatureRecord build() { throw new RuntimeException("Stub!"); }
}

/** Skin temperature delta entry of {@link android.health.connect.datatypes.SkinTemperatureRecord SkinTemperatureRecord}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Delta {

/**
 * Skin temperature delta entry of {@link android.health.connect.datatypes.SkinTemperatureRecord SkinTemperatureRecord}.
 *
 * @param delta Temperature difference.
 * This value cannot be {@code null}.
 * @param time The point in time when the measurement was taken.

 * This value cannot be {@code null}.
 */

public Delta(@android.annotation.NonNull android.health.connect.datatypes.units.TemperatureDelta delta, @android.annotation.NonNull java.time.Instant time) { throw new RuntimeException("Stub!"); }

/**
 * @return delta of the skin temperature.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.units.TemperatureDelta getDelta() { throw new RuntimeException("Stub!"); }

/**
 * @return time at which this measurement was recorded.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.time.Instant getTime() { throw new RuntimeException("Stub!"); }

/**
 * Indicates whether some other object is "equal to" this one.
 *
 * @param object the reference object with which to compare.
 * This value may be {@code null}.
 * @return {@code true} if this object is the same as the object.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object object) { throw new RuntimeException("Stub!"); }

/**
 * @return a hash code value for the object.
 */

public int hashCode() { throw new RuntimeException("Stub!"); }
}

}

