/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.health.connect.datatypes;

import android.health.connect.HealthConnectManager;
import android.health.connect.datatypes.units.Power;

/** Captures the power generated by the user, e.g.&nbsp;during cycling or rowing with a power meter. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class PowerRecord extends android.health.connect.datatypes.IntervalRecord {

PowerRecord() { throw new RuntimeException("Stub!"); }

/**
 * @return PowerRecord samples corresponding to this record

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.health.connect.datatypes.PowerRecord.PowerRecordSample> getSamples() { throw new RuntimeException("Stub!"); }

/**
 * Indicates whether some other object is "equal to" this one.
 *
 * @param object the reference object with which to compare.
 * This value may be {@code null}.
 * @return {@code true} if this object is the same as the obj
 */

public boolean equals(@android.annotation.Nullable java.lang.Object object) { throw new RuntimeException("Stub!"); }

/** Returns a hash code value for the object. */

public int hashCode() { throw new RuntimeException("Stub!"); }

/** Metric identifier to get avg power using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager} */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Power> POWER_AVG;
static { POWER_AVG = null; }

/** Metric identifier to get max power using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager} */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Power> POWER_MAX;
static { POWER_MAX = null; }

/** Metric identifier to get min power using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager} */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Power> POWER_MIN;
static { POWER_MIN = null; }
/** Builder class for {@link android.health.connect.datatypes.PowerRecord PowerRecord} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * @param metadata Metadata to be associated with the record. See {@link android.health.connect.datatypes.Metadata Metadata}.
 * This value cannot be {@code null}.
 * @param startTime Start time of this activity
 * This value cannot be {@code null}.
 * @param endTime End time of this activity
 * This value cannot be {@code null}.
 * @param powerRecordSamples Samples of recorded PowerRecord

 * This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.health.connect.datatypes.Metadata metadata, @android.annotation.NonNull java.time.Instant startTime, @android.annotation.NonNull java.time.Instant endTime, @android.annotation.NonNull java.util.List<android.health.connect.datatypes.PowerRecord.PowerRecordSample> powerRecordSamples) { throw new RuntimeException("Stub!"); }

/**
 * Sets the zone offset of the user when the activity started
 * @param startZoneOffset This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.PowerRecord.Builder setStartZoneOffset(@android.annotation.NonNull java.time.ZoneOffset startZoneOffset) { throw new RuntimeException("Stub!"); }

/**
 * Sets the zone offset of the user when the activity ended
 * @param endZoneOffset This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.PowerRecord.Builder setEndZoneOffset(@android.annotation.NonNull java.time.ZoneOffset endZoneOffset) { throw new RuntimeException("Stub!"); }

/**
 * Sets the start zone offset of this record to system default.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.PowerRecord.Builder clearStartZoneOffset() { throw new RuntimeException("Stub!"); }

/**
 * Sets the start zone offset of this record to system default.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.PowerRecord.Builder clearEndZoneOffset() { throw new RuntimeException("Stub!"); }

/**
 * @return Object of {@link android.health.connect.datatypes.PowerRecord PowerRecord}

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.PowerRecord build() { throw new RuntimeException("Stub!"); }
}

/**
 * Represents a single measurement of power. For example, using a power meter when exercising on
 * a stationary bike.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class PowerRecordSample {

/**
 * PowerRecord sample for entries of {@link android.health.connect.datatypes.PowerRecord PowerRecord}
 *
 * @param power Power generated, in {@link android.health.connect.datatypes.units.Power Power} unit.
 * This value cannot be {@code null}.
 * @param time The point in time when the measurement was taken.

 * This value cannot be {@code null}.
 */

public PowerRecordSample(@android.annotation.NonNull android.health.connect.datatypes.units.Power power, @android.annotation.NonNull java.time.Instant time) { throw new RuntimeException("Stub!"); }

/**
 * @return Power for this sample

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.units.Power getPower() { throw new RuntimeException("Stub!"); }

/**
 * @return time at which this sample was recorded

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.time.Instant getTime() { throw new RuntimeException("Stub!"); }

/**
 * Indicates whether some other object is "equal to" this one.
 *
 * @param object the reference object with which to compare.
 * @return {@code true} if this object is the same as the obj
 */

public boolean equals(java.lang.Object object) { throw new RuntimeException("Stub!"); }

/**
 * Returns a hash code value for the object.
 *
 * @return a hash code value for this object.
 */

public int hashCode() { throw new RuntimeException("Stub!"); }
}

}

