/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.health.connect.datatypes;

import android.health.connect.HealthConnectManager;

/** Captures the user's heart rate. Each record represents a series of measurements. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class HeartRateRecord extends android.health.connect.datatypes.IntervalRecord {

HeartRateRecord() { throw new RuntimeException("Stub!"); }

/**
 * @return heart rate samples corresponding to this record

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.health.connect.datatypes.HeartRateRecord.HeartRateSample> getSamples() { throw new RuntimeException("Stub!"); }

/**
 * Indicates whether some other object is "equal to" this one.
 *
 * @param object the reference object with which to compare.
 * This value may be {@code null}.
 * @return {@code true} if this object is the same as the obj
 */

public boolean equals(@android.annotation.Nullable java.lang.Object object) { throw new RuntimeException("Stub!"); }

/** Returns a hash code value for the object. */

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * Metric identifier to get avg heart rate using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<java.lang.Long> BPM_AVG;
static { BPM_AVG = null; }

/**
 * Metric identifier to get max heart rate in beats per minute using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<java.lang.Long> BPM_MAX;
static { BPM_MAX = null; }

/**
 * Metric identifier to get min heart rate in beats per minute using aggregate APIs in {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<java.lang.Long> BPM_MIN;
static { BPM_MIN = null; }

/**
 * Metric identifier to retrieve the number of heart rate measurements using aggregate APIs in
 * {@link android.health.connect.HealthConnectManager HealthConnectManager}
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<java.lang.Long> HEART_MEASUREMENTS_COUNT;
static { HEART_MEASUREMENTS_COUNT = null; }
/**
 * Builder class for {@link android.health.connect.datatypes.HeartRateRecord HeartRateRecord}
 *
 * @see android.health.connect.datatypes.HeartRateRecord
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * @param metadata Metadata to be associated with the record. See {@link android.health.connect.datatypes.Metadata Metadata}.
 * This value cannot be {@code null}.
 * @param startTime Start time of this activity
 * This value cannot be {@code null}.
 * @param endTime End time of this activity
 * This value cannot be {@code null}.
 * @param heartRateSamples Samples of recorded heart rate
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException if {@code heartRateSamples} is empty
 */

public Builder(@android.annotation.NonNull android.health.connect.datatypes.Metadata metadata, @android.annotation.NonNull java.time.Instant startTime, @android.annotation.NonNull java.time.Instant endTime, @android.annotation.NonNull java.util.List<android.health.connect.datatypes.HeartRateRecord.HeartRateSample> heartRateSamples) { throw new RuntimeException("Stub!"); }

/**
 * Sets the zone offset of the user when the activity started. By default, the starting zone
 * offset is set the current zone offset.
 
 * @param startZoneOffset This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.HeartRateRecord.Builder setStartZoneOffset(@android.annotation.NonNull java.time.ZoneOffset startZoneOffset) { throw new RuntimeException("Stub!"); }

/**
 * Sets the zone offset of the user when the activity ended. By default, the end zone offset
 * is set the current zone offset.
 
 * @param endZoneOffset This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.HeartRateRecord.Builder setEndZoneOffset(@android.annotation.NonNull java.time.ZoneOffset endZoneOffset) { throw new RuntimeException("Stub!"); }

/**
 * Sets the start zone offset of this record to system default.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.HeartRateRecord.Builder clearStartZoneOffset() { throw new RuntimeException("Stub!"); }

/**
 * Sets the start zone offset of this record to system default.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.HeartRateRecord.Builder clearEndZoneOffset() { throw new RuntimeException("Stub!"); }

/**
 * @return Object of {@link android.health.connect.datatypes.HeartRateRecord HeartRateRecord}

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.HeartRateRecord build() { throw new RuntimeException("Stub!"); }
}

/** A class to represent heart rate samples */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class HeartRateSample {

/**
 * Heart rate sample for entries of {@link android.health.connect.datatypes.HeartRateRecord HeartRateRecord}
 *
 * @param beatsPerMinute Heart beats per minute.
 * @param time The point in time when the measurement was taken.

 * This value cannot be {@code null}.
 */

public HeartRateSample(long beatsPerMinute, @android.annotation.NonNull java.time.Instant time) { throw new RuntimeException("Stub!"); }

/**
 * @return beats per minute for this sample
 */

public long getBeatsPerMinute() { throw new RuntimeException("Stub!"); }

/**
 * @return time at which this sample was recorded

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.time.Instant getTime() { throw new RuntimeException("Stub!"); }

/**
 * Indicates whether some other object is "equal to" this one.
 *
 * @param object the reference object with which to compare.
 * This value may be {@code null}.
 * @return {@code true} if this object is the same as the obj
 */

public boolean equals(@android.annotation.Nullable java.lang.Object object) { throw new RuntimeException("Stub!"); }

/**
 * Returns a hash code value for the object.
 *
 * @return a hash code value for this object.
 */

public int hashCode() { throw new RuntimeException("Stub!"); }
}

}

