/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.health.connect.datatypes;


/** A goal which should be aimed for during a {@link android.health.connect.datatypes.PlannedExerciseStep PlannedExerciseStep}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class ExercisePerformanceGoal {

ExercisePerformanceGoal() { throw new RuntimeException("Stub!"); }
/**
 * An {@link android.health.connect.datatypes.ExercisePerformanceGoal ExercisePerformanceGoal} that requires completing as many repetitions as possible.
 * AMRAP (as many reps as possible) sets are often used in conjunction with a duration based
 * completion goal.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class AmrapGoal extends android.health.connect.datatypes.ExercisePerformanceGoal {

AmrapGoal() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.health.connect.datatypes.ExercisePerformanceGoal.AmrapGoal INSTANCE;
static { INSTANCE = null; }
}

/**
 * An {@link android.health.connect.datatypes.ExercisePerformanceGoal ExercisePerformanceGoal} that requires a target cadence range to be met during the
 * associated {@link android.health.connect.datatypes.PlannedExerciseStep PlannedExerciseStep}. The value may be interpreted as RPM for e.g. cycling
 * activities, or as steps per minute for e.g. walking/running activities.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class CadenceGoal extends android.health.connect.datatypes.ExercisePerformanceGoal {

/**
 * @param minRpm Minimum cadence level, in RPM, that should be reached.
 * @param maxRpm Maximum cadence level, in RPM, that should be reached.
 */

public CadenceGoal(double minRpm, double maxRpm) { throw new RuntimeException("Stub!"); }

/**
 * @return Minimum cadence level, in RPM, that should be reached.
 */

public double getMinRpm() { throw new RuntimeException("Stub!"); }

/**
 * @return Maximum cadence level, in RPM, that should be reached.
 */

public double getMaxRpm() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }
}

/**
 * An {@link android.health.connect.datatypes.ExercisePerformanceGoal ExercisePerformanceGoal} that requires a target heart rate range, in BPM, to be met
 * during the associated {@link android.health.connect.datatypes.PlannedExerciseStep PlannedExerciseStep}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class HeartRateGoal extends android.health.connect.datatypes.ExercisePerformanceGoal {

/**
 * @param minBpm Minimum heart rate, in BPM, that should be reached.
 * @param maxBpm Maximum heart rate, in BPM, that should be reached.
 */

public HeartRateGoal(int minBpm, int maxBpm) { throw new RuntimeException("Stub!"); }

/**
 * @return Minimum heart rate, in BPM, that should be reached.
 */

public int getMinBpm() { throw new RuntimeException("Stub!"); }

/**
 * @return Maximum heart rate, in BPM, that should be reached.
 */

public int getMaxBpm() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }
}

/**
 * An {@link android.health.connect.datatypes.ExercisePerformanceGoal ExercisePerformanceGoal} that requires a target power range to be met during the
 * associated {@link android.health.connect.datatypes.PlannedExerciseStep PlannedExerciseStep}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class PowerGoal extends android.health.connect.datatypes.ExercisePerformanceGoal {

/**
 * @param minPower Minimum power level that should be reached.
 * This value cannot be {@code null}.
 * @param maxPower Maximum power level that should be reached.

 * This value cannot be {@code null}.
 */

public PowerGoal(@android.annotation.NonNull android.health.connect.datatypes.units.Power minPower, @android.annotation.NonNull android.health.connect.datatypes.units.Power maxPower) { throw new RuntimeException("Stub!"); }

/**
 * @return Minimum power level that should be reached.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.units.Power getMinPower() { throw new RuntimeException("Stub!"); }

/**
 * @return Maximum power level that should be reached.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.units.Power getMaxPower() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }
}

/**
 * An {@link android.health.connect.datatypes.ExercisePerformanceGoal ExercisePerformanceGoal} that requires a target RPE (rate of perceived exertion) to
 * be met during the associated {@link android.health.connect.datatypes.PlannedExerciseStep PlannedExerciseStep}.
 *
 * <p>Values correspond to the Borg CR10 RPE scale and must be in the range 0 to 10 inclusive.
 * 0: No exertion (at rest) 1: Very light 2-3: Light 4-5: Moderate 6-7: Hard 8-9: Very hard 10:
 * Maximum effort
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class RateOfPerceivedExertionGoal extends android.health.connect.datatypes.ExercisePerformanceGoal {

/**
 * @param rpe Target RPE that should be met.
 */

public RateOfPerceivedExertionGoal(int rpe) { throw new RuntimeException("Stub!"); }

/**
 * @return Target RPE that should be met.
 */

public int getRpe() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }
}

/**
 * An {@link android.health.connect.datatypes.ExercisePerformanceGoal ExercisePerformanceGoal} that requires a target speed range to be met during the
 * associated {@link android.health.connect.datatypes.PlannedExerciseStep PlannedExerciseStep}. This can be used to represent pace or speed goals.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class SpeedGoal extends android.health.connect.datatypes.ExercisePerformanceGoal {

/**
 * @param minSpeed Minimum speed that should be reached.
 * This value cannot be {@code null}.
 * @param maxSpeed Maximum speed that should be reached.

 * This value cannot be {@code null}.
 */

public SpeedGoal(@android.annotation.NonNull android.health.connect.datatypes.units.Velocity minSpeed, @android.annotation.NonNull android.health.connect.datatypes.units.Velocity maxSpeed) { throw new RuntimeException("Stub!"); }

/**
 * @return Minimum speed that should be reached.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.units.Velocity getMinSpeed() { throw new RuntimeException("Stub!"); }

/**
 * @return Maximum speed that should be reached.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.units.Velocity getMaxSpeed() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }
}

/** An {@link android.health.connect.datatypes.ExercisePerformanceGoal ExercisePerformanceGoal} that is unknown. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class UnknownGoal extends android.health.connect.datatypes.ExercisePerformanceGoal {

UnknownGoal() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.health.connect.datatypes.ExercisePerformanceGoal.UnknownGoal INSTANCE;
static { INSTANCE = null; }
}

/**
 * An {@link android.health.connect.datatypes.ExercisePerformanceGoal ExercisePerformanceGoal} that requires a target weight to be lifted during the
 * associated {@link android.health.connect.datatypes.PlannedExerciseStep PlannedExerciseStep}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class WeightGoal extends android.health.connect.datatypes.ExercisePerformanceGoal {

/**
 * @param mass Target weight that should be lifted.

 * This value cannot be {@code null}.
 */

public WeightGoal(@android.annotation.NonNull android.health.connect.datatypes.units.Mass mass) { throw new RuntimeException("Stub!"); }

/**
 * @return Target weight that should be lifted.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.units.Mass getMass() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }
}

}

