/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.health.connect.changelog;

import android.health.connect.HealthConnectManager;

/** Request class for {@link android.health.connect.HealthConnectManager#getChangeLogs HealthConnectManager#getChangeLogs} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class ChangeLogsRequest implements android.os.Parcelable {

ChangeLogsRequest() { throw new RuntimeException("Stub!"); }

/**
 * Returns the token for the change logs request
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getToken() { throw new RuntimeException("Stub!"); }

/**
 * Returns the maximum number of records requested using {@link android.health.connect.HealthConnectManager#getChangeLogs  } operation

 * @return Value is between 1 and 5000 inclusive
 */

public int getPageSize() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.health.connect.changelog.ChangeLogsRequest> CREATOR;
static { CREATOR = null; }
/** Builder class for {@link android.health.connect.changelog.ChangeLogsRequest ChangeLogsRequest} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * @param token This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull java.lang.String token) { throw new RuntimeException("Stub!"); }

/**
 * @param pageSize number of change logs to be returned, this corresponds to the maximum
 *     number of entries to be returned i.e. sum of the response within {@link android.health.connect.changelog.ChangeLogsResponse ChangeLogsResponse}
 *     <p>If not set default is 1000 and maximum value is 5000.
 * Value is between 1 and 5000 inclusive
 * @throws java.lang.IllegalArgumentException if requested pageSize > 5000 or < 1
 
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.changelog.ChangeLogsRequest.Builder setPageSize(int pageSize) { throw new RuntimeException("Stub!"); }

/**
 * Returns Object of {@link android.health.connect.changelog.ChangeLogsRequest ChangeLogsRequest}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.changelog.ChangeLogsRequest build() { throw new RuntimeException("Stub!"); }
}

}

