/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.graphics.pdf.models.selection;


/**
 * <p>
 * Represents the list of selected content on a particular page of the PDF document. By
 * default, the selection boundary is represented from left to right.
 * <strong>Note: </strong>Currently supports text selection only.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class PageSelection implements android.os.Parcelable {

/**
 * Creates a new instance of {@link android.graphics.pdf.models.selection.PageSelection PageSelection} for the specified page, the start and stop
 * selection boundary, and the selected text content.
 *
 * @param page             The page number of the selection.
 * @param start            Boundary where the selection starts.
 * This value cannot be {@code null}.
 * @param stop             Boundary where the selection stops.
 * This value cannot be {@code null}.
 * @param selectedContents list of segments of selected text content.
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException If the page number is negative.
 * @throws java.lang.NullPointerException     If start/stop edge or text selection is null.
 */

public PageSelection(int page, @android.annotation.NonNull android.graphics.pdf.models.selection.SelectionBoundary start, @android.annotation.NonNull android.graphics.pdf.models.selection.SelectionBoundary stop, @android.annotation.NonNull java.util.List<android.graphics.pdf.content.PdfPageTextContent> selectedContents) { throw new RuntimeException("Stub!"); }

/**
 * Gets the particular page for which the selection is highlighted.
 *
 * @return The page number on which the current selection resides.
 */

public int getPage() { throw new RuntimeException("Stub!"); }

/**
 * <p>
 * Gets the edge from where the selection starts- index is inclusive.
 *
 * @return The starting edge of the selection.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.graphics.pdf.models.selection.SelectionBoundary getStart() { throw new RuntimeException("Stub!"); }

/**
 * <p>
 * Gets the edge where the selection stops - index is inclusive.
 *
 * @return The stopping edge of the selection.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.graphics.pdf.models.selection.SelectionBoundary getStop() { throw new RuntimeException("Stub!"); }

/**
 * Returns the text content within the selection boundaries on the page. In case there are
 * non-continuous selections, this method returns the list of those text content in order of
 * viewing.
 *
 * @return list of text contents within the selection boundaries.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.graphics.pdf.content.PdfPageTextContent> getSelectedTextContents() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.graphics.pdf.models.selection.PageSelection> CREATOR;
static { CREATOR = null; }
}

