/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.graphics.pdf.models;


/** Represents a single option in a combo box or list box PDF form widget. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class ListItem implements android.os.Parcelable {

/**
 * Creates a new choice option with the specified label, and selected state.
 *
 * @param label    Label for choice option.
 * This value cannot be {@code null}.
 * @param selected Determines if the option is selected or not.
 * @throws java.lang.NullPointerException if {@code label} is null
 */

public ListItem(@android.annotation.NonNull java.lang.String label, boolean selected) { throw new RuntimeException("Stub!"); }

/**
 * @return the label for the choice option in the list
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getLabel() { throw new RuntimeException("Stub!"); }

/** @return {@code true} if the choice option is selected in the list */

public boolean isSelected() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object obj) { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.graphics.pdf.models.ListItem> CREATOR;
static { CREATOR = null; }
}

