/*
 * Copyright (C) 2006 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.database.sqlite;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class SQLiteDatabase extends android.database.sqlite.SQLiteClosable {

SQLiteDatabase() { throw new RuntimeException("Stub!"); }

protected void finalize() throws java.lang.Throwable { throw new RuntimeException("Stub!"); }

protected void onAllReferencesReleased() { throw new RuntimeException("Stub!"); }

public static int releaseMemory() { throw new RuntimeException("Stub!"); }

@Deprecated
public void setLockingEnabled(boolean lockingEnabled) { throw new RuntimeException("Stub!"); }

public void beginTransaction() { throw new RuntimeException("Stub!"); }

public void beginTransactionNonExclusive() { throw new RuntimeException("Stub!"); }

public void beginTransactionReadOnly() { throw new RuntimeException("Stub!"); }

public void beginTransactionWithListener(@android.annotation.Nullable android.database.sqlite.SQLiteTransactionListener transactionListener) { throw new RuntimeException("Stub!"); }

public void beginTransactionWithListenerNonExclusive(@android.annotation.Nullable android.database.sqlite.SQLiteTransactionListener transactionListener) { throw new RuntimeException("Stub!"); }

public void beginTransactionWithListenerReadOnly(@android.annotation.Nullable android.database.sqlite.SQLiteTransactionListener transactionListener) { throw new RuntimeException("Stub!"); }

public void endTransaction() { throw new RuntimeException("Stub!"); }

public void setTransactionSuccessful() { throw new RuntimeException("Stub!"); }

public boolean inTransaction() { throw new RuntimeException("Stub!"); }

public boolean isDbLockedByCurrentThread() { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean isDbLockedByOtherThreads() { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean yieldIfContended() { throw new RuntimeException("Stub!"); }

public boolean yieldIfContendedSafely() { throw new RuntimeException("Stub!"); }

public boolean yieldIfContendedSafely(long sleepAfterYieldDelay) { throw new RuntimeException("Stub!"); }

@Deprecated
public java.util.Map<java.lang.String,java.lang.String> getSyncedTables() { throw new RuntimeException("Stub!"); }

public static android.database.sqlite.SQLiteDatabase openDatabase(@android.annotation.NonNull java.lang.String path, @android.annotation.Nullable android.database.sqlite.SQLiteDatabase.CursorFactory factory, int flags) { throw new RuntimeException("Stub!"); }

public static android.database.sqlite.SQLiteDatabase openDatabase(@android.annotation.NonNull java.io.File path, @android.annotation.NonNull android.database.sqlite.SQLiteDatabase.OpenParams openParams) { throw new RuntimeException("Stub!"); }

public static android.database.sqlite.SQLiteDatabase openDatabase(@android.annotation.NonNull java.lang.String path, @android.annotation.Nullable android.database.sqlite.SQLiteDatabase.CursorFactory factory, int flags, @android.annotation.Nullable android.database.DatabaseErrorHandler errorHandler) { throw new RuntimeException("Stub!"); }

public static android.database.sqlite.SQLiteDatabase openOrCreateDatabase(@android.annotation.NonNull java.io.File file, @android.annotation.Nullable android.database.sqlite.SQLiteDatabase.CursorFactory factory) { throw new RuntimeException("Stub!"); }

public static android.database.sqlite.SQLiteDatabase openOrCreateDatabase(@android.annotation.NonNull java.lang.String path, @android.annotation.Nullable android.database.sqlite.SQLiteDatabase.CursorFactory factory) { throw new RuntimeException("Stub!"); }

public static android.database.sqlite.SQLiteDatabase openOrCreateDatabase(@android.annotation.NonNull java.lang.String path, @android.annotation.Nullable android.database.sqlite.SQLiteDatabase.CursorFactory factory, @android.annotation.Nullable android.database.DatabaseErrorHandler errorHandler) { throw new RuntimeException("Stub!"); }

public static boolean deleteDatabase(@android.annotation.NonNull java.io.File file) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.database.sqlite.SQLiteDatabase create(@android.annotation.Nullable android.database.sqlite.SQLiteDatabase.CursorFactory factory) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.database.sqlite.SQLiteDatabase createInMemory(@android.annotation.NonNull android.database.sqlite.SQLiteDatabase.OpenParams openParams) { throw new RuntimeException("Stub!"); }

public void setCustomScalarFunction(@android.annotation.NonNull java.lang.String functionName, @android.annotation.NonNull java.util.function.UnaryOperator<java.lang.String> scalarFunction) throws android.database.sqlite.SQLiteException { throw new RuntimeException("Stub!"); }

public void setCustomAggregateFunction(@android.annotation.NonNull java.lang.String functionName, @android.annotation.NonNull java.util.function.BinaryOperator<java.lang.String> aggregateFunction) throws android.database.sqlite.SQLiteException { throw new RuntimeException("Stub!"); }

public void execPerConnectionSQL(@android.annotation.NonNull java.lang.String sql, @android.annotation.Nullable java.lang.Object[] bindArgs) throws android.database.SQLException { throw new RuntimeException("Stub!"); }

public int getVersion() { throw new RuntimeException("Stub!"); }

public void setVersion(int version) { throw new RuntimeException("Stub!"); }

public long getMaximumSize() { throw new RuntimeException("Stub!"); }

public long setMaximumSize(long numBytes) { throw new RuntimeException("Stub!"); }

public long getPageSize() { throw new RuntimeException("Stub!"); }

public void setPageSize(long numBytes) { throw new RuntimeException("Stub!"); }

@Deprecated
public void markTableSyncable(java.lang.String table, java.lang.String deletedTable) { throw new RuntimeException("Stub!"); }

@Deprecated
public void markTableSyncable(java.lang.String table, java.lang.String foreignKey, java.lang.String updateTable) { throw new RuntimeException("Stub!"); }

public static java.lang.String findEditTable(java.lang.String tables) { throw new RuntimeException("Stub!"); }

public android.database.sqlite.SQLiteStatement compileStatement(java.lang.String sql) throws android.database.SQLException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.database.Cursor query(boolean distinct, @android.annotation.NonNull java.lang.String table, @android.annotation.Nullable java.lang.String[] columns, @android.annotation.Nullable java.lang.String selection, @android.annotation.Nullable java.lang.String[] selectionArgs, @android.annotation.Nullable java.lang.String groupBy, @android.annotation.Nullable java.lang.String having, @android.annotation.Nullable java.lang.String orderBy, @android.annotation.Nullable java.lang.String limit) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.database.Cursor query(boolean distinct, @android.annotation.NonNull java.lang.String table, @android.annotation.Nullable java.lang.String[] columns, @android.annotation.Nullable java.lang.String selection, @android.annotation.Nullable java.lang.String[] selectionArgs, @android.annotation.Nullable java.lang.String groupBy, @android.annotation.Nullable java.lang.String having, @android.annotation.Nullable java.lang.String orderBy, @android.annotation.Nullable java.lang.String limit, @android.annotation.Nullable android.os.CancellationSignal cancellationSignal) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.database.Cursor queryWithFactory(@android.annotation.Nullable android.database.sqlite.SQLiteDatabase.CursorFactory cursorFactory, boolean distinct, @android.annotation.NonNull java.lang.String table, @android.annotation.Nullable java.lang.String[] columns, @android.annotation.Nullable java.lang.String selection, @android.annotation.Nullable java.lang.String[] selectionArgs, @android.annotation.Nullable java.lang.String groupBy, @android.annotation.Nullable java.lang.String having, @android.annotation.Nullable java.lang.String orderBy, @android.annotation.Nullable java.lang.String limit) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.database.Cursor queryWithFactory(@android.annotation.Nullable android.database.sqlite.SQLiteDatabase.CursorFactory cursorFactory, boolean distinct, @android.annotation.NonNull java.lang.String table, @android.annotation.Nullable java.lang.String[] columns, @android.annotation.Nullable java.lang.String selection, @android.annotation.Nullable java.lang.String[] selectionArgs, @android.annotation.Nullable java.lang.String groupBy, @android.annotation.Nullable java.lang.String having, @android.annotation.Nullable java.lang.String orderBy, @android.annotation.Nullable java.lang.String limit, @android.annotation.Nullable android.os.CancellationSignal cancellationSignal) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.database.Cursor query(@android.annotation.NonNull java.lang.String table, @android.annotation.Nullable java.lang.String[] columns, @android.annotation.Nullable java.lang.String selection, @android.annotation.Nullable java.lang.String[] selectionArgs, @android.annotation.Nullable java.lang.String groupBy, @android.annotation.Nullable java.lang.String having, @android.annotation.Nullable java.lang.String orderBy) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.database.Cursor query(@android.annotation.NonNull java.lang.String table, @android.annotation.Nullable java.lang.String[] columns, @android.annotation.Nullable java.lang.String selection, @android.annotation.Nullable java.lang.String[] selectionArgs, @android.annotation.Nullable java.lang.String groupBy, @android.annotation.Nullable java.lang.String having, @android.annotation.Nullable java.lang.String orderBy, @android.annotation.Nullable java.lang.String limit) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.database.Cursor rawQuery(@android.annotation.NonNull java.lang.String sql, @android.annotation.Nullable java.lang.String[] selectionArgs) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.database.Cursor rawQuery(@android.annotation.NonNull java.lang.String sql, @android.annotation.Nullable java.lang.String[] selectionArgs, @android.annotation.Nullable android.os.CancellationSignal cancellationSignal) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.database.Cursor rawQueryWithFactory(@android.annotation.Nullable android.database.sqlite.SQLiteDatabase.CursorFactory cursorFactory, @android.annotation.NonNull java.lang.String sql, @android.annotation.Nullable java.lang.String[] selectionArgs, @android.annotation.NonNull java.lang.String editTable) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.database.Cursor rawQueryWithFactory(@android.annotation.Nullable android.database.sqlite.SQLiteDatabase.CursorFactory cursorFactory, @android.annotation.NonNull java.lang.String sql, @android.annotation.Nullable java.lang.String[] selectionArgs, @android.annotation.NonNull java.lang.String editTable, @android.annotation.Nullable android.os.CancellationSignal cancellationSignal) { throw new RuntimeException("Stub!"); }

public long insert(@android.annotation.NonNull java.lang.String table, @android.annotation.Nullable java.lang.String nullColumnHack, @android.annotation.Nullable android.content.ContentValues values) { throw new RuntimeException("Stub!"); }

public long insertOrThrow(@android.annotation.NonNull java.lang.String table, @android.annotation.Nullable java.lang.String nullColumnHack, @android.annotation.Nullable android.content.ContentValues values) throws android.database.SQLException { throw new RuntimeException("Stub!"); }

public long replace(@android.annotation.NonNull java.lang.String table, @android.annotation.Nullable java.lang.String nullColumnHack, @android.annotation.Nullable android.content.ContentValues initialValues) { throw new RuntimeException("Stub!"); }

public long replaceOrThrow(@android.annotation.NonNull java.lang.String table, @android.annotation.Nullable java.lang.String nullColumnHack, @android.annotation.Nullable android.content.ContentValues initialValues) throws android.database.SQLException { throw new RuntimeException("Stub!"); }

public long insertWithOnConflict(@android.annotation.NonNull java.lang.String table, @android.annotation.Nullable java.lang.String nullColumnHack, @android.annotation.Nullable android.content.ContentValues initialValues, int conflictAlgorithm) { throw new RuntimeException("Stub!"); }

public int delete(@android.annotation.NonNull java.lang.String table, @android.annotation.Nullable java.lang.String whereClause, @android.annotation.Nullable java.lang.String[] whereArgs) { throw new RuntimeException("Stub!"); }

public int update(@android.annotation.NonNull java.lang.String table, @android.annotation.Nullable android.content.ContentValues values, @android.annotation.Nullable java.lang.String whereClause, @android.annotation.Nullable java.lang.String[] whereArgs) { throw new RuntimeException("Stub!"); }

public int updateWithOnConflict(@android.annotation.NonNull java.lang.String table, @android.annotation.Nullable android.content.ContentValues values, @android.annotation.Nullable java.lang.String whereClause, @android.annotation.Nullable java.lang.String[] whereArgs, int conflictAlgorithm) { throw new RuntimeException("Stub!"); }

public void execSQL(java.lang.String sql) throws android.database.SQLException { throw new RuntimeException("Stub!"); }

public void execSQL(@android.annotation.NonNull java.lang.String sql, @android.annotation.NonNull java.lang.Object[] bindArgs) throws android.database.SQLException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.database.sqlite.SQLiteRawStatement createRawStatement(@android.annotation.NonNull java.lang.String sql) { throw new RuntimeException("Stub!"); }

public long getLastInsertRowId() { throw new RuntimeException("Stub!"); }

public long getLastChangedRowCount() { throw new RuntimeException("Stub!"); }

public long getTotalChangedRowCount() { throw new RuntimeException("Stub!"); }

public void validateSql(@android.annotation.NonNull java.lang.String sql, @android.annotation.Nullable android.os.CancellationSignal cancellationSignal) { throw new RuntimeException("Stub!"); }

public boolean isReadOnly() { throw new RuntimeException("Stub!"); }

public boolean isOpen() { throw new RuntimeException("Stub!"); }

public boolean needUpgrade(int newVersion) { throw new RuntimeException("Stub!"); }

public java.lang.String getPath() { throw new RuntimeException("Stub!"); }

public void setLocale(java.util.Locale locale) { throw new RuntimeException("Stub!"); }

public void setMaxSqlCacheSize(int cacheSize) { throw new RuntimeException("Stub!"); }

public void setForeignKeyConstraintsEnabled(boolean enable) { throw new RuntimeException("Stub!"); }

public boolean enableWriteAheadLogging() { throw new RuntimeException("Stub!"); }

public void disableWriteAheadLogging() { throw new RuntimeException("Stub!"); }

public boolean isWriteAheadLoggingEnabled() { throw new RuntimeException("Stub!"); }

public java.util.List<android.util.Pair<java.lang.String,java.lang.String>> getAttachedDbs() { throw new RuntimeException("Stub!"); }

public boolean isDatabaseIntegrityOk() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public static final int CONFLICT_ABORT = 2; // 0x2

public static final int CONFLICT_FAIL = 3; // 0x3

public static final int CONFLICT_IGNORE = 4; // 0x4

public static final int CONFLICT_NONE = 0; // 0x0

public static final int CONFLICT_REPLACE = 5; // 0x5

public static final int CONFLICT_ROLLBACK = 1; // 0x1

public static final int CREATE_IF_NECESSARY = 268435456; // 0x10000000

public static final int ENABLE_WRITE_AHEAD_LOGGING = 536870912; // 0x20000000

public static final java.lang.String JOURNAL_MODE_DELETE = "DELETE";

public static final java.lang.String JOURNAL_MODE_MEMORY = "MEMORY";

public static final java.lang.String JOURNAL_MODE_OFF = "OFF";

public static final java.lang.String JOURNAL_MODE_PERSIST = "PERSIST";

public static final java.lang.String JOURNAL_MODE_TRUNCATE = "TRUNCATE";

public static final java.lang.String JOURNAL_MODE_WAL = "WAL";

public static final int MAX_SQL_CACHE_SIZE = 100; // 0x64

public static final int NO_LOCALIZED_COLLATORS = 16; // 0x10

public static final int OPEN_READONLY = 1; // 0x1

public static final int OPEN_READWRITE = 0; // 0x0

public static final int SQLITE_MAX_LIKE_PATTERN_LENGTH = 50000; // 0xc350

public static final java.lang.String SYNC_MODE_EXTRA = "EXTRA";

public static final java.lang.String SYNC_MODE_FULL = "FULL";

public static final java.lang.String SYNC_MODE_NORMAL = "NORMAL";

public static final java.lang.String SYNC_MODE_OFF = "OFF";
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface CursorFactory {

public android.database.Cursor newCursor(android.database.sqlite.SQLiteDatabase db, android.database.sqlite.SQLiteCursorDriver masterQuery, java.lang.String editTable, android.database.sqlite.SQLiteQuery query);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class OpenParams {

OpenParams() { throw new RuntimeException("Stub!"); }

public int getLookasideSlotSize() { throw new RuntimeException("Stub!"); }

public int getLookasideSlotCount() { throw new RuntimeException("Stub!"); }

public int getOpenFlags() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.database.sqlite.SQLiteDatabase.CursorFactory getCursorFactory() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.database.DatabaseErrorHandler getErrorHandler() { throw new RuntimeException("Stub!"); }

public long getIdleConnectionTimeout() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getJournalMode() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getSynchronousMode() { throw new RuntimeException("Stub!"); }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

public Builder(android.database.sqlite.SQLiteDatabase.OpenParams params) { throw new RuntimeException("Stub!"); }

public android.database.sqlite.SQLiteDatabase.OpenParams.Builder setLookasideConfig(int slotSize, int slotCount) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.database.sqlite.SQLiteDatabase.OpenParams.Builder setOpenFlags(int openFlags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.database.sqlite.SQLiteDatabase.OpenParams.Builder addOpenFlags(int openFlags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.database.sqlite.SQLiteDatabase.OpenParams.Builder removeOpenFlags(int openFlags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.database.sqlite.SQLiteDatabase.OpenParams.Builder setCursorFactory(@android.annotation.Nullable android.database.sqlite.SQLiteDatabase.CursorFactory cursorFactory) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.database.sqlite.SQLiteDatabase.OpenParams.Builder setErrorHandler(@android.annotation.Nullable android.database.DatabaseErrorHandler errorHandler) { throw new RuntimeException("Stub!"); }

@Deprecated
@android.annotation.NonNull
public android.database.sqlite.SQLiteDatabase.OpenParams.Builder setIdleConnectionTimeout(long idleConnectionTimeoutMs) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.database.sqlite.SQLiteDatabase.OpenParams.Builder setJournalMode(@android.annotation.NonNull java.lang.String journalMode) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.database.sqlite.SQLiteDatabase.OpenParams.Builder setSynchronousMode(@android.annotation.NonNull java.lang.String syncMode) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.database.sqlite.SQLiteDatabase.OpenParams build() { throw new RuntimeException("Stub!"); }
}

}

}

