/*
 * Copyright (C) 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.bluetooth;

import android.os.Parcelable;

/**
 * Represents the codec configuration for a Bluetooth LE Audio source device.
 *
 * <p>Contains the source codec type.
 *
 * <p>The source codec type values are the same as those supported by the device hardware.
 *
 * @see android.bluetooth.BluetoothLeAudioCodecConfig
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class BluetoothLeAudioCodecConfig implements android.os.Parcelable {

BluetoothLeAudioCodecConfig() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param out This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel out, int flags) { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * Gets the codec type.
 *
 * @return the codec type

 * Value is {@link android.bluetooth.BluetoothLeAudioCodecConfig#SOURCE_CODEC_TYPE_LC3}, or {@link android.bluetooth.BluetoothLeAudioCodecConfig#SOURCE_CODEC_TYPE_INVALID}
 */

public int getCodecType() { throw new RuntimeException("Stub!"); }

/**
 * Gets the codec name.
 *
 * @return the codec name

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getCodecName() { throw new RuntimeException("Stub!"); }

/**
 * Returns the codec selection priority.
 *
 * <p>The codec selection priority is relative to other codecs: larger value means higher
 * priority.

 * @return Value is {@link android.bluetooth.BluetoothLeAudioCodecConfig#CODEC_PRIORITY_DISABLED}, {@link android.bluetooth.BluetoothLeAudioCodecConfig#CODEC_PRIORITY_DEFAULT}, or {@link android.bluetooth.BluetoothLeAudioCodecConfig#CODEC_PRIORITY_HIGHEST}
 */

public int getCodecPriority() { throw new RuntimeException("Stub!"); }

/**
 * Returns the codec sample rate.
 * @return Value is either <code>0</code> or a combination of {@link android.bluetooth.BluetoothLeAudioCodecConfig#SAMPLE_RATE_NONE}, {@link android.bluetooth.BluetoothLeAudioCodecConfig#SAMPLE_RATE_8000}, {@link android.bluetooth.BluetoothLeAudioCodecConfig#SAMPLE_RATE_11025}, {@link android.bluetooth.BluetoothLeAudioCodecConfig#SAMPLE_RATE_16000}, {@link android.bluetooth.BluetoothLeAudioCodecConfig#SAMPLE_RATE_22050}, {@link android.bluetooth.BluetoothLeAudioCodecConfig#SAMPLE_RATE_24000}, {@link android.bluetooth.BluetoothLeAudioCodecConfig#SAMPLE_RATE_32000}, {@link android.bluetooth.BluetoothLeAudioCodecConfig#SAMPLE_RATE_44100}, {@link android.bluetooth.BluetoothLeAudioCodecConfig#SAMPLE_RATE_48000}, {@link android.bluetooth.BluetoothLeAudioCodecConfig#SAMPLE_RATE_88200}, {@link android.bluetooth.BluetoothLeAudioCodecConfig#SAMPLE_RATE_96000}, {@link android.bluetooth.BluetoothLeAudioCodecConfig#SAMPLE_RATE_176400}, {@link android.bluetooth.BluetoothLeAudioCodecConfig#SAMPLE_RATE_192000}, and {@link android.bluetooth.BluetoothLeAudioCodecConfig#SAMPLE_RATE_384000}
 */

public int getSampleRate() { throw new RuntimeException("Stub!"); }

/**
 * Returns the codec bits per sample.
 * @return Value is either <code>0</code> or a combination of {@link android.bluetooth.BluetoothLeAudioCodecConfig#BITS_PER_SAMPLE_NONE}, {@link android.bluetooth.BluetoothLeAudioCodecConfig#BITS_PER_SAMPLE_16}, {@link android.bluetooth.BluetoothLeAudioCodecConfig#BITS_PER_SAMPLE_24}, and {@link android.bluetooth.BluetoothLeAudioCodecConfig#BITS_PER_SAMPLE_32}
 */

public int getBitsPerSample() { throw new RuntimeException("Stub!"); }

/**
 * Returns the codec channel mode.
 * @return Value is either <code>0</code> or a combination of {@link android.bluetooth.BluetoothLeAudioCodecConfig#CHANNEL_COUNT_NONE}, {@link android.bluetooth.BluetoothLeAudioCodecConfig#CHANNEL_COUNT_1}, and {@link android.bluetooth.BluetoothLeAudioCodecConfig#CHANNEL_COUNT_2}
 */

public int getChannelCount() { throw new RuntimeException("Stub!"); }

/**
 * Returns the frame duration.
 * @return Value is either <code>0</code> or a combination of {@link android.bluetooth.BluetoothLeAudioCodecConfig#FRAME_DURATION_NONE}, {@link android.bluetooth.BluetoothLeAudioCodecConfig#FRAME_DURATION_7500}, and {@link android.bluetooth.BluetoothLeAudioCodecConfig#FRAME_DURATION_10000}
 */

public int getFrameDuration() { throw new RuntimeException("Stub!"); }

/** Returns the octets per frame */

public int getOctetsPerFrame() { throw new RuntimeException("Stub!"); }

/** Returns the minimum octets per frame */

public int getMinOctetsPerFrame() { throw new RuntimeException("Stub!"); }

/** Returns the maximum octets per frame */

public int getMaxOctetsPerFrame() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Returns a hash representation of this BluetoothLeAudioCodecConfig based on all the config
 * values.
 */

public int hashCode() { throw new RuntimeException("Stub!"); }

/** Codec bits per sample 16. */

public static final int BITS_PER_SAMPLE_16 = 1; // 0x1

/** Codec bits per sample 24. */

public static final int BITS_PER_SAMPLE_24 = 2; // 0x2

/** Codec bits per sample 32. */

public static final int BITS_PER_SAMPLE_32 = 8; // 0x8

/** Codec bits per sample 0. Default value of the codec bits per sample. */

public static final int BITS_PER_SAMPLE_NONE = 0; // 0x0

/** Codec channel mode MONO. */

public static final int CHANNEL_COUNT_1 = 1; // 0x1

/** Codec channel mode STEREO. */

public static final int CHANNEL_COUNT_2 = 2; // 0x2

/** Codec channel mode NONE. Default value of the codec channel mode. */

public static final int CHANNEL_COUNT_NONE = 0; // 0x0

/** Codec priority default. Default value used for codec priority. */

public static final int CODEC_PRIORITY_DEFAULT = 0; // 0x0

/**
 * Codec priority disabled. Used to indicate that this codec is disabled and should not be used.
 */

public static final int CODEC_PRIORITY_DISABLED = -1; // 0xffffffff

/** Codec priority highest. Used to indicate the highest priority a codec can have. */

public static final int CODEC_PRIORITY_HIGHEST = 1000000; // 0xf4240

/** {@link android.os.Parcelable.Creator Parcelable.Creator} interface implementation. */

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.bluetooth.BluetoothLeAudioCodecConfig> CREATOR;
static { CREATOR = null; }

/** Frame duration 10000 us. */

public static final int FRAME_DURATION_10000 = 2; // 0x2

/** Frame duration 7500 us. */

public static final int FRAME_DURATION_7500 = 1; // 0x1

/** Frame duration 0. Default value of the frame duration. */

public static final int FRAME_DURATION_NONE = 0; // 0x0

/** Codec sample rate 11025 Hz. */

public static final int SAMPLE_RATE_11025 = 2; // 0x2

/** Codec sample rate 16000 Hz. */

public static final int SAMPLE_RATE_16000 = 4; // 0x4

/** Codec sample rate 176400 Hz. */

public static final int SAMPLE_RATE_176400 = 1024; // 0x400

/** Codec sample rate 192000 Hz. */

public static final int SAMPLE_RATE_192000 = 2048; // 0x800

/** Codec sample rate 22050 Hz. */

public static final int SAMPLE_RATE_22050 = 8; // 0x8

/** Codec sample rate 24000 Hz. */

public static final int SAMPLE_RATE_24000 = 16; // 0x10

/** Codec sample rate 32000 Hz. */

public static final int SAMPLE_RATE_32000 = 32; // 0x20

/** Codec sample rate 384000 Hz. */

public static final int SAMPLE_RATE_384000 = 4096; // 0x1000

/** Codec sample rate 44100 Hz. */

public static final int SAMPLE_RATE_44100 = 64; // 0x40

/** Codec sample rate 48000 Hz. */

public static final int SAMPLE_RATE_48000 = 128; // 0x80

/** Codec sample rate 8000 Hz. */

public static final int SAMPLE_RATE_8000 = 1; // 0x1

/** Codec sample rate 88200 Hz. */

public static final int SAMPLE_RATE_88200 = 256; // 0x100

/** Codec sample rate 96000 Hz. */

public static final int SAMPLE_RATE_96000 = 512; // 0x200

/**
 * Codec sample rate 0 Hz. Default value used for codec sample rate. Values are the bit mask as
 * defined in the Bluetooth Assigned Numbers, Generic Audio, Supported_Sampling_Frequencies
 * table.
 */

public static final int SAMPLE_RATE_NONE = 0; // 0x0

public static final int SOURCE_CODEC_TYPE_INVALID = 1000000; // 0xf4240

public static final int SOURCE_CODEC_TYPE_LC3 = 0; // 0x0
/**
 * Builder for {@link android.bluetooth.BluetoothLeAudioCodecConfig BluetoothLeAudioCodecConfig}.
 *
 * <p>By default, the codec type will be set to {@link android.bluetooth.BluetoothLeAudioCodecConfig#SOURCE_CODEC_TYPE_INVALID  }
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * @param config This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.bluetooth.BluetoothLeAudioCodecConfig config) { throw new RuntimeException("Stub!"); }

/**
 * Set codec type for Bluetooth LE audio codec config.
 *
 * @param codecType of this codec
 * Value is {@link android.bluetooth.BluetoothLeAudioCodecConfig#SOURCE_CODEC_TYPE_LC3}, or {@link android.bluetooth.BluetoothLeAudioCodecConfig#SOURCE_CODEC_TYPE_INVALID}
 * @return the same Builder instance
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.bluetooth.BluetoothLeAudioCodecConfig.Builder setCodecType(int codecType) { throw new RuntimeException("Stub!"); }

/**
 * Set codec priority for Bluetooth LE audio codec config.
 *
 * @param codecPriority of this codec
 * Value is {@link android.bluetooth.BluetoothLeAudioCodecConfig#CODEC_PRIORITY_DISABLED}, {@link android.bluetooth.BluetoothLeAudioCodecConfig#CODEC_PRIORITY_DEFAULT}, or {@link android.bluetooth.BluetoothLeAudioCodecConfig#CODEC_PRIORITY_HIGHEST}
 * @return the same Builder instance
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.bluetooth.BluetoothLeAudioCodecConfig.Builder setCodecPriority(int codecPriority) { throw new RuntimeException("Stub!"); }

/**
 * Set sample rate for Bluetooth LE audio codec config.
 *
 * @param sampleRate of this codec
 * Value is either <code>0</code> or a combination of {@link android.bluetooth.BluetoothLeAudioCodecConfig#SAMPLE_RATE_NONE}, {@link android.bluetooth.BluetoothLeAudioCodecConfig#SAMPLE_RATE_8000}, {@link android.bluetooth.BluetoothLeAudioCodecConfig#SAMPLE_RATE_11025}, {@link android.bluetooth.BluetoothLeAudioCodecConfig#SAMPLE_RATE_16000}, {@link android.bluetooth.BluetoothLeAudioCodecConfig#SAMPLE_RATE_22050}, {@link android.bluetooth.BluetoothLeAudioCodecConfig#SAMPLE_RATE_24000}, {@link android.bluetooth.BluetoothLeAudioCodecConfig#SAMPLE_RATE_32000}, {@link android.bluetooth.BluetoothLeAudioCodecConfig#SAMPLE_RATE_44100}, {@link android.bluetooth.BluetoothLeAudioCodecConfig#SAMPLE_RATE_48000}, {@link android.bluetooth.BluetoothLeAudioCodecConfig#SAMPLE_RATE_88200}, {@link android.bluetooth.BluetoothLeAudioCodecConfig#SAMPLE_RATE_96000}, {@link android.bluetooth.BluetoothLeAudioCodecConfig#SAMPLE_RATE_176400}, {@link android.bluetooth.BluetoothLeAudioCodecConfig#SAMPLE_RATE_192000}, and {@link android.bluetooth.BluetoothLeAudioCodecConfig#SAMPLE_RATE_384000}
 * @return the same Builder instance
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.bluetooth.BluetoothLeAudioCodecConfig.Builder setSampleRate(int sampleRate) { throw new RuntimeException("Stub!"); }

/**
 * Set the bits per sample for LE audio codec config.
 *
 * @param bitsPerSample of this codec
 * Value is either <code>0</code> or a combination of {@link android.bluetooth.BluetoothLeAudioCodecConfig#BITS_PER_SAMPLE_NONE}, {@link android.bluetooth.BluetoothLeAudioCodecConfig#BITS_PER_SAMPLE_16}, {@link android.bluetooth.BluetoothLeAudioCodecConfig#BITS_PER_SAMPLE_24}, and {@link android.bluetooth.BluetoothLeAudioCodecConfig#BITS_PER_SAMPLE_32}
 * @return the same Builder instance
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.bluetooth.BluetoothLeAudioCodecConfig.Builder setBitsPerSample(int bitsPerSample) { throw new RuntimeException("Stub!"); }

/**
 * Set the channel count for Bluetooth LE audio codec config.
 *
 * @param channelCount of this codec
 * Value is either <code>0</code> or a combination of {@link android.bluetooth.BluetoothLeAudioCodecConfig#CHANNEL_COUNT_NONE}, {@link android.bluetooth.BluetoothLeAudioCodecConfig#CHANNEL_COUNT_1}, and {@link android.bluetooth.BluetoothLeAudioCodecConfig#CHANNEL_COUNT_2}
 * @return the same Builder instance
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.bluetooth.BluetoothLeAudioCodecConfig.Builder setChannelCount(int channelCount) { throw new RuntimeException("Stub!"); }

/**
 * Set the frame duration for Bluetooth LE audio codec config.
 *
 * @param frameDuration of this codec
 * Value is either <code>0</code> or a combination of {@link android.bluetooth.BluetoothLeAudioCodecConfig#FRAME_DURATION_NONE}, {@link android.bluetooth.BluetoothLeAudioCodecConfig#FRAME_DURATION_7500}, and {@link android.bluetooth.BluetoothLeAudioCodecConfig#FRAME_DURATION_10000}
 * @return the same Builder instance
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.bluetooth.BluetoothLeAudioCodecConfig.Builder setFrameDuration(int frameDuration) { throw new RuntimeException("Stub!"); }

/**
 * Set the octets per frame for Bluetooth LE audio codec config.
 *
 * @param octetsPerFrame of this codec
 * @return the same Builder instance

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.bluetooth.BluetoothLeAudioCodecConfig.Builder setOctetsPerFrame(int octetsPerFrame) { throw new RuntimeException("Stub!"); }

/**
 * Set the minimum octets per frame for Bluetooth LE audio codec config.
 *
 * @param minOctetsPerFrame of this codec
 * @return the same Builder instance

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.bluetooth.BluetoothLeAudioCodecConfig.Builder setMinOctetsPerFrame(int minOctetsPerFrame) { throw new RuntimeException("Stub!"); }

/**
 * Set the maximum octets per frame for Bluetooth LE audio codec config.
 *
 * @param maxOctetsPerFrame of this codec
 * @return the same Builder instance

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.bluetooth.BluetoothLeAudioCodecConfig.Builder setMaxOctetsPerFrame(int maxOctetsPerFrame) { throw new RuntimeException("Stub!"); }

/**
 * Build {@link android.bluetooth.BluetoothLeAudioCodecConfig BluetoothLeAudioCodecConfig}.
 *
 * @return new BluetoothLeAudioCodecConfig built

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.bluetooth.BluetoothLeAudioCodecConfig build() { throw new RuntimeException("Stub!"); }
}

}

