/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.app.sdksandbox.sdkprovider;

import android.app.Activity;
import android.app.sdksandbox.AppOwnedSdkSandboxInterface;
import android.app.sdksandbox.LoadSdkException;
import android.app.sdksandbox.SandboxedSdk;
import android.app.sdksandbox.SandboxedSdkProvider;
import android.app.sdksandbox.SdkSandboxManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.IBinder;
import java.util.List;
import java.util.concurrent.Executor;

/**
 * Controller that is used by SDK loaded in the sandbox to access information provided by the sdk
 * sandbox.
 *
 * <p>It enables the SDK to communicate with other SDKS in the SDK sandbox and know about the state
 * of the sdks that are currently loaded in it.
 *
 * <p>An instance of {@link android.app.sdksandbox.sdkprovider.SdkSandboxController SdkSandboxController} can be obtained using {@link android.content.Context#getSystemService  } and {@link android.app.sdksandbox.sdkprovider.SdkSandboxController class}. The {@link android.content.Context Context} can in turn
 * be obtained using {@link android.app.sdksandbox.SandboxedSdkProvider#getContext()}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class SdkSandboxController {

SdkSandboxController() { throw new RuntimeException("Stub!"); }

/**
 * Fetches all {@link android.app.sdksandbox.AppOwnedSdkSandboxInterface AppOwnedSdkSandboxInterface} that are registered by the app.
 *
 * @return List of {@link android.app.sdksandbox.AppOwnedSdkSandboxInterface AppOwnedSdkSandboxInterface} containing all currently registered
 *     AppOwnedSdkSandboxInterface.
 * This value cannot be {@code null}.
 * @throws java.lang.UnsupportedOperationException if the controller is obtained from an unexpected
 *     context. Use {@link android.app.sdksandbox.SandboxedSdkProvider#getContext() SandboxedSdkProvider#getContext()} for the right context
 */

@android.annotation.NonNull
public java.util.List<android.app.sdksandbox.AppOwnedSdkSandboxInterface> getAppOwnedSdkSandboxInterfaces() { throw new RuntimeException("Stub!"); }

/**
 * Fetches information about Sdks that are loaded in the sandbox.
 *
 * @return List of {@link android.app.sdksandbox.SandboxedSdk SandboxedSdk} containing all currently loaded sdks
 * This value cannot be {@code null}.
 * @throws java.lang.UnsupportedOperationException if the controller is obtained from an unexpected
 *     context. Use {@link android.app.sdksandbox.SandboxedSdkProvider#getContext() SandboxedSdkProvider#getContext()} for the right context
 */

@android.annotation.NonNull
public java.util.List<android.app.sdksandbox.SandboxedSdk> getSandboxedSdks() { throw new RuntimeException("Stub!"); }

/**
 * Loads SDK in an SDK sandbox java process.
 *
 * <p>Loads SDK library with {@code sdkName} to an SDK sandbox process asynchronously. The
 * caller will be notified through the {@code receiver}.
 *
 * <p>The caller may only load {@code SDKs} the client app depends on into the SDK sandbox.
 *
 * @param sdkName name of the SDK to be loaded.
 * This value cannot be {@code null}.
 * @param params additional parameters to be passed to the SDK in the form of a {@link android.os.Bundle Bundle}
 *     as agreed between the client and the SDK.
 * This value cannot be {@code null}.
 * @param executor the {@link java.util.concurrent.Executor Executor} on which to invoke the receiver.
 * This value cannot be {@code null}.
 * Callback and listener events are dispatched through this
 * {@link java.util.concurrent.Executor Executor}, providing an easy way to control which thread is
 * used. To dispatch events through the main thread of your
 * application, you can use
 * {@link android.content.Context#getMainExecutor() Context.getMainExecutor()}.
 * Otherwise, provide an {@link java.util.concurrent.Executor Executor} that dispatches to an appropriate thread.
 * @param receiver This either receives a {@link android.app.sdksandbox.SandboxedSdk SandboxedSdk} on a successful run, or {@link android.app.sdksandbox.LoadSdkException LoadSdkException}.
 * This value cannot be {@code null}.
 * @throws java.lang.UnsupportedOperationException if the controller is obtained from an unexpected
 *     context. Use {@link android.app.sdksandbox.SandboxedSdkProvider#getContext() SandboxedSdkProvider#getContext()} for the right context
 */

public void loadSdk(@android.annotation.NonNull java.lang.String sdkName, @android.annotation.NonNull android.os.Bundle params, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<android.app.sdksandbox.SandboxedSdk,android.app.sdksandbox.LoadSdkException> receiver) { throw new RuntimeException("Stub!"); }

/**
 * Returns {@link android.content.SharedPreferences SharedPreferences} containing data synced from the client app.
 *
 * <p>Keys that have been synced by the client app using {@link android.app.sdksandbox.SdkSandboxManager#addSyncedSharedPreferencesKeys(Set)  } can be found in this {@link android.content.SharedPreferences SharedPreferences}.
 *
 * <p>The returned {@link android.content.SharedPreferences SharedPreferences} should only be read. Writing to it is not
 * supported.
 *
 * @return {@link android.content.SharedPreferences SharedPreferences} containing data synced from client app.
 * This value cannot be {@code null}.
 * @throws java.lang.UnsupportedOperationException if the controller is obtained from an unexpected
 *     context. Use {@link android.app.sdksandbox.SandboxedSdkProvider#getContext() SandboxedSdkProvider#getContext()} for the right context
 */

@android.annotation.NonNull
public android.content.SharedPreferences getClientSharedPreferences() { throw new RuntimeException("Stub!"); }

/**
 * Returns an identifier for a {@link android.app.sdksandbox.sdkprovider.SdkSandboxActivityHandler SdkSandboxActivityHandler} after registering it.
 *
 * <p>This function registers an implementation of {@link android.app.sdksandbox.sdkprovider.SdkSandboxActivityHandler SdkSandboxActivityHandler} created by
 * an SDK and returns an {@link android.os.IBinder IBinder} which uniquely identifies the passed {@link android.app.sdksandbox.sdkprovider.SdkSandboxActivityHandler SdkSandboxActivityHandler} object.
 *
 * <p>If the same {@link android.app.sdksandbox.sdkprovider.SdkSandboxActivityHandler SdkSandboxActivityHandler} registered multiple times without
 * unregistering, the same {@link android.os.IBinder IBinder} token will be returned.
 *
 * @param sdkSandboxActivityHandler is the {@link android.app.sdksandbox.sdkprovider.SdkSandboxActivityHandler SdkSandboxActivityHandler} to register.
 * This value cannot be {@code null}.
 * @return {@link android.os.IBinder IBinder} uniquely identify the passed {@link android.app.sdksandbox.sdkprovider.SdkSandboxActivityHandler SdkSandboxActivityHandler}.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.os.IBinder registerSdkSandboxActivityHandler(@android.annotation.NonNull android.app.sdksandbox.sdkprovider.SdkSandboxActivityHandler sdkSandboxActivityHandler) { throw new RuntimeException("Stub!"); }

/**
 * Unregister an already registered {@link android.app.sdksandbox.sdkprovider.SdkSandboxActivityHandler SdkSandboxActivityHandler}.
 *
 * <p>If the passed {@link android.app.sdksandbox.sdkprovider.SdkSandboxActivityHandler SdkSandboxActivityHandler} is registered, it will be unregistered.
 * Otherwise, it will do nothing.
 *
 * <p>After unregistering, SDK can register the same handler object again or create a new one in
 * case it wants a new {@link android.app.Activity Activity}.
 *
 * <p>If the {@link android.os.IBinder IBinder} token of the unregistered handler used to start a {@link android.app.Activity Activity},
 * the {@link android.app.Activity Activity} will fail to start.
 *
 * @param sdkSandboxActivityHandler is the {@link android.app.sdksandbox.sdkprovider.SdkSandboxActivityHandler SdkSandboxActivityHandler} to unregister.
 
 * This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public void unregisterSdkSandboxActivityHandler(@android.annotation.NonNull android.app.sdksandbox.sdkprovider.SdkSandboxActivityHandler sdkSandboxActivityHandler) { throw new RuntimeException("Stub!"); }

/**
 * Returns the package name of the client app.
 *
 * @throws java.lang.UnsupportedOperationException if the controller is obtained from an unexpected
 *     context. Use {@link android.app.sdksandbox.SandboxedSdkProvider#getContext() SandboxedSdkProvider#getContext()} for the right context.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getClientPackageName() { throw new RuntimeException("Stub!"); }

public static final java.lang.String SDK_SANDBOX_CONTROLLER_SERVICE = "sdk_sandbox_controller_service";
}

