/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.app.appsearch;


/** The result class of the {@link android.app.appsearch.AppSearchSession#searchSuggestion AppSearchSession#searchSuggestion}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class SearchSuggestionResult implements android.os.Parcelable {

SearchSuggestionResult() { throw new RuntimeException("Stub!"); }

/**
 * Returns the suggested result that could be used as query expression in the {@link android.app.appsearch.AppSearchSession#search  }.
 *
 * <p>The suggested result will never be empty.
 *
 * <p>The suggested result only contains lowercase or special characters.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getSuggestedResult() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param other This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object other) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

/** @hide */

public final int describeContents() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.app.appsearch.SearchSuggestionResult> CREATOR;
static { CREATOR = null; }
/** The Builder class of {@link android.app.appsearch.SearchSuggestionResult SearchSuggestionResult}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Sets the suggested result that could be used as query expression in the {@link android.app.appsearch.AppSearchSession#search  }.
 *
 * <p>The suggested result should only contain lowercase or special characters.
 
 * @param suggestedResult This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSuggestionResult.Builder setSuggestedResult(@android.annotation.NonNull java.lang.String suggestedResult) { throw new RuntimeException("Stub!"); }

/**
 * Build a {@link android.app.appsearch.SearchSuggestionResult SearchSuggestionResult} object
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSuggestionResult build() { throw new RuntimeException("Stub!"); }
}

}

