/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.app.appsearch;

import java.util.Set;

/**
 * A class to hold a all necessary Visibility information corresponding to the same schema. This
 * pattern allows for easier association of these documents.
 *
 * <p>This does not correspond to any schema, the properties held in this class are kept in two
 * separate schemas, VisibilityConfig and PublicAclOverlay.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class SchemaVisibilityConfig implements android.os.Parcelable {

SchemaVisibilityConfig() { throw new RuntimeException("Stub!"); }

/**
 * Returns a list of {@link android.app.appsearch.PackageIdentifier PackageIdentifier}s of packages that can access this schema.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.app.appsearch.PackageIdentifier> getAllowedPackages() { throw new RuntimeException("Stub!"); }

/**
 * Returns an array of Integers representing Android Permissions as defined in {@link android.app.appsearch.SetSchemaRequest.AppSearchSupportedPermission SetSchemaRequest.AppSearchSupportedPermission} that the caller must hold to access the schema
 * this {@link android.app.appsearch.SchemaVisibilityConfig SchemaVisibilityConfig} represents.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Set<java.util.Set<java.lang.Integer>> getRequiredPermissions() { throw new RuntimeException("Stub!"); }

/**
 * Returns the {@link android.app.appsearch.PackageIdentifier PackageIdentifier} of the package that will be used as the target package
 * in a call to {@link android.content.pm.PackageManager#canPackageQuery} to determine which
 * packages can access this publicly visible schema. Returns null if the schema is not publicly
 * visible.
 */

@android.annotation.Nullable
public android.app.appsearch.PackageIdentifier getPubliclyVisibleTargetPackage() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/** @hide */

public final int describeContents() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.app.appsearch.SchemaVisibilityConfig> CREATOR;
static { CREATOR = null; }
/** The builder class of {@link android.app.appsearch.SchemaVisibilityConfig SchemaVisibilityConfig}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/** Creates a {@link android.app.appsearch.SchemaVisibilityConfig.Builder Builder} for a {@link android.app.appsearch.SchemaVisibilityConfig SchemaVisibilityConfig}. */

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Add {@link android.app.appsearch.PackageIdentifier PackageIdentifier} of packages which has access to this schema.
 * @param packageIdentifier This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SchemaVisibilityConfig.Builder addAllowedPackage(@android.annotation.NonNull android.app.appsearch.PackageIdentifier packageIdentifier) { throw new RuntimeException("Stub!"); }

/**
 * Clears the list of packages which have access to this schema.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SchemaVisibilityConfig.Builder clearAllowedPackages() { throw new RuntimeException("Stub!"); }

/**
 * Adds a set of required Android {@link android.Manifest.permission} combination a package
 * needs to hold to access the schema this {@link android.app.appsearch.SchemaVisibilityConfig SchemaVisibilityConfig} represents.
 *
 * <p>If the querier holds ALL of the required permissions in this combination, they will
 * have access to read {@link android.app.appsearch.GenericDocument GenericDocument} objects of the given schema type.
 *
 * <p>You can call this method repeatedly to add multiple permission combinations, and the
 * querier will have access if they holds ANY of the combinations.
 *
 * <p>Merged Set available from {@link #getRequiredPermissions()}.
 *
 * @see android.app.appsearch.SetSchemaRequest.Builder#addRequiredPermissionsForSchemaTypeVisibility for supported
 *     Permissions.
 
 * @param visibleToPermissions This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SchemaVisibilityConfig.Builder addRequiredPermissions(@android.annotation.NonNull java.util.Set<java.lang.Integer> visibleToPermissions) { throw new RuntimeException("Stub!"); }

/**
 * Clears all required permissions combinations set to this {@link android.app.appsearch.SchemaVisibilityConfig SchemaVisibilityConfig}.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SchemaVisibilityConfig.Builder clearRequiredPermissions() { throw new RuntimeException("Stub!"); }

/**
 * Specify that this schema should be publicly available, to the same packages that have
 * visibility to the package passed as a parameter. This visibility is determined by the
 * result of {@link android.content.pm.PackageManager#canPackageQuery}.
 *
 * <p>It is possible for the packageIdentifier parameter to be different from the package
 * performing the indexing. This might happen in the case of an on-device indexer processing
 * information about various packages. The visibility will be the same regardless of which
 * package indexes the document, as the visibility is based on the packageIdentifier
 * parameter.
 *
 * <p>Calling this with packageIdentifier set to null is valid, and will remove public
 * visibility for the schema.
 *
 * @param packageIdentifier the {@link android.app.appsearch.PackageIdentifier PackageIdentifier} of the package that will be used
 *     as the target package in a call to {@link
 *     android.content.pm.PackageManager#canPackageQuery} to determine which packages can
 *     access this publicly visible schema.

 * This value may be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SchemaVisibilityConfig.Builder setPubliclyVisibleTargetPackage(@android.annotation.Nullable android.app.appsearch.PackageIdentifier packageIdentifier) { throw new RuntimeException("Stub!"); }

/**
 * Build a {@link android.app.appsearch.SchemaVisibilityConfig SchemaVisibilityConfig}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SchemaVisibilityConfig build() { throw new RuntimeException("Stub!"); }
}

}

