/*
 * Copyright 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.app.appsearch;


/**
 * Encapsulates a request to index documents into an {@link android.app.appsearch.AppSearchSession AppSearchSession} database.
 *
 * @see android.app.appsearch.AppSearchSession#put
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class PutDocumentsRequest {

PutDocumentsRequest() { throw new RuntimeException("Stub!"); }

/**
 * Returns a list of {@link android.app.appsearch.GenericDocument GenericDocument} objects that are part of this request.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.app.appsearch.GenericDocument> getGenericDocuments() { throw new RuntimeException("Stub!"); }

/**
 * Returns a list of {@link android.app.appsearch.GenericDocument GenericDocument} objects containing taken action metrics that are
 * part of this request.
 *
 * <p>See {@link android.app.appsearch.PutDocumentsRequest.Builder#addTakenActionGenericDocuments(android.app.appsearch.GenericDocument...) Builder#addTakenActionGenericDocuments(GenericDocument...)}.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.app.appsearch.GenericDocument> getTakenActionGenericDocuments() { throw new RuntimeException("Stub!"); }
/** Builder for {@link android.app.appsearch.PutDocumentsRequest PutDocumentsRequest} objects. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Adds one or more {@link android.app.appsearch.GenericDocument GenericDocument} objects to the request.
 * @param documents This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.PutDocumentsRequest.Builder addGenericDocuments(@android.annotation.NonNull android.app.appsearch.GenericDocument... documents) { throw new RuntimeException("Stub!"); }

/**
 * Adds a collection of {@link android.app.appsearch.GenericDocument GenericDocument} objects to the request.
 * @param documents This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.PutDocumentsRequest.Builder addGenericDocuments(@android.annotation.NonNull java.util.Collection<? extends android.app.appsearch.GenericDocument> documents) { throw new RuntimeException("Stub!"); }

/**
 * Adds one or more {@link android.app.appsearch.GenericDocument GenericDocument} objects containing taken action metrics to the
 * request.
 *
 * <p>Metrics to be collected by AppSearch:
 *
 * <ul>
 *   <li>name: STRING, the name of the taken action.
 *       <p>Name is an optional custom field that allows the client to tag and categorize
 *       taken action {@link android.app.appsearch.GenericDocument GenericDocument}.
 *   <li>referencedQualifiedId: STRING, the qualified id of the {@link android.app.appsearch.SearchResult SearchResult}
 *       document that the user takes action on.
 *       <p>A qualified id is a string generated by package, database, namespace, and
 *       document id. See {@link
 *       android.app.appsearch.util.DocumentIdUtil#createQualifiedId} for more details.
 *   <li>previousQueries: REPEATED STRING, the list of all previous user-entered search
 *       inputs, without any operators or rewriting, collected during this search session in
 *       chronological order.
 *   <li>finalQuery: STRING, the final user-entered search input (without any operators or
 *       rewriting) that yielded the {@link android.app.appsearch.SearchResult SearchResult} on which the user took action.
 *   <li>resultRankInBlock: LONG, the rank of the {@link android.app.appsearch.SearchResult SearchResult} document among the
 *       user-defined block.
 *       <p>The client can define its own custom definition for block, e.g. corpus name,
 *       group, etc.
 *       <p>For example, a client defines the block as corpus, and AppSearch returns 5
 *       documents with corpus = ["corpus1", "corpus1", "corpus2", "corpus3", "corpus2"].
 *       Then the block ranks of them = [1, 2, 1, 1, 2].
 *       <p>If the client is not presenting the results in multiple blocks, they should set
 *       this value to match resultRankGlobal.
 *   <li>resultRankGlobal: LONG, the global rank of the {@link android.app.appsearch.SearchResult SearchResult} document.
 *       <p>Global rank reflects the order of {@link android.app.appsearch.SearchResult SearchResult} documents returned by
 *       AppSearch.
 *       <p>For example, AppSearch returns 2 pages with 10 {@link android.app.appsearch.SearchResult SearchResult} documents
 *       for each page. Then the global ranks of them will be 1 to 10 for the first page,
 *       and 11 to 20 for the second page.
 *   <li>timeStayOnResultMillis: LONG, the time in milliseconds that user stays on the
 *       {@link android.app.appsearch.SearchResult SearchResult} document after clicking it.
 * </ul>
 *
 * <p>Certain anonymized information about actions reported using this API may be uploaded
 * using statsd and may be used to improve the quality of the search algorithms. Most of the
 * information in this class is already non-identifiable, such as durations and its position
 * in the result set. Identifiable information which you choose to provide, such as the
 * query string, will be anonymized using techniques like Federated Analytics to ensure only
 * the most frequently searched terms across the whole user population are retained and
 * available for study.
 *
 * <p>You can alternatively use the {@link #addGenericDocuments(android.app.appsearch.GenericDocument...)} API to
 * retain the benefits of joining and using it on-device, without triggering any of the
 * anonymized stats uploading described above.
 *
 * @param takenActionGenericDocuments one or more {@link android.app.appsearch.GenericDocument GenericDocument} objects containing
 *     taken action metric fields.
 
 * This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.PutDocumentsRequest.Builder addTakenActionGenericDocuments(@android.annotation.NonNull android.app.appsearch.GenericDocument... takenActionGenericDocuments) throws android.app.appsearch.exceptions.AppSearchException { throw new RuntimeException("Stub!"); }

/**
 * Adds a collection of {@link android.app.appsearch.GenericDocument GenericDocument} objects containing taken action metrics to
 * the request.
 *
 * @see #addTakenActionGenericDocuments(GenericDocument...)
 * @param takenActionGenericDocuments a collection of {@link android.app.appsearch.GenericDocument GenericDocument} objects
 *     containing taken action metric fields.
 
 * This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.PutDocumentsRequest.Builder addTakenActionGenericDocuments(@android.annotation.NonNull java.util.Collection<? extends android.app.appsearch.GenericDocument> takenActionGenericDocuments) throws android.app.appsearch.exceptions.AppSearchException { throw new RuntimeException("Stub!"); }

/**
 * Creates a new {@link android.app.appsearch.PutDocumentsRequest PutDocumentsRequest} object.
 *
 * @throws java.lang.IllegalArgumentException if there is any id collision between normal and action
 *     documents.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.PutDocumentsRequest build() { throw new RuntimeException("Stub!"); }
}

}

