/*
 * Copyright 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.app.appsearch;

import java.util.Map;
import java.util.Set;

/** The response class of {@link android.app.appsearch.AppSearchSession#getSchema AppSearchSession#getSchema} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class GetSchemaResponse implements android.os.Parcelable {

GetSchemaResponse() { throw new RuntimeException("Stub!"); }

/**
 * Returns the overall database schema version.
 *
 * <p>If the database is empty, 0 will be returned.

 * @return Value is 0 or greater
 */

public int getVersion() { throw new RuntimeException("Stub!"); }

/**
 * Return the schemas most recently successfully provided to {@link android.app.appsearch.AppSearchSession#setSchema AppSearchSession#setSchema}.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Set<android.app.appsearch.AppSearchSchema> getSchemas() { throw new RuntimeException("Stub!"); }

/**
 * Returns all the schema types that are opted out of being displayed and visible on any system
 * UI surface.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Set<java.lang.String> getSchemaTypesNotDisplayedBySystem() { throw new RuntimeException("Stub!"); }

/**
 * Returns a mapping of schema types to the set of packages that have access to that schema
 * type.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Map<java.lang.String,java.util.Set<android.app.appsearch.PackageIdentifier>> getSchemaTypesVisibleToPackages() { throw new RuntimeException("Stub!"); }

/**
 * Returns a mapping of schema types to the set of {@link android.Manifest.permission}
 * combination sets that querier must hold to access that schema type.
 *
 * <p>The querier could read the {@link android.app.appsearch.GenericDocument GenericDocument} objects under the {@code schemaType} if
 * they holds ALL required permissions of ANY of the individual value sets.
 *
 * <p>For example, if the Map contains {@code {% verbatim %}{{permissionA, PermissionB}, {
 * PermissionC, PermissionD}, {PermissionE}}{% endverbatim %}}.
 *
 * <ul>
 *   <li>A querier holding both PermissionA and PermissionB has access.
 *   <li>A querier holding both PermissionC and PermissionD has access.
 *   <li>A querier holding only PermissionE has access.
 *   <li>A querier holding both PermissionA and PermissionE has access.
 *   <li>A querier holding only PermissionA doesn't have access.
 *   <li>A querier holding only PermissionA and PermissionC doesn't have access.
 * </ul>
 *
 * @return The map contains schema type and all combinations of required permission for querier
 *     to access it. The supported Permission are {@link android.app.appsearch.SetSchemaRequest#READ_SMS SetSchemaRequest#READ_SMS}, {@link android.app.appsearch.SetSchemaRequest#READ_CALENDAR      }, {@link android.app.appsearch.SetSchemaRequest#READ_CONTACTS SetSchemaRequest#READ_CONTACTS}, {@link android.app.appsearch.SetSchemaRequest#READ_EXTERNAL_STORAGE      }, {@link android.app.appsearch.SetSchemaRequest#READ_HOME_APP_SEARCH_DATA      } and {@link android.app.appsearch.SetSchemaRequest#READ_ASSISTANT_APP_SEARCH_DATA      }.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Map<java.lang.String,java.util.Set<java.util.Set<java.lang.Integer>>> getRequiredPermissionsForSchemaTypeVisibility() { throw new RuntimeException("Stub!"); }

/**
 * Returns a mapping of publicly visible schemas to the {@link android.app.appsearch.PackageIdentifier PackageIdentifier} specifying the
 * package the schemas are from.
 *
 * <p>If no schemas have been set as publicly visible, an empty set will be returned.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Map<java.lang.String,android.app.appsearch.PackageIdentifier> getPubliclyVisibleSchemas() { throw new RuntimeException("Stub!"); }

/**
 * Returns a mapping of schema types to the set of {@link android.app.appsearch.SchemaVisibilityConfig SchemaVisibilityConfig} that have
 * access to that schema type.
 *
 * @see android.app.appsearch.SetSchemaRequest.Builder#addSchemaTypeVisibleToConfig

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Map<java.lang.String,java.util.Set<android.app.appsearch.SchemaVisibilityConfig>> getSchemaTypesVisibleToConfigs() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

/** @hide */

public final int describeContents() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.app.appsearch.GetSchemaResponse> CREATOR;
static { CREATOR = null; }
/** Builder for {@link android.app.appsearch.GetSchemaResponse GetSchemaResponse} objects. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/** Create a {@link android.app.appsearch.GetSchemaResponse.Builder Builder} object} */

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Sets the database overall schema version.
 *
 * <p>Default version is 0
 
 * @param version Value is 0 or greater
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.GetSchemaResponse.Builder setVersion(int version) { throw new RuntimeException("Stub!"); }

/**
 * Adds one {@link android.app.appsearch.AppSearchSchema AppSearchSchema} to the schema list.
 * @param schema This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.GetSchemaResponse.Builder addSchema(@android.annotation.NonNull android.app.appsearch.AppSearchSchema schema) { throw new RuntimeException("Stub!"); }

/**
 * Sets whether or not documents from the provided {@code schemaType} will be displayed and
 * visible on any system UI surface.
 *
 * @param schemaType The name of an {@link android.app.appsearch.AppSearchSchema AppSearchSchema} within the same {@link android.app.appsearch.GetSchemaResponse GetSchemaResponse}, which won't be displayed by system.
 
 * This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.GetSchemaResponse.Builder addSchemaTypeNotDisplayedBySystem(@android.annotation.NonNull java.lang.String schemaType) { throw new RuntimeException("Stub!"); }

/**
 * Sets whether or not documents from the provided {@code schemaType} can be read by the
 * specified package.
 *
 * <p>Each package is represented by a {@link android.app.appsearch.PackageIdentifier PackageIdentifier}, containing a package name
 * and a byte array of type {@link android.content.pm.PackageManager#CERT_INPUT_SHA256}.
 *
 * <p>To opt into one-way data sharing with another application, the developer will need to
 * explicitly grant the other application’s package name and certificate Read access to its
 * data.
 *
 * <p>For two-way data sharing, both applications need to explicitly grant Read access to
 * one another.
 *
 * @param schemaType The schema type to set visibility on.
 * This value cannot be {@code null}.
 * @param packageIdentifiers Represents the package that has access to the given schema
 *     type.
 
 * This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.GetSchemaResponse.Builder setSchemaTypeVisibleToPackages(@android.annotation.NonNull java.lang.String schemaType, @android.annotation.NonNull java.util.Set<android.app.appsearch.PackageIdentifier> packageIdentifiers) { throw new RuntimeException("Stub!"); }

/**
 * Sets a set of required {@link android.Manifest.permission} combinations to the given
 * schema type.
 *
 * <p>The querier could read the {@link android.app.appsearch.GenericDocument GenericDocument} objects under the {@code
 * schemaType} if they holds ALL required permissions of ANY of the individual value sets.
 *
 * <p>For example, if the Map contains {@code {% verbatim %}{{permissionA, PermissionB},
 * {PermissionC, PermissionD}, {PermissionE}}{% endverbatim %}}.
 *
 * <ul>
 *   <li>A querier holds both PermissionA and PermissionB has access.
 *   <li>A querier holds both PermissionC and PermissionD has access.
 *   <li>A querier holds only PermissionE has access.
 *   <li>A querier holds both PermissionA and PermissionE has access.
 *   <li>A querier holds only PermissionA doesn't have access.
 *   <li>A querier holds both PermissionA and PermissionC doesn't have access.
 * </ul>
 *
 * @param schemaType The schema type to set visibility on.
 * This value cannot be {@code null}.
 * @param visibleToPermissionSets The Sets of Android permissions that will be required to
 *     access the given schema.
 * Value is {@link android.app.appsearch.SetSchemaRequest#READ_SMS}, {@link android.app.appsearch.SetSchemaRequest#READ_CALENDAR}, {@link android.app.appsearch.SetSchemaRequest#READ_CONTACTS}, {@link android.app.appsearch.SetSchemaRequest#READ_EXTERNAL_STORAGE}, {@link android.app.appsearch.SetSchemaRequest#READ_HOME_APP_SEARCH_DATA}, {@link android.app.appsearch.SetSchemaRequest#READ_ASSISTANT_APP_SEARCH_DATA}, android.app.appsearch.SetSchemaRequest.ENTERPRISE_ACCESS, or android.app.appsearch.SetSchemaRequest.MANAGED_PROFILE_CONTACTS_ACCESS
 * This value cannot be {@code null}.
 * @see android.Manifest.permission#READ_SMS
 * @see android.Manifest.permission#READ_CALENDAR
 * @see android.Manifest.permission#READ_CONTACTS
 * @see android.Manifest.permission#READ_EXTERNAL_STORAGE
 * @see android.Manifest.permission#READ_HOME_APP_SEARCH_DATA
 * @see android.Manifest.permission#READ_ASSISTANT_APP_SEARCH_DATA
 
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.GetSchemaResponse.Builder setRequiredPermissionsForSchemaTypeVisibility(@android.annotation.NonNull java.lang.String schemaType, @android.annotation.NonNull java.util.Set<java.util.Set<java.lang.Integer>> visibleToPermissionSets) { throw new RuntimeException("Stub!"); }

/**
 * Specify that the schema should be publicly available, to packages which already have
 * visibility to {@code packageIdentifier}.
 *
 * @param schemaType the schema to make publicly accessible.
 * This value cannot be {@code null}.
 * @param packageIdentifier the package from which the document schema is from.
 * This value cannot be {@code null}.
 * @see android.app.appsearch.SetSchemaRequest.Builder#setPubliclyVisibleSchema
 
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.GetSchemaResponse.Builder setPubliclyVisibleSchema(@android.annotation.NonNull java.lang.String schemaType, @android.annotation.NonNull android.app.appsearch.PackageIdentifier packageIdentifier) { throw new RuntimeException("Stub!"); }

/**
 * Sets the documents from the provided {@code schemaType} can be read by the caller if they
 * match the ALL visibility requirements set in {@link android.app.appsearch.SchemaVisibilityConfig SchemaVisibilityConfig}.
 *
 * <p>The requirements in a {@link android.app.appsearch.SchemaVisibilityConfig SchemaVisibilityConfig} is "AND" relationship. A caller
 * must match ALL requirements to access the schema. For example, a caller must hold
 * required permissions AND it is a specified package.
 *
 * <p>The querier could have access if they match ALL requirements in ANY of the given
 * {@link android.app.appsearch.SchemaVisibilityConfig SchemaVisibilityConfig}s
 *
 * <p>For example, if the Set contains {@code {% verbatim %}{{PackageA and Permission1},
 * {PackageB and Permission2}}{% endverbatim %}}.
 *
 * <ul>
 *   <li>A querier from packageA could read if they holds Permission1.
 *   <li>A querier from packageA could NOT read if they only holds Permission2 instead of
 *       Permission1.
 *   <li>A querier from packageB could read if they holds Permission2.
 *   <li>A querier from packageC could never read.
 *   <li>A querier holds both PermissionA and PermissionE has access.
 * </ul>
 *
 * @param schemaType The schema type to set visibility on.
 * This value cannot be {@code null}.
 * @param visibleToConfigs The {@link android.app.appsearch.SchemaVisibilityConfig SchemaVisibilityConfig}s hold all requirements that a
 *     call must to match to access the schema.
 
 * This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.GetSchemaResponse.Builder setSchemaTypeVisibleToConfigs(@android.annotation.NonNull java.lang.String schemaType, @android.annotation.NonNull java.util.Set<android.app.appsearch.SchemaVisibilityConfig> visibleToConfigs) { throw new RuntimeException("Stub!"); }

/**
 * Builds a {@link android.app.appsearch.GetSchemaResponse GetSchemaResponse} object.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.GetSchemaResponse build() { throw new RuntimeException("Stub!"); }
}

}

