/*
 * Copyright 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.app.appsearch;

import java.util.Map;

/**
 * Encapsulates a request to retrieve documents by namespace and IDs from the {@link android.app.appsearch.AppSearchSession AppSearchSession} database.
 *
 * @see android.app.appsearch.AppSearchSession#getByDocumentId
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class GetByDocumentIdRequest implements android.os.Parcelable {

GetByDocumentIdRequest() { throw new RuntimeException("Stub!"); }

/**
 * Returns the namespace attached to the request.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getNamespace() { throw new RuntimeException("Stub!"); }

/**
 * Returns the set of document IDs attached to the request.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Set<java.lang.String> getIds() { throw new RuntimeException("Stub!"); }

/**
 * Returns a map from schema type to property paths to be used for projection.
 *
 * <p>If the map is empty, then all properties will be retrieved for all results.
 *
 * <p>Calling this function repeatedly is inefficient. Prefer to retain the Map returned by this
 * function, rather than calling it multiple times.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Map<java.lang.String,java.util.List<java.lang.String>> getProjections() { throw new RuntimeException("Stub!"); }

/**
 * Returns a map from schema type to property paths to be used for projection.
 *
 * <p>If the map is empty, then all properties will be retrieved for all results.
 *
 * <p>Calling this function repeatedly is inefficient. Prefer to retain the Map returned by this
 * function, rather than calling it multiple times.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Map<java.lang.String,java.util.List<android.app.appsearch.PropertyPath>> getProjectionPaths() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

/** @hide */

public final int describeContents() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.app.appsearch.GetByDocumentIdRequest> CREATOR;
static { CREATOR = null; }

/**
 * Schema type to be used in {@link android.app.appsearch.GetByDocumentIdRequest.Builder#addProjection GetByDocumentIdRequest.Builder#addProjection} to apply
 * property paths to all results, excepting any types that have had their own, specific property
 * paths set.
 */

public static final java.lang.String PROJECTION_SCHEMA_TYPE_WILDCARD = "*";
/** Builder for {@link android.app.appsearch.GetByDocumentIdRequest GetByDocumentIdRequest} objects. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Creates a {@link android.app.appsearch.GetByDocumentIdRequest.Builder GetByDocumentIdRequest.Builder} instance.
 * @param namespace This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull java.lang.String namespace) { throw new RuntimeException("Stub!"); }

/**
 * Adds one or more document IDs to the request.
 * @param ids This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.GetByDocumentIdRequest.Builder addIds(@android.annotation.NonNull java.lang.String... ids) { throw new RuntimeException("Stub!"); }

/**
 * Adds a collection of IDs to the request.
 * @param ids This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.GetByDocumentIdRequest.Builder addIds(@android.annotation.NonNull java.util.Collection<java.lang.String> ids) { throw new RuntimeException("Stub!"); }

/**
 * Adds property paths for the specified type to be used for projection. If property paths
 * are added for a type, then only the properties referred to will be retrieved for results
 * of that type. If a property path that is specified isn't present in a result, it will be
 * ignored for that result. Property paths cannot be null.
 *
 * <p>If no property paths are added for a particular type, then all properties of results
 * of that type will be retrieved.
 *
 * <p>If property path is added for the {@link android.app.appsearch.GetByDocumentIdRequest#PROJECTION_SCHEMA_TYPE_WILDCARD  }, then those property paths will
 * apply to all results, excepting any types that have their own, specific property paths
 * set.
 *
 * @see android.app.appsearch.SearchSpec.Builder#addProjectionPaths
 
 * @param schemaType This value cannot be {@code null}.

 * @param propertyPaths This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.GetByDocumentIdRequest.Builder addProjection(@android.annotation.NonNull java.lang.String schemaType, @android.annotation.NonNull java.util.Collection<java.lang.String> propertyPaths) { throw new RuntimeException("Stub!"); }

/**
 * Adds property paths for the specified type to be used for projection. If property paths
 * are added for a type, then only the properties referred to will be retrieved for results
 * of that type. If a property path that is specified isn't present in a result, it will be
 * ignored for that result. Property paths cannot be null.
 *
 * <p>If no property paths are added for a particular type, then all properties of results
 * of that type will be retrieved.
 *
 * <p>If property path is added for the {@link android.app.appsearch.GetByDocumentIdRequest#PROJECTION_SCHEMA_TYPE_WILDCARD  }, then those property paths will
 * apply to all results, excepting any types that have their own, specific property paths
 * set.
 *
 * @see android.app.appsearch.SearchSpec.Builder#addProjectionPaths
 
 * @param schemaType This value cannot be {@code null}.

 * @param propertyPaths This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.GetByDocumentIdRequest.Builder addProjectionPaths(@android.annotation.NonNull java.lang.String schemaType, @android.annotation.NonNull java.util.Collection<android.app.appsearch.PropertyPath> propertyPaths) { throw new RuntimeException("Stub!"); }

/**
 * Builds a new {@link android.app.appsearch.GetByDocumentIdRequest GetByDocumentIdRequest}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.GetByDocumentIdRequest build() { throw new RuntimeException("Stub!"); }
}

}

