/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.app.appsearch;

import java.util.concurrent.Executor;

/**
 * Provides a connection to the work profile's AppSearch databases that explicitly allow access from
 * enterprise sessions. Databases may have additional required permissions and restricted fields
 * when accessed through an enterprise session that they normally would not have.
 *
 * <p>EnterpriseGlobalSearchSession will only return results when created from the main user context
 * and when there is an associated work profile. If the given context is either not the main user or
 * does not have a work profile, queries will successfully complete with empty results, allowing
 * clients to query the work profile without having to account for whether it exists or not.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class EnterpriseGlobalSearchSession {

EnterpriseGlobalSearchSession() { throw new RuntimeException("Stub!"); }

/**
 * Retrieves documents from all AppSearch databases that the querying application has access to.
 *
 * <p>Applications can be granted access to documents by specifying {@link android.app.appsearch.SetSchemaRequest.Builder#setSchemaTypeVisibilityForPackage  } when building a schema.
 *
 * <p>Document access can also be granted to system UIs by specifying {@link android.app.appsearch.SetSchemaRequest.Builder#setSchemaTypeDisplayedBySystem  } when building a schema.
 *
 * <p>See {@link android.app.appsearch.AppSearchSession#search AppSearchSession#search} for a detailed explanation on forming a query string.
 *
 * <p>This method is lightweight. The heavy work will be done in {@link android.app.appsearch.SearchResults#getNextPage  }.
 *
 * @param queryExpression query string to search.
 * This value cannot be {@code null}.
 * @param searchSpec spec for setting document filters, adding projection, setting term match
 *     type, etc.
 * This value cannot be {@code null}.
 * @return a {@link android.app.appsearch.SearchResults SearchResults} object for retrieved matched documents.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchResults search(@android.annotation.NonNull java.lang.String queryExpression, @android.annotation.NonNull android.app.appsearch.SearchSpec searchSpec) { throw new RuntimeException("Stub!"); }

/**
 * Retrieves {@link android.app.appsearch.GenericDocument GenericDocument} documents, belonging to the specified package name and
 * database name and identified by the namespace and ids in the request, from the {@link android.app.appsearch.GlobalSearchSession GlobalSearchSession} database.
 *
 * <p>If the package or database doesn't exist or if the calling package doesn't have access,
 * the gets will be handled as failures in an {@link android.app.appsearch.AppSearchBatchResult AppSearchBatchResult} object in the
 * callback.
 *
 * @param packageName the name of the package to get from
 * This value cannot be {@code null}.
 * @param databaseName the name of the database to get from
 * This value cannot be {@code null}.
 * @param request a request containing a namespace and IDs to get documents for.
 * This value cannot be {@code null}.
 * @param executor Executor on which to invoke the callback.
 * This value cannot be {@code null}.
 * Callback and listener events are dispatched through this
 * {@link java.util.concurrent.Executor Executor}, providing an easy way to control which thread is
 * used. To dispatch events through the main thread of your
 * application, you can use
 * {@link android.content.Context#getMainExecutor() Context.getMainExecutor()}.
 * Otherwise, provide an {@link java.util.concurrent.Executor Executor} that dispatches to an appropriate thread.
 * @param callback Callback to receive the pending result of performing this operation. The keys
 *     of the returned {@link android.app.appsearch.AppSearchBatchResult AppSearchBatchResult} are the input IDs. The values are the
 *     returned {@link android.app.appsearch.GenericDocument GenericDocument}s on success, or a failed {@link android.app.appsearch.AppSearchResult AppSearchResult}
 *     otherwise. IDs that are not found will return a failed {@link android.app.appsearch.AppSearchResult AppSearchResult} with a
 *     result code of {@link android.app.appsearch.AppSearchResult#RESULT_NOT_FOUND AppSearchResult#RESULT_NOT_FOUND}. If an unexpected internal error
 *     occurs in the AppSearch service, {@link android.app.appsearch.BatchResultCallback#onSystemError BatchResultCallback#onSystemError} will be
 *     invoked with a {@link java.lang.Throwable Throwable}.

 * This value cannot be {@code null}.
 */

public void getByDocumentId(@android.annotation.NonNull java.lang.String packageName, @android.annotation.NonNull java.lang.String databaseName, @android.annotation.NonNull android.app.appsearch.GetByDocumentIdRequest request, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.app.appsearch.BatchResultCallback<java.lang.String,android.app.appsearch.GenericDocument> callback) { throw new RuntimeException("Stub!"); }

/**
 * Retrieves the collection of schemas most recently successfully provided to {@link android.app.appsearch.AppSearchSession#setSchema  } for any types belonging to the requested package and database
 * that the caller has been granted access to.
 *
 * <p>If the requested package/database combination does not exist or the caller has not been
 * granted access to it, then an empty GetSchemaResponse will be returned.
 *
 * @param packageName the package that owns the requested {@link android.app.appsearch.AppSearchSchema AppSearchSchema} instances.
 * This value cannot be {@code null}.
 * @param databaseName the database that owns the requested {@link android.app.appsearch.AppSearchSchema AppSearchSchema} instances.
 * This value cannot be {@code null}.
 * @param executor Executor on which to invoke the callback.
 * This value cannot be {@code null}.
 * Callback and listener events are dispatched through this
 * {@link java.util.concurrent.Executor Executor}, providing an easy way to control which thread is
 * used. To dispatch events through the main thread of your
 * application, you can use
 * {@link android.content.Context#getMainExecutor() Context.getMainExecutor()}.
 * Otherwise, provide an {@link java.util.concurrent.Executor Executor} that dispatches to an appropriate thread.
 * @param callback The pending {@link android.app.appsearch.GetSchemaResponse GetSchemaResponse} containing the schemas that the caller
 *     has access to or an empty GetSchemaResponse if the request package and database does not
 *     exist, has not set a schema or contains no schemas that are accessible to the caller.

 * This value cannot be {@code null}.
 */

public void getSchema(@android.annotation.NonNull java.lang.String packageName, @android.annotation.NonNull java.lang.String databaseName, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull java.util.function.Consumer<android.app.appsearch.AppSearchResult<android.app.appsearch.GetSchemaResponse>> callback) { throw new RuntimeException("Stub!"); }
}

