/*
 * Copyright 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.app.appsearch;


/**
 * Information about the success or failure of an AppSearch call.
 *
 * @param <ValueType> The type of result object for successful calls.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class AppSearchResult<ValueType> {

AppSearchResult() { throw new RuntimeException("Stub!"); }

/** Returns {@code true} if {@link #getResultCode} equals {@link android.app.appsearch.AppSearchResult#RESULT_OK AppSearchResult#RESULT_OK}. */

public boolean isSuccess() { throw new RuntimeException("Stub!"); }

/**
 * Returns one of the {@code RESULT} constants defined in {@link android.app.appsearch.AppSearchResult AppSearchResult}.
 * @return Value is {@link android.app.appsearch.AppSearchResult#RESULT_OK}, {@link android.app.appsearch.AppSearchResult#RESULT_UNKNOWN_ERROR}, {@link android.app.appsearch.AppSearchResult#RESULT_INTERNAL_ERROR}, {@link android.app.appsearch.AppSearchResult#RESULT_INVALID_ARGUMENT}, {@link android.app.appsearch.AppSearchResult#RESULT_IO_ERROR}, {@link android.app.appsearch.AppSearchResult#RESULT_OUT_OF_SPACE}, {@link android.app.appsearch.AppSearchResult#RESULT_NOT_FOUND}, {@link android.app.appsearch.AppSearchResult#RESULT_INVALID_SCHEMA}, {@link android.app.appsearch.AppSearchResult#RESULT_SECURITY_ERROR}, {@link android.app.appsearch.AppSearchResult#RESULT_DENIED}, {@link android.app.appsearch.AppSearchResult#RESULT_RATE_LIMITED}, or android.app.appsearch.AppSearchResult.RESULT_TIMED_OUT
 */

public int getResultCode() { throw new RuntimeException("Stub!"); }

/**
 * Returns the result value associated with this result, if it was successful.
 *
 * <p>See the documentation of the particular {@link android.app.appsearch.AppSearchSession AppSearchSession} call producing this
 * {@link android.app.appsearch.AppSearchResult AppSearchResult} for what is placed in the result value by that call.
 *
 * @throws java.lang.IllegalStateException if this {@link android.app.appsearch.AppSearchResult AppSearchResult} is not successful.

 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public ValueType getResultValue() { throw new RuntimeException("Stub!"); }

/**
 * Returns the error message associated with this result.
 *
 * <p>If {@link #isSuccess} is {@code true}, the error message is always {@code null}. The error
 * message may be {@code null} even if {@link #isSuccess} is {@code false}. See the
 * documentation of the particular {@link android.app.appsearch.AppSearchSession AppSearchSession} call producing this {@link android.app.appsearch.AppSearchResult AppSearchResult} for what is returned by {@link #getErrorMessage}.
 */

@android.annotation.Nullable
public java.lang.String getErrorMessage() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param other This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object other) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * Creates a new successful {@link android.app.appsearch.AppSearchResult AppSearchResult}.
 *
 * @param value An optional value to associate with the successful result of the operation being
 *     performed.
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public static <ValueType> android.app.appsearch.AppSearchResult<ValueType> newSuccessfulResult(@android.annotation.Nullable ValueType value) { throw new RuntimeException("Stub!"); }

/**
 * Creates a new failed {@link android.app.appsearch.AppSearchResult AppSearchResult}.
 *
 * @param resultCode One of the constants documented in {@link android.app.appsearch.AppSearchResult#getResultCode AppSearchResult#getResultCode}.
 * Value is {@link android.app.appsearch.AppSearchResult#RESULT_OK}, {@link android.app.appsearch.AppSearchResult#RESULT_UNKNOWN_ERROR}, {@link android.app.appsearch.AppSearchResult#RESULT_INTERNAL_ERROR}, {@link android.app.appsearch.AppSearchResult#RESULT_INVALID_ARGUMENT}, {@link android.app.appsearch.AppSearchResult#RESULT_IO_ERROR}, {@link android.app.appsearch.AppSearchResult#RESULT_OUT_OF_SPACE}, {@link android.app.appsearch.AppSearchResult#RESULT_NOT_FOUND}, {@link android.app.appsearch.AppSearchResult#RESULT_INVALID_SCHEMA}, {@link android.app.appsearch.AppSearchResult#RESULT_SECURITY_ERROR}, {@link android.app.appsearch.AppSearchResult#RESULT_DENIED}, {@link android.app.appsearch.AppSearchResult#RESULT_RATE_LIMITED}, or android.app.appsearch.AppSearchResult.RESULT_TIMED_OUT
 * @param errorMessage An optional string describing the reason or nature of the failure.
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public static <ValueType> android.app.appsearch.AppSearchResult<ValueType> newFailedResult(int resultCode, @android.annotation.Nullable java.lang.String errorMessage) { throw new RuntimeException("Stub!"); }

/**
 * The requested operation is denied for the caller. This error is logged and returned for
 * denylist rejections.
 */

public static final int RESULT_DENIED = 9; // 0x9

/**
 * An internal error occurred within AppSearch, which the caller cannot address.
 *
 * <p>This error may be considered similar to {@link java.lang.IllegalStateException IllegalStateException}
 */

public static final int RESULT_INTERNAL_ERROR = 2; // 0x2

/**
 * The caller supplied invalid arguments to the call.
 *
 * <p>This error may be considered similar to {@link java.lang.IllegalArgumentException IllegalArgumentException}.
 */

public static final int RESULT_INVALID_ARGUMENT = 3; // 0x3

/** The caller supplied a schema which is invalid or incompatible with the previous schema. */

public static final int RESULT_INVALID_SCHEMA = 7; // 0x7

/**
 * An issue occurred reading or writing to storage. The call might succeed if repeated.
 *
 * <p>This error may be considered similar to {@link java.io.IOException}.
 */

public static final int RESULT_IO_ERROR = 4; // 0x4

/** An entity the caller requested to interact with does not exist in the system. */

public static final int RESULT_NOT_FOUND = 6; // 0x6

/** The call was successful. */

public static final int RESULT_OK = 0; // 0x0

/** Storage is out of space, and no more space could be reclaimed. */

public static final int RESULT_OUT_OF_SPACE = 5; // 0x5

/**
 * The caller has hit AppSearch's rate limit and the requested operation has been rejected. The
 * caller is recommended to reschedule tasks with exponential backoff.
 */

public static final int RESULT_RATE_LIMITED = 10; // 0xa

/** The caller requested an operation it does not have privileges for. */

public static final int RESULT_SECURITY_ERROR = 8; // 0x8

/** An unknown error occurred while processing the call. */

public static final int RESULT_UNKNOWN_ERROR = 1; // 0x1
}

