/*
 * Copyright (C) 2010 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.app.admin;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class DevicePolicyManager {

DevicePolicyManager() { throw new RuntimeException("Stub!"); }

public void setMtePolicy(int policy) { throw new RuntimeException("Stub!"); }

public int getMtePolicy() { throw new RuntimeException("Stub!"); }

public static boolean isMtePolicyEnforced() { throw new RuntimeException("Stub!"); }

public void setContentProtectionPolicy(@android.annotation.Nullable android.content.ComponentName admin, int policy) { throw new RuntimeException("Stub!"); }

public int getContentProtectionPolicy(@android.annotation.Nullable android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public boolean isSafeOperation(int reason) { throw new RuntimeException("Stub!"); }

public boolean isAdminActive(@android.annotation.NonNull android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.util.List<android.content.ComponentName> getActiveAdmins() { throw new RuntimeException("Stub!"); }

public void removeActiveAdmin(@android.annotation.NonNull android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public boolean hasGrantedPolicy(@android.annotation.NonNull android.content.ComponentName admin, int usesPolicy) { throw new RuntimeException("Stub!"); }

@Deprecated
public void setPasswordQuality(@android.annotation.NonNull android.content.ComponentName admin, int quality) { throw new RuntimeException("Stub!"); }

@Deprecated
public int getPasswordQuality(@android.annotation.Nullable android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

@Deprecated
public void setPasswordMinimumLength(@android.annotation.NonNull android.content.ComponentName admin, int length) { throw new RuntimeException("Stub!"); }

@Deprecated
public int getPasswordMinimumLength(@android.annotation.Nullable android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

@Deprecated
public void setPasswordMinimumUpperCase(@android.annotation.NonNull android.content.ComponentName admin, int length) { throw new RuntimeException("Stub!"); }

@Deprecated
public int getPasswordMinimumUpperCase(@android.annotation.Nullable android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

@Deprecated
public void setPasswordMinimumLowerCase(@android.annotation.NonNull android.content.ComponentName admin, int length) { throw new RuntimeException("Stub!"); }

@Deprecated
public int getPasswordMinimumLowerCase(@android.annotation.Nullable android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

@Deprecated
public void setPasswordMinimumLetters(@android.annotation.NonNull android.content.ComponentName admin, int length) { throw new RuntimeException("Stub!"); }

@Deprecated
public int getPasswordMinimumLetters(@android.annotation.Nullable android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

@Deprecated
public void setPasswordMinimumNumeric(@android.annotation.NonNull android.content.ComponentName admin, int length) { throw new RuntimeException("Stub!"); }

@Deprecated
public int getPasswordMinimumNumeric(@android.annotation.Nullable android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

@Deprecated
public void setPasswordMinimumSymbols(@android.annotation.NonNull android.content.ComponentName admin, int length) { throw new RuntimeException("Stub!"); }

@Deprecated
public int getPasswordMinimumSymbols(@android.annotation.Nullable android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

@Deprecated
public void setPasswordMinimumNonLetter(@android.annotation.NonNull android.content.ComponentName admin, int length) { throw new RuntimeException("Stub!"); }

@Deprecated
public int getPasswordMinimumNonLetter(@android.annotation.Nullable android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public void setPasswordHistoryLength(@android.annotation.NonNull android.content.ComponentName admin, int length) { throw new RuntimeException("Stub!"); }

public void setPasswordExpirationTimeout(@android.annotation.Nullable android.content.ComponentName admin, long timeout) { throw new RuntimeException("Stub!"); }

public long getPasswordExpirationTimeout(@android.annotation.Nullable android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public long getPasswordExpiration(@android.annotation.Nullable android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public int getPasswordHistoryLength(@android.annotation.Nullable android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public int getPasswordMaximumLength(int quality) { throw new RuntimeException("Stub!"); }

public boolean isActivePasswordSufficient() { throw new RuntimeException("Stub!"); }

public boolean isActivePasswordSufficientForDeviceRequirement() { throw new RuntimeException("Stub!"); }

public int getPasswordComplexity() { throw new RuntimeException("Stub!"); }

public void setRequiredPasswordComplexity(int passwordComplexity) { throw new RuntimeException("Stub!"); }

public int getRequiredPasswordComplexity() { throw new RuntimeException("Stub!"); }

public boolean isUsingUnifiedPassword(@android.annotation.NonNull android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public int getCurrentFailedPasswordAttempts() { throw new RuntimeException("Stub!"); }

public void setMaximumFailedPasswordsForWipe(@android.annotation.Nullable android.content.ComponentName admin, int num) { throw new RuntimeException("Stub!"); }

public int getMaximumFailedPasswordsForWipe(@android.annotation.Nullable android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean resetPassword(java.lang.String password, int flags) { throw new RuntimeException("Stub!"); }

public boolean setResetPasswordToken(@android.annotation.Nullable android.content.ComponentName admin, byte[] token) { throw new RuntimeException("Stub!"); }

public boolean clearResetPasswordToken(@android.annotation.Nullable android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public boolean isResetPasswordTokenActive(@android.annotation.Nullable android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public boolean resetPasswordWithToken(@android.annotation.Nullable android.content.ComponentName admin, java.lang.String password, byte[] token, int flags) { throw new RuntimeException("Stub!"); }

public void setMaximumTimeToLock(@android.annotation.Nullable android.content.ComponentName admin, long timeMs) { throw new RuntimeException("Stub!"); }

public long getMaximumTimeToLock(@android.annotation.Nullable android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public void setRequiredStrongAuthTimeout(@android.annotation.Nullable android.content.ComponentName admin, long timeoutMs) { throw new RuntimeException("Stub!"); }

public long getRequiredStrongAuthTimeout(@android.annotation.Nullable android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public void lockNow() { throw new RuntimeException("Stub!"); }

public void lockNow(int flags) { throw new RuntimeException("Stub!"); }

public void wipeData(int flags) { throw new RuntimeException("Stub!"); }

public void wipeData(int flags, @android.annotation.NonNull java.lang.CharSequence reason) { throw new RuntimeException("Stub!"); }

public void wipeDevice(int flags) { throw new RuntimeException("Stub!"); }

public void setFactoryResetProtectionPolicy(@android.annotation.Nullable android.content.ComponentName admin, @android.annotation.Nullable android.app.admin.FactoryResetProtectionPolicy policy) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.app.admin.FactoryResetProtectionPolicy getFactoryResetProtectionPolicy(@android.annotation.Nullable android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public void setRecommendedGlobalProxy(@android.annotation.NonNull android.content.ComponentName admin, @android.annotation.Nullable android.net.ProxyInfo proxyInfo) { throw new RuntimeException("Stub!"); }

@Deprecated
public int setStorageEncryption(@android.annotation.NonNull android.content.ComponentName admin, boolean encrypt) { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean getStorageEncryption(@android.annotation.Nullable android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public int getStorageEncryptionStatus() { throw new RuntimeException("Stub!"); }

public boolean installCaCert(@android.annotation.Nullable android.content.ComponentName admin, byte[] certBuffer) { throw new RuntimeException("Stub!"); }

public void uninstallCaCert(@android.annotation.Nullable android.content.ComponentName admin, byte[] certBuffer) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<byte[]> getInstalledCaCerts(@android.annotation.Nullable android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public void uninstallAllUserCaCerts(@android.annotation.Nullable android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public boolean hasCaCertInstalled(@android.annotation.Nullable android.content.ComponentName admin, byte[] certBuffer) { throw new RuntimeException("Stub!"); }

public boolean installKeyPair(@android.annotation.Nullable android.content.ComponentName admin, @android.annotation.NonNull java.security.PrivateKey privKey, @android.annotation.NonNull java.security.cert.Certificate cert, @android.annotation.NonNull java.lang.String alias) { throw new RuntimeException("Stub!"); }

public boolean installKeyPair(@android.annotation.Nullable android.content.ComponentName admin, @android.annotation.NonNull java.security.PrivateKey privKey, @android.annotation.NonNull java.security.cert.Certificate[] certs, @android.annotation.NonNull java.lang.String alias, boolean requestAccess) { throw new RuntimeException("Stub!"); }

public boolean installKeyPair(@android.annotation.Nullable android.content.ComponentName admin, @android.annotation.NonNull java.security.PrivateKey privKey, @android.annotation.NonNull java.security.cert.Certificate[] certs, @android.annotation.NonNull java.lang.String alias, int flags) { throw new RuntimeException("Stub!"); }

public boolean removeKeyPair(@android.annotation.Nullable android.content.ComponentName admin, @android.annotation.NonNull java.lang.String alias) { throw new RuntimeException("Stub!"); }

public boolean hasKeyPair(@android.annotation.NonNull java.lang.String alias) { throw new RuntimeException("Stub!"); }

public android.security.AttestedKeyPair generateKeyPair(@android.annotation.Nullable android.content.ComponentName admin, @android.annotation.NonNull java.lang.String algorithm, @android.annotation.NonNull android.security.keystore.KeyGenParameterSpec keySpec, int idAttestationFlags) { throw new RuntimeException("Stub!"); }

public boolean grantKeyPairToApp(@android.annotation.Nullable android.content.ComponentName admin, @android.annotation.NonNull java.lang.String alias, @android.annotation.NonNull java.lang.String packageName) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.Map<java.lang.Integer,java.util.Set<java.lang.String>> getKeyPairGrants(@android.annotation.NonNull java.lang.String alias) { throw new RuntimeException("Stub!"); }

public boolean revokeKeyPairFromApp(@android.annotation.Nullable android.content.ComponentName admin, @android.annotation.NonNull java.lang.String alias, @android.annotation.NonNull java.lang.String packageName) { throw new RuntimeException("Stub!"); }

public boolean grantKeyPairToWifiAuth(@android.annotation.NonNull java.lang.String alias) { throw new RuntimeException("Stub!"); }

public boolean revokeKeyPairFromWifiAuth(@android.annotation.NonNull java.lang.String alias) { throw new RuntimeException("Stub!"); }

public boolean isKeyPairGrantedToWifiAuth(@android.annotation.NonNull java.lang.String alias) { throw new RuntimeException("Stub!"); }

public boolean isDeviceIdAttestationSupported() { throw new RuntimeException("Stub!"); }

public boolean isUniqueDeviceAttestationSupported() { throw new RuntimeException("Stub!"); }

public boolean setKeyPairCertificate(@android.annotation.Nullable android.content.ComponentName admin, @android.annotation.NonNull java.lang.String alias, @android.annotation.NonNull java.util.List<java.security.cert.Certificate> certs, boolean isUserSelectable) { throw new RuntimeException("Stub!"); }

@Deprecated
public void setCertInstallerPackage(@android.annotation.NonNull android.content.ComponentName admin, @android.annotation.Nullable java.lang.String installerPackage) throws java.lang.SecurityException { throw new RuntimeException("Stub!"); }

@Deprecated
@android.annotation.Nullable
public java.lang.String getCertInstallerPackage(@android.annotation.NonNull android.content.ComponentName admin) throws java.lang.SecurityException { throw new RuntimeException("Stub!"); }

public void setDelegatedScopes(@android.annotation.NonNull android.content.ComponentName admin, @android.annotation.NonNull java.lang.String delegatePackage, @android.annotation.NonNull java.util.List<java.lang.String> scopes) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<java.lang.String> getDelegatedScopes(@android.annotation.Nullable android.content.ComponentName admin, @android.annotation.NonNull java.lang.String delegatedPackage) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.util.List<java.lang.String> getDelegatePackages(@android.annotation.NonNull android.content.ComponentName admin, @android.annotation.NonNull java.lang.String delegationScope) { throw new RuntimeException("Stub!"); }

public void setAlwaysOnVpnPackage(@android.annotation.NonNull android.content.ComponentName admin, @android.annotation.Nullable java.lang.String vpnPackage, boolean lockdownEnabled) throws android.content.pm.PackageManager.NameNotFoundException { throw new RuntimeException("Stub!"); }

public void setAlwaysOnVpnPackage(@android.annotation.NonNull android.content.ComponentName admin, @android.annotation.Nullable java.lang.String vpnPackage, boolean lockdownEnabled, @android.annotation.Nullable java.util.Set<java.lang.String> lockdownAllowlist) throws android.content.pm.PackageManager.NameNotFoundException { throw new RuntimeException("Stub!"); }

public boolean isAlwaysOnVpnLockdownEnabled(@android.annotation.NonNull android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.util.Set<java.lang.String> getAlwaysOnVpnLockdownWhitelist(@android.annotation.NonNull android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getAlwaysOnVpnPackage(@android.annotation.NonNull android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public void setCameraDisabled(@android.annotation.Nullable android.content.ComponentName admin, boolean disabled) { throw new RuntimeException("Stub!"); }

public boolean getCameraDisabled(@android.annotation.Nullable android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public boolean requestBugreport(@android.annotation.NonNull android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public void setScreenCaptureDisabled(@android.annotation.Nullable android.content.ComponentName admin, boolean disabled) { throw new RuntimeException("Stub!"); }

public boolean getScreenCaptureDisabled(@android.annotation.Nullable android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public void setNearbyNotificationStreamingPolicy(int policy) { throw new RuntimeException("Stub!"); }

public int getNearbyNotificationStreamingPolicy() { throw new RuntimeException("Stub!"); }

public void setNearbyAppStreamingPolicy(int policy) { throw new RuntimeException("Stub!"); }

public int getNearbyAppStreamingPolicy() { throw new RuntimeException("Stub!"); }

@Deprecated
public void setAutoTimeRequired(@android.annotation.NonNull android.content.ComponentName admin, boolean required) { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean getAutoTimeRequired() { throw new RuntimeException("Stub!"); }

public void setAutoTimeEnabled(@android.annotation.Nullable android.content.ComponentName admin, boolean enabled) { throw new RuntimeException("Stub!"); }

public boolean getAutoTimeEnabled(@android.annotation.Nullable android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public void setAutoTimeZoneEnabled(@android.annotation.Nullable android.content.ComponentName admin, boolean enabled) { throw new RuntimeException("Stub!"); }

public boolean getAutoTimeZoneEnabled(@android.annotation.Nullable android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public void setKeyguardDisabledFeatures(@android.annotation.Nullable android.content.ComponentName admin, int which) { throw new RuntimeException("Stub!"); }

public int getKeyguardDisabledFeatures(@android.annotation.Nullable android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public boolean isDeviceOwnerApp(java.lang.String packageName) { throw new RuntimeException("Stub!"); }

@Deprecated
public void clearDeviceOwnerApp(java.lang.String packageName) { throw new RuntimeException("Stub!"); }

@Deprecated
public void clearProfileOwner(@android.annotation.NonNull android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public void setDeviceOwnerLockScreenInfo(@android.annotation.NonNull android.content.ComponentName admin, java.lang.CharSequence info) { throw new RuntimeException("Stub!"); }

public java.lang.CharSequence getDeviceOwnerLockScreenInfo() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String[] setPackagesSuspended(@android.annotation.Nullable android.content.ComponentName admin, @android.annotation.NonNull java.lang.String[] packageNames, boolean suspended) { throw new RuntimeException("Stub!"); }

public boolean isPackageSuspended(@android.annotation.Nullable android.content.ComponentName admin, java.lang.String packageName) throws android.content.pm.PackageManager.NameNotFoundException { throw new RuntimeException("Stub!"); }

public void setProfileEnabled(@android.annotation.NonNull android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public void setProfileName(@android.annotation.NonNull android.content.ComponentName admin, java.lang.String profileName) { throw new RuntimeException("Stub!"); }

public boolean isProfileOwnerApp(java.lang.String packageName) { throw new RuntimeException("Stub!"); }

public boolean isOrganizationOwnedDeviceWithManagedProfile() { throw new RuntimeException("Stub!"); }

public void addPersistentPreferredActivity(@android.annotation.Nullable android.content.ComponentName admin, android.content.IntentFilter filter, @android.annotation.NonNull android.content.ComponentName activity) { throw new RuntimeException("Stub!"); }

public void clearPackagePersistentPreferredActivities(@android.annotation.Nullable android.content.ComponentName admin, java.lang.String packageName) { throw new RuntimeException("Stub!"); }

public void setDefaultSmsApplication(@android.annotation.Nullable android.content.ComponentName admin, @android.annotation.NonNull java.lang.String packageName) { throw new RuntimeException("Stub!"); }

public void setDefaultDialerApplication(@android.annotation.NonNull java.lang.String packageName) { throw new RuntimeException("Stub!"); }

@Deprecated
public void setApplicationRestrictionsManagingPackage(@android.annotation.NonNull android.content.ComponentName admin, @android.annotation.Nullable java.lang.String packageName) throws android.content.pm.PackageManager.NameNotFoundException { throw new RuntimeException("Stub!"); }

@Deprecated
@android.annotation.Nullable
public java.lang.String getApplicationRestrictionsManagingPackage(@android.annotation.NonNull android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean isCallerApplicationRestrictionsManagingPackage() { throw new RuntimeException("Stub!"); }

public void setApplicationRestrictions(@android.annotation.Nullable android.content.ComponentName admin, java.lang.String packageName, android.os.Bundle settings) { throw new RuntimeException("Stub!"); }

public void setTrustAgentConfiguration(@android.annotation.Nullable android.content.ComponentName admin, @android.annotation.NonNull android.content.ComponentName target, android.os.PersistableBundle configuration) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.util.List<android.os.PersistableBundle> getTrustAgentConfiguration(@android.annotation.Nullable android.content.ComponentName admin, @android.annotation.NonNull android.content.ComponentName agent) { throw new RuntimeException("Stub!"); }

@Deprecated
public void setCrossProfileCallerIdDisabled(@android.annotation.NonNull android.content.ComponentName admin, boolean disabled) { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean getCrossProfileCallerIdDisabled(@android.annotation.NonNull android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public void setCredentialManagerPolicy(@android.annotation.Nullable android.app.admin.PackagePolicy policy) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.app.admin.PackagePolicy getCredentialManagerPolicy() { throw new RuntimeException("Stub!"); }

public void setManagedProfileCallerIdAccessPolicy(@android.annotation.Nullable android.app.admin.PackagePolicy policy) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.app.admin.PackagePolicy getManagedProfileCallerIdAccessPolicy() { throw new RuntimeException("Stub!"); }

public void setManagedProfileContactsAccessPolicy(@android.annotation.Nullable android.app.admin.PackagePolicy policy) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.app.admin.PackagePolicy getManagedProfileContactsAccessPolicy() { throw new RuntimeException("Stub!"); }

@Deprecated
public void setCrossProfileContactsSearchDisabled(@android.annotation.NonNull android.content.ComponentName admin, boolean disabled) { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean getCrossProfileContactsSearchDisabled(@android.annotation.NonNull android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public void setBluetoothContactSharingDisabled(@android.annotation.NonNull android.content.ComponentName admin, boolean disabled) { throw new RuntimeException("Stub!"); }

public boolean getBluetoothContactSharingDisabled(@android.annotation.NonNull android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public void addCrossProfileIntentFilter(@android.annotation.Nullable android.content.ComponentName admin, android.content.IntentFilter filter, int flags) { throw new RuntimeException("Stub!"); }

public void clearCrossProfileIntentFilters(@android.annotation.Nullable android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public boolean setPermittedAccessibilityServices(@android.annotation.NonNull android.content.ComponentName admin, java.util.List<java.lang.String> packageNames) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.util.List<java.lang.String> getPermittedAccessibilityServices(@android.annotation.NonNull android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public boolean setPermittedInputMethods(@android.annotation.Nullable android.content.ComponentName admin, java.util.List<java.lang.String> packageNames) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.util.List<java.lang.String> getPermittedInputMethods(@android.annotation.Nullable android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public boolean setPermittedCrossProfileNotificationListeners(@android.annotation.NonNull android.content.ComponentName admin, @android.annotation.Nullable java.util.List<java.lang.String> packageList) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.util.List<java.lang.String> getPermittedCrossProfileNotificationListeners(@android.annotation.NonNull android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.util.List<java.lang.String> getKeepUninstalledPackages(@android.annotation.Nullable android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public void setKeepUninstalledPackages(@android.annotation.Nullable android.content.ComponentName admin, @android.annotation.NonNull java.util.List<java.lang.String> packageNames) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.os.UserHandle createAndManageUser(@android.annotation.NonNull android.content.ComponentName admin, @android.annotation.NonNull java.lang.String name, @android.annotation.NonNull android.content.ComponentName profileOwner, @android.annotation.Nullable android.os.PersistableBundle adminExtras, int flags) { throw new RuntimeException("Stub!"); }

public boolean removeUser(@android.annotation.NonNull android.content.ComponentName admin, @android.annotation.NonNull android.os.UserHandle userHandle) { throw new RuntimeException("Stub!"); }

public boolean switchUser(@android.annotation.NonNull android.content.ComponentName admin, @android.annotation.Nullable android.os.UserHandle userHandle) { throw new RuntimeException("Stub!"); }

public int startUserInBackground(@android.annotation.NonNull android.content.ComponentName admin, @android.annotation.NonNull android.os.UserHandle userHandle) { throw new RuntimeException("Stub!"); }

public int stopUser(@android.annotation.NonNull android.content.ComponentName admin, @android.annotation.NonNull android.os.UserHandle userHandle) { throw new RuntimeException("Stub!"); }

public int logoutUser(@android.annotation.NonNull android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public void setManagedSubscriptionsPolicy(@android.annotation.Nullable android.app.admin.ManagedSubscriptionsPolicy policy) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.admin.ManagedSubscriptionsPolicy getManagedSubscriptionsPolicy() { throw new RuntimeException("Stub!"); }

public java.util.List<android.os.UserHandle> getSecondaryUsers(@android.annotation.NonNull android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public boolean isEphemeralUser(@android.annotation.NonNull android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.os.Bundle getApplicationRestrictions(@android.annotation.Nullable android.content.ComponentName admin, java.lang.String packageName) { throw new RuntimeException("Stub!"); }

public void addUserRestriction(@android.annotation.NonNull android.content.ComponentName admin, java.lang.String key) { throw new RuntimeException("Stub!"); }

public void addUserRestrictionGlobally(@android.annotation.NonNull java.lang.String key) { throw new RuntimeException("Stub!"); }

public void clearUserRestriction(@android.annotation.NonNull android.content.ComponentName admin, java.lang.String key) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.os.Bundle getUserRestrictions(@android.annotation.NonNull android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.os.Bundle getUserRestrictionsGlobally() { throw new RuntimeException("Stub!"); }

public android.content.Intent createAdminSupportIntent(@android.annotation.NonNull java.lang.String restriction) { throw new RuntimeException("Stub!"); }

public boolean setApplicationHidden(@android.annotation.Nullable android.content.ComponentName admin, java.lang.String packageName, boolean hidden) { throw new RuntimeException("Stub!"); }

public boolean isApplicationHidden(@android.annotation.Nullable android.content.ComponentName admin, java.lang.String packageName) { throw new RuntimeException("Stub!"); }

public void enableSystemApp(@android.annotation.NonNull android.content.ComponentName admin, java.lang.String packageName) { throw new RuntimeException("Stub!"); }

public int enableSystemApp(@android.annotation.NonNull android.content.ComponentName admin, android.content.Intent intent) { throw new RuntimeException("Stub!"); }

public boolean installExistingPackage(@android.annotation.NonNull android.content.ComponentName admin, java.lang.String packageName) { throw new RuntimeException("Stub!"); }

public void setAccountManagementDisabled(@android.annotation.Nullable android.content.ComponentName admin, java.lang.String accountType, boolean disabled) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String[] getAccountTypesWithManagementDisabled() { throw new RuntimeException("Stub!"); }

public void setLockTaskPackages(@android.annotation.Nullable android.content.ComponentName admin, @android.annotation.NonNull java.lang.String[] packages) throws java.lang.SecurityException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String[] getLockTaskPackages(@android.annotation.Nullable android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public boolean isLockTaskPermitted(java.lang.String pkg) { throw new RuntimeException("Stub!"); }

public void setLockTaskFeatures(@android.annotation.Nullable android.content.ComponentName admin, int flags) { throw new RuntimeException("Stub!"); }

public int getLockTaskFeatures(@android.annotation.Nullable android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public void setPreferentialNetworkServiceEnabled(boolean enabled) { throw new RuntimeException("Stub!"); }

public boolean isPreferentialNetworkServiceEnabled() { throw new RuntimeException("Stub!"); }

public void setPreferentialNetworkServiceConfigs(@android.annotation.NonNull java.util.List<android.app.admin.PreferentialNetworkServiceConfig> preferentialNetworkServiceConfigs) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.app.admin.PreferentialNetworkServiceConfig> getPreferentialNetworkServiceConfigs() { throw new RuntimeException("Stub!"); }

public void setGlobalSetting(@android.annotation.NonNull android.content.ComponentName admin, java.lang.String setting, java.lang.String value) { throw new RuntimeException("Stub!"); }

public void setSystemSetting(@android.annotation.NonNull android.content.ComponentName admin, @android.annotation.NonNull java.lang.String setting, java.lang.String value) { throw new RuntimeException("Stub!"); }

public void setConfiguredNetworksLockdownState(@android.annotation.Nullable android.content.ComponentName admin, boolean lockdown) { throw new RuntimeException("Stub!"); }

public boolean hasLockdownAdminConfiguredNetworks(@android.annotation.Nullable android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public boolean setTime(@android.annotation.Nullable android.content.ComponentName admin, long millis) { throw new RuntimeException("Stub!"); }

public boolean setTimeZone(@android.annotation.Nullable android.content.ComponentName admin, java.lang.String timeZone) { throw new RuntimeException("Stub!"); }

public void setLocationEnabled(@android.annotation.NonNull android.content.ComponentName admin, boolean locationEnabled) { throw new RuntimeException("Stub!"); }

public void setSecureSetting(@android.annotation.NonNull android.content.ComponentName admin, java.lang.String setting, java.lang.String value) { throw new RuntimeException("Stub!"); }

public void setRestrictionsProvider(@android.annotation.NonNull android.content.ComponentName admin, @android.annotation.Nullable android.content.ComponentName provider) { throw new RuntimeException("Stub!"); }

public void setMasterVolumeMuted(@android.annotation.NonNull android.content.ComponentName admin, boolean on) { throw new RuntimeException("Stub!"); }

public boolean isMasterVolumeMuted(@android.annotation.NonNull android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public void setUninstallBlocked(@android.annotation.Nullable android.content.ComponentName admin, java.lang.String packageName, boolean uninstallBlocked) { throw new RuntimeException("Stub!"); }

public boolean isUninstallBlocked(@android.annotation.Nullable android.content.ComponentName admin, java.lang.String packageName) { throw new RuntimeException("Stub!"); }

public boolean addCrossProfileWidgetProvider(@android.annotation.Nullable android.content.ComponentName admin, java.lang.String packageName) { throw new RuntimeException("Stub!"); }

public boolean removeCrossProfileWidgetProvider(@android.annotation.Nullable android.content.ComponentName admin, java.lang.String packageName) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<java.lang.String> getCrossProfileWidgetProviders(@android.annotation.Nullable android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public void setUserIcon(@android.annotation.NonNull android.content.ComponentName admin, android.graphics.Bitmap icon) { throw new RuntimeException("Stub!"); }

public void setSystemUpdatePolicy(@android.annotation.NonNull android.content.ComponentName admin, android.app.admin.SystemUpdatePolicy policy) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.app.admin.SystemUpdatePolicy getSystemUpdatePolicy() { throw new RuntimeException("Stub!"); }

public boolean setKeyguardDisabled(@android.annotation.NonNull android.content.ComponentName admin, boolean disabled) { throw new RuntimeException("Stub!"); }

public boolean setStatusBarDisabled(@android.annotation.Nullable android.content.ComponentName admin, boolean disabled) { throw new RuntimeException("Stub!"); }

public boolean isStatusBarDisabled() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.app.admin.SystemUpdateInfo getPendingSystemUpdate(@android.annotation.Nullable android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public void setPermissionPolicy(@android.annotation.NonNull android.content.ComponentName admin, int policy) { throw new RuntimeException("Stub!"); }

public int getPermissionPolicy(android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public boolean setPermissionGrantState(@android.annotation.Nullable android.content.ComponentName admin, @android.annotation.NonNull java.lang.String packageName, @android.annotation.NonNull java.lang.String permission, int grantState) { throw new RuntimeException("Stub!"); }

public int getPermissionGrantState(@android.annotation.Nullable android.content.ComponentName admin, @android.annotation.NonNull java.lang.String packageName, @android.annotation.NonNull java.lang.String permission) { throw new RuntimeException("Stub!"); }

public boolean isProvisioningAllowed(@android.annotation.NonNull java.lang.String action) { throw new RuntimeException("Stub!"); }

public boolean isManagedProfile(@android.annotation.NonNull android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getWifiMacAddress(@android.annotation.Nullable android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public void reboot(@android.annotation.NonNull android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public void setShortSupportMessage(@android.annotation.Nullable android.content.ComponentName admin, @android.annotation.Nullable java.lang.CharSequence message) { throw new RuntimeException("Stub!"); }

public java.lang.CharSequence getShortSupportMessage(@android.annotation.Nullable android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public void setLongSupportMessage(@android.annotation.NonNull android.content.ComponentName admin, @android.annotation.Nullable java.lang.CharSequence message) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.CharSequence getLongSupportMessage(@android.annotation.NonNull android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.admin.DevicePolicyManager getParentProfileInstance(@android.annotation.NonNull android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public void setSecurityLoggingEnabled(@android.annotation.Nullable android.content.ComponentName admin, boolean enabled) { throw new RuntimeException("Stub!"); }

public boolean isSecurityLoggingEnabled(@android.annotation.Nullable android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.util.List<android.app.admin.SecurityLog.SecurityEvent> retrieveSecurityLogs(@android.annotation.Nullable android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<java.lang.String> setMeteredDataDisabledPackages(@android.annotation.NonNull android.content.ComponentName admin, @android.annotation.NonNull java.util.List<java.lang.String> packageNames) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<java.lang.String> getMeteredDataDisabledPackages(@android.annotation.NonNull android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.util.List<android.app.admin.SecurityLog.SecurityEvent> retrievePreRebootSecurityLogs(@android.annotation.Nullable android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

@Deprecated
public void setOrganizationColor(@android.annotation.NonNull android.content.ComponentName admin, int color) { throw new RuntimeException("Stub!"); }

@Deprecated
public int getOrganizationColor(@android.annotation.NonNull android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public void setOrganizationName(@android.annotation.Nullable android.content.ComponentName admin, @android.annotation.Nullable java.lang.CharSequence title) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.CharSequence getOrganizationName(@android.annotation.Nullable android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public void setAffiliationIds(@android.annotation.NonNull android.content.ComponentName admin, @android.annotation.NonNull java.util.Set<java.lang.String> ids) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.Set<java.lang.String> getAffiliationIds(@android.annotation.NonNull android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public boolean isAffiliatedUser() { throw new RuntimeException("Stub!"); }

public void setBackupServiceEnabled(@android.annotation.NonNull android.content.ComponentName admin, boolean enabled) { throw new RuntimeException("Stub!"); }

public boolean isBackupServiceEnabled(@android.annotation.NonNull android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public void setNetworkLoggingEnabled(@android.annotation.Nullable android.content.ComponentName admin, boolean enabled) { throw new RuntimeException("Stub!"); }

public boolean isNetworkLoggingEnabled(@android.annotation.Nullable android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.util.List<android.app.admin.NetworkEvent> retrieveNetworkLogs(@android.annotation.Nullable android.content.ComponentName admin, long batchToken) { throw new RuntimeException("Stub!"); }

public boolean bindDeviceAdminServiceAsUser(@android.annotation.NonNull android.content.ComponentName admin, @android.annotation.NonNull android.content.Intent serviceIntent, @android.annotation.NonNull android.content.ServiceConnection conn, int flags, @android.annotation.NonNull android.os.UserHandle targetUser) { throw new RuntimeException("Stub!"); }

public boolean bindDeviceAdminServiceAsUser(@android.annotation.NonNull android.content.ComponentName admin, @android.annotation.NonNull android.content.Intent serviceIntent, @android.annotation.NonNull android.content.ServiceConnection conn, @android.annotation.NonNull android.content.Context.BindServiceFlags flags, @android.annotation.NonNull android.os.UserHandle targetUser) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.os.UserHandle> getBindDeviceAdminTargetUsers(@android.annotation.NonNull android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public void clearApplicationUserData(@android.annotation.NonNull android.content.ComponentName admin, @android.annotation.NonNull java.lang.String packageName, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.app.admin.DevicePolicyManager.OnClearApplicationUserDataListener listener) { throw new RuntimeException("Stub!"); }

public void setLogoutEnabled(@android.annotation.NonNull android.content.ComponentName admin, boolean enabled) { throw new RuntimeException("Stub!"); }

public boolean isLogoutEnabled() { throw new RuntimeException("Stub!"); }

public void transferOwnership(@android.annotation.NonNull android.content.ComponentName admin, @android.annotation.NonNull android.content.ComponentName target, @android.annotation.Nullable android.os.PersistableBundle bundle) { throw new RuntimeException("Stub!"); }

public void setStartUserSessionMessage(@android.annotation.NonNull android.content.ComponentName admin, @android.annotation.Nullable java.lang.CharSequence startUserSessionMessage) { throw new RuntimeException("Stub!"); }

public void setEndUserSessionMessage(@android.annotation.NonNull android.content.ComponentName admin, @android.annotation.Nullable java.lang.CharSequence endUserSessionMessage) { throw new RuntimeException("Stub!"); }

public java.lang.CharSequence getStartUserSessionMessage(@android.annotation.NonNull android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public java.lang.CharSequence getEndUserSessionMessage(@android.annotation.NonNull android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public int addOverrideApn(@android.annotation.NonNull android.content.ComponentName admin, @android.annotation.NonNull android.telephony.data.ApnSetting apnSetting) { throw new RuntimeException("Stub!"); }

public boolean updateOverrideApn(@android.annotation.NonNull android.content.ComponentName admin, int apnId, @android.annotation.NonNull android.telephony.data.ApnSetting apnSetting) { throw new RuntimeException("Stub!"); }

public boolean removeOverrideApn(@android.annotation.NonNull android.content.ComponentName admin, int apnId) { throw new RuntimeException("Stub!"); }

public java.util.List<android.telephony.data.ApnSetting> getOverrideApns(@android.annotation.NonNull android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public void setOverrideApnsEnabled(@android.annotation.NonNull android.content.ComponentName admin, boolean enabled) { throw new RuntimeException("Stub!"); }

public boolean isOverrideApnEnabled(@android.annotation.NonNull android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.os.PersistableBundle getTransferOwnershipBundle() { throw new RuntimeException("Stub!"); }

public int setGlobalPrivateDnsModeOpportunistic(@android.annotation.NonNull android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public int setGlobalPrivateDnsModeSpecifiedHost(@android.annotation.NonNull android.content.ComponentName admin, @android.annotation.NonNull java.lang.String privateDnsHost) { throw new RuntimeException("Stub!"); }

public void installSystemUpdate(@android.annotation.Nullable android.content.ComponentName admin, @android.annotation.NonNull android.net.Uri updateFilePath, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.app.admin.DevicePolicyManager.InstallSystemUpdateCallback callback) { throw new RuntimeException("Stub!"); }

public int getGlobalPrivateDnsMode(@android.annotation.NonNull android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getGlobalPrivateDnsHost(@android.annotation.NonNull android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

@Deprecated
public void setCrossProfileCalendarPackages(@android.annotation.NonNull android.content.ComponentName admin, @android.annotation.Nullable java.util.Set<java.lang.String> packageNames) { throw new RuntimeException("Stub!"); }

@Deprecated
@android.annotation.Nullable
public java.util.Set<java.lang.String> getCrossProfileCalendarPackages(@android.annotation.NonNull android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public void setCrossProfilePackages(@android.annotation.NonNull android.content.ComponentName admin, @android.annotation.NonNull java.util.Set<java.lang.String> packageNames) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.Set<java.lang.String> getCrossProfilePackages(@android.annotation.NonNull android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public void setUserControlDisabledPackages(@android.annotation.Nullable android.content.ComponentName admin, @android.annotation.NonNull java.util.List<java.lang.String> packages) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<java.lang.String> getUserControlDisabledPackages(@android.annotation.Nullable android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public void setCommonCriteriaModeEnabled(@android.annotation.Nullable android.content.ComponentName admin, boolean enabled) { throw new RuntimeException("Stub!"); }

public boolean isCommonCriteriaModeEnabled(@android.annotation.Nullable android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public int getPersonalAppsSuspendedReasons(@android.annotation.NonNull android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public void setPersonalAppsSuspended(@android.annotation.NonNull android.content.ComponentName admin, boolean suspended) { throw new RuntimeException("Stub!"); }

public void setManagedProfileMaximumTimeOff(@android.annotation.NonNull android.content.ComponentName admin, long timeoutMillis) { throw new RuntimeException("Stub!"); }

public long getManagedProfileMaximumTimeOff(@android.annotation.NonNull android.content.ComponentName admin) { throw new RuntimeException("Stub!"); }

public void acknowledgeDeviceCompliant() { throw new RuntimeException("Stub!"); }

public boolean isComplianceAcknowledgementRequired() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getEnrollmentSpecificId() { throw new RuntimeException("Stub!"); }

public void setOrganizationId(@android.annotation.NonNull java.lang.String enterpriseId) { throw new RuntimeException("Stub!"); }

public boolean canAdminGrantSensorsPermissions() { throw new RuntimeException("Stub!"); }

public void setUsbDataSignalingEnabled(boolean enabled) { throw new RuntimeException("Stub!"); }

public boolean isUsbDataSignalingEnabled() { throw new RuntimeException("Stub!"); }

public boolean canUsbDataSignalingBeDisabled() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.os.UserHandle> listForegroundAffiliatedUsers() { throw new RuntimeException("Stub!"); }

public void setMinimumRequiredWifiSecurityLevel(int level) { throw new RuntimeException("Stub!"); }

public int getMinimumRequiredWifiSecurityLevel() { throw new RuntimeException("Stub!"); }

public void setWifiSsidPolicy(@android.annotation.Nullable android.app.admin.WifiSsidPolicy policy) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.app.admin.WifiSsidPolicy getWifiSsidPolicy() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.admin.DevicePolicyResourcesManager getResources() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getDevicePolicyManagementRoleHolderPackage() { throw new RuntimeException("Stub!"); }

public boolean isDeviceFinanced() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.Set<java.lang.Integer> getSubscriptionIds() { throw new RuntimeException("Stub!"); }

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_ADD_DEVICE_ADMIN = "android.app.action.ADD_DEVICE_ADMIN";

public static final java.lang.String ACTION_ADMIN_POLICY_COMPLIANCE = "android.app.action.ADMIN_POLICY_COMPLIANCE";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_APPLICATION_DELEGATION_SCOPES_CHANGED = "android.app.action.APPLICATION_DELEGATION_SCOPES_CHANGED";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_CHECK_POLICY_COMPLIANCE = "android.app.action.CHECK_POLICY_COMPLIANCE";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.SERVICE_ACTION) public static final java.lang.String ACTION_DEVICE_ADMIN_SERVICE = "android.app.action.DEVICE_ADMIN_SERVICE";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_DEVICE_FINANCING_STATE_CHANGED = "android.app.admin.action.DEVICE_FINANCING_STATE_CHANGED";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_DEVICE_OWNER_CHANGED = "android.app.action.DEVICE_OWNER_CHANGED";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_DEVICE_POLICY_RESOURCE_UPDATED = "android.app.action.DEVICE_POLICY_RESOURCE_UPDATED";

public static final java.lang.String ACTION_GET_PROVISIONING_MODE = "android.app.action.GET_PROVISIONING_MODE";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_MANAGED_PROFILE_PROVISIONED = "android.app.action.MANAGED_PROFILE_PROVISIONED";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_PROFILE_OWNER_CHANGED = "android.app.action.PROFILE_OWNER_CHANGED";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_PROVISIONING_SUCCESSFUL = "android.app.action.PROVISIONING_SUCCESSFUL";

@Deprecated @android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_PROVISION_MANAGED_DEVICE = "android.app.action.PROVISION_MANAGED_DEVICE";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_PROVISION_MANAGED_PROFILE = "android.app.action.PROVISION_MANAGED_PROFILE";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_SET_NEW_PARENT_PROFILE_PASSWORD = "android.app.action.SET_NEW_PARENT_PROFILE_PASSWORD";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_SET_NEW_PASSWORD = "android.app.action.SET_NEW_PASSWORD";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_START_ENCRYPTION = "android.app.action.START_ENCRYPTION";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_SYSTEM_UPDATE_POLICY_CHANGED = "android.app.action.SYSTEM_UPDATE_POLICY_CHANGED";

public static final int CONTENT_PROTECTION_DISABLED = 1; // 0x1

public static final int CONTENT_PROTECTION_ENABLED = 2; // 0x2

public static final int CONTENT_PROTECTION_NOT_CONTROLLED_BY_POLICY = 0; // 0x0

public static final java.lang.String DELEGATION_APP_RESTRICTIONS = "delegation-app-restrictions";

public static final java.lang.String DELEGATION_BLOCK_UNINSTALL = "delegation-block-uninstall";

public static final java.lang.String DELEGATION_CERT_INSTALL = "delegation-cert-install";

public static final java.lang.String DELEGATION_CERT_SELECTION = "delegation-cert-selection";

public static final java.lang.String DELEGATION_ENABLE_SYSTEM_APP = "delegation-enable-system-app";

public static final java.lang.String DELEGATION_INSTALL_EXISTING_PACKAGE = "delegation-install-existing-package";

public static final java.lang.String DELEGATION_KEEP_UNINSTALLED_PACKAGES = "delegation-keep-uninstalled-packages";

public static final java.lang.String DELEGATION_NETWORK_LOGGING = "delegation-network-logging";

public static final java.lang.String DELEGATION_PACKAGE_ACCESS = "delegation-package-access";

public static final java.lang.String DELEGATION_PERMISSION_GRANT = "delegation-permission-grant";

public static final java.lang.String DELEGATION_SECURITY_LOGGING = "delegation-security-logging";

@Deprecated public static final int ENCRYPTION_STATUS_ACTIVATING = 2; // 0x2

public static final int ENCRYPTION_STATUS_ACTIVE = 3; // 0x3

public static final int ENCRYPTION_STATUS_ACTIVE_DEFAULT_KEY = 4; // 0x4

public static final int ENCRYPTION_STATUS_ACTIVE_PER_USER = 5; // 0x5

public static final int ENCRYPTION_STATUS_INACTIVE = 1; // 0x1

public static final int ENCRYPTION_STATUS_UNSUPPORTED = 0; // 0x0

public static final java.lang.String EXTRA_ADD_EXPLANATION = "android.app.extra.ADD_EXPLANATION";

public static final java.lang.String EXTRA_DELEGATION_SCOPES = "android.app.extra.DELEGATION_SCOPES";

public static final java.lang.String EXTRA_DEVICE_ADMIN = "android.app.extra.DEVICE_ADMIN";

public static final java.lang.String EXTRA_DEVICE_PASSWORD_REQUIREMENT_ONLY = "android.app.extra.DEVICE_PASSWORD_REQUIREMENT_ONLY";

public static final java.lang.String EXTRA_PASSWORD_COMPLEXITY = "android.app.extra.PASSWORD_COMPLEXITY";

public static final java.lang.String EXTRA_PROVISIONING_ACCOUNT_TO_MIGRATE = "android.app.extra.PROVISIONING_ACCOUNT_TO_MIGRATE";

public static final java.lang.String EXTRA_PROVISIONING_ADMIN_EXTRAS_BUNDLE = "android.app.extra.PROVISIONING_ADMIN_EXTRAS_BUNDLE";

public static final java.lang.String EXTRA_PROVISIONING_ALLOWED_PROVISIONING_MODES = "android.app.extra.PROVISIONING_ALLOWED_PROVISIONING_MODES";

public static final java.lang.String EXTRA_PROVISIONING_ALLOW_OFFLINE = "android.app.extra.PROVISIONING_ALLOW_OFFLINE";

public static final java.lang.String EXTRA_PROVISIONING_DEVICE_ADMIN_COMPONENT_NAME = "android.app.extra.PROVISIONING_DEVICE_ADMIN_COMPONENT_NAME";

public static final java.lang.String EXTRA_PROVISIONING_DEVICE_ADMIN_MINIMUM_VERSION_CODE = "android.app.extra.PROVISIONING_DEVICE_ADMIN_MINIMUM_VERSION_CODE";

public static final java.lang.String EXTRA_PROVISIONING_DEVICE_ADMIN_PACKAGE_CHECKSUM = "android.app.extra.PROVISIONING_DEVICE_ADMIN_PACKAGE_CHECKSUM";

public static final java.lang.String EXTRA_PROVISIONING_DEVICE_ADMIN_PACKAGE_DOWNLOAD_COOKIE_HEADER = "android.app.extra.PROVISIONING_DEVICE_ADMIN_PACKAGE_DOWNLOAD_COOKIE_HEADER";

public static final java.lang.String EXTRA_PROVISIONING_DEVICE_ADMIN_PACKAGE_DOWNLOAD_LOCATION = "android.app.extra.PROVISIONING_DEVICE_ADMIN_PACKAGE_DOWNLOAD_LOCATION";

@Deprecated public static final java.lang.String EXTRA_PROVISIONING_DEVICE_ADMIN_PACKAGE_NAME = "android.app.extra.PROVISIONING_DEVICE_ADMIN_PACKAGE_NAME";

public static final java.lang.String EXTRA_PROVISIONING_DEVICE_ADMIN_SIGNATURE_CHECKSUM = "android.app.extra.PROVISIONING_DEVICE_ADMIN_SIGNATURE_CHECKSUM";

public static final java.lang.String EXTRA_PROVISIONING_DISCLAIMERS = "android.app.extra.PROVISIONING_DISCLAIMERS";

public static final java.lang.String EXTRA_PROVISIONING_DISCLAIMER_CONTENT = "android.app.extra.PROVISIONING_DISCLAIMER_CONTENT";

public static final java.lang.String EXTRA_PROVISIONING_DISCLAIMER_HEADER = "android.app.extra.PROVISIONING_DISCLAIMER_HEADER";

@Deprecated public static final java.lang.String EXTRA_PROVISIONING_EMAIL_ADDRESS = "android.app.extra.PROVISIONING_EMAIL_ADDRESS";

public static final java.lang.String EXTRA_PROVISIONING_IMEI = "android.app.extra.PROVISIONING_IMEI";

public static final java.lang.String EXTRA_PROVISIONING_KEEP_ACCOUNT_ON_MIGRATION = "android.app.extra.PROVISIONING_KEEP_ACCOUNT_ON_MIGRATION";

@Deprecated public static final java.lang.String EXTRA_PROVISIONING_KEEP_SCREEN_ON = "android.app.extra.PROVISIONING_KEEP_SCREEN_ON";

public static final java.lang.String EXTRA_PROVISIONING_LEAVE_ALL_SYSTEM_APPS_ENABLED = "android.app.extra.PROVISIONING_LEAVE_ALL_SYSTEM_APPS_ENABLED";

public static final java.lang.String EXTRA_PROVISIONING_LOCALE = "android.app.extra.PROVISIONING_LOCALE";

public static final java.lang.String EXTRA_PROVISIONING_LOCAL_TIME = "android.app.extra.PROVISIONING_LOCAL_TIME";

@Deprecated public static final java.lang.String EXTRA_PROVISIONING_LOGO_URI = "android.app.extra.PROVISIONING_LOGO_URI";

@Deprecated public static final java.lang.String EXTRA_PROVISIONING_MAIN_COLOR = "android.app.extra.PROVISIONING_MAIN_COLOR";

public static final java.lang.String EXTRA_PROVISIONING_MODE = "android.app.extra.PROVISIONING_MODE";

public static final java.lang.String EXTRA_PROVISIONING_SENSORS_PERMISSION_GRANT_OPT_OUT = "android.app.extra.PROVISIONING_SENSORS_PERMISSION_GRANT_OPT_OUT";

public static final java.lang.String EXTRA_PROVISIONING_SERIAL_NUMBER = "android.app.extra.PROVISIONING_SERIAL_NUMBER";

public static final java.lang.String EXTRA_PROVISIONING_SHOULD_LAUNCH_RESULT_INTENT = "android.app.extra.PROVISIONING_SHOULD_LAUNCH_RESULT_INTENT";

public static final java.lang.String EXTRA_PROVISIONING_SKIP_EDUCATION_SCREENS = "android.app.extra.PROVISIONING_SKIP_EDUCATION_SCREENS";

public static final java.lang.String EXTRA_PROVISIONING_SKIP_ENCRYPTION = "android.app.extra.PROVISIONING_SKIP_ENCRYPTION";

@Deprecated public static final java.lang.String EXTRA_PROVISIONING_SKIP_USER_CONSENT = "android.app.extra.PROVISIONING_SKIP_USER_CONSENT";

public static final java.lang.String EXTRA_PROVISIONING_TIME_ZONE = "android.app.extra.PROVISIONING_TIME_ZONE";

public static final java.lang.String EXTRA_PROVISIONING_USE_MOBILE_DATA = "android.app.extra.PROVISIONING_USE_MOBILE_DATA";

public static final java.lang.String EXTRA_PROVISIONING_WIFI_ANONYMOUS_IDENTITY = "android.app.extra.PROVISIONING_WIFI_ANONYMOUS_IDENTITY";

public static final java.lang.String EXTRA_PROVISIONING_WIFI_CA_CERTIFICATE = "android.app.extra.PROVISIONING_WIFI_CA_CERTIFICATE";

public static final java.lang.String EXTRA_PROVISIONING_WIFI_DOMAIN = "android.app.extra.PROVISIONING_WIFI_DOMAIN";

public static final java.lang.String EXTRA_PROVISIONING_WIFI_EAP_METHOD = "android.app.extra.PROVISIONING_WIFI_EAP_METHOD";

public static final java.lang.String EXTRA_PROVISIONING_WIFI_HIDDEN = "android.app.extra.PROVISIONING_WIFI_HIDDEN";

public static final java.lang.String EXTRA_PROVISIONING_WIFI_IDENTITY = "android.app.extra.PROVISIONING_WIFI_IDENTITY";

public static final java.lang.String EXTRA_PROVISIONING_WIFI_PAC_URL = "android.app.extra.PROVISIONING_WIFI_PAC_URL";

public static final java.lang.String EXTRA_PROVISIONING_WIFI_PASSWORD = "android.app.extra.PROVISIONING_WIFI_PASSWORD";

public static final java.lang.String EXTRA_PROVISIONING_WIFI_PHASE2_AUTH = "android.app.extra.PROVISIONING_WIFI_PHASE2_AUTH";

public static final java.lang.String EXTRA_PROVISIONING_WIFI_PROXY_BYPASS = "android.app.extra.PROVISIONING_WIFI_PROXY_BYPASS";

public static final java.lang.String EXTRA_PROVISIONING_WIFI_PROXY_HOST = "android.app.extra.PROVISIONING_WIFI_PROXY_HOST";

public static final java.lang.String EXTRA_PROVISIONING_WIFI_PROXY_PORT = "android.app.extra.PROVISIONING_WIFI_PROXY_PORT";

public static final java.lang.String EXTRA_PROVISIONING_WIFI_SECURITY_TYPE = "android.app.extra.PROVISIONING_WIFI_SECURITY_TYPE";

public static final java.lang.String EXTRA_PROVISIONING_WIFI_SSID = "android.app.extra.PROVISIONING_WIFI_SSID";

public static final java.lang.String EXTRA_PROVISIONING_WIFI_USER_CERTIFICATE = "android.app.extra.PROVISIONING_WIFI_USER_CERTIFICATE";

public static final java.lang.String EXTRA_RESOURCE_IDS = "android.app.extra.RESOURCE_IDS";

public static final java.lang.String EXTRA_RESOURCE_TYPE = "android.app.extra.RESOURCE_TYPE";

public static final int EXTRA_RESOURCE_TYPE_DRAWABLE = 1; // 0x1

public static final int EXTRA_RESOURCE_TYPE_STRING = 2; // 0x2

public static final java.lang.String EXTRA_RESULT_LAUNCH_INTENT = "android.app.extra.RESULT_LAUNCH_INTENT";

public static final int FLAG_EVICT_CREDENTIAL_ENCRYPTION_KEY = 1; // 0x1

public static final int FLAG_MANAGED_CAN_ACCESS_PARENT = 2; // 0x2

public static final int FLAG_PARENT_CAN_ACCESS_MANAGED = 1; // 0x1

public static final int ID_TYPE_BASE_INFO = 1; // 0x1

public static final int ID_TYPE_IMEI = 4; // 0x4

public static final int ID_TYPE_INDIVIDUAL_ATTESTATION = 16; // 0x10

public static final int ID_TYPE_MEID = 8; // 0x8

public static final int ID_TYPE_SERIAL = 2; // 0x2

public static final int INSTALLKEY_REQUEST_CREDENTIALS_ACCESS = 1; // 0x1

public static final int INSTALLKEY_SET_USER_SELECTABLE = 2; // 0x2

public static final int KEYGUARD_DISABLE_BIOMETRICS = 416; // 0x1a0

public static final int KEYGUARD_DISABLE_FACE = 128; // 0x80

public static final int KEYGUARD_DISABLE_FEATURES_ALL = 2147483647; // 0x7fffffff

public static final int KEYGUARD_DISABLE_FEATURES_NONE = 0; // 0x0

public static final int KEYGUARD_DISABLE_FINGERPRINT = 32; // 0x20

public static final int KEYGUARD_DISABLE_IRIS = 256; // 0x100

@Deprecated public static final int KEYGUARD_DISABLE_REMOTE_INPUT = 64; // 0x40

public static final int KEYGUARD_DISABLE_SECURE_CAMERA = 2; // 0x2

public static final int KEYGUARD_DISABLE_SECURE_NOTIFICATIONS = 4; // 0x4

public static final int KEYGUARD_DISABLE_SHORTCUTS_ALL = 512; // 0x200

public static final int KEYGUARD_DISABLE_TRUST_AGENTS = 16; // 0x10

public static final int KEYGUARD_DISABLE_UNREDACTED_NOTIFICATIONS = 8; // 0x8

public static final int KEYGUARD_DISABLE_WIDGETS_ALL = 1; // 0x1

public static final int LEAVE_ALL_SYSTEM_APPS_ENABLED = 16; // 0x10

public static final int LOCK_TASK_FEATURE_BLOCK_ACTIVITY_START_IN_TASK = 64; // 0x40

public static final int LOCK_TASK_FEATURE_GLOBAL_ACTIONS = 16; // 0x10

public static final int LOCK_TASK_FEATURE_HOME = 4; // 0x4

public static final int LOCK_TASK_FEATURE_KEYGUARD = 32; // 0x20

public static final int LOCK_TASK_FEATURE_NONE = 0; // 0x0

public static final int LOCK_TASK_FEATURE_NOTIFICATIONS = 2; // 0x2

public static final int LOCK_TASK_FEATURE_OVERVIEW = 8; // 0x8

public static final int LOCK_TASK_FEATURE_SYSTEM_INFO = 1; // 0x1

public static final int MAKE_USER_EPHEMERAL = 2; // 0x2

public static final java.lang.String MIME_TYPE_PROVISIONING_NFC = "application/com.android.managedprovisioning";

public static final int MTE_DISABLED = 2; // 0x2

public static final int MTE_ENABLED = 1; // 0x1

public static final int MTE_NOT_CONTROLLED_BY_POLICY = 0; // 0x0

public static final int NEARBY_STREAMING_DISABLED = 1; // 0x1

public static final int NEARBY_STREAMING_ENABLED = 2; // 0x2

public static final int NEARBY_STREAMING_NOT_CONTROLLED_BY_POLICY = 0; // 0x0

public static final int NEARBY_STREAMING_SAME_MANAGED_ACCOUNT_ONLY = 3; // 0x3

public static final int OPERATION_SAFETY_REASON_DRIVING_DISTRACTION = 1; // 0x1

public static final int PASSWORD_COMPLEXITY_HIGH = 327680; // 0x50000

public static final int PASSWORD_COMPLEXITY_LOW = 65536; // 0x10000

public static final int PASSWORD_COMPLEXITY_MEDIUM = 196608; // 0x30000

public static final int PASSWORD_COMPLEXITY_NONE = 0; // 0x0

public static final int PASSWORD_QUALITY_ALPHABETIC = 262144; // 0x40000

public static final int PASSWORD_QUALITY_ALPHANUMERIC = 327680; // 0x50000

public static final int PASSWORD_QUALITY_BIOMETRIC_WEAK = 32768; // 0x8000

public static final int PASSWORD_QUALITY_COMPLEX = 393216; // 0x60000

public static final int PASSWORD_QUALITY_NUMERIC = 131072; // 0x20000

public static final int PASSWORD_QUALITY_NUMERIC_COMPLEX = 196608; // 0x30000

public static final int PASSWORD_QUALITY_SOMETHING = 65536; // 0x10000

public static final int PASSWORD_QUALITY_UNSPECIFIED = 0; // 0x0

public static final int PERMISSION_GRANT_STATE_DEFAULT = 0; // 0x0

public static final int PERMISSION_GRANT_STATE_DENIED = 2; // 0x2

public static final int PERMISSION_GRANT_STATE_GRANTED = 1; // 0x1

public static final int PERMISSION_POLICY_AUTO_DENY = 2; // 0x2

public static final int PERMISSION_POLICY_AUTO_GRANT = 1; // 0x1

public static final int PERMISSION_POLICY_PROMPT = 0; // 0x0

public static final int PERSONAL_APPS_NOT_SUSPENDED = 0; // 0x0

public static final int PERSONAL_APPS_SUSPENDED_EXPLICITLY = 1; // 0x1

public static final int PERSONAL_APPS_SUSPENDED_PROFILE_TIMEOUT = 2; // 0x2

public static final java.lang.String POLICY_DISABLE_CAMERA = "policy_disable_camera";

public static final java.lang.String POLICY_DISABLE_SCREEN_CAPTURE = "policy_disable_screen_capture";

public static final int PRIVATE_DNS_MODE_OFF = 1; // 0x1

public static final int PRIVATE_DNS_MODE_OPPORTUNISTIC = 2; // 0x2

public static final int PRIVATE_DNS_MODE_PROVIDER_HOSTNAME = 3; // 0x3

public static final int PRIVATE_DNS_MODE_UNKNOWN = 0; // 0x0

public static final int PRIVATE_DNS_SET_ERROR_FAILURE_SETTING = 2; // 0x2

public static final int PRIVATE_DNS_SET_ERROR_HOST_NOT_SERVING = 1; // 0x1

public static final int PRIVATE_DNS_SET_NO_ERROR = 0; // 0x0

public static final int PROVISIONING_MODE_FULLY_MANAGED_DEVICE = 1; // 0x1

public static final int PROVISIONING_MODE_MANAGED_PROFILE = 2; // 0x2

public static final int PROVISIONING_MODE_MANAGED_PROFILE_ON_PERSONAL_DEVICE = 3; // 0x3

public static final int RESET_PASSWORD_DO_NOT_ASK_CREDENTIALS_ON_BOOT = 2; // 0x2

public static final int RESET_PASSWORD_REQUIRE_ENTRY = 1; // 0x1

public static final int SKIP_SETUP_WIZARD = 1; // 0x1

public static final int WIFI_SECURITY_ENTERPRISE_192 = 3; // 0x3

public static final int WIFI_SECURITY_ENTERPRISE_EAP = 2; // 0x2

public static final int WIFI_SECURITY_OPEN = 0; // 0x0

public static final int WIFI_SECURITY_PERSONAL = 1; // 0x1

public static final int WIPE_EUICC = 4; // 0x4

public static final int WIPE_EXTERNAL_STORAGE = 1; // 0x1

public static final int WIPE_RESET_PROTECTION_DATA = 2; // 0x2

public static final int WIPE_SILENTLY = 8; // 0x8
@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class InstallSystemUpdateCallback {

public InstallSystemUpdateCallback() { throw new RuntimeException("Stub!"); }

public void onInstallUpdateError(int errorCode, @android.annotation.NonNull java.lang.String errorMessage) { throw new RuntimeException("Stub!"); }

public static final int UPDATE_ERROR_BATTERY_LOW = 5; // 0x5

public static final int UPDATE_ERROR_FILE_NOT_FOUND = 4; // 0x4

public static final int UPDATE_ERROR_INCORRECT_OS_VERSION = 2; // 0x2

public static final int UPDATE_ERROR_UNKNOWN = 1; // 0x1

public static final int UPDATE_ERROR_UPDATE_FILE_INVALID = 3; // 0x3
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnClearApplicationUserDataListener {

public void onApplicationUserDataCleared(java.lang.String packageName, boolean succeeded);
}

}

