/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.ondevicepersonalization;

import java.util.Set;

/**
 * An interface to a read-only key-value store.
 *
 * Used as a Data Access Object for the REMOTE_DATA table.
 *
 * @see android.adservices.ondevicepersonalization.IsolatedService#getRemoteData(RequestToken)
 *
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public interface KeyValueStore {

/**
 * Looks up a key in a read-only store.
 *
 * <br>
 * This method may take several seconds to complete, so it should
 * only be called from a worker thread.
 * @param key The key to look up.
 * This value cannot be {@code null}.
 * @return the value to which the specified key is mapped,
 * or null if there contains no mapping for the key.
 *
 */

@android.annotation.Nullable
public byte[] get(@android.annotation.NonNull java.lang.String key);

/**
 * Returns a Set view of the keys contained in the REMOTE_DATA table.
 
 * <br>
 * This method may take several seconds to complete, so it should
 * only be called from a worker thread.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Set<java.lang.String> keySet();
}

