/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.ondevicepersonalization;


/**
 * The result returned by
 * {@link android.adservices.ondevicepersonalization.IsolatedWorker#onExecute(android.adservices.ondevicepersonalization.ExecuteInput,android.os.OutcomeReceiver) IsolatedWorker#onExecute(ExecuteInput, android.os.OutcomeReceiver)} in response to a call to
 * {@code OnDevicePersonalizationManager#execute(ComponentName, PersistableBundle,
 * java.util.concurrent.Executor, OutcomeReceiver)}
 * from a client app.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class ExecuteOutput {

ExecuteOutput() { throw new RuntimeException("Stub!"); }

/**
 * Persistent data to be written to the REQUESTS table after
 * {@link android.adservices.ondevicepersonalization.IsolatedWorker#onExecute(android.adservices.ondevicepersonalization.ExecuteInput,android.os.OutcomeReceiver) IsolatedWorker#onExecute(ExecuteInput, android.os.OutcomeReceiver)}
 * completes. If null, no persistent data will be written.
 */

@android.annotation.Nullable
public android.adservices.ondevicepersonalization.RequestLogRecord getRequestLogRecord() { throw new RuntimeException("Stub!"); }

/**
 * A {@link android.adservices.ondevicepersonalization.RenderingConfig RenderingConfig} object that contains information about the content to be rendered
 * in the client app view. Can be null if no content is to be rendered.
 */

@android.annotation.Nullable
public android.adservices.ondevicepersonalization.RenderingConfig getRenderingConfig() { throw new RuntimeException("Stub!"); }

/**
 * A list of {@link android.adservices.ondevicepersonalization.EventLogRecord EventLogRecord} objects to be written to the EVENTS table. Each
 * {@link android.adservices.ondevicepersonalization.EventLogRecord EventLogRecord} must be associated with an existing {@link android.adservices.ondevicepersonalization.RequestLogRecord RequestLogRecord} in
 * the REQUESTS table, specified using
 * {@link android.adservices.ondevicepersonalization.EventLogRecord.Builder#setRequestLogRecord(android.adservices.ondevicepersonalization.RequestLogRecord) EventLogRecord.Builder#setRequestLogRecord(RequestLogRecord)}.
 * If the {@link android.adservices.ondevicepersonalization.RequestLogRecord RequestLogRecord} is not specified, the {@link android.adservices.ondevicepersonalization.EventLogRecord EventLogRecord} will not be
 * written.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.adservices.ondevicepersonalization.EventLogRecord> getEventLogRecords() { throw new RuntimeException("Stub!"); }

/**
 * A byte array that an {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService} may optionally return to to a calling app,
 * by setting this field to a non-null value.
 * The contents of this array will be returned to the caller of
 * {@link android.adservices.ondevicepersonalization.OnDevicePersonalizationManager#execute(ComponentName,PersistableBundle,java.util.concurrent.Executor,OutcomeReceiver) OnDevicePersonalizationManager#execute(ComponentName, PersistableBundle, java.util.concurrent.Executor, OutcomeReceiver)}
 * if returning data from isolated processes is allowed by policy and the
 * (calling app package, isolated service package) pair is present in an allowlist that
 * permits data to be returned.
 */

@android.annotation.Nullable
public byte[] getOutputData() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }
/**
 * A builder for {@link android.adservices.ondevicepersonalization.ExecuteOutput ExecuteOutput}
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Persistent data to be written to the REQUESTS table after
 * {@link android.adservices.ondevicepersonalization.IsolatedWorker#onExecute(android.adservices.ondevicepersonalization.ExecuteInput,android.os.OutcomeReceiver) IsolatedWorker#onExecute(ExecuteInput, android.os.OutcomeReceiver)}
 * completes. If null, no persistent data will be written.

 * @param value This value may be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.ExecuteOutput.Builder setRequestLogRecord(@android.annotation.Nullable android.adservices.ondevicepersonalization.RequestLogRecord value) { throw new RuntimeException("Stub!"); }

/**
 * A {@link android.adservices.ondevicepersonalization.RenderingConfig RenderingConfig} object that contains information about the content to be rendered
 * in the client app view. Can be null if no content is to be rendered.

 * @param value This value may be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.ExecuteOutput.Builder setRenderingConfig(@android.annotation.Nullable android.adservices.ondevicepersonalization.RenderingConfig value) { throw new RuntimeException("Stub!"); }

/**
 * A list of {@link android.adservices.ondevicepersonalization.EventLogRecord EventLogRecord} objects to be written to the EVENTS table. Each
 * {@link android.adservices.ondevicepersonalization.EventLogRecord EventLogRecord} must be associated with an existing {@link android.adservices.ondevicepersonalization.RequestLogRecord RequestLogRecord} in
 * the REQUESTS table, specified using
 * {@link android.adservices.ondevicepersonalization.EventLogRecord.Builder#setRequestLogRecord(android.adservices.ondevicepersonalization.RequestLogRecord) EventLogRecord.Builder#setRequestLogRecord(RequestLogRecord)}.
 * If the {@link android.adservices.ondevicepersonalization.RequestLogRecord RequestLogRecord} is not specified, the {@link android.adservices.ondevicepersonalization.EventLogRecord EventLogRecord} will not be
 * written.
 
 * @param value This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.ExecuteOutput.Builder setEventLogRecords(@android.annotation.NonNull java.util.List<android.adservices.ondevicepersonalization.EventLogRecord> value) { throw new RuntimeException("Stub!"); }

/**
 * @see #setEventLogRecords
 * @param value This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.ExecuteOutput.Builder addEventLogRecord(@android.annotation.NonNull android.adservices.ondevicepersonalization.EventLogRecord value) { throw new RuntimeException("Stub!"); }

/**
 * A byte array that an {@link android.adservices.ondevicepersonalization.IsolatedService IsolatedService} may optionally return to to a calling app,
 * by setting this field to a non-null value.
 * The contents of this array will be returned to the caller of
 * {@link android.adservices.ondevicepersonalization.OnDevicePersonalizationManager#execute(ComponentName,PersistableBundle,java.util.concurrent.Executor,OutcomeReceiver) OnDevicePersonalizationManager#execute(ComponentName, PersistableBundle, java.util.concurrent.Executor, OutcomeReceiver)}
 * if returning data from isolated processes is allowed by policy and the
 * (calling app package, isolated service package) pair is present in an allowlist that
 * permits data to be returned.

 * @param value This value may be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.ExecuteOutput.Builder setOutputData(@android.annotation.Nullable byte... value) { throw new RuntimeException("Stub!"); }

/**
 * Builds the instance. This builder should not be touched after calling this!
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.ondevicepersonalization.ExecuteOutput build() { throw new RuntimeException("Stub!"); }
}

}

