/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.measurement;

import android.net.Uri;
import android.view.InputEvent;

/**
 * Class to hold input to measurement source registration calls.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class SourceRegistrationRequest implements android.os.Parcelable {

SourceRegistrationRequest() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * Registration URIs to fetch sources.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.net.Uri> getRegistrationUris() { throw new RuntimeException("Stub!"); }

/**
 * User Interaction {@link android.view.InputEvent InputEvent} used by the AttributionReporting API to distinguish
 * clicks from views. It will be an {@link android.view.InputEvent InputEvent} object (for a click event) or null (for a
 * view event)
 */

@android.annotation.Nullable
public android.view.InputEvent getInputEvent() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param out This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel out, int flags) { throw new RuntimeException("Stub!"); }

/** Creator for Paracelable (via reflection). */

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.adservices.measurement.SourceRegistrationRequest> CREATOR;
static { CREATOR = null; }
/** Builder for {@link android.adservices.measurement.SourceRegistrationRequest SourceRegistrationRequest}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Builder constructor for {@link android.adservices.measurement.SourceRegistrationRequest SourceRegistrationRequest}.
 *
 * @param registrationUris source registration {@link android.net.Uri Uri}s
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException if the scheme for one or more of the
 * {@code registrationUris} is not HTTPS
 */

public Builder(@android.annotation.NonNull java.util.List<android.net.Uri> registrationUris) { throw new RuntimeException("Stub!"); }

/**
 * Setter corresponding to {@link #getInputEvent()}.
 *
 * @param inputEvent User Interaction {@link android.view.InputEvent InputEvent} used by the AttributionReporting
 *     API to distinguish clicks from views. It will be an {@link android.view.InputEvent InputEvent} object (for a
 *     click event) or null (for a view event)
 * @return builder

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.measurement.SourceRegistrationRequest.Builder setInputEvent(@android.annotation.Nullable android.view.InputEvent inputEvent) { throw new RuntimeException("Stub!"); }

/**
 * Pre-validates parameters and builds {@link android.adservices.measurement.SourceRegistrationRequest SourceRegistrationRequest}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.measurement.SourceRegistrationRequest build() { throw new RuntimeException("Stub!"); }
}

}

