/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.customaudience;

import android.adservices.common.AdTechIdentifier;
import android.os.OutcomeReceiver;
import java.util.concurrent.Executor;

/**
 * This POJO represents the {@link android.adservices.customaudience.TestCustomAudienceManager#removeCustomAudienceRemoteInfoOverride(android.adservices.customaudience.RemoveCustomAudienceOverrideRequest,java.util.concurrent.Executor,android.os.OutcomeReceiver) TestCustomAudienceManager#removeCustomAudienceRemoteInfoOverride(
 * RemoveCustomAudienceOverrideRequest, Executor, OutcomeReceiver)} request.
 *
 * <p>It contains fields {@code buyer} and {@code name} which will serve as the identifier for the
 * overrides to be removed.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class RemoveCustomAudienceOverrideRequest {

/**
 * @param buyer This value cannot be {@code null}.

 * @param name This value cannot be {@code null}.
 */

public RemoveCustomAudienceOverrideRequest(@android.annotation.NonNull android.adservices.common.AdTechIdentifier buyer, @android.annotation.NonNull java.lang.String name) { throw new RuntimeException("Stub!"); }

/**
 * @return an {@link android.adservices.common.AdTechIdentifier AdTechIdentifier} representing the buyer
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.common.AdTechIdentifier getBuyer() { throw new RuntimeException("Stub!"); }

/**
 * @return name of the custom audience being overridden
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getName() { throw new RuntimeException("Stub!"); }
/** Builder for {@link android.adservices.customaudience.RemoveCustomAudienceOverrideRequest RemoveCustomAudienceOverrideRequest} objects. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Sets the buyer {@link android.adservices.common.AdTechIdentifier AdTechIdentifier} for the custom audience.
 * @param buyer This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.RemoveCustomAudienceOverrideRequest.Builder setBuyer(@android.annotation.NonNull android.adservices.common.AdTechIdentifier buyer) { throw new RuntimeException("Stub!"); }

/**
 * Sets the name for the custom audience that was overridden.
 * @param name This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.RemoveCustomAudienceOverrideRequest.Builder setName(@android.annotation.NonNull java.lang.String name) { throw new RuntimeException("Stub!"); }

/**
 * Builds a {@link android.adservices.customaudience.RemoveCustomAudienceOverrideRequest RemoveCustomAudienceOverrideRequest} instance.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.customaudience.RemoveCustomAudienceOverrideRequest build() { throw new RuntimeException("Stub!"); }
}

}

