/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.adselection;

import android.adservices.common.AdTechIdentifier;
import android.os.OutcomeReceiver;
import java.util.concurrent.Executor;

/**
 * Represents a request containing the seller, the ad selection data id and data.
 *
 * <p>Instances of this class are created by SDKs to be provided as arguments to the {@link android.adservices.adselection.AdSelectionManager#persistAdSelectionResult  } methods in {@link android.adservices.adselection.AdSelectionManager AdSelectionManager}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class PersistAdSelectionResultRequest {

PersistAdSelectionResultRequest() { throw new RuntimeException("Stub!"); }

/**
 * @return an ad selection id.
 * @deprecated Use the {@link #getAdSelectionDataId()} instead, the underlying value is enforced
 *     to be the same.
 */

@Deprecated
public long getAdSelectionId() { throw new RuntimeException("Stub!"); }

/**
 * Returns the id that identifies the {@link android.adservices.adselection.AdSelectionManager#getAdSelectionData(android.adservices.adselection.GetAdSelectionDataRequest,java.util.concurrent.Executor,android.os.OutcomeReceiver)  }
 * payload that generated this result.
 */

public long getAdSelectionDataId() { throw new RuntimeException("Stub!"); }

/**
 * @return a seller.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public android.adservices.common.AdTechIdentifier getSeller() { throw new RuntimeException("Stub!"); }

/**
 * @return an ad selection result.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public byte[] getAdSelectionResult() { throw new RuntimeException("Stub!"); }
/** Builder for {@link android.adservices.adselection.PersistAdSelectionResultRequest PersistAdSelectionResultRequest} objects. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Sets the ad selection id {@link java.lang.Long Long}.
 *
 * @deprecated Use the {@link #setAdSelectionDataId(long)} instead.

 * @return This value cannot be {@code null}.
 */

@Deprecated
@android.annotation.NonNull
public android.adservices.adselection.PersistAdSelectionResultRequest.Builder setAdSelectionId(long adSelectionId) { throw new RuntimeException("Stub!"); }

/**
 * Sets the ad selection data id {@link java.lang.Long Long}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.PersistAdSelectionResultRequest.Builder setAdSelectionDataId(long adSelectionDataId) { throw new RuntimeException("Stub!"); }

/**
 * Sets the seller {@link android.adservices.common.AdTechIdentifier AdTechIdentifier}.
 * @param seller This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.PersistAdSelectionResultRequest.Builder setSeller(@android.annotation.Nullable android.adservices.common.AdTechIdentifier seller) { throw new RuntimeException("Stub!"); }

/**
 * Sets the ad selection result {@link java.lang.String String}.
 * @param adSelectionResult This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.PersistAdSelectionResultRequest.Builder setAdSelectionResult(@android.annotation.Nullable byte[] adSelectionResult) { throw new RuntimeException("Stub!"); }

/**
 * Builds a {@link android.adservices.adselection.PersistAdSelectionResultRequest PersistAdSelectionResultRequest} instance.
 *
 * @throws java.lang.IllegalArgumentException if the adSelectionIid is not set

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.adselection.PersistAdSelectionResultRequest build() { throw new RuntimeException("Stub!"); }
}

}

