/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.adservices.adselection;

import android.adservices.common.AdData;

/**
 * Represents an ad and its corresponding bid value after the bid generation step in the ad
 * selection process.
 *
 * <p>The ads and their bids are fed into an ad scoring process which will inform the final ad
 * selection. The currency unit for the bid is expected to be the same requested by the seller when
 * initiating the selection process and not specified in this class. The seller can provide the
 * currency via AdSelectionSignals. The currency is opaque to FLEDGE.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class AdWithBid implements android.os.Parcelable {

/**
 * @param adData An {@link android.adservices.common.AdData AdData} object defining an ad's render URI and buyer metadata
 * This value cannot be {@code null}.
 * @param bid The amount of money a buyer has bid to show an ad; note that while the bid is
 *     expected to be non-negative, this is only enforced during the ad selection process
 * @throws java.lang.NullPointerException if adData is null
 */

public AdWithBid(@android.annotation.NonNull android.adservices.common.AdData adData, double bid) { throw new RuntimeException("Stub!"); }

/**
 * @return the ad that was bid on

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.adservices.common.AdData getAdData() { throw new RuntimeException("Stub!"); }

/**
 * The bid is the amount of money an advertiser has bid during the ad selection process to show
 * an ad. The bid could be any non-negative {@code double}, such as 0.00, 0.17, 1.10, or
 * 1000.00.
 *
 * <p>The currency for a bid would be controlled by Seller and will remain consistent across a
 * run of Ad selection. This could be achieved by leveraging bidding signals during
 * "generateBid()" phase and using the same currency during the creation of contextual ads.
 * Having currency unit as a dedicated field could be supported in future releases.
 *
 * @return the bid value to be passed to the scoring function when scoring the ad returned by
 *     {@link #getAdData()}
 */

public double getBid() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.adservices.adselection.AdWithBid> CREATOR;
static { CREATOR = null; }
}

