/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.adservices.adid;

import android.content.Context;
import java.util.concurrent.Executor;

/**
 * AdId Manager provides APIs for app and ad-SDKs to access advertising ID. The advertising ID is a
 * unique, per-device, user-resettable ID for advertising. It gives users better controls and
 * provides developers with a simple, standard system to continue to monetize their apps via
 * personalized ads (formerly known as interest-based ads).
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class AdIdManager {

AdIdManager() { throw new RuntimeException("Stub!"); }

/**
 * Factory method for creating an instance of AdIdManager.
 *
 * @param context The {@link android.content.Context Context} to use
 * This value cannot be {@code null}.
 * @return A {@link android.adservices.adid.AdIdManager AdIdManager} instance
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public static android.adservices.adid.AdIdManager get(@android.annotation.NonNull android.content.Context context) { throw new RuntimeException("Stub!"); }

/**
 * Return the AdId.
 *
 * <br>
 * Requires {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_AD_ID}
 * @param executor The executor to run callback.
 * This value cannot be {@code null}.
 * Callback and listener events are dispatched through this
 * {@link java.util.concurrent.Executor Executor}, providing an easy way to control which thread is
 * used. To dispatch events through the main thread of your
 * application, you can use
 * {@link android.content.Context#getMainExecutor() Context.getMainExecutor()}.
 * Otherwise, provide an {@link java.util.concurrent.Executor Executor} that dispatches to an appropriate thread.
 * @param callback The callback that's called after adid are available or an error occurs.
 
 * This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public void getAdId(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<android.adservices.adid.AdId,java.lang.Exception> callback) { throw new RuntimeException("Stub!"); }

/**
 * Return the AdId. For use on Android R or lower.
 *
 * <br>
 * Requires {@link android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_AD_ID}
 * @param executor The executor to run callback.
 * This value cannot be {@code null}.
 * Callback and listener events are dispatched through this
 * {@link java.util.concurrent.Executor Executor}, providing an easy way to control which thread is
 * used. To dispatch events through the main thread of your
 * application, you can use
 * {@link android.content.Context#getMainExecutor() Context.getMainExecutor()}.
 * Otherwise, provide an {@link java.util.concurrent.Executor Executor} that dispatches to an appropriate thread.
 * @param callback The callback that's called after adid are available or an error occurs.
 
 * This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public void getAdId(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.adservices.common.AdServicesOutcomeReceiver<android.adservices.adid.AdId,java.lang.Exception> callback) { throw new RuntimeException("Stub!"); }
}

