/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.adservices.adid;


/**
 * A unique, user-resettable, device-wide, per-profile ID for advertising.
 *
 * <p>Ad networks may use {@code AdId} to monetize for Interest Based Advertising (IBA), i.e.
 * targeting and remarketing ads. The user may limit availability of this identifier.
 *
 * @see AdIdManager#getAdId(Executor, OutcomeReceiver)
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class AdId {

/**
 * Creates an instance of {@link android.adservices.adid.AdId AdId}
 *
 * @param adId obtained from the provider service.
 * This value cannot be {@code null}.
 * @param limitAdTrackingEnabled value from the provider service which determines the value of
 *     adId.
 */

public AdId(@android.annotation.NonNull java.lang.String adId, boolean limitAdTrackingEnabled) { throw new RuntimeException("Stub!"); }

/**
 * The advertising ID.
 *
 * <p>The value of advertising Id depends on a combination of {@link
 * #isLimitAdTrackingEnabled()} and {@link
 * android.adservices.common.AdServicesPermissions#ACCESS_ADSERVICES_AD_ID}.
 *
 * <p>When the user is {@link #isLimitAdTrackingEnabled limiting ad tracking}, the API returns
 * {@link #ZERO_OUT}. This disallows a caller to track the user for monetization purposes.
 *
 * <p>Otherwise, a string unique to the device and user is returned, which can be used to track
 * users for advertising.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getAdId() { throw new RuntimeException("Stub!"); }

/**
 * Retrieves the limit ad tracking enabled setting.
 *
 * <p>This value is true if user has limit ad tracking enabled, {@code false} otherwise.
 */

public boolean isLimitAdTrackingEnabled() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * A zeroed-out {@link #getAdId ad id} that is returned when the user has {@link
 * #isLimitAdTrackingEnabled limited ad tracking}.
 */

public static final java.lang.String ZERO_OUT = "00000000-0000-0000-0000-000000000000";
}

