/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.security.PublicKey;
import java.security.spec.EncodedKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import org.conscrypt.ArrayUtils;
import org.conscrypt.OpenSSLX25519Key;

public class OpenSSLX25519PublicKey
implements OpenSSLX25519Key,
PublicKey {
    private static final long serialVersionUID = 453861992373478445L;
    private static final byte[] X509_PREAMBLE = new byte[]{48, 42, 48, 5, 6, 3, 43, 101, 110, 3, 33, 0};
    private final byte[] uCoordinate;

    public OpenSSLX25519PublicKey(EncodedKeySpec keySpec) throws InvalidKeySpecException {
        byte[] encoded = keySpec.getEncoded();
        if ("X.509".equals(keySpec.getFormat())) {
            if (!ArrayUtils.startsWith(encoded, X509_PREAMBLE)) {
                throw new InvalidKeySpecException("Invalid format");
            }
            int totalLength = X509_PREAMBLE.length + 32;
            if (encoded.length < totalLength) {
                throw new InvalidKeySpecException("Invalid key size");
            }
            this.uCoordinate = Arrays.copyOfRange(encoded, X509_PREAMBLE.length, totalLength);
        } else if ("raw".equalsIgnoreCase(keySpec.getFormat())) {
            if (encoded.length != 32) {
                throw new InvalidKeySpecException("Invalid key size");
            }
            this.uCoordinate = encoded;
        } else {
            throw new InvalidKeySpecException("Encoding must be in X.509 or raw format");
        }
    }

    public OpenSSLX25519PublicKey(byte[] coordinateBytes) {
        if (coordinateBytes.length != 32) {
            throw new IllegalArgumentException("Invalid key size");
        }
        this.uCoordinate = (byte[])coordinateBytes.clone();
    }

    @Override
    public String getAlgorithm() {
        return "XDH";
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        if (this.uCoordinate == null) {
            throw new IllegalStateException("key is destroyed");
        }
        return ArrayUtils.concat(X509_PREAMBLE, this.uCoordinate);
    }

    @Override
    public byte[] getU() {
        if (this.uCoordinate == null) {
            throw new IllegalStateException("key is destroyed");
        }
        return (byte[])this.uCoordinate.clone();
    }

    public boolean equals(Object o) {
        if (this.uCoordinate == null) {
            throw new IllegalStateException("key is destroyed");
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenSSLX25519PublicKey)) {
            return false;
        }
        OpenSSLX25519PublicKey that = (OpenSSLX25519PublicKey)o;
        return Arrays.equals(this.uCoordinate, that.uCoordinate);
    }

    public int hashCode() {
        if (this.uCoordinate == null) {
            throw new IllegalStateException("key is destroyed");
        }
        return Arrays.hashCode(this.uCoordinate);
    }
}

