/*
 * Decompiled with CFR 0.152.
 */
package com.google.archivepatcher.generator.bsdiff;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public interface RandomAccessObject
extends DataInput,
DataOutput,
Closeable {
    public long length() throws IOException;

    public void seek(long var1) throws IOException;

    public void seekToIntAligned(long var1) throws IOException;

    public static final class RandomAccessMmapObject
    extends RandomAccessByteArrayObject {
        private final boolean mShouldDeleteFileOnRelease;
        private final File mFile;
        private final FileChannel mFileChannel;

        public RandomAccessMmapObject(RandomAccessFile randomAccessFile, String mode) throws IOException, IllegalArgumentException {
            if (randomAccessFile.length() > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Only files up to 2GiB in size are supported.");
            }
            FileChannel.MapMode mapMode = mode.equals("r") ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE;
            this.mFileChannel = randomAccessFile.getChannel();
            this.mByteBuffer = this.mFileChannel.map(mapMode, 0L, randomAccessFile.length());
            this.mByteBuffer.position(0);
            this.mShouldDeleteFileOnRelease = false;
            this.mFile = null;
        }

        public RandomAccessMmapObject(String tempFileName, String mode, long length) throws IOException, IllegalArgumentException {
            if (length > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("RandomAccessMmapObject only supports file sizes up to Integer.MAX_VALUE.");
            }
            this.mFile = File.createTempFile(tempFileName, "temp");
            this.mFile.deleteOnExit();
            this.mShouldDeleteFileOnRelease = true;
            FileChannel.MapMode mapMode = mode.equals("r") ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE;
            RandomAccessFile file = null;
            try {
                file = new RandomAccessFile(this.mFile, mode);
                this.mFileChannel = file.getChannel();
                this.mByteBuffer = this.mFileChannel.map(mapMode, 0L, (int)length);
                this.mByteBuffer.position(0);
            }
            catch (IOException e) {
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.close();
                throw new IOException("Unable to open file", e);
            }
        }

        public RandomAccessMmapObject(File tempFile, String mode) throws IOException, IllegalArgumentException {
            if (tempFile.length() > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Only files up to 2GiB in size are supported.");
            }
            this.mFile = tempFile;
            this.mFile.deleteOnExit();
            this.mShouldDeleteFileOnRelease = true;
            FileChannel.MapMode mapMode = mode.equals("r") ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE;
            RandomAccessFile file = null;
            try {
                file = new RandomAccessFile(this.mFile, mode);
                this.mFileChannel = file.getChannel();
                this.mByteBuffer = this.mFileChannel.map(mapMode, 0L, tempFile.length());
                this.mByteBuffer.position(0);
            }
            catch (IOException e) {
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.close();
                throw new IOException("Unable to open file", e);
            }
        }

        @Override
        public void close() throws IOException {
            if (this.mFileChannel != null) {
                this.mFileChannel.close();
            }
            this.mByteBuffer = null;
            System.gc();
            if (this.mShouldDeleteFileOnRelease && this.mFile != null) {
                this.mFile.delete();
            }
        }
    }

    public static class RandomAccessByteArrayObject
    implements RandomAccessObject {
        protected ByteBuffer mByteBuffer;

        public RandomAccessByteArrayObject(byte[] byteArray) {
            this.mByteBuffer = ByteBuffer.wrap(byteArray);
        }

        public RandomAccessByteArrayObject(int length) {
            this.mByteBuffer = ByteBuffer.allocate(length);
        }

        protected RandomAccessByteArrayObject() {
        }

        @Override
        public long length() {
            return this.mByteBuffer.capacity();
        }

        @Override
        public byte readByte() {
            return this.mByteBuffer.get();
        }

        @Override
        public int readInt() {
            return this.mByteBuffer.getInt();
        }

        public void writeByte(byte b) {
            this.mByteBuffer.put(b);
        }

        @Override
        public void writeInt(int i) {
            this.mByteBuffer.putInt(i);
        }

        @Override
        public void seek(long pos) {
            if (pos > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("RandomAccessByteArrayObject can only handle seek() addresses up to Integer.MAX_VALUE.");
            }
            this.mByteBuffer.position((int)pos);
        }

        @Override
        public void seekToIntAligned(long pos) {
            this.seek(pos * 4L);
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public boolean readBoolean() {
            return this.readByte() != 0;
        }

        @Override
        public char readChar() {
            return this.mByteBuffer.getChar();
        }

        @Override
        public double readDouble() {
            return this.mByteBuffer.getDouble();
        }

        @Override
        public float readFloat() {
            return this.mByteBuffer.getFloat();
        }

        @Override
        public void readFully(byte[] b) {
            this.mByteBuffer.get(b);
        }

        @Override
        public void readFully(byte[] b, int off, int len) {
            this.mByteBuffer.get(b, off, len);
        }

        @Override
        public String readLine() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long readLong() {
            return this.mByteBuffer.getLong();
        }

        @Override
        public short readShort() {
            return this.mByteBuffer.getShort();
        }

        @Override
        public int readUnsignedByte() {
            return this.mByteBuffer.get() & 0xFF;
        }

        @Override
        public int readUnsignedShort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String readUTF() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int skipBytes(int n) {
            this.mByteBuffer.position(this.mByteBuffer.position() + n);
            return n;
        }

        @Override
        public void write(byte[] b) {
            this.mByteBuffer.put(b);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            this.mByteBuffer.put(b, off, len);
        }

        @Override
        public void write(int b) {
            this.writeByte((byte)b);
        }

        @Override
        public void writeBoolean(boolean v) {
            this.writeByte(v ? (byte)1 : 0);
        }

        @Override
        public void writeByte(int v) {
            this.writeByte((byte)v);
        }

        @Override
        public void writeBytes(String s) {
            for (int x = 0; x < s.length(); ++x) {
                this.writeByte((byte)s.charAt(x));
            }
        }

        @Override
        public void writeChar(int v) {
            this.mByteBuffer.putChar((char)v);
        }

        @Override
        public void writeChars(String s) {
            for (int x = 0; x < s.length(); ++x) {
                this.writeChar(s.charAt(x));
            }
        }

        @Override
        public void writeDouble(double v) {
            this.mByteBuffer.putDouble(v);
        }

        @Override
        public void writeFloat(float v) {
            this.mByteBuffer.putFloat(v);
        }

        @Override
        public void writeLong(long v) {
            this.mByteBuffer.putLong(v);
        }

        @Override
        public void writeShort(int v) {
            this.mByteBuffer.putShort((short)v);
        }

        @Override
        public void writeUTF(String s) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class RandomAccessFileObject
    extends RandomAccessFile
    implements RandomAccessObject {
        private final boolean mShouldDeleteFileOnClose;
        private final File mFile;

        public RandomAccessFileObject(File tempFile, String mode) throws IOException {
            this(tempFile, mode, false);
        }

        public RandomAccessFileObject(File tempFile, String mode, boolean deleteFileOnClose) throws IOException {
            super(tempFile, mode);
            this.mShouldDeleteFileOnClose = deleteFileOnClose;
            this.mFile = tempFile;
            if (this.mShouldDeleteFileOnClose) {
                this.mFile.deleteOnExit();
            }
        }

        @Override
        public void seekToIntAligned(long pos) throws IOException {
            this.seek(pos * 4L);
        }

        @Override
        public void close() throws IOException {
            super.close();
            if (this.mShouldDeleteFileOnClose) {
                this.mFile.delete();
            }
        }
    }
}

