/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.unpack200;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;

public class SegmentConstantPoolArrayCache {
    protected IdentityHashMap<String[], CachedArray> knownArrays = new IdentityHashMap(1000);
    protected List<Integer> lastIndexes;
    protected String[] lastArray;
    protected String lastKey;

    public List<Integer> indexesForArrayKey(String[] array2, String key) {
        if (!this.arrayIsCached(array2)) {
            this.cacheArray(array2);
        }
        if (this.lastArray == array2 && this.lastKey == key) {
            return this.lastIndexes;
        }
        this.lastArray = array2;
        this.lastKey = key;
        this.lastIndexes = this.knownArrays.get(array2).indexesForKey(key);
        return this.lastIndexes;
    }

    protected boolean arrayIsCached(String[] array2) {
        if (!this.knownArrays.containsKey(array2)) {
            return false;
        }
        CachedArray cachedArray = this.knownArrays.get(array2);
        return cachedArray.lastKnownSize() == array2.length;
    }

    protected void cacheArray(String[] array2) {
        if (this.arrayIsCached(array2)) {
            throw new IllegalArgumentException("Trying to cache an array that already exists");
        }
        this.knownArrays.put(array2, new CachedArray(array2));
        this.lastArray = null;
    }

    protected class CachedArray {
        String[] primaryArray;
        int lastKnownSize;
        HashMap<String, List<Integer>> primaryTable;

        public CachedArray(String[] array2) {
            this.primaryArray = array2;
            this.lastKnownSize = array2.length;
            this.primaryTable = new HashMap(this.lastKnownSize);
            this.cacheIndexes();
        }

        public int lastKnownSize() {
            return this.lastKnownSize;
        }

        public List<Integer> indexesForKey(String key) {
            if (!this.primaryTable.containsKey(key)) {
                return Collections.EMPTY_LIST;
            }
            return this.primaryTable.get(key);
        }

        protected void cacheIndexes() {
            for (int index2 = 0; index2 < this.primaryArray.length; ++index2) {
                String key = this.primaryArray[index2];
                if (!this.primaryTable.containsKey(key)) {
                    this.primaryTable.put(key, new ArrayList());
                }
                this.primaryTable.get(key).add(index2);
            }
        }
    }
}

