/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;

class Limiter<T>
extends AbstractCollection<T> {
    private T[] data;
    private final int limit;
    private final Comparator<? super T> comparator;
    private int size;
    private boolean initial = true;

    public Limiter(int limit2, Comparator<? super T> comparator) {
        this.limit = limit2;
        this.comparator = comparator;
        this.data = new Object[Math.min(1000, limit2) * 2];
    }

    public boolean put(T t) {
        if (this.initial) {
            if (this.size == this.data.length) {
                if (this.size < this.limit * 2) {
                    Object[] newData = new Object[Math.min(this.limit, this.size) * 2];
                    System.arraycopy(this.data, 0, newData, 0, this.size);
                    this.data = newData;
                } else {
                    Arrays.sort(this.data, this.comparator);
                    this.initial = false;
                    this.size = this.limit;
                }
                this.put(t);
            } else {
                this.data[this.size++] = t;
            }
            return true;
        }
        if (this.size == this.data.length) {
            this.sortTail();
        }
        if (this.comparator.compare(t, this.data[this.limit - 1]) < 0) {
            this.data[this.size++] = t;
            return true;
        }
        return false;
    }

    public Limiter<T> putAll(Limiter<T> ls) {
        int i2;
        if (!ls.initial) {
            for (i2 = 0; i2 < this.limit && this.put(ls.data[i2]); ++i2) {
            }
            i2 = this.limit;
        }
        while (i2 < ls.size) {
            this.put(ls.data[i2]);
            ++i2;
        }
        return this;
    }

    private void sortTail() {
        T[] d = this.data;
        int l = this.limit;
        int s = this.size;
        Comparator<T> cmp = this.comparator;
        Arrays.sort(d, l, s, cmp);
        if (cmp.compare(d[s - 1], d[0]) < 0) {
            System.arraycopy(d, 0, d, s - l, 2 * l - s);
            System.arraycopy(d, l, d, 0, s - l);
        } else {
            Object[] buf = new Object[l];
            int i2 = 0;
            int j = l;
            int k = 0;
            while (i2 < l - 1 && k < l && j < s) {
                if (cmp.compare(d[i2], d[j]) <= 0) {
                    buf[k++] = d[i2++];
                    continue;
                }
                buf[k++] = d[j++];
            }
            if (k < l) {
                System.arraycopy(d, i2 < l - 1 ? i2 : j, d, k, l - k);
            }
            System.arraycopy(buf, 0, d, 0, k);
        }
        this.size = l;
    }

    public void sort() {
        if (this.initial) {
            Arrays.sort(this.data, 0, this.size, this.comparator);
        } else if (this.size > this.limit) {
            this.sortTail();
        }
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOfRange(this.data, 0, this.size());
    }

    @Override
    public Iterator<T> iterator() {
        return Arrays.asList(this.data).subList(0, this.size()).iterator();
    }

    @Override
    public int size() {
        return this.initial && this.size < this.limit ? this.size : this.limit;
    }
}

