/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.util.Spliterator;
import java.util.function.Consumer;

class CharSpliterator
implements Spliterator<String> {
    private final CharSequence source;
    private final char delimiter;
    private int pos;
    private final int fence;
    private int nEmpty;
    private String next;
    private final boolean trimEmpty;

    CharSpliterator(CharSequence source, char delimiter, boolean trimEmpty) {
        this.source = source;
        this.delimiter = delimiter;
        this.fence = source.length();
        this.trimEmpty = trimEmpty;
    }

    private CharSpliterator(CharSpliterator suffix, int fence, boolean trimEmpty, int suffixNEmpty, int suffixPos) {
        this.source = suffix.source;
        this.delimiter = suffix.delimiter;
        this.fence = fence;
        this.trimEmpty = trimEmpty;
        this.pos = suffix.pos;
        suffix.pos = suffixPos;
        this.nEmpty = suffix.nEmpty;
        suffix.nEmpty = suffixNEmpty;
        this.next = suffix.next;
        suffix.next = null;
    }

    private int next(int pos) {
        if (pos == this.fence) {
            return pos;
        }
        if (this.source instanceof String) {
            int nextPos = ((String)this.source).indexOf(this.delimiter, pos);
            return nextPos == -1 ? this.fence : nextPos;
        }
        while (pos < this.fence) {
            if (this.source.charAt(pos) == this.delimiter) {
                return pos;
            }
            ++pos;
        }
        return this.fence;
    }

    @Override
    public boolean tryAdvance(Consumer<? super String> action2) {
        if (this.nEmpty > 0) {
            --this.nEmpty;
            action2.accept("");
            return true;
        }
        if (this.next != null) {
            action2.accept(this.next);
            this.next = null;
            return true;
        }
        if (this.pos > this.fence) {
            return false;
        }
        int nextPos = this.next(this.pos);
        if (this.trimEmpty) {
            while (nextPos == this.pos && nextPos != this.fence) {
                ++this.nEmpty;
                nextPos = this.next(++this.pos);
            }
        }
        String str = this.source.subSequence(this.pos, nextPos).toString();
        this.pos = nextPos + 1;
        if (this.trimEmpty && nextPos == this.fence && str.isEmpty()) {
            this.nEmpty = 0;
            return false;
        }
        if (this.nEmpty > 0) {
            this.next = str;
            --this.nEmpty;
            action2.accept("");
        } else {
            action2.accept(str);
        }
        return true;
    }

    @Override
    public Spliterator<String> trySplit() {
        int mid = this.pos + this.fence >>> 1;
        int nextPos = this.next(mid);
        if (nextPos == this.fence) {
            return null;
        }
        if (this.trimEmpty && nextPos == mid) {
            while (nextPos < this.fence && this.source.charAt(nextPos) == this.delimiter) {
                ++nextPos;
            }
            return nextPos == this.fence ? new CharSpliterator(this, mid, true, 0, nextPos + 1) : new CharSpliterator(this, mid, false, nextPos - mid - 1, nextPos);
        }
        return new CharSpliterator(this, nextPos, false, 0, nextPos + 1);
    }

    @Override
    public long estimateSize() {
        return this.pos > this.fence ? 0L : (long)(this.fence - this.pos);
    }

    @Override
    public int characteristics() {
        return 272;
    }
}

