/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage.impl.containers;

import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMutableMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010'\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0004B=\b\u0002\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0003\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\t0\u0003\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0017\u001a\u00020\u0018H\u0007J\b\u0010\u0019\u001a\u00020\u0018H\u0016J\u0015\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0015\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000J\u0018\u0010!\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u001c\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\"J\u001b\u0010#\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010$2\u0006\u0010\u001f\u001a\u00028\u0001\u00a2\u0006\u0002\u0010%J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006H\u0007J\b\u0010'\u001a\u00020\u001bH\u0016J\u001f\u0010(\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u001c\u001a\u00028\u00002\u0006\u0010\u001f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010)J\u001e\u0010*\u001a\u00020\u00182\u0014\u0010+\u001a\u0010\u0012\u0006\b\u0001\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010,H\u0016J\u0017\u0010-\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u001c\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\"J\u0013\u0010.\u001a\u00020\u00182\u0006\u0010/\u001a\u00028\u0001\u00a2\u0006\u0002\u00100J\b\u00101\u001a\u000202H\u0016R&\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\f0\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\t0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000e\u00a8\u00063"}, d2={"Lcom/intellij/workspaceModel/storage/impl/containers/BidirectionalMap;", "K", "V", "", "()V", "slotsWithList", "", "keyToValueMap", "valueToKeysMap", "", "(Ljava/util/Set;Ljava/util/Map;Ljava/util/Map;)V", "entries", "", "getEntries", "()Ljava/util/Set;", "keys", "getKeys", "size", "", "getSize", "()I", "values", "getValues", "assertConsistency", "", "clear", "containsKey", "", "key", "(Ljava/lang/Object;)Z", "containsValue", "value", "copy", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "getKeysByValue", "", "(Ljava/lang/Object;)Ljava/util/List;", "getSlotsWithList", "isEmpty", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "putAll", "from", "", "remove", "removeValue", "v", "(Ljava/lang/Object;)V", "toString", "", "intellij.platform.workspaceModel.storage"})
@SourceDebugExtension(value={"SMAP\nBidirectionalMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BidirectionalMap.kt\ncom/intellij/workspaceModel/storage/impl/containers/BidirectionalMap\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,180:1\n1855#2,2:181\n1549#2:183\n1620#2,3:184\n1855#2,2:189\n1#3:187\n215#4:188\n216#4:191\n*S KotlinDebug\n*F\n+ 1 BidirectionalMap.kt\ncom/intellij/workspaceModel/storage/impl/containers/BidirectionalMap\n*L\n145#1:181,2\n157#1:183\n157#1:184,3\n165#1:189,2\n162#1:188\n162#1:191\n*E\n"})
public final class BidirectionalMap<K, V>
implements Map<K, V>,
KMutableMap {
    @NotNull
    private final Set<V> slotsWithList;
    @NotNull
    private final Map<K, V> keyToValueMap;
    @NotNull
    private final Map<V, Object> valueToKeysMap;

    private BidirectionalMap(Set<V> slotsWithList, Map<K, V> keyToValueMap, Map<V, Object> valueToKeysMap) {
        this.slotsWithList = slotsWithList;
        this.keyToValueMap = keyToValueMap;
        this.valueToKeysMap = valueToKeysMap;
    }

    public BidirectionalMap() {
        Set set = new HashSet();
        Map map2 = CollectionFactory.createSmallMemoryFootprintMap();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"createSmallMemoryFootprintMap<K,V>()");
        Map map3 = CollectionFactory.createSmallMemoryFootprintMap();
        Intrinsics.checkNotNullExpressionValue(map3, (String)"createSmallMemoryFootprintMap<V,Any>()");
        this(set, map2, map3);
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        Object existingKeys;
        V oldValue = this.keyToValueMap.put(key, value);
        if (oldValue != null) {
            if (Intrinsics.areEqual(oldValue, value)) {
                return oldValue;
            }
            Object object = this.valueToKeysMap.get(oldValue);
            Intrinsics.checkNotNull((Object)object);
            Object keys2 = object;
            if (TypeIntrinsics.isMutableList((Object)keys2)) {
                TypeIntrinsics.asMutableCollection((Object)((Collection)keys2)).remove(key);
                if (((List)keys2).size() == 1) {
                    Object e = ((List)keys2).get(0);
                    Intrinsics.checkNotNull(e);
                    this.valueToKeysMap.put(oldValue, e);
                    this.slotsWithList.remove(oldValue);
                } else if (((List)keys2).isEmpty()) {
                    this.valueToKeysMap.remove(oldValue);
                    this.slotsWithList.remove(oldValue);
                }
            } else {
                this.valueToKeysMap.remove(oldValue);
            }
        }
        if ((existingKeys = this.valueToKeysMap.get(value)) == null) {
            K k = key;
            Intrinsics.checkNotNull(k);
            this.valueToKeysMap.put(value, k);
            return oldValue;
        }
        if (TypeIntrinsics.isMutableList((Object)existingKeys)) {
            TypeIntrinsics.asMutableList((Object)existingKeys);
            ((List)existingKeys).add(key);
        } else {
            Map<Object, Object> map2 = this.valueToKeysMap;
            Object object = new Object[]{existingKeys, key};
            object = new SmartList<Object>(object);
            map2.put(value, object);
            this.slotsWithList.add(value);
        }
        return oldValue;
    }

    @Override
    public void clear() {
        this.slotsWithList.clear();
        this.keyToValueMap.clear();
        this.valueToKeysMap.clear();
    }

    @Nullable
    public final List<K> getKeysByValue(V value) {
        List list;
        Object object = this.valueToKeysMap.get(value);
        if (object != null) {
            Object keys2 = object;
            boolean bl = false;
            list = TypeIntrinsics.isMutableList((Object)keys2) ? TypeIntrinsics.asMutableList((Object)keys2) : (List)new SmartList<Object>(keys2);
        } else {
            list = null;
        }
        return list;
    }

    @NotNull
    public Set<K> getKeys() {
        return this.keyToValueMap.keySet();
    }

    public int getSize() {
        return this.keyToValueMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.keyToValueMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keyToValueMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.valueToKeysMap.containsKey(value);
    }

    @Override
    @Nullable
    public V get(Object key) {
        return this.keyToValueMap.get(key);
    }

    public final void removeValue(V v) {
        Object keys2 = this.valueToKeysMap.remove(v);
        if (keys2 != null) {
            if (TypeIntrinsics.isMutableList((Object)keys2)) {
                for (Object k : (List)keys2) {
                    TypeIntrinsics.asMutableMap(this.keyToValueMap).remove(k);
                }
                this.slotsWithList.remove(v);
            } else {
                this.keyToValueMap.remove(keys2);
            }
        }
    }

    @Override
    @Nullable
    public V remove(Object key) {
        V value = this.keyToValueMap.remove(key);
        Object keys2 = this.valueToKeysMap.get(value);
        if (keys2 != null) {
            if (TypeIntrinsics.isMutableList((Object)keys2) && ((List)keys2).size() > 1) {
                TypeIntrinsics.asMutableCollection((Object)((Collection)keys2)).remove(key);
                if (((List)keys2).size() == 1) {
                    V v = value;
                    Intrinsics.checkNotNull(v);
                    Object e = ((List)keys2).get(0);
                    Intrinsics.checkNotNull(e);
                    this.valueToKeysMap.put(v, e);
                    this.slotsWithList.remove(value);
                }
            } else {
                if (TypeIntrinsics.isMutableList((Object)keys2)) {
                    TypeIntrinsics.asMutableCollection((Object)this.slotsWithList).remove(value);
                }
                TypeIntrinsics.asMutableMap(this.valueToKeysMap).remove(value);
            }
        }
        return value;
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> from) {
        Intrinsics.checkNotNullParameter(from, (String)"from");
        for (Map.Entry<K, V> entry : from.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            this.put(key, value);
        }
    }

    @NotNull
    public Set<V> getValues() {
        return this.valueToKeysMap.keySet();
    }

    @NotNull
    public Set<Map.Entry<K, V>> getEntries() {
        return this.keyToValueMap.entrySet();
    }

    @NotNull
    public final BidirectionalMap<K, V> copy() {
        Map map2 = CollectionFactory.createSmallMemoryFootprintMap(this.valueToKeysMap);
        Intrinsics.checkNotNullExpressionValue(map2, (String)"createSmallMemoryFootprintMap(valueToKeysMap)");
        Map clonedValueToKeysMap = map2;
        Iterable $this$forEach$iv = this.slotsWithList;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            Object value = element$iv = iterator2.next();
            boolean bl = false;
            Map map3 = clonedValueToKeysMap;
            Object object = this.valueToKeysMap.get(value);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<K of com.intellij.workspaceModel.storage.impl.containers.BidirectionalMap.copy$lambda$1>");
            SmartList smartList = new SmartList((List)object);
            map3.put(value, smartList);
        }
        Set set = new HashSet(this.slotsWithList);
        Map<K, V> map4 = CollectionFactory.createSmallMemoryFootprintMap(this.keyToValueMap);
        Intrinsics.checkNotNullExpressionValue(map4, (String)"createSmallMemoryFootprintMap(keyToValueMap)");
        return new BidirectionalMap<K, V>(set, map4, clonedValueToKeysMap);
    }

    @TestOnly
    @NotNull
    public final Set<V> getSlotsWithList() {
        return this.slotsWithList;
    }

    /*
     * WARNING - void declaration
     */
    @TestOnly
    public final void assertConsistency() {
        void $this$mapTo$iv$iv;
        void $this$map$iv22;
        Iterable iterable = this.valueToKeysMap.values();
        Set<K> set = this.keyToValueMap.keySet();
        boolean $i$f$map = false;
        Iterator<Map.Entry<V, Object>> iterator2 = $this$map$iv22;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv22, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator3 = $this$mapTo$iv$iv.iterator();
        while (iterator3.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator3.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it instanceof SmartList ? (SmartList<Object>)it : new SmartList<void>(it));
        }
        boolean $this$map$iv22 = Intrinsics.areEqual(set, (Object)CollectionsKt.toSet((Iterable)CollectionsKt.flatten((Iterable)((List)destination$iv$iv))));
        if (_Assertions.ENABLED && !$this$map$iv22) {
            boolean $i$a$-assert-BidirectionalMap$assertConsistency$42 = false;
            String $i$a$-assert-BidirectionalMap$assertConsistency$42 = "The count of keys in one map does not equal the amount on the second map";
            throw new AssertionError((Object)$i$a$-assert-BidirectionalMap$assertConsistency$42);
        }
        $this$map$iv22 = Intrinsics.areEqual((Object)CollectionsKt.toSet((Iterable)this.keyToValueMap.values()), this.valueToKeysMap.keySet());
        if (_Assertions.ENABLED && !$this$map$iv22) {
            boolean $i$a$-assert-BidirectionalMap$assertConsistency$52 = false;
            String $i$a$-assert-BidirectionalMap$assertConsistency$52 = "The count of values in one map does not equal the amount on the second map";
            throw new AssertionError((Object)$i$a$-assert-BidirectionalMap$assertConsistency$52);
        }
        Map<V, Object> $this$forEach$iv = this.valueToKeysMap;
        boolean $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Object, Object> element$iv;
            Map.Entry<Object, Object> entry = element$iv = iterator2.next();
            boolean bl = false;
            V value = entry.getKey();
            Object keys2 = entry.getValue();
            if (keys2 instanceof SmartList) {
                boolean bl2 = this.slotsWithList.contains(value);
                if (_Assertions.ENABLED && !bl2) {
                    boolean $i$a$-assert-BidirectionalMap$assertConsistency$4$22 = false;
                    String $i$a$-assert-BidirectionalMap$assertConsistency$4$22 = "Not registered value: " + value + " with list at slotsWithList collection";
                    throw new AssertionError((Object)$i$a$-assert-BidirectionalMap$assertConsistency$4$22);
                }
                Iterable $this$forEach$iv2 = (Iterable)keys2;
                boolean $i$f$forEach2 = false;
                Iterator iterator4 = $this$forEach$iv2.iterator();
                while (iterator4.hasNext()) {
                    Object element$iv2;
                    Object it = element$iv2 = iterator4.next();
                    boolean bl3 = false;
                    boolean bl4 = this.keyToValueMap.containsKey(it);
                    if (_Assertions.ENABLED && !bl4) {
                        boolean $i$a$-assert-BidirectionalMap$assertConsistency$4$2$32 = false;
                        String $i$a$-assert-BidirectionalMap$assertConsistency$4$2$32 = "Key: " + it + " is not registered at keyToValueMap collection";
                        throw new AssertionError((Object)$i$a$-assert-BidirectionalMap$assertConsistency$4$2$32);
                    }
                    bl4 = Intrinsics.areEqual(this.keyToValueMap.get(it), value);
                    if (!_Assertions.ENABLED || bl4) continue;
                    boolean bl5 = false;
                    String string2 = "Value by key: " + it + " is different in collections. Expected: " + value + " but actual " + this.keyToValueMap.get(it);
                    throw new AssertionError((Object)string2);
                }
                continue;
            }
            boolean bl6 = this.keyToValueMap.containsKey(keys2);
            if (_Assertions.ENABLED && !bl6) {
                boolean $i$a$-assert-BidirectionalMap$assertConsistency$4$52 = false;
                String $i$a$-assert-BidirectionalMap$assertConsistency$4$52 = "Key: " + keys2 + " is not registered at keyToValueMap collection";
                throw new AssertionError((Object)$i$a$-assert-BidirectionalMap$assertConsistency$4$52);
            }
            bl6 = Intrinsics.areEqual(this.keyToValueMap.get(keys2), value);
            if (!_Assertions.ENABLED || bl6) continue;
            boolean bl7 = false;
            String string3 = "Value by key: " + keys2 + " is different in collections. Expected: " + value + " but actual " + this.keyToValueMap.get(keys2);
            throw new AssertionError((Object)string3);
        }
    }

    @NotNull
    public String toString() {
        return this.keyToValueMap.toString();
    }
}

