/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage.impl;

import com.intellij.workspaceModel.storage.EntitySource;
import com.intellij.workspaceModel.storage.SymbolicEntityId;
import com.intellij.workspaceModel.storage.impl.AbstractEntityStorage;
import com.intellij.workspaceModel.storage.impl.EntitiesKt;
import com.intellij.workspaceModel.storage.impl.EntityFamily;
import com.intellij.workspaceModel.storage.impl.EntityIdKt;
import com.intellij.workspaceModel.storage.impl.MutableStorageIndexes;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityData;
import com.intellij.workspaceModel.storage.impl.external.ExternalEntityMappingImpl;
import com.intellij.workspaceModel.storage.impl.external.MutableExternalEntityMappingImpl;
import com.intellij.workspaceModel.storage.impl.indices.EntityStorageInternalIndex;
import com.intellij.workspaceModel.storage.impl.indices.MultimapStorageIndex;
import com.intellij.workspaceModel.storage.impl.indices.SymbolicIdInternalIndex;
import com.intellij.workspaceModel.storage.impl.indices.VirtualFileIndex;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u0000 #2\u00020\u0001:\u0001#B-\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bBC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0016\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\r\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0006\u0010!\u001a\u00020\"R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R$\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\rX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\t\u001a\u00020\nX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0004\u001a\u00020\u0005X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006$"}, d2={"Lcom/intellij/workspaceModel/storage/impl/StorageIndexes;", "", "softLinks", "Lcom/intellij/workspaceModel/storage/impl/indices/MultimapStorageIndex;", "virtualFileIndex", "Lcom/intellij/workspaceModel/storage/impl/indices/VirtualFileIndex;", "entitySourceIndex", "Lcom/intellij/workspaceModel/storage/impl/indices/EntityStorageInternalIndex;", "Lcom/intellij/workspaceModel/storage/EntitySource;", "symbolicIdIndex", "Lcom/intellij/workspaceModel/storage/impl/indices/SymbolicIdInternalIndex;", "(Lcom/intellij/workspaceModel/storage/impl/indices/MultimapStorageIndex;Lcom/intellij/workspaceModel/storage/impl/indices/VirtualFileIndex;Lcom/intellij/workspaceModel/storage/impl/indices/EntityStorageInternalIndex;Lcom/intellij/workspaceModel/storage/impl/indices/SymbolicIdInternalIndex;)V", "externalMappings", "", "", "Lcom/intellij/workspaceModel/storage/impl/external/ExternalEntityMappingImpl;", "(Lcom/intellij/workspaceModel/storage/impl/indices/MultimapStorageIndex;Lcom/intellij/workspaceModel/storage/impl/indices/VirtualFileIndex;Lcom/intellij/workspaceModel/storage/impl/indices/EntityStorageInternalIndex;Lcom/intellij/workspaceModel/storage/impl/indices/SymbolicIdInternalIndex;Ljava/util/Map;)V", "getEntitySourceIndex$intellij_platform_workspaceModel_storage", "()Lcom/intellij/workspaceModel/storage/impl/indices/EntityStorageInternalIndex;", "getExternalMappings$intellij_platform_workspaceModel_storage", "()Ljava/util/Map;", "getSoftLinks$intellij_platform_workspaceModel_storage", "()Lcom/intellij/workspaceModel/storage/impl/indices/MultimapStorageIndex;", "getSymbolicIdIndex$intellij_platform_workspaceModel_storage", "()Lcom/intellij/workspaceModel/storage/impl/indices/SymbolicIdInternalIndex;", "getVirtualFileIndex$intellij_platform_workspaceModel_storage", "()Lcom/intellij/workspaceModel/storage/impl/indices/VirtualFileIndex;", "assertConsistency", "", "storage", "Lcom/intellij/workspaceModel/storage/impl/AbstractEntityStorage;", "assertEntitySourceIndex", "assertSymbolicIdIndex", "toMutable", "Lcom/intellij/workspaceModel/storage/impl/MutableStorageIndexes;", "Companion", "intellij.platform.workspaceModel.storage"})
@SourceDebugExtension(value={"SMAP\nStorageIndexes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StorageIndexes.kt\ncom/intellij/workspaceModel/storage/impl/StorageIndexes\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,291:1\n1#2:292\n1864#3,2:293\n288#3,2:295\n1855#3,2:297\n1866#3:299\n1864#3,2:300\n1855#3,2:302\n1866#3:304\n*S KotlinDebug\n*F\n+ 1 StorageIndexes.kt\ncom/intellij/workspaceModel/storage/impl/StorageIndexes\n*L\n112#1:293,2\n114#1:295,2\n116#1:297,2\n112#1:299\n131#1:300,2\n135#1:302,2\n131#1:304\n*E\n"})
public class StorageIndexes {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MultimapStorageIndex softLinks;
    @NotNull
    private final VirtualFileIndex virtualFileIndex;
    @NotNull
    private final EntityStorageInternalIndex<EntitySource> entitySourceIndex;
    @NotNull
    private final SymbolicIdInternalIndex symbolicIdIndex;
    @NotNull
    private final Map<String, ExternalEntityMappingImpl<?>> externalMappings;
    @NotNull
    private static final StorageIndexes EMPTY = new StorageIndexes(new MultimapStorageIndex(), new VirtualFileIndex(), new EntityStorageInternalIndex<EntitySource>(false), new SymbolicIdInternalIndex(), new HashMap());

    public StorageIndexes(@NotNull MultimapStorageIndex softLinks, @NotNull VirtualFileIndex virtualFileIndex, @NotNull EntityStorageInternalIndex<EntitySource> entitySourceIndex, @NotNull SymbolicIdInternalIndex symbolicIdIndex, @NotNull Map<String, ? extends ExternalEntityMappingImpl<?>> externalMappings) {
        Intrinsics.checkNotNullParameter((Object)softLinks, (String)"softLinks");
        Intrinsics.checkNotNullParameter((Object)virtualFileIndex, (String)"virtualFileIndex");
        Intrinsics.checkNotNullParameter(entitySourceIndex, (String)"entitySourceIndex");
        Intrinsics.checkNotNullParameter((Object)symbolicIdIndex, (String)"symbolicIdIndex");
        Intrinsics.checkNotNullParameter(externalMappings, (String)"externalMappings");
        this.softLinks = softLinks;
        this.virtualFileIndex = virtualFileIndex;
        this.entitySourceIndex = entitySourceIndex;
        this.symbolicIdIndex = symbolicIdIndex;
        this.externalMappings = externalMappings;
    }

    @NotNull
    public MultimapStorageIndex getSoftLinks$intellij_platform_workspaceModel_storage() {
        return this.softLinks;
    }

    @NotNull
    public VirtualFileIndex getVirtualFileIndex$intellij_platform_workspaceModel_storage() {
        return this.virtualFileIndex;
    }

    @NotNull
    public EntityStorageInternalIndex<EntitySource> getEntitySourceIndex$intellij_platform_workspaceModel_storage() {
        return this.entitySourceIndex;
    }

    @NotNull
    public SymbolicIdInternalIndex getSymbolicIdIndex$intellij_platform_workspaceModel_storage() {
        return this.symbolicIdIndex;
    }

    @NotNull
    public Map<String, ExternalEntityMappingImpl<?>> getExternalMappings$intellij_platform_workspaceModel_storage() {
        return this.externalMappings;
    }

    public StorageIndexes(@NotNull MultimapStorageIndex softLinks, @NotNull VirtualFileIndex virtualFileIndex, @NotNull EntityStorageInternalIndex<EntitySource> entitySourceIndex, @NotNull SymbolicIdInternalIndex symbolicIdIndex) {
        Intrinsics.checkNotNullParameter((Object)softLinks, (String)"softLinks");
        Intrinsics.checkNotNullParameter((Object)virtualFileIndex, (String)"virtualFileIndex");
        Intrinsics.checkNotNullParameter(entitySourceIndex, (String)"entitySourceIndex");
        Intrinsics.checkNotNullParameter((Object)symbolicIdIndex, (String)"symbolicIdIndex");
        this(softLinks, virtualFileIndex, entitySourceIndex, symbolicIdIndex, MapsKt.emptyMap());
    }

    @NotNull
    public final MutableStorageIndexes toMutable() {
        MultimapStorageIndex.MutableMultimapStorageIndex copiedSoftLinks = MultimapStorageIndex.MutableMultimapStorageIndex.Companion.from(this.getSoftLinks$intellij_platform_workspaceModel_storage());
        VirtualFileIndex.MutableVirtualFileIndex copiedVirtualFileIndex = VirtualFileIndex.MutableVirtualFileIndex.Companion.from(this.getVirtualFileIndex$intellij_platform_workspaceModel_storage());
        EntityStorageInternalIndex.MutableEntityStorageInternalIndex<EntitySource> copiedEntitySourceIndex = EntityStorageInternalIndex.MutableEntityStorageInternalIndex.Companion.from(this.getEntitySourceIndex$intellij_platform_workspaceModel_storage());
        SymbolicIdInternalIndex.MutableSymbolicIdInternalIndex copiedSymbolicIdIndex = SymbolicIdInternalIndex.MutableSymbolicIdInternalIndex.Companion.from(this.getSymbolicIdIndex$intellij_platform_workspaceModel_storage());
        Map<String, MutableExternalEntityMappingImpl<?>> copiedExternalMappings = MutableExternalEntityMappingImpl.Companion.fromMap(this.getExternalMappings$intellij_platform_workspaceModel_storage());
        return new MutableStorageIndexes(copiedSoftLinks, copiedVirtualFileIndex, copiedEntitySourceIndex, copiedSymbolicIdIndex, copiedExternalMappings);
    }

    public final void assertConsistency(@NotNull AbstractEntityStorage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        this.assertEntitySourceIndex(storage);
        this.assertSymbolicIdIndex(storage);
        this.getVirtualFileIndex$intellij_platform_workspaceModel_storage().assertConsistency$intellij_platform_workspaceModel_storage();
        Iterator<Map.Entry<String, ExternalEntityMappingImpl<?>>> iterator2 = this.getExternalMappings$intellij_platform_workspaceModel_storage().entrySet().iterator();
        while (iterator2.hasNext()) {
            ExternalEntityMappingImpl<?> mappings = iterator2.next().getValue();
            Iterator iterator3 = ((Map)mappings.getIndex$intellij_platform_workspaceModel_storage()).entrySet().iterator();
            while (iterator3.hasNext()) {
                boolean bl;
                long id = ((Number)iterator3.next().getKey()).longValue();
                boolean bl2 = bl = storage.entityDataById$intellij_platform_workspaceModel_storage(id) != null;
                if (!_Assertions.ENABLED || bl) continue;
                boolean bl3 = false;
                String string2 = "Missing entity by id: " + id;
                throw new AssertionError((Object)string2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void assertSymbolicIdIndex(AbstractEntityStorage storage) {
        boolean bl;
        int expectedSize = 0;
        Iterable $this$forEachIndexed$iv = storage.getEntitiesByType$intellij_platform_workspaceModel_storage().getEntityFamilies$intellij_platform_workspaceModel_storage();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            Object v0;
            void family;
            int i2;
            block6: {
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                EntityFamily entityFamily = (EntityFamily)item$iv;
                i2 = n;
                boolean bl2 = false;
                if (family == null) continue;
                Iterable $this$firstOrNull$iv = family.getEntities$intellij_platform_workspaceModel_storage();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    WorkspaceEntityData it = (WorkspaceEntityData)element$iv;
                    boolean bl3 = false;
                    if (!(it != null)) continue;
                    v0 = element$iv;
                    break block6;
                }
                v0 = null;
            }
            WorkspaceEntityData workspaceEntityData = v0;
            if ((workspaceEntityData != null ? EntitiesKt.symbolicId(workspaceEntityData) : null) == null) continue;
            long mutableId = 0L;
            mutableId = EntityIdKt.createEntityId(0, i2);
            Iterable $this$forEach$iv = family.getEntities$intellij_platform_workspaceModel_storage();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WorkspaceEntityData data = (WorkspaceEntityData)element$iv;
                boolean bl4 = false;
                if (data == null) continue;
                mutableId = EntityIdKt.copy$default(mutableId, data.getId(), 0, 2, null);
                SymbolicEntityId<?> expectedSymbolicId = this.getSymbolicIdIndex$intellij_platform_workspaceModel_storage().getEntryById$intellij_platform_workspaceModel_storage(mutableId);
                boolean bl5 = Intrinsics.areEqual(expectedSymbolicId, EntitiesKt.symbolicId(data));
                if (_Assertions.ENABLED && !bl5) {
                    boolean bl6 = false;
                    String string2 = "Entity " + data + " isn't found in persistent id index. SymbolicId: " + EntitiesKt.symbolicId(data) + ", Id: " + mutableId + ". Expected entity source: " + expectedSymbolicId;
                    throw new AssertionError((Object)string2);
                }
                ++expectedSize;
            }
        }
        boolean bl7 = bl = expectedSize == this.getSymbolicIdIndex$intellij_platform_workspaceModel_storage().getIndex$intellij_platform_workspaceModel_storage().size();
        if (_Assertions.ENABLED && !bl) {
            boolean bl8 = false;
            String string3 = "Incorrect size of symbolic id index. Expected: " + expectedSize + ", actual: " + this.getSymbolicIdIndex$intellij_platform_workspaceModel_storage().getIndex$intellij_platform_workspaceModel_storage().size();
            throw new AssertionError((Object)string3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void assertEntitySourceIndex(AbstractEntityStorage storage) {
        boolean bl;
        int expectedSize = 0;
        Iterable $this$forEachIndexed$iv = storage.getEntitiesByType$intellij_platform_workspaceModel_storage().getEntityFamilies$intellij_platform_workspaceModel_storage();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void family;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            EntityFamily entityFamily = (EntityFamily)item$iv;
            int i2 = n;
            boolean bl2 = false;
            if (family == null) continue;
            long mutableId = 0L;
            mutableId = EntityIdKt.createEntityId(0, i2);
            Iterable $this$forEach$iv = family.getEntities$intellij_platform_workspaceModel_storage();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WorkspaceEntityData data = (WorkspaceEntityData)element$iv;
                boolean bl3 = false;
                if (data == null) continue;
                mutableId = EntityIdKt.copy$default(mutableId, data.getId(), 0, 2, null);
                EntitySource expectedEntitySource = this.getEntitySourceIndex$intellij_platform_workspaceModel_storage().getEntryById$intellij_platform_workspaceModel_storage(mutableId);
                boolean bl4 = Intrinsics.areEqual((Object)expectedEntitySource, (Object)data.getEntitySource());
                if (_Assertions.ENABLED && !bl4) {
                    boolean bl5 = false;
                    String string2 = "Entity " + data + " isn't found in entity source index. Entity source: " + data.getEntitySource() + ", Id: " + mutableId + ". Expected entity source: " + expectedEntitySource;
                    throw new AssertionError((Object)string2);
                }
                ++expectedSize;
            }
        }
        boolean bl6 = bl = expectedSize == this.getEntitySourceIndex$intellij_platform_workspaceModel_storage().getIndex$intellij_platform_workspaceModel_storage().getSize();
        if (_Assertions.ENABLED && !bl) {
            boolean bl7 = false;
            String string3 = "Incorrect size of entity source index. Expected: " + expectedSize + ", actual: " + this.getEntitySourceIndex$intellij_platform_workspaceModel_storage().getIndex$intellij_platform_workspaceModel_storage().getSize();
            throw new AssertionError((Object)string3);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/workspaceModel/storage/impl/StorageIndexes$Companion;", "", "()V", "EMPTY", "Lcom/intellij/workspaceModel/storage/impl/StorageIndexes;", "getEMPTY", "()Lcom/intellij/workspaceModel/storage/impl/StorageIndexes;", "intellij.platform.workspaceModel.storage"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StorageIndexes getEMPTY() {
            return EMPTY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

