/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage.impl;

import com.esotericsoftware.kryo.kryo5.KryoException;
import com.esotericsoftware.kryo.kryo5.io.ByteBufferOutput;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0016J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0013H\u0016J*\u0010\u0014\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/workspaceModel/storage/impl/KryoOutput;", "Lcom/esotericsoftware/kryo/kryo5/io/ByteBufferOutput;", "file", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "fileChannel", "Ljava/nio/channels/FileChannel;", "close", "", "flush", "writeInt", "value", "", "writeInts", "array", "", "offset", "count", "writeLong", "", "writeLongs", "", "optimizePositive", "", "intellij.platform.workspaceModel.storage"})
public final class KryoOutput
extends ByteBufferOutput {
    @NotNull
    private final FileChannel fileChannel;

    public KryoOutput(@NotNull Path file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        super(524288, Integer.MAX_VALUE);
        FileChannel fileChannel = FileChannel.open(file2, (Set<? extends OpenOption>)EnumSet.of((Enum)StandardOpenOption.CREATE, (Enum)StandardOpenOption.WRITE), new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)fileChannel, (String)"open(file, EnumSet.of(St\u2026tandardOpenOption.WRITE))");
        this.fileChannel = fileChannel;
        this.setVariableLengthEncoding(false);
        this.byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public void writeInt(int value) {
        this.require(4);
        this.byteBuffer.putInt(value);
        this.position += 4;
    }

    @Override
    public void writeLong(long value) {
        this.require(8);
        this.byteBuffer.putLong(value);
        this.position += 8;
    }

    @Override
    public void writeInts(@NotNull int[] array2, int offset, int count2) {
        Intrinsics.checkNotNullParameter((Object)array2, (String)"array");
        if (count2 == 0) {
            return;
        }
        int required = count2 << 2;
        this.require(required);
        this.byteBuffer.asIntBuffer().put(array2, offset, count2);
        this.byteBuffer.position(this.byteBuffer.position() + required);
        this.position = this.byteBuffer.position();
    }

    @Override
    public void writeLongs(@Nullable long[] array2, int offset, int count2, boolean optimizePositive) {
        if (count2 == 0) {
            return;
        }
        int required = count2 << 3;
        this.require(required);
        this.byteBuffer.asLongBuffer().put(array2, offset, count2);
        this.byteBuffer.position(this.byteBuffer.position() + required);
        this.position = this.byteBuffer.position();
    }

    @Override
    public void flush() {
        long filePosition = this.total;
        try {
            this.byteBuffer.flip();
            while (this.byteBuffer.hasRemaining()) {
                filePosition += (long)this.fileChannel.write(this.byteBuffer, filePosition);
            }
            this.byteBuffer.clear();
        }
        catch (IOException e) {
            throw new KryoException(e);
        }
        this.total = filePosition;
        this.position = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Closeable closeable = this.fileChannel;
        Throwable throwable = null;
        try {
            FileChannel it = (FileChannel)closeable;
            boolean bl = false;
            super.close();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

