/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage.impl;

import com.esotericsoftware.kryo.kryo5.io.ByteBufferInput;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.io.ByteBufferUtil;
import java.io.Closeable;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0016\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\bH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/workspaceModel/storage/impl/KryoInput;", "Lcom/esotericsoftware/kryo/kryo5/io/ByteBufferInput;", "file", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "close", "", "readInt", "", "readInts", "", "length", "readLong", "", "readLongs", "", "intellij.platform.workspaceModel.storage"})
public final class KryoInput
extends ByteBufferInput {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KryoInput(@NotNull Path file2) {
        MappedByteBuffer mappedByteBuffer;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Closeable closeable = FileChannel.open(file2, (Set<? extends OpenOption>)EnumSet.of((Enum)StandardOpenOption.READ), new FileAttribute[0]);
        KryoInput kryoInput = this;
        Throwable throwable = null;
        try {
            FileChannel fileChannel = (FileChannel)closeable;
            boolean bl = false;
            mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size());
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        kryoInput.byteBuffer = mappedByteBuffer;
        this.byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.setVariableLengthEncoding(false);
        this.capacity = this.byteBuffer.capacity();
        this.limit = this.byteBuffer.limit();
    }

    @Override
    @NotNull
    public long[] readLongs(int length) {
        if (length == 0) {
            Intrinsics.checkNotNullExpressionValue((Object)ArrayUtilRt.EMPTY_LONG_ARRAY, (String)"EMPTY_LONG_ARRAY");
            return ArrayUtilRt.EMPTY_LONG_ARRAY;
        }
        long[] array2 = new long[length];
        this.byteBuffer.asLongBuffer().get(array2);
        this.byteBuffer.position(this.byteBuffer.position() + 8 * length);
        this.position = this.byteBuffer.position();
        return array2;
    }

    @Override
    @NotNull
    public int[] readInts(int length) {
        if (length == 0) {
            Intrinsics.checkNotNullExpressionValue((Object)ArrayUtilRt.EMPTY_INT_ARRAY, (String)"EMPTY_INT_ARRAY");
            return ArrayUtilRt.EMPTY_INT_ARRAY;
        }
        int[] array2 = new int[length];
        this.byteBuffer.asIntBuffer().get(array2);
        this.byteBuffer.position(this.byteBuffer.position() + 4 * length);
        this.position = this.byteBuffer.position();
        return array2;
    }

    @Override
    public int readInt() {
        int result2 = this.byteBuffer.getInt();
        this.position += 4;
        return result2;
    }

    @Override
    public long readLong() {
        long result2 = this.byteBuffer.getLong();
        this.position += 8;
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            super.close();
        }
        finally {
            ByteBufferUtil.cleanBuffer(this.byteBuffer);
        }
    }
}

