/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ref;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.FList;
import com.intellij.util.containers.HashingStrategy;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DebugReflectionUtil {
    private static final Map<Class<?>, Field[]> allFields;
    private static final Field[] EMPTY_FIELD_ARRAY;
    private static final Method Unsafe_shouldBeInitialized;
    private static final Key<Boolean> REPORTED_LEAKED;

    private static Field @NotNull [] getAllFields(@NotNull Class<?> aClass) {
        Field[] cached;
        if (aClass == null) {
            DebugReflectionUtil.$$$reportNull$$$0(0);
        }
        if ((cached = allFields.get(aClass)) == null) {
            try {
                Field[] declaredFields = aClass.getDeclaredFields();
                ArrayList<Field> fields2 = new ArrayList<Field>(declaredFields.length + 5);
                for (Field declaredField : declaredFields) {
                    declaredField.setAccessible(true);
                    Class<?> type = declaredField.getType();
                    if (DebugReflectionUtil.isTrivial(type)) continue;
                    fields2.add(declaredField);
                }
                Class<?> superclass = aClass.getSuperclass();
                if (superclass != null) {
                    for (Field sup : DebugReflectionUtil.getAllFields(superclass)) {
                        if (fields2.contains(sup)) continue;
                        fields2.add(sup);
                    }
                }
                cached = fields2.isEmpty() ? EMPTY_FIELD_ARRAY : fields2.toArray(new Field[0]);
            }
            catch (IncompatibleClassChangeError | NoClassDefFoundError | SecurityException e) {
                cached = EMPTY_FIELD_ARRAY;
            }
            catch (RuntimeException e) {
                if (e.getClass().getName().equals("java.lang.reflect.InaccessibleObjectException")) {
                    cached = EMPTY_FIELD_ARRAY;
                }
                throw e;
            }
            allFields.put(aClass, cached);
        }
        if (cached == null) {
            DebugReflectionUtil.$$$reportNull$$$0(1);
        }
        return cached;
    }

    private static boolean isTrivial(@NotNull Class<?> type) {
        if (type == null) {
            DebugReflectionUtil.$$$reportNull$$$0(2);
        }
        return type.isPrimitive() || type == String.class || type == Class.class || type.isArray() && DebugReflectionUtil.isTrivial(type.getComponentType());
    }

    private static boolean isInitialized(@NotNull Class<?> root) {
        if (root == null) {
            DebugReflectionUtil.$$$reportNull$$$0(3);
        }
        if (Unsafe_shouldBeInitialized == null) {
            return false;
        }
        boolean isInitialized = false;
        try {
            isInitialized = (Boolean)Unsafe_shouldBeInitialized.invoke(ReflectionUtil.getUnsafe(), root) == false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isInitialized;
    }

    public static <V> boolean walkObjects(int maxDepth, @NotNull Map<Object, String> startRoots, @NotNull Class<V> lookFor, @NotNull Predicate<Object> shouldExamineValue, @NotNull PairProcessor<? super V, ? super BackLink<?>> leakProcessor) {
        if (startRoots == null) {
            DebugReflectionUtil.$$$reportNull$$$0(4);
        }
        if (lookFor == null) {
            DebugReflectionUtil.$$$reportNull$$$0(5);
        }
        if (shouldExamineValue == null) {
            DebugReflectionUtil.$$$reportNull$$$0(6);
        }
        if (leakProcessor == null) {
            DebugReflectionUtil.$$$reportNull$$$0(7);
        }
        IntOpenHashSet visited = new IntOpenHashSet(100);
        ArrayDeque<2> toVisit = new ArrayDeque<2>(100);
        for (Map.Entry<Object, String> entry : startRoots.entrySet()) {
            Object startRoot = entry.getKey();
            final String description = entry.getValue();
            toVisit.addLast(new BackLink<Object>(startRoot, null, null){

                @Override
                void print(@NotNull StringBuilder result2) {
                    if (result2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    super.print(result2);
                    result2.append(" (from ").append(description).append(")");
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/util/ref/DebugReflectionUtil$2", "print"));
                }
            });
        }
        BackLink backLink;
        while ((backLink = (BackLink)toVisit.pollFirst()) != null) {
            if (backLink.depth > maxDepth) continue;
            Object value = backLink.value;
            if (lookFor.isAssignableFrom(value.getClass()) && DebugReflectionUtil.markLeaked(value) && !leakProcessor.process(value, backLink)) {
                return false;
            }
            if (!visited.add(System.identityHashCode(value))) continue;
            DebugReflectionUtil.queueStronglyReferencedValues(toVisit, value, backLink, shouldExamineValue);
        }
        return true;
    }

    private static void queueStronglyReferencedValues(@NotNull Deque<? super BackLink<?>> queue, @NotNull Object root, @NotNull BackLink<?> backLink, @NotNull Predicate<Object> shouldExamineValue) {
        if (queue == null) {
            DebugReflectionUtil.$$$reportNull$$$0(8);
        }
        if (root == null) {
            DebugReflectionUtil.$$$reportNull$$$0(9);
        }
        if (backLink == null) {
            DebugReflectionUtil.$$$reportNull$$$0(10);
        }
        if (shouldExamineValue == null) {
            DebugReflectionUtil.$$$reportNull$$$0(11);
        }
        Class<?> rootClass = root.getClass();
        for (Field field : DebugReflectionUtil.getAllFields(rootClass)) {
            Object value;
            String fieldName = field.getName();
            if (root instanceof Reference && ("referent".equals(fieldName) || "discovered".equals(fieldName))) continue;
            try {
                value = field.get(root);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            DebugReflectionUtil.queue(value, field, backLink, queue, shouldExamineValue);
        }
        if (rootClass.isArray()) {
            try {
                for (Object object : (Object[])root) {
                    DebugReflectionUtil.queue(object, null, backLink, queue, shouldExamineValue);
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (root instanceof Class && DebugReflectionUtil.isInitialized((Class)root)) {
            for (Field field : DebugReflectionUtil.getAllFields((Class)root)) {
                if ((field.getModifiers() & 8) == 0) continue;
                try {
                    Object value = field.get(null);
                    DebugReflectionUtil.queue(value, field, backLink, queue, shouldExamineValue);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
    }

    private static void queue(Object value, Field field, @NotNull BackLink<?> backLink, @NotNull Deque<? super BackLink<?>> queue, @NotNull Predicate<Object> shouldExamineValue) {
        if (backLink == null) {
            DebugReflectionUtil.$$$reportNull$$$0(12);
        }
        if (queue == null) {
            DebugReflectionUtil.$$$reportNull$$$0(13);
        }
        if (shouldExamineValue == null) {
            DebugReflectionUtil.$$$reportNull$$$0(14);
        }
        if (value == null || DebugReflectionUtil.isTrivial(value.getClass())) {
            return;
        }
        if (shouldExamineValue.test(value)) {
            queue.addLast(new BackLink<Object>(value, field, backLink));
        }
    }

    private static boolean markLeaked(Object leaked) {
        return !(leaked instanceof UserDataHolderEx) || ((UserDataHolderEx)leaked).replace(REPORTED_LEAKED, null, Boolean.TRUE);
    }

    static {
        Method shouldBeInitialized;
        allFields = Collections.synchronizedMap(CollectionFactory.createCustomHashingStrategyMap(new HashingStrategy<Class<?>>(){

            @Override
            public int hashCode(@Nullable Class<?> aClass) {
                return aClass == null ? 0 : aClass.getName().hashCode();
            }

            @Override
            public boolean equals(@Nullable Class<?> o1, @Nullable Class<?> o2) {
                return o1 == o2;
            }
        }));
        EMPTY_FIELD_ARRAY = new Field[0];
        try {
            shouldBeInitialized = ReflectionUtil.getDeclaredMethod(Class.forName("sun.misc.Unsafe"), "shouldBeInitialized", Class.class);
        }
        catch (ClassNotFoundException ignored) {
            shouldBeInitialized = null;
        }
        Unsafe_shouldBeInitialized = shouldBeInitialized;
        REPORTED_LEAKED = Key.create("REPORTED_LEAKED");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ref/DebugReflectionUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startRoots";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookFor";
                break;
            }
            case 6: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shouldExamineValue";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leakProcessor";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backLink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ref/DebugReflectionUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllFields";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isTrivial";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isInitialized";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "walkObjects";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "queueStronglyReferencedValues";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "queue";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class BackLink<V> {
        @NotNull
        private final V value;
        private final Field field;
        private final BackLink<?> backLink;
        private final int depth;

        BackLink(@NotNull V value, @Nullable Field field, @Nullable BackLink<?> backLink) {
            if (value == null) {
                BackLink.$$$reportNull$$$0(0);
            }
            this.value = value;
            this.field = field;
            this.backLink = backLink;
            this.depth = backLink == null ? 0 : backLink.depth + 1;
        }

        public String toString() {
            StringBuilder result2 = new StringBuilder();
            BackLink<?> backLink = this;
            while (backLink != null) {
                backLink.print(result2);
                backLink = backLink.backLink;
            }
            return result2.toString();
        }

        void print(@NotNull StringBuilder result2) {
            String valueStr;
            if (result2 == null) {
                BackLink.$$$reportNull$$$0(1);
            }
            V value = this.value;
            try {
                valueStr = value instanceof FList ? "FList (size=" + ((FList)value).size() + ")" : (value instanceof Collection ? "Collection (size=" + ((Collection)value).size() + ")" : (value instanceof Object[] ? Arrays.toString((Object[])value) : String.valueOf(value)));
                valueStr = StringUtil.first(StringUtil.convertLineSeparators(valueStr, "\\n"), 200, true);
            }
            catch (Throwable e) {
                valueStr = "(" + e.getMessage() + " while computing .toString())";
            }
            Field field = this.field;
            String fieldName = field == null ? "?" : field.getDeclaringClass().getName() + "." + field.getName();
            result2.append("via '").append(fieldName).append("'; Value: '").append(valueStr).append("' of ").append(value.getClass()).append("\n");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/ref/DebugReflectionUtil$BackLink";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "print";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

