/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.io.DirectByteBufferAllocator;
import com.intellij.util.io.PageCacheUtils;
import com.intellij.util.io.PagedFileStorageLockFree;
import com.intellij.util.io.pagecache.FilePageCacheStatistics;
import com.intellij.util.io.pagecache.impl.FrugalQuantileEstimator;
import com.intellij.util.io.pagecache.impl.PageImpl;
import com.intellij.util.io.pagecache.impl.PagesTable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class FilePageCacheLockFree
implements AutoCloseable {
    private static final Logger LOG = Logger.getInstance(FilePageCacheLockFree.class);
    private static final int MAX_PAGES_TO_RECLAIM_AT_ONCE = 5;
    private static final int INITIAL_PAGES_TABLE_SIZE = 32;
    private static final int STATE_NOT_STARTED = 0;
    private static final int STATE_WAITING_FIRST_STORAGE_REGISTRATION = 1;
    private static final int STATE_WORKING = 2;
    private static final int STATE_CLOSED = 3;
    public static final int TOKENS_PER_USE = 8;
    public static final int TOKENS_INITIALLY = 16;
    private static final int DEFAULT_PERCENTS_OF_PAGES_TO_PREPARE_FOR_RECLAIM = 10;
    private final long cacheCapacityBytes;
    private final AtomicLong totalNativeBytesCached = new AtomicLong(0L);
    private final AtomicLong totalHeapBytesCached = new AtomicLong(0L);
    private final Map<Path, PagesTable> pagesPerFile = CollectionFactory.createSmallMemoryFootprintMap();
    private volatile ConcurrentLinkedQueue<PageImpl> pagesToProbablyReclaimQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Command> commandsQueue = new ConcurrentLinkedQueue();
    private final PagesForReclaimCollector pagesForReclaimCollector;
    private final Thread housekeeperThread;
    private volatile int state = 0;
    private final FilePageCacheStatistics statistics = new FilePageCacheStatistics();

    public FilePageCacheLockFree(long cacheCapacityBytes) {
        this(cacheCapacityBytes, r -> new Thread(r, "FilePageCache housekeeper"));
    }

    public FilePageCacheLockFree(long cacheCapacityBytes, ThreadFactory maintenanceThreadFactory) {
        if (cacheCapacityBytes <= 0L) {
            throw new IllegalArgumentException("Capacity(=" + cacheCapacityBytes + ") must be >0");
        }
        this.cacheCapacityBytes = cacheCapacityBytes;
        this.pagesForReclaimCollector = new PagesForReclaimCollector(10, 20);
        this.housekeeperThread = maintenanceThreadFactory.newThread(this::cacheMaintenanceLoop);
        this.housekeeperThread.setDaemon(true);
        this.state = 1;
    }

    public long getCacheCapacityBytes() {
        return this.cacheCapacityBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PagesTable registerStorage(@NotNull PagedFileStorageLockFree storage) throws IOException {
        if (storage == null) {
            FilePageCacheLockFree.$$$reportNull$$$0(0);
        }
        this.checkNotClosed();
        Map<Path, PagesTable> map2 = this.pagesPerFile;
        synchronized (map2) {
            Path absolutePath = storage.getFile().toAbsolutePath();
            if (this.pagesPerFile.containsKey(absolutePath)) {
                throw new IOException("Storage for [" + absolutePath + "] is already registered");
            }
            boolean firstStorageRegistered = this.pagesPerFile.isEmpty();
            PagesTable pages = new PagesTable(32);
            this.pagesPerFile.put(absolutePath, pages);
            if (firstStorageRegistered && this.state == 1) {
                this.housekeeperThread.start();
                this.state = 2;
            }
            return pages;
        }
    }

    Future<?> enqueueStoragePagesClosing(@NotNull PagedFileStorageLockFree storage, @NotNull CompletableFuture<Object> finish) {
        if (storage == null) {
            FilePageCacheLockFree.$$$reportNull$$$0(1);
        }
        if (finish == null) {
            FilePageCacheLockFree.$$$reportNull$$$0(2);
        }
        this.checkNotClosed();
        CloseStorageCommand task = new CloseStorageCommand(storage, finish);
        this.commandsQueue.add(task);
        return task.onFinish;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws InterruptedException {
        FilePageCacheLockFree filePageCacheLockFree = this;
        synchronized (filePageCacheLockFree) {
            if (this.state != 3) {
                this.housekeeperThread.interrupt();
                this.housekeeperThread.join();
                this.state = 3;
            }
        }
    }

    public FilePageCacheStatistics getStatistics() {
        return this.statistics;
    }

    private void cacheMaintenanceLoop() {
        while (!Thread.interrupted()) {
            try {
                int pagesPreparedToReclaim = this.pagesForReclaimCollector.totalPagesPreparedToReclaim();
                int pagesRemainedToReclaim = this.pagesToProbablyReclaimQueue.size();
                if (pagesRemainedToReclaim <= pagesPreparedToReclaim / 2 || !this.commandsQueue.isEmpty()) {
                    this.doCacheMaintenanceTurn();
                    this.statistics.cacheMaintenanceTurnDone();
                } else {
                    this.statistics.cacheMaintenanceTurnSkipped();
                }
                if (pagesRemainedToReclaim > pagesPreparedToReclaim / 2) {
                    this.pagesForReclaimCollector.collectLessAggressively();
                    Thread.sleep(1L);
                    continue;
                }
                if (pagesRemainedToReclaim > 0) {
                    Thread.yield();
                    continue;
                }
                this.pagesForReclaimCollector.collectMoreAggressively();
            }
            catch (InterruptedException e) {
                break;
            }
            catch (Throwable t) {
                LOG.error("Exception in FilePageCache housekeeper thread (thread continue to run)", t);
            }
        }
        LOG.info("maintenance loop interrupted -> exiting");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCacheMaintenanceTurn() {
        PageImpl candidate;
        int reclaimed = this.cleanClosedStoragesAndReclaimPages(1);
        this.statistics.closedStoragesReclaimed(reclaimed);
        Map<Path, PagesTable> pagesPerStorage = this.threadSafeCopyOfPagesPerStorage();
        this.pagesForReclaimCollector.startCollectingTurn();
        try {
            Collection<PagesTable> pagesTables = pagesPerStorage.values();
            for (PagesTable pagesTable : pagesTables) {
                AtomicReferenceArray<PageImpl> pages = pagesTable.pages();
                int pagesAliveInTable = 0;
                for (int i2 = 0; i2 < pages.length(); ++i2) {
                    boolean succeed;
                    PageImpl page = pages.get(i2);
                    if (page == null || page.isTombstone()) continue;
                    ++pagesAliveInTable;
                    if (page.isAboutToUnmap() && page.usageCount() == 0 && (succeed = page.tryMoveTowardsPreTombstone(false))) {
                        this.unmapPageAndReclaimBuffer(page);
                        continue;
                    }
                    int tokensOfUsefulness = FilePageCacheLockFree.adjustPageUsefulness(page);
                    page.updateLocalTokensOfUsefulness(tokensOfUsefulness);
                    this.pagesForReclaimCollector.checkPageGoodForReclaim(page);
                }
                pagesTable.shrinkIfNeeded(pagesAliveInTable);
            }
        }
        finally {
            this.pagesForReclaimCollector.finishCollectingTurn();
        }
        this.pagesToProbablyReclaimQueue = this.pagesForReclaimCollector.pagesForReclaimAsQueue();
        int pagesFlushed = this.pagesForReclaimCollector.ensureEnoughCleanPagesToReclaim(0.5);
        int remainsToReclaim = 10;
        while (this.totalNativeBytesCached.get() + this.totalHeapBytesCached.get() > this.cacheCapacityBytes && remainsToReclaim > 0 && (candidate = this.pagesToProbablyReclaimQueue.poll()) != null) {
            boolean succeed;
            ByteBuffer data;
            if (!candidate.isUsable() || candidate.usageCount() != 0 || (data = candidate.pageBufferUnchecked()) == null || data.isDirect() || !(succeed = candidate.tryMoveTowardsPreTombstone(false))) continue;
            this.unmapPageAndReclaimBuffer(candidate);
            --remainsToReclaim;
        }
    }

    private static int adjustPageUsefulness(@NotNull PageImpl page) {
        int usageCount;
        if (page == null) {
            FilePageCacheLockFree.$$$reportNull$$$0(3);
        }
        if ((usageCount = page.usageCount()) > 0) {
            return page.addTokensOfUsefulness(usageCount * 8);
        }
        return page.decayTokensOfUsefulness(7, 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int cleanClosedStoragesAndReclaimPages(int maxStoragesToProcess) {
        Command command2;
        int successfullyCleaned = 0;
        for (int i2 = 0; i2 < maxStoragesToProcess && (command2 = this.commandsQueue.poll()) != null; ++i2) {
            if (!(command2 instanceof CloseStorageCommand)) continue;
            CloseStorageCommand closeStorageCommand = (CloseStorageCommand)command2;
            PagedFileStorageLockFree storage = closeStorageCommand.storageToClose;
            CompletableFuture futureToFinalize = closeStorageCommand.onFinish;
            if (!storage.isClosed()) {
                AssertionError error = new AssertionError((Object)("Code bug: storage " + storage + " must be closed before CloseStorageCommand is queued"));
                futureToFinalize.completeExceptionally((Throwable)((Object)error));
                throw error;
            }
            PagesTable pagesTable = storage.pages();
            boolean somePagesStillInUse = this.tryToReclaimAll(pagesTable);
            if (!somePagesStillInUse) {
                Path file2 = storage.getFile();
                try {
                    PageCacheUtils.CHANNELS_CACHE.closeChannel(file2);
                }
                catch (Throwable t) {
                    LOG.error("Can't close channel for " + file2, t);
                    futureToFinalize.completeExceptionally(t);
                }
                ++successfullyCleaned;
                Map<Path, PagesTable> map2 = this.pagesPerFile;
                synchronized (map2) {
                    Path absolutePath = storage.getFile().toAbsolutePath();
                    PagesTable removed = this.pagesPerFile.remove(absolutePath);
                    assert (removed != null) : "Storage for [" + absolutePath + "] must exists";
                }
                futureToFinalize.complete(null);
                continue;
            }
            this.commandsQueue.offer(command2);
        }
        return successfullyCleaned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private Map<Path, PagesTable> threadSafeCopyOfPagesPerStorage() {
        Map<Path, PagesTable> map2 = this.pagesPerFile;
        // MONITORENTER : map2
        HashMap<Path, PagesTable> hashMap = new HashMap<Path, PagesTable>(this.pagesPerFile);
        // MONITOREXIT : map2
        if (hashMap != null) return hashMap;
        FilePageCacheLockFree.$$$reportNull$$$0(4);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    boolean tryToReclaimAll(@NotNull PagesTable pagesTable) {
        if (pagesTable == null) {
            FilePageCacheLockFree.$$$reportNull$$$0(5);
        }
        pagesTable.pagesLock().lock();
        try {
            pages = pagesTable.pages();
            somePagesStillInUse = false;
            for (i = 0; i < pages.length(); ++i) {
                page = pages.get(i);
                if (page == null || page.isTombstone()) continue;
                if (!page.isNotReadyYet()) {
                    succeed = page.tryMoveTowardsPreTombstone(false);
                    if (succeed) {
                        this.unmapPageAndReclaimBuffer(page);
                    }
                } else {
                    pageWriteLock = page.pageLock().writeLock();
                    if (pageWriteLock.tryLock()) {
                        try {
                            succeed = page.tryMoveTowardsPreTombstone(true);
                            if (!succeed) ** GOTO lbl31
                            if (page.pageBufferUnchecked() != null) {
                                this.unmapPageAndReclaimBuffer(page);
                            }
                            page.entomb();
                        }
                        finally {
                            pageWriteLock.unlock();
                        }
                    } else {
                        succeed = page.tryMoveTowardsPreTombstone(false);
                        if (succeed) {
                            this.unmapPageAndReclaimBuffer(page);
                        }
                    }
                }
lbl31:
                // 7 sources

                somePagesStillInUse |= page.isTombstone() == false;
            }
            var4_4 = somePagesStillInUse;
            return var4_4;
        }
        finally {
            pagesTable.pagesLock().unlock();
        }
    }

    private void unmapPageAndReclaimBuffer(@NotNull PageImpl pageToReclaim) {
        if (pageToReclaim == null) {
            FilePageCacheLockFree.$$$reportNull$$$0(6);
        }
        ByteBuffer pageBuffer = FilePageCacheLockFree.entombPageAndGetPageBuffer(pageToReclaim);
        this.reclaimPageBuffer(pageBuffer);
    }

    private void reclaimPageBuffer(@NotNull ByteBuffer pageBuffer) {
        if (pageBuffer == null) {
            FilePageCacheLockFree.$$$reportNull$$$0(7);
        }
        if (pageBuffer.isDirect()) {
            DirectByteBufferAllocator.ALLOCATOR.release(pageBuffer);
            this.totalNativeBytesCached.addAndGet(-pageBuffer.capacity());
            this.statistics.pageReclaimedNative(pageBuffer.capacity());
        } else {
            this.totalHeapBytesCached.addAndGet(-pageBuffer.capacity());
            this.statistics.pageReclaimedHeap(pageBuffer.capacity());
        }
    }

    @NotNull
    private static ByteBuffer entombPageAndGetPageBuffer(@NotNull PageImpl pageToUnmap) {
        if (pageToUnmap == null) {
            FilePageCacheLockFree.$$$reportNull$$$0(8);
        }
        if (!pageToUnmap.isPreTombstone()) {
            throw new AssertionError((Object)("Bug: page must be PRE_TOMBSTONE: " + pageToUnmap));
        }
        if (pageToUnmap.isDirty()) {
            try {
                pageToUnmap.flush();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Can't flush page: " + pageToUnmap, e);
            }
        }
        ByteBuffer pageBuffer = pageToUnmap.detachTombstoneBuffer();
        pageToUnmap.entomb();
        ByteBuffer byteBuffer = pageBuffer;
        if (byteBuffer == null) {
            FilePageCacheLockFree.$$$reportNull$$$0(9);
        }
        return byteBuffer;
    }

    @NotNull
    ByteBuffer allocatePageBuffer(int bufferSize) {
        this.checkNotClosed();
        ByteBuffer reclaimedBuffer = this.tryReclaimPageOfSize(bufferSize, 5);
        if (reclaimedBuffer != null) {
            this.statistics.pageReclaimedByHandover(bufferSize, reclaimedBuffer.isDirect());
            ByteBuffer byteBuffer = reclaimedBuffer;
            if (byteBuffer == null) {
                FilePageCacheLockFree.$$$reportNull$$$0(10);
            }
            return byteBuffer;
        }
        long capacityReserveBytes = this.cacheCapacityBytes - this.totalNativeBytesCached.get();
        if (capacityReserveBytes >= (long)bufferSize) {
            ByteBuffer buffer = DirectByteBufferAllocator.ALLOCATOR.allocate(bufferSize);
            this.totalNativeBytesCached.addAndGet(buffer.capacity());
            this.statistics.pageAllocatedNative(bufferSize);
            ByteBuffer byteBuffer = buffer;
            if (byteBuffer == null) {
                FilePageCacheLockFree.$$$reportNull$$$0(11);
            }
            return byteBuffer;
        }
        this.totalHeapBytesCached.addAndGet(bufferSize);
        this.statistics.pageAllocatedHeap(bufferSize);
        ByteBuffer byteBuffer = ByteBuffer.allocate(bufferSize);
        if (byteBuffer == null) {
            FilePageCacheLockFree.$$$reportNull$$$0(12);
        }
        return byteBuffer;
    }

    @Nullable
    private ByteBuffer tryReclaimPageOfSize(int bufferSize, int maxPagesToTry) {
        int dirtyPagesSkipped = 0;
        for (int i2 = 0; i2 < maxPagesToTry && this.totalNativeBytesCached.get() > this.cacheCapacityBytes - (long)bufferSize; ++i2) {
            int rnd10;
            PageImpl candidateToReclaim = this.pagesToProbablyReclaimQueue.poll();
            if (candidateToReclaim == null) {
                return null;
            }
            if (candidateToReclaim.usageCount() > 0) continue;
            if (candidateToReclaim.isDirty() && dirtyPagesSkipped <= (rnd10 = ThreadLocalRandom.current().nextInt(maxPagesToTry))) {
                ++dirtyPagesSkipped;
                this.pagesToProbablyReclaimQueue.offer(candidateToReclaim);
                continue;
            }
            boolean succeed = candidateToReclaim.tryMoveTowardsPreTombstone(false);
            if (!succeed) continue;
            ByteBuffer reclaimedBuffer = FilePageCacheLockFree.entombPageAndGetPageBuffer(candidateToReclaim);
            if (reclaimedBuffer.capacity() == bufferSize) {
                reclaimedBuffer.clear().limit(bufferSize);
                return reclaimedBuffer;
            }
            this.reclaimPageBuffer(reclaimedBuffer);
        }
        return null;
    }

    private void checkNotClosed() throws IllegalStateException {
        if (this.state == 3) {
            throw new IllegalStateException("Cache is already closed");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finish";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "page";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/FilePageCacheLockFree";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pagesTable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pageToReclaim";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pageBuffer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pageToUnmap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/FilePageCacheLockFree";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "threadSafeCopyOfPagesPerStorage";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "entombPageAndGetPageBuffer";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "allocatePageBuffer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerStorage";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "enqueueStoragePagesClosing";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "adjustPageUsefulness";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "tryToReclaimAll";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "unmapPageAndReclaimBuffer";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "reclaimPageBuffer";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "entombPageAndGetPageBuffer";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PagesForReclaimCollector {
        private static final Comparator<PageImpl> BY_USEFULNESS = Comparator.comparing(page -> page.localTokensOfUsefulness());
        private final FrugalQuantileEstimator lowUsefulnessThresholdEstimator;
        private final int minPercentOfPagesToPrepareForReclaim;
        private final int maxPercentOfPagesToPrepareForReclaim;
        @NotNull
        private List<PageImpl> pagesForReclaimNonDirty = Collections.emptyList();
        @NotNull
        private List<PageImpl> pagesForReclaimDirty = Collections.emptyList();

        public PagesForReclaimCollector(int minPercentOfPagesToPrepareForReclaim, int maxPercentOfPagesToPrepareForReclaim) {
            if (minPercentOfPagesToPrepareForReclaim > maxPercentOfPagesToPrepareForReclaim) {
                throw new IllegalArgumentException("minPercent(=" + minPercentOfPagesToPrepareForReclaim + ") must be <= maxPercent(=" + maxPercentOfPagesToPrepareForReclaim + ")");
            }
            this.minPercentOfPagesToPrepareForReclaim = minPercentOfPagesToPrepareForReclaim;
            this.maxPercentOfPagesToPrepareForReclaim = maxPercentOfPagesToPrepareForReclaim;
            this.lowUsefulnessThresholdEstimator = new FrugalQuantileEstimator(minPercentOfPagesToPrepareForReclaim, 0.5, 0.0);
        }

        public void startCollectingTurn() {
            this.pagesForReclaimDirty = new ArrayList<PageImpl>(5);
            this.pagesForReclaimNonDirty = new ArrayList<PageImpl>(5);
        }

        public void finishCollectingTurn() {
            this.pagesForReclaimDirty.sort(BY_USEFULNESS);
            this.pagesForReclaimNonDirty.sort(BY_USEFULNESS);
        }

        public List<PageImpl> pagesForReclaimNonDirty() {
            return this.pagesForReclaimNonDirty;
        }

        public List<PageImpl> pagesForReclaimDirty() {
            return this.pagesForReclaimDirty;
        }

        public ConcurrentLinkedQueue<PageImpl> pagesForReclaimAsQueue() {
            ConcurrentLinkedQueue<PageImpl> pagesForReclaim = new ConcurrentLinkedQueue<PageImpl>();
            pagesForReclaim.addAll(this.pagesForReclaimNonDirty);
            pagesForReclaim.addAll(this.pagesForReclaimDirty);
            return pagesForReclaim;
        }

        public int totalPagesPreparedToReclaim() {
            return this.pagesForReclaimDirty.size() + this.pagesForReclaimNonDirty.size();
        }

        public void collectMoreAggressively() {
            int currentPercentage = this.lowUsefulnessThresholdEstimator.percentileToEstimate();
            if (currentPercentage < this.maxPercentOfPagesToPrepareForReclaim) {
                this.lowUsefulnessThresholdEstimator.updateTargetPercentile(currentPercentage + 1);
            }
        }

        public void collectLessAggressively() {
            int currentPercentage = this.lowUsefulnessThresholdEstimator.percentileToEstimate();
            if (currentPercentage > this.minPercentOfPagesToPrepareForReclaim) {
                this.lowUsefulnessThresholdEstimator.updateTargetPercentile(currentPercentage - 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int ensureEnoughCleanPagesToReclaim(double fractionOfCleanPagesToAim) {
            int totalPagesToReclaim = this.pagesForReclaimDirty.size() + this.pagesForReclaimNonDirty.size();
            int dirtyPagesTargetCount = (int)((1.0 - fractionOfCleanPagesToAim) * (double)totalPagesToReclaim);
            int pagesToFlush = this.pagesForReclaimDirty.size() - dirtyPagesTargetCount;
            if (pagesToFlush > 0) {
                int actuallyFlushed = 0;
                for (int i2 = 0; i2 < pagesToFlush; ++i2) {
                    PageImpl page = this.pagesForReclaimDirty.get(i2);
                    if (page.isTombstone()) continue;
                    try {
                        if (!page.pageLock().readLock().tryLock()) continue;
                        try {
                            page.flush();
                            ++actuallyFlushed;
                            continue;
                        }
                        finally {
                            page.pageLock().readLock().unlock();
                        }
                    }
                    catch (IOException e) {
                        LOG.warn("Can't flush page " + page, e);
                    }
                }
                return actuallyFlushed;
            }
            return 0;
        }

        private void checkPageGoodForReclaim(@NotNull PageImpl page) {
            if (page == null) {
                PagesForReclaimCollector.$$$reportNull$$$0(0);
            }
            int tokensOfUsefulness = page.tokensOfUsefulness();
            double lowUsefulnessThreshold = this.lowUsefulnessThresholdEstimator.updateEstimation(tokensOfUsefulness);
            if (page.isUsable() && page.usageCount() == 0 && (double)tokensOfUsefulness <= lowUsefulnessThreshold) {
                this.addCandidateForReclaim(page);
            }
        }

        private void addCandidateForReclaim(@NotNull PageImpl page) {
            if (page == null) {
                PagesForReclaimCollector.$$$reportNull$$$0(1);
            }
            if (page.isDirty()) {
                this.pagesForReclaimDirty.add(page);
            } else {
                this.pagesForReclaimNonDirty.add(page);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "page";
            objectArray2[1] = "com/intellij/util/io/FilePageCacheLockFree$PagesForReclaimCollector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkPageGoodForReclaim";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addCandidateForReclaim";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class CloseStorageCommand
    extends Command {
        private final PagedFileStorageLockFree storageToClose;
        private final CompletableFuture<?> onFinish;

        protected CloseStorageCommand(@NotNull PagedFileStorageLockFree storageToClose, @NotNull CompletableFuture<Object> onFinish) {
            if (storageToClose == null) {
                CloseStorageCommand.$$$reportNull$$$0(0);
            }
            if (onFinish == null) {
                CloseStorageCommand.$$$reportNull$$$0(1);
            }
            this.storageToClose = storageToClose;
            this.onFinish = onFinish;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "storageToClose";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "onFinish";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/io/FilePageCacheLockFree$CloseStorageCommand";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static abstract class Command {
        protected Command() {
        }
    }
}

