/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.Iterator;

public final class IntObjectCache<T>
implements Iterable<T> {
    private static final int DEFAULT_SIZE = 8192;
    public static final int MIN_SIZE = 4;
    private static final int[] HASHTABLE_SIZES = new int[]{5, 11, 23, 47, 97, 197, 397, 797, 1597, 3203, 6421, 12853, 25717, 51437, 102877, 205759, 411527, 823117, 1646237, 3292489, 6584983, 13169977, 26339969, 52679969, 105359939, 210719881, 421439783, 842879579, 1685759167, 433, 877, 1759, 3527, 7057, 14143, 28289, 56591, 113189, 226379, 452759, 905551, 1811107, 3622219, 7244441, 14488931, 28977863, 57955739, 115911563, 231823147, 463646329, 927292699, 1854585413, 953, 1907, 3821, 7643, 15287, 30577, 61169, 122347, 244703, 489407, 978821, 1957651, 3915341, 7830701, 15661423, 31322867, 62645741, 125291483, 250582987, 501165979, 1002331963, 2004663929, 1039, 2081, 4177, 8363, 16729, 33461, 66923, 133853, 267713, 535481, 1070981, 2141977, 4283963, 8567929, 17135863, 34271747, 68543509, 137087021, 274174111, 548348231, 1096696463, 31, 67, 137, 277, 557, 1117, 2237, 4481, 8963, 17929, 35863, 71741, 143483, 286973, 573953, 0x118411, 2295859, 4591721, 9183457, 18366923, 36733847, 73467739, 146935499, 293871013, 587742049, 1175484103, 599, 1201, 2411, 4831, 9677, 19373, 38747, 77509, 155027, 310081, 620171, 1240361, 2480729, 0x4BB4B3, 9922933, 19845871, 39691759, 79383533, 158767069, 317534141, 635068283, 1270136683, 311, 631, 1277, 2557, 5119, 10243, 20507, 41017, 82037, 164089, 328213, 656429, 1312867, 2625761, 5251529, 10503061, 21006137, 42012281, 84024581, 168049163, 336098327, 672196673, 1344393353, 3, 7, 17, 37, 79, 163, 331, 673, 1361, 2729, 5471, 10949, 21911, 43853, 87719, 175447, 350899, 701819, 1403641, 2807303, 5614657, 11229331, 22458671, 44917381, 89834777, 179669557, 359339171, 718678369, 1437356741, 43, 89, 179, 359, 719, 1439, 2879, 5779, 11579, 23159, 46327, 92657, 185323, 370661, 741337, 1482707, 2965421, 5930887, 11861791, 23723597, 47447201, 94894427, 189788857, 379577741, 759155483, 1518310967, 379, 761, 1523, 3049, 6101, 12203, 24407, 48817, 97649, 195311, 390647, 781301, 1562611, 3125257, 6250537, 12501169, 25002389, 50004791, 100009607, 200019221, 400038451, 800076929, 1600153859};
    private int myTop;
    private int myBack;
    private CacheEntry<T>[] myCache;
    private int[] myHashTable;
    private int myHashTableSize;
    private int myCount;
    private int myFirstFree;
    private DeletedPairsListener[] myListeners;
    private int myAttempts;
    private int myHits;

    private static int getAdjustedTableSize(int candidate) {
        int index2 = Arrays.binarySearch(HASHTABLE_SIZES, candidate);
        if (index2 >= 0) {
            return candidate;
        }
        return HASHTABLE_SIZES[-index2];
    }

    public IntObjectCache() {
        this(8192);
    }

    public IntObjectCache(int cacheSize) {
        if (cacheSize < 4) {
            cacheSize = 4;
        }
        this.myBack = 0;
        this.myTop = 0;
        this.myCache = new CacheEntry[cacheSize + 1];
        for (int i2 = 0; i2 < this.myCache.length; ++i2) {
            this.myCache[i2] = new CacheEntry();
        }
        this.myHashTableSize = IntObjectCache.getAdjustedTableSize(cacheSize);
        this.myHashTable = new int[this.myHashTableSize];
        this.myAttempts = 0;
        this.myHits = 0;
        this.myFirstFree = 0;
        this.myCount = 0;
    }

    public boolean isEmpty() {
        return this.count() == 0;
    }

    public boolean containsKey(int key) {
        return this.isCached(key);
    }

    public T get(int key) {
        return this.tryKey(key);
    }

    public T put(int key, T value) {
        T oldValue = this.tryKey(key);
        if (oldValue != null) {
            this.remove(key);
        }
        this.cacheObject(key, value);
        return oldValue;
    }

    public void remove(int key) {
        int index2 = this.searchForCacheEntry(key);
        if (index2 != 0) {
            this.removeEntry(index2);
            this.removeEntryFromHashTable(index2);
            this.myCache[index2].hash_next = this.myFirstFree;
            this.myFirstFree = index2;
            CacheEntry<T> cacheEntry = this.myCache[index2];
            int deletedKey = cacheEntry.key;
            Object deletedValue = cacheEntry.value;
            this.myCache[index2].value = null;
            this.fireListenersAboutDeletion(deletedKey, deletedValue);
        }
    }

    public void removeAll() {
        IntArrayList keys2 = new IntArrayList(this.count());
        int current2 = this.myTop;
        while (current2 > 0) {
            if (this.myCache[current2].value != null) {
                keys2.add(this.myCache[current2].key);
            }
            current2 = this.myCache[current2].next;
        }
        for (int i2 = 0; i2 < keys2.size(); ++i2) {
            this.remove(keys2.getInt(i2));
        }
    }

    public void cacheObject(int key, T x) {
        int deletedKey = 0;
        T deletedValue = null;
        int index2 = this.myFirstFree;
        if (this.myCount < this.myCache.length - 1) {
            if (index2 == 0) {
                index2 = this.myCount;
                ++index2;
            } else {
                this.myFirstFree = this.myCache[index2].hash_next;
            }
            if (this.myCount == 0) {
                this.myBack = index2;
            }
        } else {
            index2 = this.myBack;
            this.removeEntryFromHashTable(index2);
            CacheEntry<T> cacheEntry = this.myCache[index2];
            deletedKey = cacheEntry.key;
            deletedValue = cacheEntry.value;
            this.myBack = this.myCache[index2].prev;
            this.myCache[this.myCache[index2].prev].next = 0;
        }
        this.myCache[index2].key = key;
        this.myCache[index2].value = x;
        this.addEntry2HashTable(index2);
        this.add2Top(index2);
        if (deletedValue != null) {
            this.fireListenersAboutDeletion(deletedKey, deletedValue);
        }
    }

    public T tryKey(int key) {
        ++this.myAttempts;
        int index2 = this.searchForCacheEntry(key);
        if (index2 == 0) {
            return null;
        }
        ++this.myHits;
        CacheEntry<T> cacheEntry = this.myCache[index2];
        int top = this.myTop;
        if (index2 != top) {
            int prev = cacheEntry.prev;
            int next2 = cacheEntry.next;
            if (index2 == this.myBack) {
                this.myBack = prev;
            } else {
                this.myCache[next2].prev = prev;
            }
            this.myCache[prev].next = next2;
            cacheEntry.next = top;
            cacheEntry.prev = 0;
            this.myCache[top].prev = index2;
            this.myTop = index2;
        }
        return cacheEntry.value;
    }

    public boolean isCached(int key) {
        return this.searchForCacheEntry(key) != 0;
    }

    public int count() {
        return this.myCount;
    }

    public int size() {
        return this.myCache.length - 1;
    }

    public void resize(int newSize) {
        IntObjectCache newCache = new IntObjectCache(newSize);
        CacheEntry<T>[] cache2 = this.myCache;
        int back = this.myBack;
        while (back != 0) {
            CacheEntry<T> cacheEntry = cache2[back];
            newCache.cacheObject(cacheEntry.key, cacheEntry.value);
            back = cacheEntry.prev;
        }
        this.myTop = newCache.myTop;
        this.myBack = newCache.myBack;
        this.myCache = newCache.myCache;
        this.myHashTable = newCache.myHashTable;
        this.myHashTableSize = newCache.myHashTableSize;
        this.myCount = newCache.myCount;
        this.myFirstFree = newCache.myFirstFree;
    }

    public double hitRate() {
        return this.myAttempts > 0 ? (double)this.myHits / (double)this.myAttempts : 0.0;
    }

    private void add2Top(int index2) {
        this.myCache[index2].next = this.myTop;
        this.myCache[index2].prev = 0;
        this.myCache[this.myTop].prev = index2;
        this.myTop = index2;
    }

    private void removeEntry(int index2) {
        if (index2 == this.myBack) {
            this.myBack = this.myCache[index2].prev;
        } else {
            this.myCache[this.myCache[index2].next].prev = this.myCache[index2].prev;
        }
        if (index2 == this.myTop) {
            this.myTop = this.myCache[index2].next;
        } else {
            this.myCache[this.myCache[index2].prev].next = this.myCache[index2].next;
        }
    }

    private void addEntry2HashTable(int index2) {
        int hash_index = (this.myCache[index2].key & Integer.MAX_VALUE) % this.myHashTableSize;
        this.myCache[index2].hash_next = this.myHashTable[hash_index];
        this.myHashTable[hash_index] = index2;
        ++this.myCount;
    }

    private void removeEntryFromHashTable(int index2) {
        int hash_index = (this.myCache[index2].key & Integer.MAX_VALUE) % this.myHashTableSize;
        int current2 = this.myHashTable[hash_index];
        int previous = 0;
        while (current2 != 0) {
            int next2 = this.myCache[current2].hash_next;
            if (current2 == index2) {
                if (previous != 0) {
                    this.myCache[previous].hash_next = next2;
                } else {
                    this.myHashTable[hash_index] = next2;
                }
                --this.myCount;
                break;
            }
            previous = current2;
            current2 = next2;
        }
    }

    private int searchForCacheEntry(int key) {
        this.myCache[0].key = key;
        int current2 = this.myHashTable[(key & Integer.MAX_VALUE) % this.myHashTableSize];
        while (true) {
            CacheEntry<T> cacheEntry = this.myCache[current2];
            if (key == cacheEntry.key) break;
            current2 = cacheEntry.hash_next;
        }
        return current2;
    }

    @Override
    public Iterator<T> iterator() {
        return new IntObjectCacheIterator(this);
    }

    public void addDeletedPairsListener(DeletedPairsListener<T> listener) {
        this.myListeners = this.myListeners == null ? new DeletedPairsListener[1] : Arrays.copyOf(this.myListeners, this.myListeners.length + 1);
        this.myListeners[this.myListeners.length - 1] = listener;
    }

    public void removeDeletedPairsListener(DeletedPairsListener<T> listener) {
        if (this.myListeners != null) {
            if (this.myListeners.length == 1) {
                this.myListeners = null;
            } else {
                DeletedPairsListener[] newListeners = new DeletedPairsListener[this.myListeners.length - 1];
                int i2 = 0;
                for (DeletedPairsListener myListener : this.myListeners) {
                    if (myListener == listener) continue;
                    newListeners[i2++] = myListener;
                }
                this.myListeners = newListeners;
            }
        }
    }

    private void fireListenersAboutDeletion(int key, T value) {
        if (this.myListeners != null) {
            for (DeletedPairsListener myListener : this.myListeners) {
                myListener.objectRemoved(key, value);
            }
        }
    }

    static {
        Arrays.sort(HASHTABLE_SIZES);
    }

    protected static final class CacheEntry<T> {
        public int key;
        public T value;
        public int prev;
        public int next;
        public int hash_next;

        protected CacheEntry() {
        }
    }

    protected final class IntObjectCacheIterator
    implements Iterator<T> {
        private int myCurrentEntry = 0;

        public IntObjectCacheIterator(IntObjectCache cache2) {
            ((IntObjectCache)cache2).myCache[0].next = cache2.myTop;
        }

        @Override
        public boolean hasNext() {
            this.myCurrentEntry = ((IntObjectCache)IntObjectCache.this).myCache[this.myCurrentEntry].next;
            return this.myCurrentEntry != 0;
        }

        @Override
        public T next() {
            return ((IntObjectCache)IntObjectCache.this).myCache[this.myCurrentEntry].value;
        }

        @Override
        public void remove() {
            IntObjectCache.this.removeEntry(((IntObjectCache)IntObjectCache.this).myCache[this.myCurrentEntry].key);
        }
    }

    @FunctionalInterface
    public static interface DeletedPairsListener<T>
    extends EventListener {
        public void objectRemoved(int var1, T var2);
    }
}

