/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.lang.CompoundRuntimeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0010\u0010\u0002\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u0003\u001a \u0010\u0004\u001a\u00020\u00052\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u0007\u001a\u0018\u0010\b\u001a\u00020\t2\u0010\u0010\u0002\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u0003\u001a\f\u0010\n\u001a\u00020\u0001*\u00020\u0001H\u0002\u00a8\u0006\u000b"}, d2={"createException", "", "errors", "", "getErrorsAsString", "", "includeStackTrace", "", "throwIfNotEmpty", "", "flatten", "intellij.platform.util.ex"})
@SourceDebugExtension(value={"SMAP\nerror.kt\nKotlin\n*S Kotlin\n*F\n+ 1 error.kt\ncom/intellij/util/ErrorKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,55:1\n10#2:56\n*S KotlinDebug\n*F\n+ 1 error.kt\ncom/intellij/util/ErrorKt\n*L\n33#1:56\n*E\n"})
public final class ErrorKt {
    public static final void throwIfNotEmpty(@Nullable List<? extends Throwable> errors) {
        Throwable exception = ErrorKt.createException(errors);
        if (exception != null) {
            throw exception;
        }
    }

    @Nullable
    public static final Throwable createException(@Nullable List<? extends Throwable> errors) {
        List<? extends Throwable> list = errors;
        List list2 = UtilKt.nullize(list != null ? CollectionsKt.filterNotNull((Iterable)list) : null);
        if (list2 == null) {
            return null;
        }
        List exceptions = list2;
        return ErrorKt.flatten(new CompoundRuntimeException(exceptions));
    }

    private static final Throwable flatten(Throwable $this$flatten) {
        ArrayList<Throwable> result2 = new ArrayList<Throwable>();
        ArrayDeque queue = new ArrayDeque();
        queue.add((Object)$this$flatten);
        int iterations = 0;
        while (!((Collection)queue).isEmpty() && iterations++ < 100) {
            Throwable exception = (Throwable)queue.removeFirst();
            if (exception instanceof CompoundRuntimeException) {
                List<Throwable> list = ((CompoundRuntimeException)exception).getExceptions();
                Intrinsics.checkNotNullExpressionValue(list, (String)"exception.exceptions");
                queue.addAll((Collection)list);
                continue;
            }
            result2.add(exception);
        }
        if (!((Collection)queue).isEmpty()) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(CompoundRuntimeException.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
            logger.warn("Exception is too complex");
            return $this$flatten;
        }
        Throwable throwable = (Throwable)CollectionsKt.singleOrNull((List)result2);
        if (throwable == null) {
            throwable = new CompoundRuntimeException((List<? extends Throwable>)result2);
        }
        return throwable;
    }

    @ApiStatus.Internal
    @NotNull
    public static final CharSequence getErrorsAsString(@NotNull List<? extends Throwable> errors, boolean includeStackTrace) {
        Intrinsics.checkNotNullParameter(errors, (String)"errors");
        StringBuilder sb = new StringBuilder();
        sb.append(errors.size() + " errors:\n");
        int n = errors.size();
        for (int i2 = 0; i2 < n; ++i2) {
            String string2;
            sb.append("[").append(i2 + 1).append("]: ------------------------------\n");
            Throwable error = errors.get(i2);
            if (includeStackTrace) {
                string2 = ExceptionUtil.getThrowableText(error);
            } else {
                String string3 = error.getMessage();
                string2 = string3;
                Intrinsics.checkNotNull((Object)string3);
            }
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"if (includeStackTrace) E\u2026ror) else error.message!!");
            String line = string2;
            sb.append(line);
            if (StringsKt.endsWith$default((CharSequence)line, (char)'\n', (boolean)false, (int)2, null)) continue;
            sb.append('\n');
        }
        sb.append(StringsKt.repeat((CharSequence)"-", (int)5));
        sb.append("------------------------------\n");
        return sb;
    }

    public static /* synthetic */ CharSequence getErrorsAsString$default(List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return ErrorKt.getErrorsAsString(list, bl);
    }
}

