/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CanonicalTypes {
    private CanonicalTypes() {
    }

    public static Type createTypeWrapper(@NotNull PsiType type) {
        if (type == null) {
            CanonicalTypes.$$$reportNull$$$0(0);
        }
        return type.accept(Creator.INSTANCE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/refactoring/util/CanonicalTypes", "createTypeWrapper"));
    }

    private static class Creator
    extends PsiTypeVisitor<Type> {
        public static final Creator INSTANCE = new Creator();
        private static final Logger LOG = Logger.getInstance(Creator.class);

        private Creator() {
        }

        @Override
        public Type visitPrimitiveType(@NotNull PsiPrimitiveType type) {
            if (type == null) {
                Creator.$$$reportNull$$$0(0);
            }
            return new Primitive(type);
        }

        @Override
        public Type visitEllipsisType(@NotNull PsiEllipsisType type) {
            if (type == null) {
                Creator.$$$reportNull$$$0(1);
            }
            return new Ellipsis(type, this.substituteComponents(type));
        }

        @Override
        public Type visitArrayType(@NotNull PsiArrayType type) {
            if (type == null) {
                Creator.$$$reportNull$$$0(2);
            }
            return new Array(type, this.substituteComponents(type));
        }

        @NotNull
        private Type substituteComponents(PsiArrayType type) {
            PsiType componentType = type.getComponentType();
            Type substituted = componentType.accept(this);
            LOG.assertTrue(substituted != null, componentType);
            Type type2 = substituted;
            if (type2 == null) {
                Creator.$$$reportNull$$$0(3);
            }
            return type2;
        }

        @Override
        public Type visitWildcardType(@NotNull PsiWildcardType type) {
            if (type == null) {
                Creator.$$$reportNull$$$0(4);
            }
            PsiType bound = type.getBound();
            return new WildcardType(type, type.isExtends(), bound == null ? null : bound.accept(this));
        }

        @Override
        public Type visitClassType(@NotNull PsiClassType type) {
            PsiClassType.ClassResolveResult resolveResult;
            PsiClass aClass;
            if (type == null) {
                Creator.$$$reportNull$$$0(5);
            }
            if ((aClass = (resolveResult = type.resolveGenerics()).getElement()) instanceof PsiAnonymousClass) {
                return this.visitClassType(((PsiAnonymousClass)aClass).getBaseClassType());
            }
            if (aClass == null) {
                return new UnresolvedType(type);
            }
            HashMap<String, Type> substitutionMap = new HashMap<String, Type>();
            PsiSubstitutor substitutor = resolveResult.getSubstitutor();
            for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(aClass)) {
                PsiType substitute = substitutor.substitute(typeParameter);
                substitutionMap.put(typeParameter.getName(), substitute != null ? substitute.accept(this) : null);
            }
            String qualifiedName = ObjectUtils.notNull(aClass.getQualifiedName(), Objects.requireNonNull(aClass.getName()));
            return new ClassType(type, qualifiedName, substitutionMap);
        }

        @Override
        public Type visitDisjunctionType(@NotNull PsiDisjunctionType type) {
            if (type == null) {
                Creator.$$$reportNull$$$0(6);
            }
            List<Type> types = ContainerUtil.map(type.getDisjunctions(), type1 -> type1.accept(this));
            return new LogicalOperationType(types, true);
        }

        @Override
        @Nullable
        public Type visitIntersectionType(@NotNull PsiIntersectionType type) {
            if (type == null) {
                Creator.$$$reportNull$$$0(7);
            }
            List<Type> types = ContainerUtil.map(type.getConjuncts(), type1 -> type1.accept(this));
            return new LogicalOperationType(types, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/util/CanonicalTypes$Creator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/util/CanonicalTypes$Creator";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "substituteComponents";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPrimitiveType";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitEllipsisType";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitArrayType";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "visitWildcardType";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "visitClassType";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "visitDisjunctionType";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "visitIntersectionType";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class Type {
        @NotNull
        public abstract PsiType getType(@Nullable PsiElement var1, PsiManager var2) throws IncorrectOperationException;

        @NotNull
        public PsiType getType(@NotNull PsiElement context2) {
            if (context2 == null) {
                Type.$$$reportNull$$$0(0);
            }
            PsiType psiType = this.getType(context2, context2.getManager());
            if (psiType == null) {
                Type.$$$reportNull$$$0(1);
            }
            return psiType;
        }

        @NonNls
        public abstract String getTypeText();

        public void addImportsTo(@NotNull JavaCodeFragment fragment) {
            if (fragment == null) {
                Type.$$$reportNull$$$0(2);
            }
        }

        public boolean isValid() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/util/CanonicalTypes$Type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fragment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/util/CanonicalTypes$Type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getType";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "addImportsTo";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class LogicalOperationType
    extends Type {
        private final List<? extends Type> myTypes;
        private final boolean myDisjunction;

        private LogicalOperationType(List<? extends Type> types, boolean disjunction) {
            this.myTypes = types;
            this.myDisjunction = disjunction;
        }

        @Override
        @NotNull
        public PsiType getType(PsiElement context2, PsiManager manager) throws IncorrectOperationException {
            List<PsiType> types = ContainerUtil.map(this.myTypes, type -> type.getType(context2, manager));
            PsiType psiType = this.myDisjunction ? new PsiDisjunctionType(types, manager) : PsiIntersectionType.createIntersection(types);
            if (psiType == null) {
                LogicalOperationType.$$$reportNull$$$0(0);
            }
            return psiType;
        }

        @Override
        public String getTypeText() {
            return StringUtil.join(this.myTypes, type -> type.getTypeText(), this.myDisjunction ? "|" : "&");
        }

        @Override
        public void addImportsTo(@NotNull JavaCodeFragment fragment) {
            if (fragment == null) {
                LogicalOperationType.$$$reportNull$$$0(1);
            }
            for (Type type : this.myTypes) {
                type.addImportsTo(fragment);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/util/CanonicalTypes$LogicalOperationType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fragment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/util/CanonicalTypes$LogicalOperationType";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addImportsTo";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class ClassType
    extends AnnotatedType {
        private final String myPresentableText;
        private final String myClassQName;
        private final Map<String, Type> mySubstitutor;

        private ClassType(@NotNull PsiType original, @NotNull String classQName, @NotNull Map<String, Type> substitutor) {
            if (original == null) {
                ClassType.$$$reportNull$$$0(0);
            }
            if (classQName == null) {
                ClassType.$$$reportNull$$$0(1);
            }
            if (substitutor == null) {
                ClassType.$$$reportNull$$$0(2);
            }
            super(TypeAnnotationProvider.Static.create(original.getAnnotations()));
            this.myPresentableText = original.getPresentableText(true);
            this.myClassQName = classQName;
            this.mySubstitutor = substitutor;
        }

        @Override
        @NotNull
        public PsiType getType(PsiElement context2, PsiManager manager) throws IncorrectOperationException {
            JavaPsiFacade facade = JavaPsiFacade.getInstance(manager.getProject());
            PsiElementFactory factory = facade.getElementFactory();
            PsiClass aClass = facade.getResolveHelper().resolveReferencedClass(this.myClassQName, context2);
            if (aClass == null) {
                PsiType psiType = factory.createTypeFromText(this.myClassQName, context2);
                if (psiType == null) {
                    ClassType.$$$reportNull$$$0(3);
                }
                return psiType;
            }
            HashMap<PsiTypeParameter, PsiType> substitutionMap = new HashMap<PsiTypeParameter, PsiType>();
            Iterator<PsiTypeParameter> iterator2 = PsiUtil.typeParametersIterable(aClass).iterator();
            while (iterator2.hasNext()) {
                PsiTypeParameter typeParameter;
                Type substitute = this.mySubstitutor.get((typeParameter = iterator2.next()).getName());
                substitutionMap.put(typeParameter, substitute != null ? substitute.getType(context2, manager) : null);
            }
            PsiClassType psiClassType = factory.createType(aClass, factory.createSubstitutor(substitutionMap), null).annotate(this.myProvider);
            if (psiClassType == null) {
                ClassType.$$$reportNull$$$0(4);
            }
            return psiClassType;
        }

        @Override
        public String getTypeText() {
            return this.myPresentableText;
        }

        @Override
        public void addImportsTo(@NotNull JavaCodeFragment fragment) {
            if (fragment == null) {
                ClassType.$$$reportNull$$$0(5);
            }
            fragment.addImportsFromString(this.myClassQName);
            for (Type type : this.mySubstitutor.values()) {
                if (type == null) continue;
                type.addImportsTo(fragment);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classQName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "substitutor";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/util/CanonicalTypes$ClassType";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fragment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/util/CanonicalTypes$ClassType";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "addImportsTo";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class UnresolvedType
    extends Type {
        private final String myPresentableText;
        private final String myCanonicalText;

        private UnresolvedType(@NotNull PsiType original) {
            if (original == null) {
                UnresolvedType.$$$reportNull$$$0(0);
            }
            this.myPresentableText = original.getPresentableText(true);
            this.myCanonicalText = original.getCanonicalText(true);
        }

        @Override
        @NotNull
        public PsiType getType(PsiElement context2, PsiManager manager) throws IncorrectOperationException {
            PsiType psiType = JavaPsiFacade.getElementFactory(manager.getProject()).createTypeFromText(this.myCanonicalText, context2);
            if (psiType == null) {
                UnresolvedType.$$$reportNull$$$0(1);
            }
            return psiType;
        }

        @Override
        public String getTypeText() {
            return this.myPresentableText;
        }

        @Override
        public boolean isValid() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/util/CanonicalTypes$UnresolvedType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/util/CanonicalTypes$UnresolvedType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class WildcardType
    extends AnnotatedType {
        private final boolean myIsExtending;
        private final Type myBound;

        private WildcardType(@NotNull PsiType original, boolean isExtending, @Nullable Type bound) {
            if (original == null) {
                WildcardType.$$$reportNull$$$0(0);
            }
            super(original.getAnnotationProvider());
            this.myIsExtending = isExtending;
            this.myBound = bound;
        }

        @Override
        @NotNull
        public PsiType getType(PsiElement context2, PsiManager manager) throws IncorrectOperationException {
            PsiWildcardType type;
            if (this.myBound == null) {
                type = PsiWildcardType.createUnbounded(manager);
            } else {
                PsiType boundType = this.myBound.getType(context2, manager);
                if (boundType.equals(PsiTypes.nullType())) {
                    throw new IncorrectOperationException("Bound type is null " + this.getTypeText());
                }
                if (boundType instanceof PsiWildcardType) {
                    throw new IncorrectOperationException("Bound type is a wildcard " + this.getTypeText() + "; " + boundType.getCanonicalText());
                }
                type = this.myIsExtending ? PsiWildcardType.createExtends(manager, boundType) : PsiWildcardType.createSuper(manager, boundType);
            }
            PsiType psiType = type.annotate(this.myProvider);
            if (psiType == null) {
                WildcardType.$$$reportNull$$$0(1);
            }
            return psiType;
        }

        @Override
        public String getTypeText() {
            return this.myBound == null ? "?" : "? " + (this.myIsExtending ? "extends " : "super ") + this.myBound.getTypeText();
        }

        @Override
        public void addImportsTo(@NotNull JavaCodeFragment fragment) {
            if (fragment == null) {
                WildcardType.$$$reportNull$$$0(2);
            }
            if (this.myBound != null) {
                this.myBound.addImportsTo(fragment);
            }
        }

        @Override
        public boolean isValid() {
            return this.myBound == null || this.myBound.isValid();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/util/CanonicalTypes$WildcardType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fragment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/util/CanonicalTypes$WildcardType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "addImportsTo";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class Ellipsis
    extends Array {
        private Ellipsis(@NotNull PsiType original, @NotNull Type componentType) {
            if (original == null) {
                Ellipsis.$$$reportNull$$$0(0);
            }
            if (componentType == null) {
                Ellipsis.$$$reportNull$$$0(1);
            }
            super(original, componentType);
        }

        @Override
        @NotNull
        public PsiType getType(PsiElement context2, PsiManager manager) throws IncorrectOperationException {
            PsiType psiType = new PsiEllipsisType(this.myComponentType.getType(context2, manager)).annotate(this.myProvider);
            if (psiType == null) {
                Ellipsis.$$$reportNull$$$0(2);
            }
            return psiType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "componentType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/util/CanonicalTypes$Ellipsis";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/util/CanonicalTypes$Ellipsis";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Array
    extends AnnotatedType {
        final Type myComponentType;
        private final String myPresentableText;

        private Array(@NotNull PsiType original, @NotNull Type componentType) {
            if (original == null) {
                Array.$$$reportNull$$$0(0);
            }
            if (componentType == null) {
                Array.$$$reportNull$$$0(1);
            }
            super(original.getAnnotationProvider());
            this.myPresentableText = original.getPresentableText(true);
            this.myComponentType = componentType;
        }

        @Override
        @NotNull
        public PsiType getType(PsiElement context2, PsiManager manager) throws IncorrectOperationException {
            PsiType psiType = this.myComponentType.getType(context2, manager).createArrayType().annotate(this.myProvider);
            if (psiType == null) {
                Array.$$$reportNull$$$0(2);
            }
            return psiType;
        }

        @Override
        public String getTypeText() {
            return this.myPresentableText;
        }

        @Override
        public void addImportsTo(@NotNull JavaCodeFragment fragment) {
            if (fragment == null) {
                Array.$$$reportNull$$$0(3);
            }
            this.myComponentType.addImportsTo(fragment);
        }

        @Override
        public boolean isValid() {
            return this.myComponentType.isValid();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "componentType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/util/CanonicalTypes$Array";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fragment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/util/CanonicalTypes$Array";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addImportsTo";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class Primitive
    extends AnnotatedType {
        private final PsiPrimitiveType myType;

        private Primitive(@NotNull PsiPrimitiveType type) {
            if (type == null) {
                Primitive.$$$reportNull$$$0(0);
            }
            super(type.getAnnotationProvider());
            this.myType = type;
        }

        @Override
        @NotNull
        public PsiType getType(PsiElement context2, PsiManager manager) {
            PsiPrimitiveType psiPrimitiveType = this.myType.annotate(this.myProvider);
            if (psiPrimitiveType == null) {
                Primitive.$$$reportNull$$$0(1);
            }
            return psiPrimitiveType;
        }

        @Override
        public String getTypeText() {
            return this.myType.getPresentableText(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/util/CanonicalTypes$Primitive";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/util/CanonicalTypes$Primitive";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class AnnotatedType
    extends Type {
        protected final TypeAnnotationProvider myProvider;

        AnnotatedType(@NotNull TypeAnnotationProvider provider) {
            if (provider == null) {
                AnnotatedType.$$$reportNull$$$0(0);
            }
            PsiAnnotation[] annotations = ContainerUtil.map(provider.getAnnotations(), annotation -> {
                PsiElement copy2 = annotation.copy();
                if (copy2 instanceof PsiAnnotation) {
                    return (PsiAnnotation)copy2;
                }
                return JavaPsiFacade.getElementFactory(annotation.getProject()).createAnnotationFromText(annotation.getText(), (PsiElement)annotation);
            }, PsiAnnotation.EMPTY_ARRAY);
            this.myProvider = TypeAnnotationProvider.Static.create(annotations);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/refactoring/util/CanonicalTypes$AnnotatedType", "<init>"));
        }
    }
}

