/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiRecordHeader;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.impl.light.LightRecordCanonicalConstructor;
import com.intellij.psi.impl.light.LightRecordField;
import com.intellij.psi.impl.light.LightRecordMethod;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.intellij.psi.util.AccessModifier;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecordAugmentProvider
extends PsiAugmentProvider {
    @Override
    @NotNull
    protected <Psi extends PsiElement> List<Psi> getAugments(@NotNull PsiElement element, @NotNull Class<Psi> type, @Nullable String nameHint) {
        if (element == null) {
            RecordAugmentProvider.$$$reportNull$$$0(0);
        }
        if (type == null) {
            RecordAugmentProvider.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiExtensibleClass) {
            PsiExtensibleClass aClass = (PsiExtensibleClass)element;
            if (!aClass.isRecord()) {
                List list = Collections.emptyList();
                if (list == null) {
                    RecordAugmentProvider.$$$reportNull$$$0(2);
                }
                return list;
            }
            if (type == PsiMethod.class && !(element instanceof PsiCompiledElement)) {
                return RecordAugmentProvider.getAccessorsAugments(aClass);
            }
            if (type == PsiField.class) {
                return RecordAugmentProvider.getFieldAugments(aClass);
            }
        }
        List list = Collections.emptyList();
        if (list == null) {
            RecordAugmentProvider.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    private static <Psi extends PsiElement> List<Psi> getAccessorsAugments(PsiExtensibleClass aClass) {
        PsiRecordHeader header = aClass.getRecordHeader();
        if (header == null) {
            List list = Collections.emptyList();
            if (list == null) {
                RecordAugmentProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        PsiRecordComponent[] components = aClass.getRecordComponents();
        PsiElementFactory factory = JavaPsiFacade.getInstance(aClass.getProject()).getElementFactory();
        ArrayList<PsiMethod> methods = new ArrayList<PsiMethod>(components.length);
        List<PsiMethod> ownMethods = aClass.getOwnMethods();
        for (PsiRecordComponent component : components) {
            PsiMethod recordMethod;
            if (!RecordAugmentProvider.shouldGenerateMethod(component, ownMethods) || (recordMethod = RecordAugmentProvider.createRecordMethod(component, factory)) == null) continue;
            LightRecordMethod method = new LightRecordMethod(aClass.getManager(), recordMethod, (PsiClass)aClass, component);
            methods.add(method);
        }
        PsiMethod constructor = RecordAugmentProvider.getCanonicalConstructor(aClass, ownMethods, header);
        if (constructor != null) {
            methods.add(constructor);
        }
        ArrayList<PsiMethod> arrayList = methods;
        if (arrayList == null) {
            RecordAugmentProvider.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @Nullable
    private static PsiMethod getCanonicalConstructor(PsiExtensibleClass aClass, List<PsiMethod> ownMethods, @NotNull PsiRecordHeader recordHeader) {
        PsiMethod nonPhysical;
        String className;
        if (recordHeader == null) {
            RecordAugmentProvider.$$$reportNull$$$0(6);
        }
        if ((className = aClass.getName()) == null) {
            return null;
        }
        for (PsiMethod method : ownMethods) {
            if (!JavaPsiRecordUtil.isCompactConstructor(method) && !JavaPsiRecordUtil.isExplicitCanonicalConstructor(method)) continue;
            return null;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory(recordHeader.getProject());
        String sb = className + recordHeader.getText() + "{" + StringUtil.join(recordHeader.getRecordComponents(), c -> "this." + c.getName() + "=" + c.getName() + ";", "\n") + "}";
        try {
            nonPhysical = factory.createMethodFromText(sb, recordHeader.getContainingClass());
        }
        catch (IncorrectOperationException e) {
            return null;
        }
        PsiModifierList classModifierList = aClass.getModifierList();
        AccessModifier modifier = classModifierList == null ? AccessModifier.PUBLIC : AccessModifier.fromModifierList(classModifierList);
        nonPhysical.getModifierList().setModifierProperty(modifier.toPsiModifier(), true);
        return new LightRecordCanonicalConstructor(nonPhysical, aClass);
    }

    private static boolean shouldGenerateMethod(PsiRecordComponent component, List<PsiMethod> ownMethods) {
        String componentName = component.getName();
        for (PsiMethod method : ownMethods) {
            if (!componentName.equals(method.getName()) || !method.getParameterList().isEmpty()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static <Psi extends PsiElement> List<Psi> getFieldAugments(PsiClass aClass) {
        PsiRecordComponent[] components = aClass.getRecordComponents();
        PsiElementFactory factory = JavaPsiFacade.getInstance(aClass.getProject()).getElementFactory();
        ArrayList<LightRecordField> fields2 = new ArrayList<LightRecordField>(components.length);
        for (PsiRecordComponent component : components) {
            PsiField recordField = RecordAugmentProvider.createRecordField(component, factory);
            if (recordField == null) continue;
            LightRecordField field = new LightRecordField(aClass.getManager(), recordField, aClass, component);
            fields2.add(field);
        }
        ArrayList<LightRecordField> arrayList = fields2;
        if (arrayList == null) {
            RecordAugmentProvider.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Nullable
    private static PsiField createRecordField(@NotNull PsiRecordComponent component, @NotNull PsiElementFactory factory) {
        if (component == null) {
            RecordAugmentProvider.$$$reportNull$$$0(8);
        }
        if (factory == null) {
            RecordAugmentProvider.$$$reportNull$$$0(9);
        }
        String name2 = component.getName();
        if (RecordAugmentProvider.hasForbiddenType(component)) {
            return null;
        }
        String typeText = RecordAugmentProvider.getTypeText(component);
        if (typeText == null) {
            return null;
        }
        try {
            return factory.createFieldFromText("private final " + typeText + " " + name2 + ";", component.getContainingClass());
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    @Nullable
    private static PsiMethod createRecordMethod(@NotNull PsiRecordComponent component, @NotNull PsiElementFactory factory) {
        if (component == null) {
            RecordAugmentProvider.$$$reportNull$$$0(10);
        }
        if (factory == null) {
            RecordAugmentProvider.$$$reportNull$$$0(11);
        }
        String name2 = component.getName();
        if (RecordAugmentProvider.hasForbiddenType(component)) {
            return null;
        }
        String typeText = RecordAugmentProvider.getTypeText(component);
        if (typeText == null) {
            return null;
        }
        try {
            return factory.createMethodFromText("public " + typeText + " " + name2 + "(){ return " + name2 + "; }", component.getContainingClass());
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    private static boolean hasForbiddenType(@NotNull PsiRecordComponent component) {
        PsiTypeElement typeElement;
        if (component == null) {
            RecordAugmentProvider.$$$reportNull$$$0(12);
        }
        return (typeElement = component.getTypeElement()) == null || typeElement.getText().equals("record");
    }

    @Nullable
    private static String getTypeText(@NotNull PsiRecordComponent component) {
        PsiTypeElement typeElement;
        if (component == null) {
            RecordAugmentProvider.$$$reportNull$$$0(13);
        }
        if ((typeElement = component.getTypeElement()) == null) {
            return null;
        }
        String typeText = typeElement.getText();
        if (typeText.endsWith("...")) {
            typeText = typeText.substring(0, typeText.length() - 3) + "[]";
        }
        return typeText;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/RecordAugmentProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordHeader";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/RecordAugmentProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAugments";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessorsAugments";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldAugments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAugments";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCanonicalConstructor";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createRecordField";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createRecordMethod";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasForbiddenType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTypeText";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

