/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;

public class OrFilter
implements ElementFilter {
    private final List<ElementFilter> myFilters;

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public OrFilter() {
        this.myFilters = new SmartList<ElementFilter>();
    }

    public OrFilter(ElementFilter ... filters) {
        this.myFilters = new SmartList<ElementFilter>(filters);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public void addFilter(ElementFilter filter2) {
        this.myFilters.add(filter2);
    }

    @Override
    public boolean isAcceptable(Object element, PsiElement context2) {
        return this.myFilters.isEmpty() || this.myFilters.stream().anyMatch(filter2 -> filter2.isAcceptable(element, context2));
    }

    public boolean isClassAcceptable(Class elementClass) {
        return this.myFilters.isEmpty() || this.myFilters.stream().anyMatch(filter2 -> filter2.isClassAcceptable(elementClass));
    }

    @Override
    public String toString() {
        return '(' + StringUtil.join(this.myFilters, " | ") + ')';
    }
}

