/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.ElementFilter;
import java.util.stream.Stream;

public class AndFilter
implements ElementFilter {
    private final ElementFilter[] myFilters;

    public AndFilter(ElementFilter filter1, ElementFilter filter2) {
        this.myFilters = new ElementFilter[]{filter1, filter2};
    }

    public AndFilter(ElementFilter ... filters) {
        this.myFilters = filters;
    }

    @Override
    public boolean isAcceptable(Object element, PsiElement context2) {
        return Stream.of(this.myFilters).allMatch(filter2 -> filter2.isAcceptable(element, context2));
    }

    public boolean isClassAcceptable(Class elementClass) {
        return Stream.of(this.myFilters).allMatch(filter2 -> filter2.isClassAcceptable(elementClass));
    }

    @Override
    public String toString() {
        return '(' + StringUtil.join(this.myFilters, ElementFilter::toString, " & ") + ')';
    }
}

