/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiNamePatternCondition;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiJavaElementPattern<T extends PsiElement, Self extends PsiJavaElementPattern<T, Self>>
extends PsiElementPattern<T, Self> {
    @NonNls
    private static final String VALUE = "value";

    public PsiJavaElementPattern(Class<T> aClass) {
        super(aClass);
    }

    public PsiJavaElementPattern(@NotNull InitialPatternCondition<T> condition) {
        if (condition == null) {
            PsiJavaElementPattern.$$$reportNull$$$0(0);
        }
        super(condition);
    }

    public Self annotationParam(@NonNls String annotationQualifiedName, @NonNls String parameterName) {
        return (Self)((PsiJavaElementPattern)this.withParent(PsiJavaPatterns.psiNameValuePair().withName(parameterName).withParent(PlatformPatterns.psiElement(PsiAnnotationParameterList.class).withParent(PsiJavaPatterns.psiAnnotation().qName(annotationQualifiedName)))));
    }

    public Self annotationParam(@NonNls String annotationQualifiedName) {
        return this.annotationParam(annotationQualifiedName, VALUE);
    }

    public Self annotationParam(ElementPattern<String> annotationQualifiedName, @NonNls String parameterName) {
        return (Self)((PsiJavaElementPattern)this.withParent(PsiJavaPatterns.psiNameValuePair().withName(parameterName).withParent(PlatformPatterns.psiElement(PsiAnnotationParameterList.class).withParent(PsiJavaPatterns.psiAnnotation().qName(annotationQualifiedName)))));
    }

    public Self annotationParam(@NotNull ElementPattern<? extends PsiAnnotation> annotation) {
        if (annotation == null) {
            PsiJavaElementPattern.$$$reportNull$$$0(1);
        }
        return (Self)((PsiJavaElementPattern)this.withParent(PsiJavaPatterns.psiNameValuePair().withParent(PlatformPatterns.psiElement(PsiAnnotationParameterList.class).withParent(annotation))));
    }

    public Self annotationParam(String parameterName, @NotNull ElementPattern<? extends PsiAnnotation> annotation) {
        if (annotation == null) {
            PsiJavaElementPattern.$$$reportNull$$$0(2);
        }
        return (Self)((PsiJavaElementPattern)this.withParent(PsiJavaPatterns.psiNameValuePair().withName(parameterName).withParent(PlatformPatterns.psiElement(PsiAnnotationParameterList.class).withParent(annotation))));
    }

    public Self insideAnnotationParam(ElementPattern<String> annotationQualifiedName, @NonNls String parameterName) {
        return (Self)((PsiJavaElementPattern)this.withAncestor(3, PsiJavaPatterns.psiNameValuePair().withName(parameterName).withParent(PlatformPatterns.psiElement(PsiAnnotationParameterList.class).withParent(PsiJavaPatterns.psiAnnotation().qName(annotationQualifiedName)))));
    }

    public Self insideAnnotationParam(ElementPattern<String> annotationQualifiedName) {
        return this.insideAnnotationParam(annotationQualifiedName, VALUE);
    }

    public Self insideAnnotationParam(@NotNull String annotationQualifiedName) {
        if (annotationQualifiedName == null) {
            PsiJavaElementPattern.$$$reportNull$$$0(3);
        }
        return this.insideAnnotationParam((ElementPattern<String>)StandardPatterns.string().equalTo(annotationQualifiedName));
    }

    public Self nameIdentifierOf(Class<? extends PsiMember> aClass) {
        return this.nameIdentifierOf(StandardPatterns.instanceOf(aClass));
    }

    public Self nameIdentifierOf(final ElementPattern<? extends PsiMember> pattern) {
        return (Self)((PsiJavaElementPattern)this.with(new PatternCondition<T>("nameIdentifierOf"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context2) {
                if (t == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!(t instanceof PsiIdentifier)) {
                    return false;
                }
                PsiElement parent = t.getParent();
                if (parent instanceof PsiClass && t != ((PsiClass)parent).getNameIdentifier()) {
                    return false;
                }
                if (parent instanceof PsiMethod && t != ((PsiMethod)parent).getNameIdentifier()) {
                    return false;
                }
                if (parent instanceof PsiVariable && t != ((PsiVariable)parent).getNameIdentifier()) {
                    return false;
                }
                return pattern.accepts(parent, context2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/PsiJavaElementPattern$1", "accepts"));
            }
        }));
    }

    public Self methodCallParameter(final int index2, final ElementPattern<? extends PsiMethod> methodPattern) {
        final PsiNamePatternCondition nameCondition = ContainerUtil.findInstance(methodPattern.getCondition().getConditions(), PsiNamePatternCondition.class);
        return (Self)((PsiJavaElementPattern)this.with(new PatternCondition<T>("methodCallParameter"){

            @Override
            public boolean accepts(@NotNull T literal, ProcessingContext context2) {
                PsiElement parent;
                if (literal == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((parent = literal.getParent()) instanceof PsiExpressionList) {
                    return this.hasIndex(literal, index2) && PsiJavaElementPattern.checkCall(context2, (PsiExpressionList)parent, methodPattern, nameCondition);
                }
                return false;
            }

            private boolean hasIndex(@NotNull T literal, int index22) {
                if (literal == null) {
                    2.$$$reportNull$$$0(1);
                }
                int currentIndex = 0;
                Object each = literal;
                while (each != null) {
                    if (!((each = each.getPrevSibling()) instanceof PsiExpression) || ++currentIndex <= index22) continue;
                    return false;
                }
                return currentIndex == index22;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "literal";
                objectArray2[1] = "com/intellij/patterns/PsiJavaElementPattern$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "accepts";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "hasIndex";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }));
    }

    public Self methodCallParameter(final @NotNull ElementPattern<? extends PsiMethod> methodPattern) {
        if (methodPattern == null) {
            PsiJavaElementPattern.$$$reportNull$$$0(4);
        }
        final PsiNamePatternCondition nameCondition = ContainerUtil.findInstance(methodPattern.getCondition().getConditions(), PsiNamePatternCondition.class);
        return (Self)((PsiJavaElementPattern)this.with(new PatternCondition<T>("methodCallParameter"){

            @Override
            public boolean accepts(@NotNull T literal, ProcessingContext context2) {
                PsiElement parent;
                if (literal == null) {
                    3.$$$reportNull$$$0(0);
                }
                return (parent = literal.getParent()) instanceof PsiExpressionList && PsiJavaElementPattern.checkCall(context2, (PsiExpressionList)parent, methodPattern, nameCondition);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/intellij/patterns/PsiJavaElementPattern$3", "accepts"));
            }
        }));
    }

    private static boolean checkCall(ProcessingContext context2, PsiExpressionList psiExpressionList, ElementPattern<? extends PsiMethod> methodPattern, @Nullable PsiNamePatternCondition nameCondition) {
        PsiElement element = psiExpressionList.getParent();
        if (element instanceof PsiMethodCallExpression) {
            PsiReferenceExpression methodExpression = ((PsiMethodCallExpression)element).getMethodExpression();
            if (nameCondition != null && !nameCondition.getNamePattern().accepts(methodExpression.getReferenceName())) {
                return false;
            }
            for (JavaResolveResult result2 : methodExpression.multiResolve(false)) {
                if (!methodPattern.accepts(result2.getElement(), context2)) continue;
                return true;
            }
        }
        return false;
    }

    public Self constructorParameter(final int index2, final String ... fqns) {
        return (Self)((PsiJavaElementPattern)this.with(new PatternCondition<T>("constructorParameter"){

            @Override
            public boolean accepts(@NotNull T literal, ProcessingContext context2) {
                PsiElement parent;
                if (literal == null) {
                    4.$$$reportNull$$$0(0);
                }
                if ((parent = literal.getParent()) instanceof PsiExpressionList) {
                    PsiJavaCodeReferenceElement reference;
                    PsiExpressionList psiExpressionList = (PsiExpressionList)parent;
                    PsiExpression[] psiExpressions = psiExpressionList.getExpressions();
                    if (psiExpressions.length <= index2 || psiExpressions[index2] != literal) {
                        return false;
                    }
                    PsiElement element = psiExpressionList.getParent();
                    if (element instanceof PsiNewExpression && (reference = ((PsiNewExpression)element).getClassOrAnonymousClassReference()) != null) {
                        String qualifiedName = reference.getQualifiedName();
                        return ArrayUtil.contains(qualifiedName, fqns);
                    }
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/intellij/patterns/PsiJavaElementPattern$4", "accepts"));
            }
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationQualifiedName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodPattern";
                break;
            }
        }
        objectArray2[1] = "com/intellij/patterns/PsiJavaElementPattern";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "annotationParam";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "insideAnnotationParam";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "methodCallParameter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Capture<T extends PsiElement>
    extends PsiJavaElementPattern<T, Capture<T>> {
        public Capture(Class<T> aClass) {
            super(aClass);
        }

        public Capture(@NotNull InitialPatternCondition<T> condition) {
            if (condition == null) {
                Capture.$$$reportNull$$$0(0);
            }
            super(condition);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/patterns/PsiJavaElementPattern$Capture", "<init>"));
        }
    }
}

